/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.MultiReader;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.query.SolrQueryParser;
import org.alfresco.solr.tracker.CoreTracker;
import org.alfresco.solr.tracker.CoreWatcherJob;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.util.RefCounted;
import org.json.JSONException;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.xml.sax.SAXException;

public class AlfrescoCoreAdminHandler
extends CoreAdminHandler {
    private static final String CMIS_TEST_NAMESPACE = "http://www.alfresco.org/test/cmis-query-test";
    QName typeThatRequiresEncoding = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"type-that-requires-encoding");
    QName aspectThatRequiresEncoding = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"aspect-that-requires-encoding");
    QName propertyThatRequiresEncoding = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"property-that-requires-encoding");
    QName extendedContent = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"extendedContent");
    QName singleTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleTextBoth");
    QName singleTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleTextUntokenised");
    QName singleTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleTextTokenised");
    QName multipleTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleTextBoth");
    QName multipleTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleTextUntokenised");
    QName multipleTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleTextTokenised");
    QName singleMLTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleMLTextBoth");
    QName singleMLTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleMLTextUntokenised");
    QName singleMLTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleMLTextTokenised");
    QName multipleMLTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleMLTextBoth");
    QName multipleMLTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleMLTextUntokenised");
    QName multipleMLTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleMLTextTokenised");
    QName singleFloat = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleFloat");
    QName multipleFloat = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleFloat");
    QName singleDouble = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleDouble");
    QName multipleDouble = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleDouble");
    QName singleInteger = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleInteger");
    QName multipleInteger = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleInteger");
    QName singleLong = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleLong");
    QName multipleLong = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleLong");
    QName singleBoolean = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleBoolean");
    QName multipleBoolean = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleBoolean");
    QName singleDate = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleDate");
    QName multipleDate = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleDate");
    QName singleDatetime = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleDatetime");
    QName multipleDatetime = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleDatetime");
    ReentrantReadWriteLock guidLock = new ReentrantReadWriteLock();
    long guid = System.nanoTime();
    private static final String ARG_ACLTXID = "acltxid";
    private static final String ARG_TXID = "txid";
    private static final String ARG_ACLID = "aclid";
    private static final String ARG_NODEID = "nodeid";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/solrtest";
    QName createdDate = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"createdDate");
    QName createdTime = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"createdTime");
    QName orderDouble = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderDouble");
    QName orderFloat = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderFloat");
    QName orderLong = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderLong");
    QName orderInt = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderInt");
    QName orderText = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderText");
    QName orderLocalisedText = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderLocalisedText");
    QName orderMLText = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderMLText");
    QName orderLocalisedMLText = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"orderLocalisedMLText");
    QName aspectWithChildren = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"aspectWithChildren");
    private QName testType = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"testType");
    private QName testSuperType = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"testSuperType");
    private QName testAspect = QName.createQName((String)"http://www.alfresco.org/test/solrtest", (String)"testAspect");
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoCoreAdminHandler.class);
    Scheduler scheduler = null;
    ConcurrentHashMap<String, CoreTracker> trackers = new ConcurrentHashMap();
    private Date orderDate = new Date();
    private int orderTextCount = 0;
    private String[] orderNames = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen"};
    private String[] orderLocalisedNames = new String[]{"chalina", "curioso", "llama", "luz", "peach", "p\u00e9ch\u00e9", "p\u00eache", "sin", "\u00e4pple", "banan", "p\u00e4ron", "orange", "rock", "r\u00f4le", "rose", "filler"};
    private String[] orderLocaliseMLText_de = new String[]{"Arg", "\u00c4rgerlich", "Arm", "Assistent", "A\u00dflar", "Assoziation", "Udet", "\u00dcbelacker", "Uell", "\u00dclle", "Ueve", "\u00dcxk\u00fcll", "Uffenbach", "apple", "and", "aardvark"};
    private String[] orderLocaliseMLText_fr = new String[]{"cote", "c\u00f4te", "cot\u00e9", "c\u00f4t\u00e9", "rock", "lemur", "lemonade", "lemon", "kale", "guava", "cheese", "beans", "bananana", "apple", "and", "aardvark"};
    private String[] orderLocaliseMLText_en = new String[]{"zebra", "tiger", "rose", "r\u00f4le", "rock", "lemur", "lemonade", "lemon", "kale", "guava", "cheese", "beans", "bananana", "apple", "and", "aardvark"};
    private String[] orderLocaliseMLText_es = new String[]{"radio", "r\u00e1faga", "rana", "r\u00e1pido", "rastrillo", "arroz", "campo", "chihuahua", "ciudad", "limonada", "llaves", "luna", "bananana", "apple", "and", "aardvark"};
    private static String[] orderable = new String[]{"zero loons", "one banana", "two apples", "three fruit", "four lemurs", "five rats", "six badgers", "seven cards", "eight cabbages", "nine zebras", "ten lemons"};
    private static String[] mlOrderable_en = new String[]{"AAAA BBBB", "EEEE FFFF", "II", "KK", "MM", "OO", "QQ", "SS", "UU", "AA", "CC"};
    private static String[] mlOrderable_fr = new String[]{"CCCC DDDD", "GGGG HHHH", "JJ", "LL", "NN", "PP", "RR", "TT", "VV", "BB", "DD"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createGUID() {
        long time;
        this.guidLock.writeLock().lock();
        try {
            time = this.guid++;
        }
        finally {
            this.guidLock.writeLock().unlock();
        }
        return "00000000-0000-" + time / 1000000000000L % 10000L + "-" + time / 100000000L % 10000L + "-" + time % 100000000L;
    }

    public AlfrescoCoreAdminHandler() {
    }

    public AlfrescoCoreAdminHandler(CoreContainer coreContainer) {
        super(coreContainer);
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Properties properties = new Properties();
            properties.setProperty("org.quartz.scheduler.instanceName", "SolrTrackerScheduler");
            properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            properties.setProperty("org.quartz.threadPool.threadCount", "3");
            properties.setProperty("org.quartz.threadPool.makeThreadsDaemons", "true");
            properties.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            properties.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
            factory.initialize(properties);
            this.scheduler = factory.getScheduler();
            this.scheduler.start();
            JobDetail job = new JobDetail("CoreWatcher", "Solr", CoreWatcherJob.class);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put((Object)"ADMIN_HANDLER", (Object)this);
            job.setJobDataMap(jobDataMap);
            try {
                CronTrigger trigger = new CronTrigger("CoreWatcherTrigger", "Solr", "0/20 * * * * ? *");
                this.scheduler.scheduleJob(job, (Trigger)trigger);
            }
            catch (java.text.ParseException e) {
                e.printStackTrace();
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        this.initLogging(coreContainer);
    }

    private void initLogging(CoreContainer coreContainer) {
        this.initResourceBasedLogging(coreContainer, "log4j.properties");
        this.initResourceBasedLogging(coreContainer, "log4j-solr.properties");
    }

    private void initResourceBasedLogging(CoreContainer coreContainer, String resource) {
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.PropertyConfigurator");
            Method method = clazz.getMethod("configure", Properties.class);
            InputStream is = this.openResource(coreContainer, resource);
            Properties p = new Properties();
            p.load(is);
            method.invoke(null, p);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (Throwable e) {
            log.info("Failed to load " + resource, e);
        }
    }

    private InputStream openResource(CoreContainer coreContainer, String resource) {
        InputStream is = null;
        try {
            File f0;
            File f = f0 = new File(resource);
            if (!f.isAbsolute()) {
                f = new File(coreContainer.getSolrHome() + resource);
            }
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            if (f != f0 && f0.isFile() && f0.canRead()) {
                return new FileInputStream(f0);
            }
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new RuntimeException("Can't find resource '" + resource + "' in classpath or '" + coreContainer.getSolrHome() + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ConcurrentHashMap<String, CoreTracker> getTrackers() {
        return this.trackers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        String a = params.get("action");
        try {
            if (a.equalsIgnoreCase("TEST")) {
                this.runTests(req, rsp);
                return false;
            }
            if (a.equalsIgnoreCase("AUTHTEST")) {
                this.runAuthTest(req, rsp);
                return false;
            }
            if (a.equalsIgnoreCase("CMISTEST")) {
                this.runCmisTests(req, rsp);
                return false;
            }
            if (a.equalsIgnoreCase("newCore")) {
                return this.newCore(req, rsp);
            }
            if (a.equalsIgnoreCase("updateCore")) {
                return this.updateCore(req, rsp);
            }
            if (a.equalsIgnoreCase("removeCore")) {
                return this.removeCore(req, rsp);
            }
            if (a.equalsIgnoreCase("CHECK")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (tracker == null) return false;
                    tracker.setCheck(true);
                    return false;
                } else {
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        tracker.setCheck(true);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("NODEREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long dbid = null;
                    if (params.get(ARG_NODEID) == null) throw new AlfrescoRuntimeException("No dbid parameter set");
                    dbid = Long.valueOf(params.get(ARG_NODEID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildNodeReport(tracker, dbid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long dbid = null;
                    if (params.get(ARG_NODEID) == null) throw new AlfrescoRuntimeException("No dbid parameter set");
                    dbid = Long.valueOf(params.get(ARG_NODEID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildNodeReport(tracker, dbid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("ACLREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long aclid = null;
                    if (params.get(ARG_ACLID) == null) throw new AlfrescoRuntimeException("No aclid parameter set");
                    aclid = Long.valueOf(params.get(ARG_ACLID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildAclReport(tracker, aclid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long aclid = null;
                    if (params.get(ARG_ACLID) == null) throw new AlfrescoRuntimeException("No dbid parameter set");
                    aclid = Long.valueOf(params.get(ARG_ACLID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildAclReport(tracker, aclid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("TXREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long txid = null;
                    if (params.get(ARG_TXID) == null) throw new AlfrescoRuntimeException("No txid parameter set");
                    txid = Long.valueOf(params.get(ARG_TXID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildTxReport(tracker, txid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long txid = null;
                    if (params.get(ARG_TXID) == null) throw new AlfrescoRuntimeException("No txid parameter set");
                    txid = Long.valueOf(params.get(ARG_TXID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildTxReport(tracker, txid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("ACLTXREPORT")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Long acltxid = null;
                    if (params.get(ARG_ACLTXID) == null) throw new AlfrescoRuntimeException("No acltxid parameter set");
                    acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    report.add(cname, this.buildAclTxReport(tracker, acltxid));
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long acltxid = null;
                    if (params.get(ARG_ACLTXID) == null) throw new AlfrescoRuntimeException("No acltxid parameter set");
                    acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String trackerName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(trackerName);
                        report.add(trackerName, this.buildAclTxReport(tracker, acltxid));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("REPORT")) {
                if (cname != null) {
                    Long fromTime = null;
                    if (params.get("fromTime") != null) {
                        fromTime = Long.valueOf(params.get("fromTime"));
                    }
                    Long toTime = null;
                    if (params.get("toTime") != null) {
                        toTime = Long.valueOf(params.get("toTime"));
                    }
                    Long fromTx = null;
                    if (params.get("fromTx") != null) {
                        fromTx = Long.valueOf(params.get("fromTx"));
                    }
                    Long toTx = null;
                    if (params.get("toTx") != null) {
                        toTx = Long.valueOf(params.get("toTx"));
                    }
                    Long fromAclTx = null;
                    if (params.get("fromAclTx") != null) {
                        fromAclTx = Long.valueOf(params.get("fromAclTx"));
                    }
                    Long toAclTx = null;
                    if (params.get("toAclTx") != null) {
                        toAclTx = Long.valueOf(params.get("toAclTx"));
                    }
                    CoreTracker tracker = this.trackers.get(cname);
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    if (tracker != null) {
                        report.add(cname, this.buildTrackerReport(tracker, fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime));
                    } else {
                        report.add(cname, (Object)"Core unknown");
                    }
                    rsp.add("report", (Object)report);
                    return false;
                } else {
                    Long fromTime = null;
                    if (params.get("fromTime") != null) {
                        fromTime = Long.valueOf(params.get("fromTime"));
                    }
                    Long toTime = null;
                    if (params.get("toTime") != null) {
                        toTime = Long.valueOf(params.get("toTime"));
                    }
                    Long fromTx = null;
                    if (params.get("fromTx") != null) {
                        fromTx = Long.valueOf(params.get("fromTx"));
                    }
                    Long toTx = null;
                    if (params.get("toTx") != null) {
                        toTx = Long.valueOf(params.get("toTx"));
                    }
                    Long fromAclTx = null;
                    if (params.get("fromAclTx") != null) {
                        fromAclTx = Long.valueOf(params.get("fromAclTx"));
                    }
                    Long toAclTx = null;
                    if (params.get("toAclTx") != null) {
                        toAclTx = Long.valueOf(params.get("toAclTx"));
                    }
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        report.add(coreName, this.buildTrackerReport(tracker, fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime));
                    }
                    rsp.add("report", (Object)report);
                }
                return false;
            }
            if (a.equalsIgnoreCase("PURGE")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (params.get(ARG_TXID) != null) {
                        Long txid = Long.valueOf(params.get(ARG_TXID));
                        tracker.addTransactionToPurge(txid);
                    }
                    if (params.get(ARG_ACLTXID) != null) {
                        Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                        tracker.addAclChangeSetToPurge(acltxid);
                    }
                    if (params.get(ARG_NODEID) != null) {
                        Long nodeid = Long.valueOf(params.get(ARG_NODEID));
                        tracker.addNodeToPurge(nodeid);
                    }
                    if (params.get(ARG_ACLID) == null) return false;
                    Long aclid = Long.valueOf(params.get(ARG_ACLID));
                    tracker.addAclToPurge(aclid);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (params.get(ARG_TXID) != null) {
                            Long txid = Long.valueOf(params.get(ARG_TXID));
                            tracker.addTransactionToPurge(txid);
                        }
                        if (params.get(ARG_ACLTXID) != null) {
                            Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                            tracker.addAclChangeSetToPurge(acltxid);
                        }
                        if (params.get(ARG_NODEID) != null) {
                            Long nodeid = Long.valueOf(params.get(ARG_NODEID));
                            tracker.addNodeToPurge(nodeid);
                        }
                        if (params.get(ARG_ACLID) == null) continue;
                        Long aclid = Long.valueOf(params.get(ARG_ACLID));
                        tracker.addAclToPurge(aclid);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("REINDEX")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (params.get(ARG_TXID) != null) {
                        Long txid = Long.valueOf(params.get(ARG_TXID));
                        tracker.addTransactionToReindex(txid);
                    }
                    if (params.get(ARG_ACLTXID) != null) {
                        Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                        tracker.addAclChangeSetToReindex(acltxid);
                    }
                    if (params.get(ARG_NODEID) != null) {
                        Long nodeid = Long.valueOf(params.get(ARG_NODEID));
                        tracker.addNodeToReindex(nodeid);
                    }
                    if (params.get(ARG_ACLID) == null) return false;
                    Long aclid = Long.valueOf(params.get(ARG_ACLID));
                    tracker.addAclToReindex(aclid);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (params.get(ARG_TXID) != null) {
                            Long txid = Long.valueOf(params.get(ARG_TXID));
                            tracker.addTransactionToReindex(txid);
                        }
                        if (params.get(ARG_ACLTXID) != null) {
                            Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                            tracker.addAclChangeSetToReindex(acltxid);
                        }
                        if (params.get(ARG_NODEID) != null) {
                            Long nodeid = Long.valueOf(params.get(ARG_NODEID));
                            tracker.addNodeToReindex(nodeid);
                        }
                        if (params.get(ARG_ACLID) == null) continue;
                        Long aclid = Long.valueOf(params.get(ARG_ACLID));
                        tracker.addAclToReindex(aclid);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("RETRY")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    Set<Long> errorDocIds = tracker.getErrorDocIds();
                    for (Long nodeid : errorDocIds) {
                        tracker.addNodeToReindex(nodeid);
                    }
                    rsp.add(cname, errorDocIds);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        Set<Long> errorDocIds = tracker.getErrorDocIds();
                        for (Long nodeid : errorDocIds) {
                            tracker.addNodeToReindex(nodeid);
                        }
                        rsp.add(coreName, errorDocIds);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("INDEX")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    if (params.get(ARG_TXID) != null) {
                        Long txid = Long.valueOf(params.get(ARG_TXID));
                        tracker.addTransactionToIndex(txid);
                    }
                    if (params.get(ARG_ACLTXID) != null) {
                        Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                        tracker.addAclChangeSetToIndex(acltxid);
                    }
                    if (params.get(ARG_NODEID) != null) {
                        Long nodeid = Long.valueOf(params.get(ARG_NODEID));
                        tracker.addNodeToIndex(nodeid);
                    }
                    if (params.get(ARG_ACLID) == null) return false;
                    Long aclid = Long.valueOf(params.get(ARG_ACLID));
                    tracker.addAclToIndex(aclid);
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (params.get(ARG_TXID) != null) {
                            Long txid = Long.valueOf(params.get(ARG_TXID));
                            tracker.addTransactionToIndex(txid);
                        }
                        if (params.get(ARG_ACLTXID) != null) {
                            Long acltxid = Long.valueOf(params.get(ARG_ACLTXID));
                            tracker.addAclChangeSetToIndex(acltxid);
                        }
                        if (params.get(ARG_NODEID) != null) {
                            Long nodeid = Long.valueOf(params.get(ARG_NODEID));
                            tracker.addNodeToIndex(nodeid);
                        }
                        if (params.get(ARG_ACLID) == null) continue;
                        Long aclid = Long.valueOf(params.get(ARG_ACLID));
                        tracker.addAclToIndex(aclid);
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("FIX")) {
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    IndexHealthReport indexHealthReport = tracker.checkIndex(null, null, null, null, null, null);
                    OpenBitSet toReindex = indexHealthReport.getTxInIndexButNotInDb();
                    toReindex.or(indexHealthReport.getDuplicatedTxInIndex());
                    toReindex.or(indexHealthReport.getMissingTxFromIndex());
                    long current = -1L;
                    while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                        tracker.addTransactionToReindex(current);
                    }
                    toReindex = indexHealthReport.getAclTxInIndexButNotInDb();
                    toReindex.or(indexHealthReport.getDuplicatedAclTxInIndex());
                    toReindex.or(indexHealthReport.getMissingAclTxFromIndex());
                    current = -1L;
                    while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                        tracker.addAclChangeSetToReindex(current);
                    }
                    return false;
                } else {
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        IndexHealthReport indexHealthReport = tracker.checkIndex(null, null, null, null, null, null);
                        OpenBitSet toReindex = indexHealthReport.getTxInIndexButNotInDb();
                        toReindex.or(indexHealthReport.getDuplicatedTxInIndex());
                        toReindex.or(indexHealthReport.getMissingTxFromIndex());
                        long current = -1L;
                        while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                            tracker.addTransactionToReindex(current);
                        }
                        toReindex = indexHealthReport.getAclTxInIndexButNotInDb();
                        toReindex.or(indexHealthReport.getDuplicatedAclTxInIndex());
                        toReindex.or(indexHealthReport.getMissingAclTxFromIndex());
                        current = -1L;
                        while ((current = toReindex.nextSetBit(current + 1L)) != -1L) {
                            tracker.addAclChangeSetToReindex(current);
                        }
                    }
                }
                return false;
            }
            if (a.equalsIgnoreCase("SUMMARY")) {
                boolean reset = false;
                boolean detail = false;
                boolean hist = false;
                boolean values = false;
                if (params.get("reset") != null) {
                    reset = Boolean.valueOf(params.get("reset"));
                }
                if (params.get("detail") != null) {
                    detail = Boolean.valueOf(params.get("detail"));
                }
                if (params.get("hist") != null) {
                    hist = Boolean.valueOf(params.get("hist"));
                }
                if (params.get("values") != null) {
                    values = Boolean.valueOf(params.get("values"));
                }
                if (cname != null) {
                    CoreTracker tracker = this.trackers.get(cname);
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    if (tracker != null) {
                        this.addCoreSummary(cname, detail, hist, values, tracker, (NamedList<Object>)report);
                        if (reset) {
                            tracker.getTrackerStats().reset();
                        }
                    } else {
                        report.add(cname, (Object)"Core unknown");
                    }
                    rsp.add("Summary", (Object)report);
                    return false;
                } else {
                    SimpleOrderedMap report = new SimpleOrderedMap();
                    for (String coreName : this.trackers.keySet()) {
                        CoreTracker tracker = this.trackers.get(coreName);
                        if (tracker != null) {
                            this.addCoreSummary(coreName, detail, hist, values, tracker, (NamedList<Object>)report);
                            if (!reset) continue;
                            tracker.getTrackerStats().reset();
                            continue;
                        }
                        report.add(coreName, (Object)"Core unknown");
                    }
                    rsp.add("Summary", (Object)report);
                }
                return false;
            }
            if (!a.equalsIgnoreCase("LOG4J")) return super.handleCustomAction(req, rsp);
            String resource = "log4j-solr.properties";
            if (params.get("resource") != null) {
                resource = params.get("resource");
            }
            this.initResourceBasedLogging(this.coreContainer, resource);
            return false;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error executing implementation of admin request " + a, (Throwable)ex);
        }
    }

    private void runTests(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.orderDate = new Date();
        this.orderTextCount = 0;
        try {
            boolean remove = true;
            SolrParams params = req.getParams();
            if (params.get("remove") != null) {
                remove = Boolean.valueOf(params.get("remove"));
            }
            String name = "test-" + System.nanoTime();
            File solrHome = new File(this.getCoreContainer().getSolrHome());
            File templates = new File(solrHome, "templates");
            File template = new File(templates, "test");
            File newCore = new File(solrHome, name);
            this.copyDirectory(template, newCore, false);
            File config = new File(newCore, "conf/solrcore.properties");
            Properties properties = new Properties();
            properties.load(new FileInputStream(config));
            properties.setProperty("data.dir.root", newCore.getCanonicalPath());
            properties.store(new FileOutputStream(config), null);
            SimpleOrderedMap before = new SimpleOrderedMap();
            rsp.add("Before", (Object)before);
            CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, name, newCore.toString());
            dcore.setCoreProperties(null);
            SolrCore core = this.coreContainer.create(dcore);
            this.coreContainer.register(name, core, false);
            before.add("core", (Object)core.getName());
            SolrResourceLoader loader = core.getSchema().getResourceLoader();
            String id = loader.getInstanceDir();
            AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance(id);
            dataModel.setCMDefaultUri();
            NodeRef rootNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            this.addStoreRoot(core, dataModel, rootNodeRef, 1, 1, 1, 1);
            before.add("StoreRoot", (Object)1);
            NodeRef n01NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n01QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"one");
            ChildAssociationRef n01CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, n01QName, n01NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 2, 1, this.testSuperType, null, this.getOrderProperties(), null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n01QName.toString()}, n01NodeRef, true);
            NodeRef n02NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n02QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"two");
            ChildAssociationRef n02CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, n02QName, n02NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 3, 1, this.testSuperType, null, this.getOrderProperties(), null, "bob", new ChildAssociationRef[]{n02CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n02QName.toString()}, n02NodeRef, true);
            NodeRef n03NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n03QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"three");
            ChildAssociationRef n03CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, n03QName, n03NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 4, 1, this.testSuperType, null, this.getOrderProperties(), null, "cid", new ChildAssociationRef[]{n03CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n03QName.toString()}, n03NodeRef, true);
            HashMap<QName, PropertyValue> properties04 = new HashMap<QName, PropertyValue>();
            HashMap<QName, String> content04 = new HashMap<QName, String>();
            properties04.putAll(this.getOrderProperties());
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic"), new StringPropertyValue("TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYONE"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic"), new StringPropertyValue("TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYUNSTORED"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic"), new StringPropertyValue("TEXT THAT IS INDEXED STORED AND TOKENISED BUT NOT ATOMICALLY KEYTWO"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"int-ista"), new StringPropertyValue("1"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"long-ista"), new StringPropertyValue("2"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"float-ista"), new StringPropertyValue("3.4"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista"), new StringPropertyValue("5.6"));
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(new Date(new Date().getTime() - 10000L));
            Date testDate = c.getTime();
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)testDate)));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)testDate)));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"boolean-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)true)));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"qname-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)QName.createQName((String)"{wibble}wobble"))));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"category-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new NodeRef(new StoreRef("proto", "id"), "CategoryId"))));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"noderef-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)n01NodeRef)));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista"), new StringPropertyValue("/" + n03QName.toString()));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Locale.UK)));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"period-ista"), new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new Period("period|12"))));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"null"), null);
            MultiPropertyValue list_0 = new MultiPropertyValue();
            list_0.addValue(new StringPropertyValue("one"));
            list_0.addValue(new StringPropertyValue("two"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"list"), list_0);
            MLTextPropertyValue mlText = new MLTextPropertyValue();
            mlText.addValue(Locale.ENGLISH, "banana");
            mlText.addValue(Locale.FRENCH, "banane");
            mlText.addValue(Locale.CHINESE, "\u9999\u8549");
            mlText.addValue(new Locale("nl"), "banaan");
            mlText.addValue(Locale.GERMAN, "banane");
            mlText.addValue(new Locale("el"), "\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1");
            mlText.addValue(Locale.ITALIAN, "banana");
            mlText.addValue(new Locale("ja"), "\u30d0\u30ca\u30ca");
            mlText.addValue(new Locale("ko"), "\ubc14\ub098\ub098");
            mlText.addValue(new Locale("pt"), "banana");
            mlText.addValue(new Locale("ru"), "\u0431\u0430\u043d\u0430\u043d");
            mlText.addValue(new Locale("es"), "pl\u00e1tano");
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"ml"), mlText);
            MultiPropertyValue list_1 = new MultiPropertyValue();
            list_1.addValue(new StringPropertyValue("100"));
            list_1.addValue(new StringPropertyValue("anyValueAsString"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista"), list_1);
            MultiPropertyValue list_2 = new MultiPropertyValue();
            list_2.addValue(new ContentPropertyValue(Locale.ENGLISH, 12L, "UTF-16", "text/plain"));
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista"), list_2);
            content04.put(QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista"), "multicontent");
            MLTextPropertyValue mlText1 = new MLTextPropertyValue();
            mlText1.addValue(Locale.ENGLISH, "cabbage");
            mlText1.addValue(Locale.FRENCH, "chou");
            MLTextPropertyValue mlText2 = new MLTextPropertyValue();
            mlText2.addValue(Locale.ENGLISH, "lemur");
            mlText2.addValue(new Locale("ru"), "\u043b\u0435\u043c\u0443\u0440");
            MultiPropertyValue list_3 = new MultiPropertyValue();
            list_3.addValue(mlText1);
            list_3.addValue(mlText2);
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"mltext-many-ista"), list_3);
            MultiPropertyValue list_4 = new MultiPropertyValue();
            list_4.addValue(null);
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"nullist"), list_4);
            NodeRef n04NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n04QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"four");
            ChildAssociationRef n04CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, n04QName, n04NodeRef, true, 0);
            properties04.put(QName.createQName((String)TEST_NAMESPACE, (String)"aspectProperty"), new StringPropertyValue(""));
            this.addNode(core, dataModel, 1, 5, 1, this.testType, new QName[]{this.testAspect}, properties04, content04, "dave", new ChildAssociationRef[]{n04CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n04QName.toString()}, n04NodeRef, true);
            NodeRef n05NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n05QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"five");
            ChildAssociationRef n05CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n01NodeRef, n05QName, n05NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 6, 1, this.testSuperType, null, this.getOrderProperties(), null, "eoin", new ChildAssociationRef[]{n05CAR}, new NodeRef[]{rootNodeRef, n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString()}, n05NodeRef, true);
            NodeRef n06NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n06QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"six");
            ChildAssociationRef n06CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n01NodeRef, n06QName, n06NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 7, 1, this.testSuperType, null, this.getOrderProperties(), null, "fred", new ChildAssociationRef[]{n06CAR}, new NodeRef[]{rootNodeRef, n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n06QName.toString()}, n06NodeRef, true);
            NodeRef n07NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n07QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"seven");
            ChildAssociationRef n07CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n02NodeRef, n07QName, n07NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 8, 1, this.testSuperType, null, this.getOrderProperties(), null, "gail", new ChildAssociationRef[]{n07CAR}, new NodeRef[]{rootNodeRef, n02NodeRef}, new String[]{"/" + n02QName.toString() + "/" + n07QName.toString()}, n07NodeRef, true);
            NodeRef n08NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n08QName_0 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"eight-0");
            QName n08QName_1 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"eight-1");
            QName n08QName_2 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"eight-2");
            ChildAssociationRef n08CAR_0 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, n08QName_0, n08NodeRef, false, 2);
            ChildAssociationRef n08CAR_1 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n01NodeRef, n08QName_1, n08NodeRef, false, 1);
            ChildAssociationRef n08CAR_2 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n02NodeRef, n08QName_2, n08NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 9, 1, this.testSuperType, null, this.getOrderProperties(), null, "hal", new ChildAssociationRef[]{n08CAR_0, n08CAR_1, n08CAR_2}, new NodeRef[]{rootNodeRef, rootNodeRef, n01NodeRef, rootNodeRef, n02NodeRef}, new String[]{"/" + n08QName_0, "/" + n01QName.toString() + "/" + n08QName_1.toString(), "/" + n02QName.toString() + "/" + n08QName_2.toString()}, n08NodeRef, true);
            NodeRef n09NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n09QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"nine");
            ChildAssociationRef n09CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n09QName, n09NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 10, 1, this.testSuperType, null, this.getOrderProperties(), null, "ian", new ChildAssociationRef[]{n09CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n09QName}, n09NodeRef, true);
            NodeRef n10NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n10QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"ten");
            ChildAssociationRef n10CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n10QName, n10NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 11, 1, this.testSuperType, null, this.getOrderProperties(), null, "jake", new ChildAssociationRef[]{n10CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n10QName}, n10NodeRef, true);
            NodeRef n11NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n11QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"eleven");
            ChildAssociationRef n11CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n11QName, n11NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 12, 1, this.testSuperType, null, this.getOrderProperties(), null, "kara", new ChildAssociationRef[]{n11CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n11QName}, n11NodeRef, true);
            NodeRef n12NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n12QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"twelve");
            ChildAssociationRef n12CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n12QName, n12NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 13, 1, this.testSuperType, null, this.getOrderProperties(), null, "loon", new ChildAssociationRef[]{n12CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName}, n12NodeRef, true);
            NodeRef n13NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n13QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"thirteen");
            QName n13QNameLink = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"link");
            ChildAssociationRef n13CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n12NodeRef, n13QName, n13NodeRef, true, 0);
            ChildAssociationRef n13CARLink = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n02NodeRef, n13QName, n13NodeRef, false, 0);
            this.addNode(core, dataModel, 1, 14, 1, this.testSuperType, null, this.getOrderProperties(), null, "mike", new ChildAssociationRef[]{n13CAR, n13CARLink}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef, n12NodeRef, rootNodeRef, n02NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName + "/" + n13QName, "/" + n02QName.toString() + "/" + n13QNameLink}, n13NodeRef, true);
            HashMap<QName, PropertyValue> properties14 = new HashMap<QName, PropertyValue>();
            properties14.putAll(this.getOrderProperties());
            HashMap<QName, String> content14 = new HashMap<QName, String>();
            MLTextPropertyValue desc1 = new MLTextPropertyValue();
            desc1.addValue(Locale.ENGLISH, "Alfresco tutorial");
            desc1.addValue(Locale.US, "Alfresco tutorial");
            Date explicitCreatedDate = new Date();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            properties14.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 298L, "UTF-8", "text/plain"));
            content14.put(ContentModel.PROP_CONTENT, "The quick brown fox jumped over the lazy dog and ate the Alfresco Tutorial, in pdf format, along with the following stop words;  a an and are as at be but by for if in into is it no not of on or such that the their then there these they this to was will with:  and random charcters \u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff");
            properties14.put(ContentModel.PROP_DESCRIPTION, desc1);
            properties14.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)explicitCreatedDate)));
            properties14.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)explicitCreatedDate)));
            NodeRef n14NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n14QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"fourteen");
            QName n14QNameCommon = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"common");
            ChildAssociationRef n14CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n13NodeRef, n14QName, n14NodeRef, true, 0);
            ChildAssociationRef n14CAR_1 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n01NodeRef, n14QNameCommon, n14NodeRef, false, 0);
            ChildAssociationRef n14CAR_2 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n02NodeRef, n14QNameCommon, n14NodeRef, false, 0);
            ChildAssociationRef n14CAR_5 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n05NodeRef, n14QNameCommon, n14NodeRef, false, 0);
            ChildAssociationRef n14CAR_6 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n06NodeRef, n14QNameCommon, n14NodeRef, false, 0);
            ChildAssociationRef n14CAR_12 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n12NodeRef, n14QNameCommon, n14NodeRef, false, 0);
            ChildAssociationRef n14CAR_13 = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n13NodeRef, n14QNameCommon, n14NodeRef, false, 0);
            this.addNode(core, dataModel, 1, 15, 1, ContentModel.TYPE_CONTENT, null, properties14, content14, "noodle", new ChildAssociationRef[]{n14CAR, n14CAR_1, n14CAR_2, n14CAR_5, n14CAR_6, n14CAR_12, n14CAR_13}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName + "/" + n13QName + "/" + n14QName, "/" + n02QName.toString() + "/" + n13QNameLink + "/" + n14QName, "/" + n01QName + "/" + n14QNameCommon, "/" + n02QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n05QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n06QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n05QName + "/" + n12QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n05QName + "/" + n12QName + "/" + n13QName + "/" + n14QNameCommon}, n14NodeRef, true);
            HashMap<QName, PropertyValue> properties15 = new HashMap<QName, PropertyValue>();
            properties15.putAll(this.getOrderProperties());
            properties15.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)explicitCreatedDate)));
            HashMap<QName, String> content15 = new HashMap<QName, String>();
            content15.put(ContentModel.PROP_CONTENT, "          ");
            NodeRef n15NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName n15QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"fifteen");
            ChildAssociationRef n15CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, n13NodeRef, n15QName, n15NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 16, 1, ContentModel.TYPE_THUMBNAIL, null, properties15, content15, "ood", new ChildAssociationRef[]{n15CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName + "/" + n13QName + "/" + n15QName, "/" + n02QName.toString() + "/" + n13QNameLink + "/" + n14QName}, n15NodeRef, true);
            this.checkRootNode((NamedList<Object>)before, core, dataModel);
            this.checkPaths((NamedList<Object>)before, core, dataModel);
            this.checkQNames((NamedList<Object>)before, core, dataModel);
            this.checkPropertyTypes((NamedList<Object>)before, core, dataModel, testDate, n01NodeRef.toString());
            this.checkType((NamedList<Object>)before, core, dataModel);
            this.checkText((NamedList<Object>)before, core, dataModel);
            this.checkMLText((NamedList<Object>)before, core, dataModel);
            this.checkAll((NamedList<Object>)before, core, dataModel);
            this.checkDataType((NamedList<Object>)before, core, dataModel);
            this.checkNullAndUnset((NamedList<Object>)before, core, dataModel);
            this.checkNonField((NamedList<Object>)before, core, dataModel);
            this.checkRanges((NamedList<Object>)before, core, dataModel);
            this.checkInternalFields((NamedList<Object>)before, core, dataModel, n01NodeRef.toString());
            this.checkAuthorityFilter((NamedList<Object>)before, core, dataModel);
            this.checkPaging((NamedList<Object>)before, core, dataModel);
            this.testSort((NamedList<Object>)before, core, dataModel);
            this.testAFTS((NamedList<Object>)before, core, dataModel);
            this.testAFTSandSort((NamedList<Object>)before, core, dataModel);
            this.testCMIS((NamedList<Object>)before, core, dataModel);
            long start = System.nanoTime();
            for (int i = 0; i < 100; ++i) {
                this.orderDate = new Date();
                this.orderTextCount = 0;
                this.addNode(core, dataModel, 1, 2, 1, this.testSuperType, null, this.getOrderProperties(), null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n01QName.toString()}, n01NodeRef, true);
            }
            long end = System.nanoTime();
            rsp.add("Index rate (docs/s)", (Object)((double)(100.0f / (float)(end - start)) * 1.0E9));
            for (int i = 0; i < 10; ++i) {
                this.orderDate = new Date();
                this.orderTextCount = 0;
                this.addNode(core, dataModel, 1, 2, 1, this.testSuperType, null, this.getOrderProperties(), null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n01QName.toString()}, n01NodeRef, true);
                this.addNode(core, dataModel, 1, 3, 1, this.testSuperType, null, this.getOrderProperties(), null, "bob", new ChildAssociationRef[]{n02CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n02QName.toString()}, n02NodeRef, true);
                this.addNode(core, dataModel, 1, 4, 1, this.testSuperType, null, this.getOrderProperties(), null, "cid", new ChildAssociationRef[]{n03CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n03QName.toString()}, n03NodeRef, true);
                properties04.putAll(this.getOrderProperties());
                this.addNode(core, dataModel, 1, 5, 1, this.testType, new QName[]{this.testAspect}, properties04, content04, "dave", new ChildAssociationRef[]{n04CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + n04QName.toString()}, n04NodeRef, true);
                this.addNode(core, dataModel, 1, 6, 1, this.testSuperType, null, this.getOrderProperties(), null, "eoin", new ChildAssociationRef[]{n05CAR}, new NodeRef[]{rootNodeRef, n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString()}, n05NodeRef, true);
                this.addNode(core, dataModel, 1, 7, 1, this.testSuperType, null, this.getOrderProperties(), null, "fred", new ChildAssociationRef[]{n06CAR}, new NodeRef[]{rootNodeRef, n01NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n06QName.toString()}, n06NodeRef, true);
                this.addNode(core, dataModel, 1, 8, 1, this.testSuperType, null, this.getOrderProperties(), null, "gail", new ChildAssociationRef[]{n07CAR}, new NodeRef[]{rootNodeRef, n02NodeRef}, new String[]{"/" + n02QName.toString() + "/" + n07QName.toString()}, n07NodeRef, true);
                this.addNode(core, dataModel, 1, 9, 1, this.testSuperType, null, this.getOrderProperties(), null, "hal", new ChildAssociationRef[]{n08CAR_0, n08CAR_1, n08CAR_2}, new NodeRef[]{rootNodeRef, rootNodeRef, n01NodeRef, rootNodeRef, n02NodeRef}, new String[]{"/" + n08QName_0, "/" + n01QName.toString() + "/" + n08QName_1.toString(), "/" + n02QName.toString() + "/" + n08QName_2.toString()}, n08NodeRef, true);
                this.addNode(core, dataModel, 1, 10, 1, this.testSuperType, null, this.getOrderProperties(), null, "ian", new ChildAssociationRef[]{n09CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n09QName}, n09NodeRef, true);
                this.addNode(core, dataModel, 1, 11, 1, this.testSuperType, null, this.getOrderProperties(), null, "jake", new ChildAssociationRef[]{n10CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n10QName}, n10NodeRef, true);
                this.addNode(core, dataModel, 1, 12, 1, this.testSuperType, null, this.getOrderProperties(), null, "kara", new ChildAssociationRef[]{n11CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n11QName}, n11NodeRef, true);
                this.addNode(core, dataModel, 1, 13, 1, this.testSuperType, null, this.getOrderProperties(), null, "loon", new ChildAssociationRef[]{n12CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName}, n12NodeRef, true);
                this.addNode(core, dataModel, 1, 14, 1, this.testSuperType, null, this.getOrderProperties(), null, "mike", new ChildAssociationRef[]{n13CAR, n13CARLink}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef, n12NodeRef, rootNodeRef, n02NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName + "/" + n13QName, "/" + n02QName.toString() + "/" + n13QNameLink}, n13NodeRef, true);
                properties14.putAll(this.getOrderProperties());
                this.addNode(core, dataModel, 1, 15, 1, ContentModel.TYPE_CONTENT, null, properties14, content14, "noodle", new ChildAssociationRef[]{n14CAR, n14CAR_1, n14CAR_2, n14CAR_5, n14CAR_6, n14CAR_12, n14CAR_13}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName + "/" + n13QName + "/" + n14QName, "/" + n02QName.toString() + "/" + n13QNameLink + "/" + n14QName, "/" + n01QName + "/" + n14QNameCommon, "/" + n02QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n05QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n06QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n05QName + "/" + n12QName + "/" + n14QNameCommon, "/" + n01QName + "/" + n05QName + "/" + n12QName + "/" + n13QName + "/" + n14QNameCommon}, n14NodeRef, true);
                properties14.putAll(this.getOrderProperties());
                this.addNode(core, dataModel, 1, 16, 1, ContentModel.TYPE_THUMBNAIL, null, properties15, content15, "ood", new ChildAssociationRef[]{n15CAR}, new NodeRef[]{rootNodeRef, n01NodeRef, n05NodeRef, n12NodeRef, n13NodeRef}, new String[]{"/" + n01QName.toString() + "/" + n05QName.toString() + "/" + n12QName + "/" + n13QName + "/" + n15QName, "/" + n02QName.toString() + "/" + n13QNameLink + "/" + n14QName}, n15NodeRef, true);
            }
            SimpleOrderedMap after = new SimpleOrderedMap();
            rsp.add("After", (Object)after);
            this.checkRootNode((NamedList<Object>)after, core, dataModel);
            this.checkPaths((NamedList<Object>)after, core, dataModel);
            this.checkQNames((NamedList<Object>)after, core, dataModel);
            this.checkPropertyTypes((NamedList<Object>)after, core, dataModel, testDate, n01NodeRef.toString());
            this.checkType((NamedList<Object>)after, core, dataModel);
            this.checkText((NamedList<Object>)after, core, dataModel);
            this.checkMLText((NamedList<Object>)after, core, dataModel);
            this.checkAll((NamedList<Object>)after, core, dataModel);
            this.checkDataType((NamedList<Object>)after, core, dataModel);
            this.checkNullAndUnset((NamedList<Object>)after, core, dataModel);
            this.checkNonField((NamedList<Object>)after, core, dataModel);
            this.checkRanges((NamedList<Object>)after, core, dataModel);
            this.testSort((NamedList<Object>)after, core, dataModel);
            this.testAFTS((NamedList<Object>)after, core, dataModel);
            this.testAFTSandSort((NamedList<Object>)after, core, dataModel);
            this.testCMIS((NamedList<Object>)after, core, dataModel);
            this.testChildNameEscaping((NamedList<Object>)after, core, dataModel, rootNodeRef);
            if (remove) {
                SolrCore done = this.coreContainer.remove(name);
                if (done != null) {
                    done.close();
                }
                this.deleteDirectory(newCore);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private boolean newCore(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            String store = "";
            SolrParams params = req.getParams();
            if (params.get("storeRef") != null) {
                store = params.get("storeRef");
            }
            if (store == null || store.length() == 0) {
                return false;
            }
            String templateName = "store";
            if (params.get("template") != null) {
                templateName = params.get("template");
            }
            StoreRef storeRef = new StoreRef(store);
            String coreName = storeRef.getProtocol() + "-" + storeRef.getIdentifier();
            if (params.get("coreName") != null) {
                coreName = params.get("coreName");
            }
            File solrHome = new File(this.getCoreContainer().getSolrHome());
            File templates = new File(solrHome, "templates");
            File template = new File(templates, templateName);
            File newCore = new File(solrHome, coreName);
            this.copyDirectory(template, newCore, false);
            File config = new File(newCore, "conf/solrcore.properties");
            Properties properties = new Properties();
            properties.load(new FileInputStream(config));
            properties.setProperty("data.dir.root", newCore.getCanonicalPath());
            properties.setProperty("data.dir.store", coreName);
            properties.setProperty("alfresco.stores", store);
            Iterator it = params.getParameterNamesIterator();
            while (it.hasNext()) {
                String paramName = (String)it.next();
                if (!paramName.startsWith("property.")) continue;
                properties.setProperty(paramName.substring("property.".length()), params.get(paramName));
            }
            properties.store(new FileOutputStream(config), null);
            CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, coreName, newCore.toString());
            dcore.setCoreProperties(null);
            SolrCore core = this.coreContainer.create(dcore);
            this.coreContainer.register(coreName, core, false);
            rsp.add("core", (Object)core.getName());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean updateCore(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            String store = "";
            SolrParams params = req.getParams();
            if (params.get("storeRef") != null) {
                store = params.get("storeRef");
            }
            if (store == null || store.length() == 0) {
                return false;
            }
            StoreRef storeRef = new StoreRef(store);
            String coreName = storeRef.getProtocol() + "-" + storeRef.getIdentifier();
            if (params.get("coreName") != null) {
                coreName = params.get("coreName");
            }
            File solrHome = new File(this.getCoreContainer().getSolrHome());
            File newCore = new File(solrHome, coreName);
            File config = new File(newCore, "conf/solrcore.properties");
            Properties properties = new Properties();
            properties.load(new FileInputStream(config));
            Iterator it = params.getParameterNamesIterator();
            while (it.hasNext()) {
                String paramName = (String)it.next();
                if (!paramName.startsWith("property.")) continue;
                properties.setProperty(paramName.substring("property.".length()), params.get(paramName));
            }
            properties.store(new FileOutputStream(config), null);
            this.coreContainer.reload(coreName);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean removeCore(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            String store = "";
            SolrParams params = req.getParams();
            if (params.get("storeRef") != null) {
                store = params.get("storeRef");
            }
            if (store == null || store.length() == 0) {
                return false;
            }
            StoreRef storeRef = new StoreRef(store);
            String coreName = storeRef.getProtocol() + "-" + storeRef.getIdentifier();
            if (params.get("coreName") != null) {
                coreName = params.get("coreName");
            }
            File solrHome = new File(this.getCoreContainer().getSolrHome());
            File newCore = new File(solrHome, coreName);
            SolrCore done = this.coreContainer.remove(coreName);
            if (done != null) {
                done.close();
            }
            this.deleteDirectory(newCore);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void runAuthTest(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            boolean remove = true;
            boolean reuse = true;
            long count = 100L;
            long maxReader = 1000L;
            SolrParams params = req.getParams();
            if (params.get("remove") != null) {
                remove = Boolean.valueOf(params.get("remove"));
            }
            if (params.get("count") != null) {
                count = Long.valueOf(params.get("count"));
            }
            if (params.get("maxReader") != null) {
                maxReader = Long.valueOf(params.get("maxReader"));
            }
            if (params.get("reuse") != null) {
                reuse = Boolean.valueOf(params.get("reuse"));
            }
            AlfrescoSolrDataModel dataModel = null;
            String name = "test-auth-" + System.nanoTime();
            SolrCore core = null;
            if (reuse) {
                for (String coreName : this.coreContainer.getCoreNames()) {
                    if (!coreName.startsWith("test-auth-")) continue;
                    core = this.coreContainer.getCore(coreName);
                    name = coreName;
                    SolrResourceLoader loader = core.getSchema().getResourceLoader();
                    String id = loader.getInstanceDir();
                    dataModel = AlfrescoSolrDataModel.getInstance(id);
                    break;
                }
            }
            if (core == null) {
                File solrHome = new File(this.getCoreContainer().getSolrHome());
                File templates = new File(solrHome, "templates");
                File template = new File(templates, "test");
                File newCore = new File(solrHome, name);
                this.copyDirectory(template, newCore, false);
                File config = new File(newCore, "conf/solrcore.properties");
                Properties properties = new Properties();
                properties.load(new FileInputStream(config));
                properties.setProperty("data.dir.root", newCore.getCanonicalPath());
                properties.store(new FileOutputStream(config), null);
                CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, name, newCore.toString());
                dcore.setCoreProperties(null);
                core = this.coreContainer.create(dcore);
                this.coreContainer.register(name, core, false);
                rsp.add("core", (Object)core.getName());
                SolrResourceLoader loader = core.getSchema().getResourceLoader();
                String id = loader.getInstanceDir();
                dataModel = AlfrescoSolrDataModel.getInstance(id);
                dataModel.setCMDefaultUri();
                NodeRef rootNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
                this.addStoreRoot(core, dataModel, rootNodeRef, 1, 1, 1, 1);
                rsp.add("StoreRootNode", (Object)1);
                HashMap<QName, PropertyValue> baseFolderProperties = new HashMap<QName, PropertyValue>();
                baseFolderProperties.put(ContentModel.PROP_NAME, new StringPropertyValue("Base Folder"));
                HashMap baseFolderContent = new HashMap();
                NodeRef baseFolderNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
                QName baseFolderQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"baseFolder");
                ChildAssociationRef n01CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, baseFolderQName, baseFolderNodeRef, true, 0);
                this.addNode(core, dataModel, 1, 2, 1, ContentModel.TYPE_FOLDER, null, baseFolderProperties, null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + baseFolderQName.toString()}, baseFolderNodeRef, true);
                HashMap<QName, PropertyValue> folder00Properties = new HashMap<QName, PropertyValue>();
                folder00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 0"));
                HashMap folder00Content = new HashMap();
                NodeRef folder00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
                QName folder00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 0");
                ChildAssociationRef folder00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, baseFolderNodeRef, folder00QName, folder00NodeRef, true, 0);
                this.addNode(core, dataModel, 1, 3, 1, ContentModel.TYPE_FOLDER, null, folder00Properties, null, "andy", new ChildAssociationRef[]{folder00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString()}, folder00NodeRef, true);
                for (long i = 0L; i < count; ++i) {
                    this.addAcl(core, dataModel, 10 + (int)i, 10 + (int)i, (int)(i % maxReader), (int)maxReader);
                    HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
                    MLTextPropertyValue desc00 = new MLTextPropertyValue();
                    desc00.addValue(Locale.ENGLISH, "Doc " + i);
                    desc00.addValue(Locale.US, "Doc " + i);
                    content00Properties.put(ContentModel.PROP_DESCRIPTION, desc00);
                    content00Properties.put(ContentModel.PROP_TITLE, desc00);
                    content00Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
                    content00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Doc " + i));
                    content00Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("Test"));
                    content00Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("Test"));
                    content00Properties.put(ContentModel.PROP_VERSION_LABEL, new StringPropertyValue("1.0"));
                    content00Properties.put(ContentModel.PROP_OWNER, new StringPropertyValue("Test"));
                    Date date00 = new Date();
                    content00Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date00)));
                    content00Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date00)));
                    HashMap<QName, String> content00Content = new HashMap<QName, String>();
                    content00Content.put(ContentModel.PROP_CONTENT, "Test doc number " + i);
                    NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
                    QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("Doc-" + i));
                    ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
                    this.addNode(core, dataModel, 1, 10 + (int)i, 10 + (int)i, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, content00Content, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, false);
                }
                core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
            this.checkAuth(rsp, core, dataModel, count);
            if (remove) {
                SolrCore done = this.coreContainer.remove(name);
                if (done != null) {
                    done.close();
                }
                this.deleteDirectory(new File(core.getCoreDescriptor().getInstanceDir()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuth(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, long count) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Auth", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testFTSQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"Test\"", (int)count, null, null, null, new String[0]);
            this.testFTSQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"doc\"", (int)count, null, null, null, new String[0]);
            this.testFTSQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"number\"", (int)count, null, null, null, new String[0]);
            this.testFTSQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"1\"", (int)count, null, null, null, new String[0]);
            this.testFTSQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "AUTHORITY:\"READER-0\"", (int)count, null, null, null, new String[0]);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 8);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 9);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 10);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 98);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 99);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 100);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 998);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 999);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 1000);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 9998);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 9999);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 10000);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 10000);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 10000);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 20000);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 20000);
            this.buildAndRunAuthQuery(dataModel, count, (NamedList<Object>)report, solrIndexSearcher, 20000);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    private void buildAndRunAuthQuery(AlfrescoSolrDataModel dataModel, long count, NamedList<Object> report, SolrIndexSearcher solrIndexSearcher, int loop) throws ParseException, IOException {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= loop; ++i) {
            if (i % 100 == 1) {
                if (i == 1) {
                    builder.append("|AUTHORITY:\"");
                } else {
                    builder.append("\" |AUTHORITY:\"");
                }
            }
            builder.append("|READER-" + i);
        }
        builder.append("\"");
        this.testFTSQuery(dataModel, report, solrIndexSearcher, builder.toString(), 0, null, null, null, "Auth-" + loop);
    }

    private void runCmisTests(SolrQueryRequest req, SolrQueryResponse rsp) {
        TimeZone.setDefault(null);
        try {
            boolean remove = true;
            SolrParams params = req.getParams();
            if (params.get("remove") != null) {
                remove = Boolean.valueOf(params.get("remove"));
            }
            String name = "test-cmis-" + System.nanoTime();
            File solrHome = new File(this.getCoreContainer().getSolrHome());
            File templates = new File(solrHome, "templates");
            File template = new File(templates, "test");
            File newCore = new File(solrHome, name);
            this.copyDirectory(template, newCore, false);
            File config = new File(newCore, "conf/solrcore.properties");
            Properties properties = new Properties();
            properties.load(new FileInputStream(config));
            properties.setProperty("data.dir.root", newCore.getCanonicalPath());
            properties.store(new FileOutputStream(config), null);
            CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, name, newCore.toString());
            dcore.setCoreProperties(null);
            SolrCore core = this.coreContainer.create(dcore);
            this.coreContainer.register(name, core, false);
            rsp.add("core", (Object)core.getName());
            SolrResourceLoader loader = core.getSchema().getResourceLoader();
            String id = loader.getInstanceDir();
            AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance(id);
            dataModel.setCMDefaultUri();
            NodeRef rootNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            this.addStoreRoot(core, dataModel, rootNodeRef, 1, 1, 1, 1);
            rsp.add("StoreRootNode", (Object)1);
            HashMap<QName, PropertyValue> baseFolderProperties = new HashMap<QName, PropertyValue>();
            baseFolderProperties.put(ContentModel.PROP_NAME, new StringPropertyValue("Base Folder"));
            HashMap baseFolderContent = new HashMap();
            NodeRef baseFolderNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName baseFolderQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"baseFolder");
            ChildAssociationRef n01CAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, baseFolderQName, baseFolderNodeRef, true, 0);
            this.addNode(core, dataModel, 1, 2, 1, ContentModel.TYPE_FOLDER, null, baseFolderProperties, null, "andy", new ChildAssociationRef[]{n01CAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + baseFolderQName.toString()}, baseFolderNodeRef, true);
            HashMap<QName, PropertyValue> folder00Properties = new HashMap<QName, PropertyValue>();
            folder00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 0"));
            HashMap folder00Content = new HashMap();
            NodeRef folder00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 0");
            ChildAssociationRef folder00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, baseFolderNodeRef, folder00QName, folder00NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 3, 1, ContentModel.TYPE_FOLDER, null, folder00Properties, null, "andy", new ChildAssociationRef[]{folder00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString()}, folder00NodeRef, true);
            HashMap<QName, PropertyValue> folder01Properties = new HashMap<QName, PropertyValue>();
            folder01Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 1"));
            HashMap folder01Content = new HashMap();
            NodeRef folder01NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder01QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 1");
            ChildAssociationRef folder01CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, baseFolderNodeRef, folder01QName, folder01NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 4, 1, ContentModel.TYPE_FOLDER, null, folder01Properties, null, "bob", new ChildAssociationRef[]{folder01CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder01QName.toString()}, folder01NodeRef, true);
            HashMap<QName, PropertyValue> folder02Properties = new HashMap<QName, PropertyValue>();
            folder02Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 2"));
            HashMap folder02Content = new HashMap();
            NodeRef folder02NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder02QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 2");
            ChildAssociationRef folder02CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, baseFolderNodeRef, folder02QName, folder02NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 5, 1, ContentModel.TYPE_FOLDER, null, folder02Properties, null, "cid", new ChildAssociationRef[]{folder02CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder02QName.toString()}, folder02NodeRef, true);
            HashMap<QName, PropertyValue> folder03Properties = new HashMap<QName, PropertyValue>();
            folder03Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 3"));
            HashMap folder03Content = new HashMap();
            NodeRef folder03NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder03QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 3");
            ChildAssociationRef folder03CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, baseFolderNodeRef, folder03QName, folder03NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 6, 1, ContentModel.TYPE_FOLDER, null, folder03Properties, null, "dave", new ChildAssociationRef[]{folder03CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder03QName.toString()}, folder03NodeRef, true);
            HashMap<QName, PropertyValue> folder04Properties = new HashMap<QName, PropertyValue>();
            folder04Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 4"));
            HashMap folder04Content = new HashMap();
            NodeRef folder04NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder04QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 4");
            ChildAssociationRef folder04CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, folder04QName, folder04NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 7, 1, ContentModel.TYPE_FOLDER, null, folder04Properties, null, "eoin", new ChildAssociationRef[]{folder04CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder04QName.toString()}, folder04NodeRef, true);
            HashMap<QName, PropertyValue> folder05Properties = new HashMap<QName, PropertyValue>();
            folder05Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 5"));
            HashMap folder05Content = new HashMap();
            NodeRef folder05NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder05QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 5");
            ChildAssociationRef folder05CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, folder05QName, folder05NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 8, 1, ContentModel.TYPE_FOLDER, null, folder05Properties, null, "fred", new ChildAssociationRef[]{folder05CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString()}, folder05NodeRef, true);
            HashMap<QName, PropertyValue> folder06Properties = new HashMap<QName, PropertyValue>();
            folder06Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 6"));
            HashMap folder06Content = new HashMap();
            NodeRef folder06NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder06QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 6");
            ChildAssociationRef folder06CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder05NodeRef, folder06QName, folder06NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 9, 1, ContentModel.TYPE_FOLDER, null, folder06Properties, null, "gail", new ChildAssociationRef[]{folder06CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString()}, folder06NodeRef, true);
            HashMap<QName, PropertyValue> folder07Properties = new HashMap<QName, PropertyValue>();
            folder07Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 7"));
            HashMap folder07Content = new HashMap();
            NodeRef folder07NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder07QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 7");
            ChildAssociationRef folder07CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder06NodeRef, folder07QName, folder07NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 10, 1, ContentModel.TYPE_FOLDER, null, folder07Properties, null, "hal", new ChildAssociationRef[]{folder07CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString()}, folder07NodeRef, true);
            HashMap<QName, PropertyValue> folder08Properties = new HashMap<QName, PropertyValue>();
            folder08Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 8"));
            HashMap folder08Content = new HashMap();
            NodeRef folder08NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder08QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 8");
            ChildAssociationRef folder08CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder07NodeRef, folder08QName, folder08NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 11, 1, ContentModel.TYPE_FOLDER, null, folder08Properties, null, "ian", new ChildAssociationRef[]{folder08CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef, folder07NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString() + "/" + folder08QName.toString()}, folder08NodeRef, true);
            HashMap<QName, PropertyValue> folder09Properties = new HashMap<QName, PropertyValue>();
            folder09Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Folder 9'"));
            HashMap folder09Content = new HashMap();
            NodeRef folder09NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName folder09QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Folder 9'");
            ChildAssociationRef folder09CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder08NodeRef, folder09QName, folder09NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 12, 1, ContentModel.TYPE_FOLDER, null, folder09Properties, null, "jake", new ChildAssociationRef[]{folder09CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef, folder07NodeRef, folder08NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString() + "/" + folder08QName.toString() + "/" + folder09QName.toString()}, folder09NodeRef, true);
            HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc00 = new MLTextPropertyValue();
            desc00.addValue(Locale.ENGLISH, "Alfresco tutorial");
            desc00.addValue(Locale.US, "Alfresco tutorial");
            content00Properties.put(ContentModel.PROP_DESCRIPTION, desc00);
            content00Properties.put(ContentModel.PROP_TITLE, desc00);
            content00Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Alfresco Tutorial"));
            content00Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content00Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            content00Properties.put(ContentModel.PROP_VERSION_LABEL, new StringPropertyValue("1.0"));
            content00Properties.put(ContentModel.PROP_OWNER, new StringPropertyValue("andy"));
            Date date00 = new Date();
            content00Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date00)));
            content00Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date00)));
            HashMap<QName, String> content00Content = new HashMap<QName, String>();
            content00Content.put(ContentModel.PROP_CONTENT, "The quick brown fox jumped over the lazy dog and ate the Alfresco Tutorial, in pdf format, along with the following stop words;  a an and are as at be but by for if in into is it no not of on or such that the their then there these they this to was will with:  and random charcters \u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff");
            NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Alfresco Tutorial");
            ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 13, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, content00Content, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, true);
            HashMap<QName, PropertyValue> content01Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc01 = new MLTextPropertyValue();
            desc01.addValue(Locale.ENGLISH, "One");
            desc01.addValue(Locale.US, "One");
            content01Properties.put(ContentModel.PROP_DESCRIPTION, desc01);
            content01Properties.put(ContentModel.PROP_TITLE, desc01);
            content01Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content01Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("AA%"));
            content01Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content01Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date01 = new Date(date00.getTime() + 1000L);
            content01Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date01)));
            content01Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date01)));
            HashMap<QName, String> content01Content = new HashMap<QName, String>();
            content01Content.put(ContentModel.PROP_CONTENT, "One Zebra Apple");
            NodeRef content01NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content01QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"AA%");
            ChildAssociationRef content01CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder01NodeRef, content01QName, content01NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 14, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content01Properties, content01Content, "cmis", new ChildAssociationRef[]{content01CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder01NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder01QName.toString() + "/" + content01QName.toString()}, content01NodeRef, true);
            HashMap<QName, PropertyValue> content02Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc02 = new MLTextPropertyValue();
            desc02.addValue(Locale.ENGLISH, "Two");
            desc02.addValue(Locale.US, "Two");
            content02Properties.put(ContentModel.PROP_DESCRIPTION, desc02);
            content02Properties.put(ContentModel.PROP_TITLE, desc02);
            content02Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content02Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("BB_"));
            content02Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content02Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date02 = new Date(date01.getTime() + 1000L);
            content02Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date02)));
            content02Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date02)));
            HashMap<QName, String> content02Content = new HashMap<QName, String>();
            content02Content.put(ContentModel.PROP_CONTENT, "Two Zebra Banana");
            NodeRef content02NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content02QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"BB_");
            ChildAssociationRef content02CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder02NodeRef, content02QName, content02NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 15, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content02Properties, content02Content, "cmis", new ChildAssociationRef[]{content02CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder02NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder02QName.toString() + "/" + content02QName.toString()}, content02NodeRef, true);
            HashMap<QName, PropertyValue> content03Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc03 = new MLTextPropertyValue();
            desc03.addValue(Locale.ENGLISH, "Three");
            desc03.addValue(Locale.US, "Three");
            content03Properties.put(ContentModel.PROP_DESCRIPTION, desc03);
            content03Properties.put(ContentModel.PROP_TITLE, desc03);
            content03Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content03Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("CC\\"));
            content03Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content03Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date03 = new Date(date02.getTime() + 1000L);
            content03Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date03)));
            content03Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date03)));
            HashMap<QName, String> content03Content = new HashMap<QName, String>();
            content03Content.put(ContentModel.PROP_CONTENT, "Three Zebra Clementine");
            NodeRef content03NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content03QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"CC\\");
            ChildAssociationRef content03CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder03NodeRef, content03QName, content03NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 16, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content03Properties, content03Content, "cmis", new ChildAssociationRef[]{content03CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder03NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder03QName.toString() + "/" + content03QName.toString()}, content03NodeRef, true);
            HashMap<QName, PropertyValue> content04Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc04 = new MLTextPropertyValue();
            desc04.addValue(Locale.ENGLISH, "Four");
            desc04.addValue(Locale.US, "Four");
            content04Properties.put(ContentModel.PROP_DESCRIPTION, desc04);
            content04Properties.put(ContentModel.PROP_TITLE, desc04);
            content04Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content04Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("DD'"));
            content04Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content04Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date04 = new Date(date03.getTime() + 1000L);
            content04Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date04)));
            content04Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date04)));
            HashMap<QName, String> content04Content = new HashMap<QName, String>();
            content04Content.put(ContentModel.PROP_CONTENT, "Four zebra durian");
            NodeRef content04NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content04QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"DD'");
            ChildAssociationRef content04CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder04NodeRef, content04QName, content04NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 17, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content04Properties, content04Content, null, new ChildAssociationRef[]{content04CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder04NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder04QName.toString() + "/" + content04QName.toString()}, content04NodeRef, true);
            HashMap<QName, PropertyValue> content05Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc05 = new MLTextPropertyValue();
            desc05.addValue(Locale.ENGLISH, "Five");
            desc05.addValue(Locale.US, "Five");
            content05Properties.put(ContentModel.PROP_DESCRIPTION, desc05);
            content05Properties.put(ContentModel.PROP_TITLE, desc05);
            content05Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content05Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("EE.aa"));
            content05Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content05Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date05 = new Date(date04.getTime() + 1000L);
            content05Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date05)));
            content05Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date05)));
            content05Properties.put(ContentModel.PROP_EXPIRY_DATE, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)"2012-12-12T12:12:12.012Z"))));
            content05Properties.put(ContentModel.PROP_LOCK_OWNER, new StringPropertyValue("andy"));
            content05Properties.put(ContentModel.PROP_LOCK_TYPE, new StringPropertyValue("WRITE_LOCK"));
            HashMap<QName, String> content05Content = new HashMap<QName, String>();
            content05Content.put(ContentModel.PROP_CONTENT, "Five zebra Ebury");
            NodeRef content05NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content05QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"EE.aa");
            ChildAssociationRef content05CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder05NodeRef, content05QName, content05NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 18, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED, ContentModel.ASPECT_LOCKABLE}, content05Properties, content05Content, null, new ChildAssociationRef[]{content05CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content05QName.toString()}, content05NodeRef, true);
            HashMap<QName, PropertyValue> content06Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc06 = new MLTextPropertyValue();
            desc06.addValue(Locale.ENGLISH, "Six");
            desc06.addValue(Locale.US, "Six");
            content06Properties.put(ContentModel.PROP_DESCRIPTION, desc06);
            content06Properties.put(ContentModel.PROP_TITLE, desc06);
            content06Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content06Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("FF.EE"));
            content06Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content06Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date06 = new Date(date05.getTime() + 1000L);
            content06Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date06)));
            content06Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date06)));
            HashMap<QName, String> content06Content = new HashMap<QName, String>();
            content06Content.put(ContentModel.PROP_CONTENT, "Six zebra fig");
            NodeRef content06NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content06QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"FF.EE");
            ChildAssociationRef content06CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder06NodeRef, content06QName, content06NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 19, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content06Properties, content06Content, null, new ChildAssociationRef[]{content06CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + content06QName.toString()}, content06NodeRef, true);
            HashMap<QName, PropertyValue> content07Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc07 = new MLTextPropertyValue();
            desc07.addValue(Locale.ENGLISH, "Seven");
            desc07.addValue(Locale.US, "Seven");
            content07Properties.put(ContentModel.PROP_DESCRIPTION, desc07);
            content07Properties.put(ContentModel.PROP_TITLE, desc07);
            content07Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content07Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("GG*GG"));
            content07Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content07Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date07 = new Date(date06.getTime() + 1000L);
            content07Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date07)));
            content07Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date07)));
            HashMap<QName, String> content07Content = new HashMap<QName, String>();
            content07Content.put(ContentModel.PROP_CONTENT, "Seven zebra grapefruit");
            NodeRef content07NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content07QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"GG*GG");
            ChildAssociationRef content07CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder07NodeRef, content07QName, content07NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 20, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content07Properties, content07Content, null, new ChildAssociationRef[]{content07CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef, folder07NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString() + "/" + content07QName.toString()}, content07NodeRef, true);
            HashMap<QName, PropertyValue> content08Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc08 = new MLTextPropertyValue();
            desc08.addValue(Locale.ENGLISH, "Eight");
            desc08.addValue(Locale.US, "Eight");
            content08Properties.put(ContentModel.PROP_DESCRIPTION, desc08);
            content08Properties.put(ContentModel.PROP_TITLE, desc08);
            content08Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-8", "text/plain"));
            content08Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("HH?HH"));
            content08Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content08Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date08 = new Date(date07.getTime() + 1000L);
            content08Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date08)));
            content08Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date08)));
            HashMap<QName, String> content08Content = new HashMap<QName, String>();
            content08Content.put(ContentModel.PROP_CONTENT, "Eight zebra jackfruit");
            NodeRef content08NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content08QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"HH?HH");
            ChildAssociationRef content08CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder08NodeRef, content08QName, content08NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 21, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content08Properties, content08Content, null, new ChildAssociationRef[]{content08CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef, folder07NodeRef, folder08NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString() + "/" + folder08QName.toString() + "/" + content08QName.toString()}, content08NodeRef, true);
            HashMap<QName, PropertyValue> content09Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc09 = new MLTextPropertyValue();
            desc09.addValue(Locale.ENGLISH, "Nine");
            desc09.addValue(Locale.US, "Nine");
            content09Properties.put(ContentModel.PROP_DESCRIPTION, desc09);
            content09Properties.put(ContentModel.PROP_TITLE, desc09);
            content09Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-9", "text/plain"));
            content09Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("aa"));
            content09Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content09Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date09 = new Date(date08.getTime() + 1000L);
            content09Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date09)));
            content09Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date09)));
            content09Properties.put(ContentModel.PROP_VERSION_LABEL, new StringPropertyValue("label"));
            HashMap<QName, String> content09Content = new HashMap<QName, String>();
            content09Content.put(ContentModel.PROP_CONTENT, "Nine zebra kiwi");
            NodeRef content09NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content09QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"aa");
            ChildAssociationRef content09CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder09NodeRef, content09QName, content09NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 22, 1, ContentModel.TYPE_CONTENT, new QName[]{ContentModel.ASPECT_TITLED}, content09Properties, content09Content, null, new ChildAssociationRef[]{content09CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef, folder07NodeRef, folder08NodeRef, folder09NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString() + "/" + folder08QName.toString() + "/" + folder09QName.toString() + "/" + content09QName.toString()}, content09NodeRef, true);
            HashMap<QName, PropertyValue> content10Properties = new HashMap<QName, PropertyValue>();
            MLTextPropertyValue desc10 = new MLTextPropertyValue();
            desc10.addValue(Locale.ENGLISH, "Ten");
            desc10.addValue(Locale.US, "Ten");
            content10Properties.put(ContentModel.PROP_DESCRIPTION, desc10);
            content10Properties.put(ContentModel.PROP_TITLE, desc10);
            content10Properties.put(ContentModel.PROP_CONTENT, new ContentPropertyValue(Locale.UK, 0L, "UTF-9", "text/plain"));
            content10Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("aa-thumb"));
            content10Properties.put(ContentModel.PROP_CREATOR, new StringPropertyValue("System"));
            content10Properties.put(ContentModel.PROP_MODIFIER, new StringPropertyValue("System"));
            Date date10 = new Date(date09.getTime() + 1000L);
            content10Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date10)));
            content10Properties.put(ContentModel.PROP_MODIFIED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date10)));
            content10Properties.put(ContentModel.PROP_VERSION_LABEL, new StringPropertyValue("label"));
            HashMap<QName, String> content10Content = new HashMap<QName, String>();
            content10Content.put(ContentModel.PROP_CONTENT, "Ten zebra kiwi thumb");
            NodeRef content10NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
            QName content10QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"aa-thumb");
            ChildAssociationRef content10CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder09NodeRef, content10QName, content10NodeRef, true, 0);
            this.addNode(core, dataModel, 1, 23, 1, ContentModel.TYPE_DICTIONARY_MODEL, new QName[]{ContentModel.ASPECT_TITLED}, content10Properties, content10Content, null, new ChildAssociationRef[]{content10CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef, folder05NodeRef, folder06NodeRef, folder07NodeRef, folder08NodeRef, folder09NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + folder05QName.toString() + "/" + folder06QName.toString() + "/" + folder07QName.toString() + "/" + folder08QName.toString() + "/" + folder09QName.toString() + "/" + content10QName.toString()}, content10NodeRef, true);
            this.checkCmisBasic(rsp, core, dataModel);
            this.checkCmisParentId(rsp, core, dataModel, baseFolderNodeRef.toString());
            this.checkCmisContentStreamFileName(rsp, core, dataModel);
            this.checkCmisContentStreamMimeType(rsp, core, dataModel);
            this.checkCmisContentStreamLength(rsp, core, dataModel);
            this.checkCmisName(rsp, core, dataModel);
            this.checkCmisLastModificationDate(rsp, core, dataModel, date10);
            this.checkCmisLastModifiedBy(rsp, core, dataModel);
            this.checkCmisCreationDate(rsp, core, dataModel, date10);
            this.checkCmisCreatedBy(rsp, core, dataModel);
            this.checkCmisObjectTypeId(rsp, core, dataModel);
            this.checkCmisObjecId(rsp, core, dataModel, folder00NodeRef.toString(), content00NodeRef.toString());
            this.checkCmisOrderby(rsp, core, dataModel);
            this.checkCmisUpperAndLower(rsp, core, dataModel);
            this.checkCmisTextPredicates(rsp, core, dataModel);
            this.checkCmisSimpleConjunction(rsp, core, dataModel);
            this.checkCmisSimpleDisjunction(rsp, core, dataModel);
            this.checkCmisExists(rsp, core, dataModel);
            this.checkInTree(rsp, core, dataModel, folder00NodeRef.toString());
            this.checkInFolder(rsp, core, dataModel, folder00NodeRef.toString());
            this.checkFTS(rsp, core, dataModel);
            this.checkAccessAs(rsp, core, dataModel);
            this.checkDateFormatting(rsp, core, dataModel);
            this.checkAspectJoin(rsp, core, dataModel);
            this.checkFTSConnectives(rsp, core, dataModel);
            this.checkLikeEscaping(rsp, core, dataModel);
            this.addTypeTestData(core, dataModel, folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date00);
            this.check_D_text(rsp, core, dataModel);
            this.check_locale(rsp, core, dataModel);
            this.check_D_mltext(rsp, core, dataModel);
            this.check_D_float(rsp, core, dataModel);
            this.check_D_double(rsp, core, dataModel);
            this.check_D_int(rsp, core, dataModel);
            this.check_D_long(rsp, core, dataModel);
            this.check_D_date(rsp, core, dataModel, date00);
            this.check_D_datetime(rsp, core, dataModel, date00);
            this.check_D_boolean(rsp, core, dataModel);
            this.check_contains_syntax(rsp, core, dataModel);
            this.addTypeSortTestData(core, dataModel, folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date00);
            this.check_order(rsp, core, dataModel);
            if (remove) {
                SolrCore done = this.coreContainer.remove(name);
                if (done != null) {
                    done.close();
                }
                this.deleteDirectory(newCore);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void checkCmisBasic(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("CMIS Basic", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * from cmis:folder", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * from cmis:document", 11, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisParentId(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, String base) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:parentId", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId =  '" + base.toString() + "'", 4, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId <> '" + base.toString() + "'", 7, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IN     ('" + base.toString() + "')", 4, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId NOT IN ('" + base.toString() + "')", 7, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisContentStreamFileName(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:contentStreamFileName", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'AA%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'BB_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'CC\\\\'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'DD\\''", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'EE.aa'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'FF.EE'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'GG*GG'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'HH?HH'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'aa'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <> 'Alfresco Tutorial'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <  'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <= 'Alfresco Tutorial'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName >  'Alfresco Tutorial'", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName >= 'Alfresco Tutorial'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IN     ('Alfresco Tutorial')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName NOT IN ('Alfresco Tutorial')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName     LIKE 'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName NOT LIKE 'Alfresco Tutorial'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisContentStreamMimeType(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:contentStreamMimeType", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType =  'text/plain'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <> 'text/plain'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <  'text/plain'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <= 'text/plain'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType >  'text/plain'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType >= 'text/plain'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IN     ('text/plain')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType NOT IN ('text/plain')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType     LIKE 'text/plain'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType NOT LIKE 'text/plain'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisContentStreamLength(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:contentStreamLength", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength =  750", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <> 750", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <  750", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <= 750", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength >  750", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength >= 750", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IN     (750)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength NOT IN (750)", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength     LIKE '750'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength NOT LIKE '750'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisName(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:name", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name =  'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name <> 'Folder 1'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name <  'Folder 1'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name <= 'Folder 1'", 3, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name >  'Folder 1'", 8, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name >= 'Folder 1'", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name IN     ('Folder 1')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name NOT IN ('Folder 1')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name     LIKE 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name NOT LIKE 'Folder 1'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder WHERE cmis:name IS     NULL", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name =  'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name <> 'Alfresco Tutorial'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name <  'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name <= 'Alfresco Tutorial'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name >  'Alfresco Tutorial'", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name >= 'Alfresco Tutorial'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name IN     ('Alfresco Tutorial')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name NOT IN ('Alfresco Tutorial')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name NOT LIKE 'Alfresco Tutorial'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisLastModificationDate(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, Date lastModificationDate) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:lastModificationDate", (Object)report);
        String sDate = ISO8601DateFormat.format((Date)lastModificationDate);
        TimeZone.setDefault(TimeZone.getTimeZone("PST"));
        String sDate2 = ISO8601DateFormat.format((Date)lastModificationDate);
        TimeZone.setDefault(null);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate = TIMESTAMP '" + sDate + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate = TIMESTAMP '" + sDate2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate =  '" + sDate + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <> '" + sDate + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <  '" + sDate + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <= '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >= '" + sDate + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IN     ('" + sDate + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT IN ('" + sDate + "')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS     NULL", 0, null, null, null, null, null, new String[]{null});
        Date date = Duration.subtract((Date)lastModificationDate, (Duration)new Duration("P1D"));
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(date);
        yesterday.set(14, yesterday.getMinimum(14));
        sDate = ISO8601DateFormat.format((Date)yesterday.getTime());
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate =  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <> '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <= '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >  '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >= '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IN     ('" + sDate + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT IN ('" + sDate + "')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS     NULL", 0, null, null, null, null, null, new String[]{null});
        date = Duration.add((Date)date, (Duration)new Duration("P2D"));
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(date);
        tomorrow.set(14, tomorrow.getMinimum(14));
        sDate = ISO8601DateFormat.format((Date)tomorrow.getTime());
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate =  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <> '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <  '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <= '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >= '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IN     ('" + sDate + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT IN ('" + sDate + "')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisLastModifiedBy(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:lastModifiedBy", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy =  'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy <> 'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy <  'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy <= 'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy >  'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy >= 'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy IN     ('System')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy NOT IN ('System')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy     LIKE 'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy NOT LIKE 'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisCreationDate(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, Date lastModificationDate) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:creationDate", (Object)report);
        String sDate = ISO8601DateFormat.format((Date)lastModificationDate);
        TimeZone.setDefault(TimeZone.getTimeZone("PST"));
        String sDate2 = ISO8601DateFormat.format((Date)lastModificationDate);
        TimeZone.setDefault(null);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate = TIMESTAMP '" + sDate + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate = TIMESTAMP '" + sDate2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate =  '" + sDate + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <> '" + sDate + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <  '" + sDate + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <= '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >= '" + sDate + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IN     ('" + sDate + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT IN ('" + sDate + "')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS     NULL", 0, null, null, null, null, null, new String[]{null});
        Date date = Duration.subtract((Date)lastModificationDate, (Duration)new Duration("P1D"));
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(date);
        yesterday.set(14, yesterday.getMinimum(14));
        sDate = ISO8601DateFormat.format((Date)yesterday.getTime());
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate =  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <> '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <= '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >  '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >= '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IN     ('" + sDate + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT IN ('" + sDate + "')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS     NULL", 0, null, null, null, null, null, new String[]{null});
        date = Duration.add((Date)date, (Duration)new Duration("P2D"));
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(date);
        tomorrow.set(14, tomorrow.getMinimum(14));
        sDate = ISO8601DateFormat.format((Date)tomorrow.getTime());
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate =  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <> '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <  '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <= '" + sDate + "'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >  '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >= '" + sDate + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IN     ('" + sDate + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT IN ('" + sDate + "')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisCreatedBy(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:createdBy", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy =  'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <> 'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <  'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <= 'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy >  'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy >= 'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IN     ('System')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy NOT IN ('System')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy     LIKE 'System'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy NOT LIKE 'System'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisObjectTypeId(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:objectTypeId", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId =  'cmis:document'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId <> 'cmis:document'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IN     ('cmis:document')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId NOT IN ('cmis:document')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IS     NULL", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId =  'cmis:folder'", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <> 'cmis:folder'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IN     ('cmis:folder')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId NOT IN ('cmis:folder')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisObjecId(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, String folderId, String docId) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("cmis:objectId", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId =  '" + folderId + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <> '" + folderId + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IN     ('" + folderId + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId  NOT IN('" + folderId + "')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE IN_FOLDER('" + folderId + "')", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE IN_TREE  ('" + folderId + "')", 6, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IS     NULL", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId =  '" + folderId + ";1.0'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <> '" + folderId + ";1.0'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IN     ('" + folderId + ";1.0')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId  NOT IN('" + folderId + ";1.0')", 10, null, null, null, null, null, new String[]{null});
        String id = docId;
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId =  '" + id + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId <> '" + id + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IN     ('" + id + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId  NOT IN('" + id + "')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS     NULL", 0, null, null, null, null, null, new String[]{null});
        id = docId + ";1.0";
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId =  '" + id + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId <> '" + id + "'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IN     ('" + id + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId  NOT IN('" + id + "')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS     NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisOrderby(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("CMIS Order by", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectTypeId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId DESC", 11, null, new int[]{12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY Meep", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY cmis:objectId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY Meep ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY Meep DESC", 11, null, new int[]{12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder F ORDER BY F.cmis:objectId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder F ORDER BY cmis:objectId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder F ORDER BY F.cmis:objectId ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  cmis:objectId FROM cmis:folder F ORDER BY F.cmis:objectId DESC", 11, null, new int[]{12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY Meep", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY F.cmis:objectId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY cmis:objectId", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY Meep ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY Meep DESC", 11, null, new int[]{12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY MEEP", 11, null, new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE(), cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY SEARCH_SCORE", 11, null, new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY MEEP ASC", 11, null, new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY MEEP DESC", 11, null, new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder where CONTAINS('cmis:name:*') ORDER BY MEEP", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder where CONTAINS('cmis:name:*') ORDER BY MEEP ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder where CONTAINS('cmis:name:*') ORDER BY MEEP DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder ORDER BY cmis:objectTypeId ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:objectTypeId FROM cmis:folder ORDER BY cmis:objectTypeId DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:folder ORDER BY cmis:createdBy ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:createdBy FROM cmis:folder ORDER BY cmis:createdBy DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:folder ORDER BY cmis:creationDate ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:creationDate FROM cmis:folder ORDER BY cmis:creationDate DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:folder ORDER BY cmis:lastModifiedBy ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModifiedBy FROM cmis:folder ORDER BY cmis:lastModifiedBy DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:folder ORDER BY cmis:lastModificationDate ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:lastModificationDate FROM cmis:folder ORDER BY cmis:lastModificationDate DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder ORDER BY cmis:name ASC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:folder ORDER BY cmis:name DESC", 11, null, new int[]{12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document ORDER BY cmis:name ASC", 11, null, new int[]{22, 14, 23, 13, 15, 16, 17, 18, 19, 20, 21}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document ORDER BY cmis:name DESC", 11, null, new int[]{21, 20, 19, 18, 17, 16, 15, 13, 23, 14, 22}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE() AS MEEP, cmis:objectId, cmis:parentId FROM cmis:folder WHERE CONTAINS('cmis:name:*') ORDER BY cmis:parentId DESC", 11, null, new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, null, null, null, new String[]{null});
    }

    private void checkCmisUpperAndLower(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Upper and Lower", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name = 'FOLDER 1'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name = 'folder 1'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) = 'FOLDER 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Lower(cmis:name) = 'folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) = 'folder 1'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Lower(cmis:name) = 'FOLDER 1'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) = 'Folder 1'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Lower(cmis:name) = 'Folder 1'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) <> 'FOLDER 1'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) <= 'FOLDER 1'", 3, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) <  'FOLDER 1'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) >= 'FOLDER 1'", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE Upper(cmis:name) >  'FOLDER 1'", 8, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisTextPredicates(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Text predicates", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 9'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 9\\''", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND NOT cmis:name = 'Folder 1'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND 'Folder 1' = ANY cmis:name", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND NOT cmis:name <> 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <> 'Folder 1'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <  'Folder 1'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <= 'Folder 1'", 3, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name >  'Folder 1'", 8, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name >= 'Folder 1'", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name IN ('Folder 1', '1')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT IN ('Folder 1', 'Folder 9\\'')", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND ANY cmis:name IN ('Folder 1', 'Folder 9\\'')", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND ANY cmis:name NOT IN ('2', '3')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'Fol%'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ 1'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ %'", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ %'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ _'", 9, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ _'", 2, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisSimpleConjunction(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Simple conjunction", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder'", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisSimpleDisjunction(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Simple disjunction", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 2'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1' OR cmis:name = 'Folder 2'", 2, null, null, null, null, null, new String[]{null});
    }

    private void checkCmisExists(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Exists", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE cmis:name IS NULL", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE cmis:name IS NOT NULL", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE cmis:name IS NULL", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkInTree(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, String id) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("In Tree", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE IN_TREE('" + id + "')", 6, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder F WHERE IN_TREE(F, '" + id + "')", 6, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, O.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_TREE(D, '" + id + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE IN_TREE('woof://woof/woof')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE IN_TREE('woof://woof/woof;woof')", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkInFolder(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, String id) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("In Folder", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE IN_FOLDER('" + id + "')", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder F WHERE IN_FOLDER(F, '" + id + "')", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, O.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_FOLDER(D, '" + id + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE IN_FOLDER('woof://woof/woof')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE IN_FOLDER('woof://woof/woof;woof')", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkFTS(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("FTS", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT SCORE()as ONE, SCORE()as TWO, D.* FROM cmis:document D WHERE CONTAINS('\\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'quick\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'quick\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document D WHERE CONTAINS(D, 'cmis:name:\\'Tutorial\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name as BOO FROM cmis:document D WHERE CONTAINS('BOO:\\'Tutorial\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document D WHERE CONTAINS('TEXT:\\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document D WHERE CONTAINS('ALL:\\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document D WHERE CONTAINS('d:content:\\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
    }

    private void checkAccessAs(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Access", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 0, null, null, null, null, null, "{!afts}|AUTHORITY:guest");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 0, null, null, null, null, null, "{!afts}|AUTHSET:\":guest\"");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 3, null, null, null, null, null, "{!afts}|AUTHORITY:cmis");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 3, null, null, null, null, null, "{!afts}|AUTHSET:\":cmis\"");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 1, null, null, null, null, null, "{!afts}|OWNER:andy");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 1, null, null, null, null, null, "{!afts}|OWNERSET:\":andy\"");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 1, null, null, null, null, null, "{!afts}|AUTHORITY:andy");
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":andy\"");
    }

    private void checkDateFormatting(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Date formatting", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-12-12T12:12:12.012Z'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-012-12T12:12:12.012Z'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-2-12T12:12:12.012Z'", 0, null, null, null, null, null, new String[]{null});
    }

    private void checkAspectJoin(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Aspect Join", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId  ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, '\\'jumped\\'') and D.cmis:contentStreamLength <> 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cm:ownable", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cm:ownable where cm:owner = 'andy'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cm:ownable where cm:owner = 'bob'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, O.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, O.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, O.*, T.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId JOIN cm:titled AS T ON T.cmis:objectId = D.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, O.* FROM cm:ownable O JOIN cmis:document D ON D.cmis:objectId = O.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT D.*, F.* FROM cmis:folder F JOIN cmis:document D ON D.cmis:objectId = F.cmis:objectId", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT O.*, T.* FROM cm:ownable O JOIN cm:titled T ON O.cmis:objectId = T.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select o.*, t.* from cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "sElEcT o.*, T.* fRoM cm:ownable o JoIn cm:titled T oN o.cmis:objectId = T.cmis:objectId", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId )", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId  JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId  )", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, '\\'jumped\\'') and D.cmis:contentStreamLength <> 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, 'jumped') and D.cmis:contentStreamLength <> 2", 1, null, null, null, null, null, new String[]{null});
    }

    private void checkFTSConnectives(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("FTS Connectives", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document where contains('\\'one\\' OR \\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document where contains('\\'one\\' or \\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document where contains('\\'one\\' \\'zebra\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document where contains('\\'one\\' and \\'zebra\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document where contains('\\'one\\' or \\'zebra\\'')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document where contains('\\'one\\'  \\'zebra\\'')", 1, null, null, null, null, null, new String[]{null});
    }

    private void checkLikeEscaping(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("Like Escaping", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutorial'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutoria_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T_______'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T______\\_'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T\\%'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'GG*GG'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '__*__'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '%*%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'HH?HH'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '__?__'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '%?%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'AA%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'AA\\%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'A%'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'a%'", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'A\\%'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'BB_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'BB\\_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B__'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B_\\_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B\\_\\_'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'CC\\\\'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'DD\\''", 1, null, null, null, null, null, new String[]{null});
    }

    private void addTypeTestData(SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, Object baseFolderQName, Object folder00QName, Date date1) throws IOException {
        HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
        MLTextPropertyValue desc00 = new MLTextPropertyValue();
        desc00.addValue(Locale.ENGLISH, "Test One");
        desc00.addValue(Locale.US, "Test 1");
        content00Properties.put(ContentModel.PROP_DESCRIPTION, desc00);
        content00Properties.put(ContentModel.PROP_TITLE, desc00);
        content00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Test One"));
        content00Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date1)));
        StringPropertyValue single = new StringPropertyValue("Un tokenised");
        content00Properties.put(this.singleTextUntokenised, single);
        content00Properties.put(this.singleTextTokenised, single);
        content00Properties.put(this.singleTextBoth, single);
        MultiPropertyValue multi = new MultiPropertyValue();
        multi.addValue(single);
        multi.addValue(new StringPropertyValue("two parts"));
        content00Properties.put(this.multipleTextUntokenised, multi);
        content00Properties.put(this.multipleTextTokenised, multi);
        content00Properties.put(this.multipleTextBoth, multi);
        content00Properties.put(this.singleMLTextUntokenised, this.makeMLText());
        content00Properties.put(this.singleMLTextTokenised, this.makeMLText());
        content00Properties.put(this.singleMLTextBoth, this.makeMLText());
        content00Properties.put(this.multipleMLTextUntokenised, this.makeMLTextMVP());
        content00Properties.put(this.multipleMLTextTokenised, this.makeMLTextMVP());
        content00Properties.put(this.multipleMLTextBoth, this.makeMLTextMVP());
        StringPropertyValue one = new StringPropertyValue("1");
        StringPropertyValue two = new StringPropertyValue("2");
        MultiPropertyValue multiDec = new MultiPropertyValue();
        multiDec.addValue(one);
        multiDec.addValue(new StringPropertyValue("1.1"));
        content00Properties.put(this.singleFloat, one);
        content00Properties.put(this.multipleFloat, multiDec);
        content00Properties.put(this.singleDouble, one);
        content00Properties.put(this.multipleDouble, multiDec);
        MultiPropertyValue multiInt = new MultiPropertyValue();
        multiInt.addValue(one);
        multiInt.addValue(two);
        content00Properties.put(this.singleInteger, one);
        content00Properties.put(this.multipleInteger, multiInt);
        content00Properties.put(this.singleLong, one);
        content00Properties.put(this.multipleLong, multiInt);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date1);
        cal.add(5, -1);
        Date date0 = cal.getTime();
        cal.add(5, 2);
        Date date2 = cal.getTime();
        StringPropertyValue d0 = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date0));
        StringPropertyValue d1 = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date1));
        StringPropertyValue d2 = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date2));
        MultiPropertyValue multiDate = new MultiPropertyValue();
        multiDate.addValue(d1);
        multiDate.addValue(d2);
        content00Properties.put(this.singleDate, d1);
        content00Properties.put(this.multipleDate, multiDate);
        content00Properties.put(this.singleDatetime, d1);
        content00Properties.put(this.multipleDatetime, multiDate);
        StringPropertyValue bTrue = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)true));
        StringPropertyValue bFalse = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)false));
        MultiPropertyValue multiBool = new MultiPropertyValue();
        multiBool.addValue(bTrue);
        multiBool.addValue(bFalse);
        content00Properties.put(this.singleBoolean, bTrue);
        content00Properties.put(this.multipleBoolean, multiBool);
        NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
        QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Test One");
        ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
        this.addNode(core, dataModel, 1, 100, 1, this.extendedContent, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, null, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, true);
    }

    private void addTypeSortTestData(SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, Object baseFolderQName, Object folder00QName, Date date1) throws IOException {
        this.addSortableNull(core, dataModel, folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, "start", 0);
        for (int i = 0; i < 10; ++i) {
            this.addSortableNode(core, dataModel, folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, i);
            if (i != 5) continue;
            this.addSortableNull(core, dataModel, folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, "mid", 1);
        }
        this.addSortableNull(core, dataModel, folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, "end", 2);
    }

    private void addSortableNull(SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, Object baseFolderQName, Object folder00QName, Date date1, String id, int offset) throws IOException {
        HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
        MLTextPropertyValue desc00 = new MLTextPropertyValue();
        desc00.addValue(Locale.ENGLISH, "Test null");
        content00Properties.put(ContentModel.PROP_DESCRIPTION, desc00);
        content00Properties.put(ContentModel.PROP_TITLE, desc00);
        content00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Test null"));
        content00Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date1)));
        NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
        QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Test null");
        ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
        this.addNode(core, dataModel, 1, 200 + offset, 1, this.extendedContent, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, null, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, true);
    }

    private void addSortableNode(SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, Object baseFolderQName, Object folder00QName, Date date1, int position) throws IOException {
        HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
        MLTextPropertyValue desc00 = new MLTextPropertyValue();
        desc00.addValue(Locale.ENGLISH, "Test " + position);
        content00Properties.put(ContentModel.PROP_DESCRIPTION, desc00);
        content00Properties.put(ContentModel.PROP_TITLE, desc00);
        content00Properties.put(ContentModel.PROP_NAME, new StringPropertyValue("Test " + position));
        content00Properties.put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date1)));
        StringPropertyValue single = new StringPropertyValue(orderable[position]);
        content00Properties.put(this.singleTextUntokenised, single);
        content00Properties.put(this.singleTextTokenised, single);
        content00Properties.put(this.singleTextBoth, single);
        MultiPropertyValue multi = new MultiPropertyValue();
        multi.addValue(single);
        multi.addValue(new StringPropertyValue(orderable[position + 1]));
        content00Properties.put(this.multipleTextUntokenised, multi);
        content00Properties.put(this.multipleTextTokenised, multi);
        content00Properties.put(this.multipleTextBoth, multi);
        content00Properties.put(this.singleMLTextUntokenised, this.makeMLText(position));
        content00Properties.put(this.singleMLTextTokenised, this.makeMLText(position));
        content00Properties.put(this.singleMLTextBoth, this.makeMLText(position));
        content00Properties.put(this.multipleMLTextUntokenised, this.makeMLTextMVP(position));
        content00Properties.put(this.multipleMLTextTokenised, this.makeMLTextMVP(position));
        content00Properties.put(this.multipleMLTextBoth, this.makeMLTextMVP());
        StringPropertyValue one = new StringPropertyValue("" + 1.1 * (double)position);
        StringPropertyValue two = new StringPropertyValue("" + 2.2 * (double)position);
        MultiPropertyValue multiDec = new MultiPropertyValue();
        multiDec.addValue(one);
        multiDec.addValue(two);
        content00Properties.put(this.singleFloat, one);
        content00Properties.put(this.multipleFloat, multiDec);
        content00Properties.put(this.singleDouble, one);
        content00Properties.put(this.multipleDouble, multiDec);
        one = new StringPropertyValue("" + 1 * position);
        two = new StringPropertyValue("" + 2 * position);
        MultiPropertyValue multiInt = new MultiPropertyValue();
        multiInt.addValue(one);
        multiInt.addValue(two);
        content00Properties.put(this.singleInteger, one);
        content00Properties.put(this.multipleInteger, multiInt);
        content00Properties.put(this.singleLong, one);
        content00Properties.put(this.multipleLong, multiInt);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date1);
        cal.add(5, position);
        Date newdate1 = cal.getTime();
        cal.add(5, -1);
        Date date0 = cal.getTime();
        cal.add(5, 2);
        Date date2 = cal.getTime();
        StringPropertyValue d0 = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date0));
        StringPropertyValue d1 = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)newdate1));
        StringPropertyValue d2 = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date2));
        MultiPropertyValue multiDate = new MultiPropertyValue();
        multiDate.addValue(d1);
        multiDate.addValue(d2);
        content00Properties.put(this.singleDate, d1);
        content00Properties.put(this.multipleDate, multiDate);
        content00Properties.put(this.singleDatetime, d1);
        content00Properties.put(this.multipleDatetime, multiDate);
        StringPropertyValue b = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)(position % 2 == 0 ? 1 : 0)));
        StringPropertyValue bTrue = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)true));
        StringPropertyValue bFalse = new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)false));
        MultiPropertyValue multiBool = new MultiPropertyValue();
        multiBool.addValue(bTrue);
        multiBool.addValue(bFalse);
        content00Properties.put(this.singleBoolean, b);
        content00Properties.put(this.multipleBoolean, multiBool);
        NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
        QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("Test " + position));
        ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
        this.addNode(core, dataModel, 1, 1000 + position, 1, this.extendedContent, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, null, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, true);
    }

    private void check_D_text(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:text", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document", 12, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth = 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <> 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth LIKE 'U_ to%sed'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth NOT LIKE 't__eni%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'Un tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'V'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth < 'U'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'V'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth <= 'U'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'Un tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'V'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth > 'U'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'V'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextBoth >= 'U'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised = 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <> 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised LIKE 'U_ to%sed'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised NOT LIKE 't__eni%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'Un tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'V'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised < 'U'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'V'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised <= 'U'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'Un tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'V'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised > 'U'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'tokenised'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'V'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextUntokenised >= 'U'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised = 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised <> 'tokenized'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised LIKE 'to%sed'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised NOT LIKE 'Ut__eniz%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised IN ('tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleTextTokenised NOT IN ('tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias = 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias <> 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias LIKE 'U_ to%sed'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias NOT LIKE 't__eni%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextBoth as alias FROM cmistest:extendedContent as T WHERE alias NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias = 'Un tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias <> 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias LIKE 'U_ to%sed'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias NOT LIKE 't__eni%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:singleTextUntokenised as alias FROM cmistest:extendedContent as T WHERE alias NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'tokenised'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias <> 'tokenized'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'to%sed'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'Ut__eniz%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT IN ('tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY cmistest:multipleTextBoth ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextBoth IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextBoth NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY cmistest:multipleTextUntokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextUntokenised IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextUntokenised NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'tokenised' =  ANY cmistest:multipleTextTokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextTokenised IN ('tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleTextTokenised NOT IN ('tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleTextBoth as alias FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleTextBoth as alias FROM cmistest:extendedContent WHERE ANY alias IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleTextBoth as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleTextUntokenised alias FROM cmistest:extendedContent WHERE 'Un tokenised' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('Un tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('Un tokenized')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:multipleTextTokenised alias FROM cmistest:extendedContent T WHERE 'tokenised' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:multipleTextTokenised alias FROM cmistest:extendedContent T WHERE ANY alias IN ('tokenised', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT T.cmistest:multipleTextTokenised alias FROM cmistest:extendedContent T WHERE ANY alias NOT IN ('tokenized')", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_locale(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("CMIS locale", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'AAAA BBBB'", 1, null, null, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'AAAA BBBB'", 1, null, null, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'CCCC DDDD'", 1, null, null, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'CCCC DDDD'", 1, null, null, Locale.FRENCH, null, null, new String[]{null});
    }

    private void check_D_mltext(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:mltext", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'AAAA BBBB'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'AAAA'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = '%AAAA'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = '%AAA'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'BBBB'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth = 'CCCC DDDD'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth <> 'EEEE FFFF'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth LIKE 'AAA_ B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth LIKE 'CCC_ D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth NOT LIKE 'B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth NOT LIKE 'D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextBoth NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised = 'AAAA BBBB'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised = 'CCCC DDDD'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised <> 'EEEE FFFF'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised LIKE 'AAA_ B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised LIKE 'CCC_ D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised NOT LIKE 'B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised NOT LIKE 'D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextUntokenised NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'AAAA'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'BBBB'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'CCCC'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised = 'DDDD'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised <> 'EEEE'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE 'A%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE '_B__'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE '%C'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised LIKE 'D%D'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised NOT LIKE 'CCCC_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('AAAA', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('CCCC', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised IN ('DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleMLTextTokenised NOT IN ('EEEE')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'AAAA BBBB'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'AAAA'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'BBBB'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias = 'CCCC DDDD'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias <> 'EEEE FFFF'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias LIKE 'AAA_ B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias LIKE 'CCC_ D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextBoth as alias FROM cmistest:extendedContent WHERE alias NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias = 'AAAA BBBB'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias = 'CCCC DDDD'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias <> 'EEEE FFFF'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'AAA_ B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'CCC_ D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'B%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'D%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextUntokenised as alias FROM cmistest:extendedContent WHERE alias NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'AAAA'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'BBBB'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'CCCC'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias = 'DDDD'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias <> 'EEEE'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'A%'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE '_B__'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE '%C'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias LIKE 'D%D'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT LIKE 'CCCC_'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('AAAA', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('CCCC', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias IN ('DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleMLTextTokenised as alias FROM cmistest:extendedContent WHERE alias NOT IN ('EEEE')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY cmistest:multipleMLTextBoth ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY cmistest:multipleMLTextBoth ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextBoth IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextBoth IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextBoth NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY cmistest:multipleMLTextUntokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY cmistest:multipleMLTextUntokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextUntokenised NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'AAAA' =  ANY cmistest:multipleMLTextTokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'BBBB' =  ANY cmistest:multipleMLTextTokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'CCCC' =  ANY cmistest:multipleMLTextTokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE 'DDDD' =  ANY cmistest:multipleMLTextTokenised ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('AAAA', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('CCCC', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised IN ('DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleMLTextTokenised NOT IN ('EEEE')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextBoth alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE 'AAAA BBBB' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE 'CCCC DDDD' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextUntokenised alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'AAAA' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'BBBB' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'CCCC' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE 'DDDD' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('AAAA', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('BBBB', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('CCCC', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias IN ('DDDD', 'Monkey')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleMLTextTokenised alias FROM cmistest:extendedContent WHERE ANY alias NOT IN ('EEEE')", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_float(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:float", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat = 1.1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <> 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat < 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat <= 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat > 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat >= 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleFloat NOT IN (1.1)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias = 1.1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <> 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias < 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias <= 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias > 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias >= 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleFloat as alias FROM cmistest:extendedContent WHERE alias NOT IN (1.1)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleFloat ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1.1' =  ANY cmistest:multipleFloat ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat IN (1.1, 2.2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat NOT IN (1.1, 2.2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleFloat NOT IN (1.3, 2.3)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE '1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE '1.1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias IN (1.1, 2.2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleFloat as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.3, 2.3)", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_double(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:double", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble = 1.1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <> 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble < 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble <= 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble > 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble >= 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDouble NOT IN (1.1)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias = 1.1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <> 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias < 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias <= 1.1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias > 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias >= 0.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDouble alias FROM cmistest:extendedContent WHERE alias NOT IN (1.1)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleDouble ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1.1' =  ANY cmistest:multipleDouble ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble IN (1.1, 2.2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble NOT IN (1.1, 2.2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDouble NOT IN (1.3, 2.3)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE '1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE '1.1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias IN (1.1, 2.2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDouble alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1.3, 2.3)", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_int(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:int", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 2", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <> 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger < 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger <= 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger > 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger >= 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger NOT IN (2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias = 2", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <> 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias < 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias <= 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias > 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias >= 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleInteger alias FROM cmistest:extendedContent WHERE alias NOT IN (2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleInteger ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '2' =  ANY cmistest:multipleInteger ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger IN (2, 3)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger NOT IN (1, 2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger NOT IN (2, 3)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleInteger NOT IN (3, 4)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE '1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE '2' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias IN (2, 3)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1, 2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (2, 3)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleInteger as alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (3, 4)", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_long(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:long", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong = 2", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <> 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong < 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong <= 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong > 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong >= 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong NOT IN (2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias = 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias = 2", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <> 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <> 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias < 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias < 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias <= 2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias > 1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias > 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias >= 1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias >= 0", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleLong as alias FROM cmistest:extendedContent WHERE alias NOT IN (2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleLong ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '2' =  ANY cmistest:multipleLong ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong IN (2, 3)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong NOT IN (1, 2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong NOT IN (2, 3)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleLong NOT IN (3, 4)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE '1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE '2' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias IN (1, 2)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias IN (2, 3)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (1, 2)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (2, 3)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleLong alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (3, 4)", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_date(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, Date date1) throws IOException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date1);
        cal.add(5, -1);
        Date date0 = cal.getTime();
        cal.add(5, 2);
        Date date2 = cal.getTime();
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:date", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        String d0 = ISO8601DateFormat.format((Date)date0);
        String d1 = ISO8601DateFormat.format((Date)date1);
        String d2 = ISO8601DateFormat.format((Date)date2);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate = TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate = TIMESTAMP '" + d2 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <> TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <> TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate < TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate < TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate <= TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate > TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate > TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate >= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate >= TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDate NOT IN (TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDate as alias FROM cmistest:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY cmistest:multipleDate ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY cmistest:multipleDate ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDate NOT IN (TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDate alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_datetime(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, Date date1) throws IOException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date1);
        cal.add(5, -1);
        Date date0 = cal.getTime();
        cal.add(5, 2);
        Date date2 = cal.getTime();
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:datetime", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        String d0 = ISO8601DateFormat.format((Date)date0);
        String d1 = ISO8601DateFormat.format((Date)date1);
        String d2 = ISO8601DateFormat.format((Date)date2);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime = TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime = TIMESTAMP '" + d2 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <> TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <> TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime < TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime < TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime <= TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime > TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime > TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime >= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime >= TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleDatetime NOT IN (TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleDatetime alias FROM cmistest:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY cmistest:multipleDatetime ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY cmistest:multipleDatetime ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE ANY cmistest:multipleDatetime NOT IN (TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleDatetime alias FROM cmistest:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "')", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_D_boolean(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("d:boolean", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = TRUE", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = true", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = FALSE", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = false", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE cmistest:singleBoolean = TRue", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = TRUE", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = true", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = FALSE", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = false", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:singleBoolean alias FROM cmistest:extendedContent WHERE alias = TRue", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '1' =  ANY cmistest:multipleBoolean ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent WHERE '2' =  ANY cmistest:multipleBoolean ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleBoolean as alias FROM cmistest:extendedContent WHERE '1' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT cmistest:multipleBoolean as alias FROM cmistest:extendedContent WHERE '2' =  ANY alias ", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_contains_syntax(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("CMIS contains syntax", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmistest:extendedContent", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('-quick')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick brown fox')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick one')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick -one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('-quick one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('-quick -one')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('fox brown quick')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR one')", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR -one')", 11, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('-quick OR -one')", 12, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'fox brown quick\\'')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\' one')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\' -one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('-\\'quick brown fox\\' one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('-\\'quick brown fox\\' -one')", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:folder WHERE CONTAINS('cmis:name:\\'Folder 9\\\\\\'\\'')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown AND one')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR (brown AND one)')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('(quick OR brown) AND one')", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown OR one')", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown one')", 1, null, null, null, null, null, new String[]{null});
    }

    private void check_order(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        rsp.add("CMIS order", (Object)report);
        int[] asc = new int[]{200, 201, 202, 1008, 1005, 1004, 1009, 1001, 1007, 1006, 1003, 1002, 100, 1000};
        int[] desc = new int[]{1000, 100, 1002, 1003, 1006, 1007, 1001, 1009, 1004, 1005, 1008, 200, 201, 202};
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleTextUntokenised", asc, desc);
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleTextBoth", asc, desc);
        asc = new int[]{200, 201, 202, 1009, 100, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008};
        desc = new int[]{1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 100, 1000, 1009, 200, 201, 202};
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleMLTextUntokenised", asc, desc);
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleMLTextBoth", asc, desc);
        asc = new int[]{200, 201, 202, 1000, 100, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009};
        desc = new int[]{1009, 1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 100, 1000, 200, 201, 202};
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleFloat", asc, desc);
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleDouble", asc, desc);
        asc = new int[]{200, 201, 202, 1000, 100, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009};
        desc = new int[]{1009, 1008, 1007, 1006, 1005, 1004, 1003, 1002, 100, 1001, 1000, 200, 201, 202};
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleInteger", asc, desc);
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleLong", asc, desc);
        asc = new int[]{200, 201, 202, 100, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009};
        desc = new int[]{1009, 1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 100, 1000, 200, 201, 202};
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleDate", asc, desc);
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleDatetime", asc, desc);
        asc = new int[]{200, 201, 202, 1001, 1003, 1005, 1007, 1009, 100, 1000, 1002, 1004, 1006, 1008};
        desc = new int[]{100, 1000, 1002, 1004, 1006, 1008, 1001, 1003, 1005, 1007, 1009, 200, 201, 202};
        this.checkOrderableProperty(rsp, core, dataModel, (NamedList<Object>)report, "cmistest:singleBoolean", asc, desc);
    }

    private void checkOrderableProperty(SolrQueryResponse rsp, SolrCore core, AlfrescoSolrDataModel dataModel, NamedList<Object> report, String propertyQueryName, int[] asc, int[] desc) throws IOException {
        this.testQueryByHandler(report, core, "/cmis", "SELECT " + propertyQueryName + " FROM cmistest:extendedContent ORDER BY " + propertyQueryName + " ASC", 14, null, asc, null, null, null, new String[]{null});
        this.testQueryByHandler(report, core, "/cmis", "SELECT " + propertyQueryName + " FROM cmistest:extendedContent ORDER BY " + propertyQueryName + " DESC", 14, null, desc, null, null, null, new String[]{null});
    }

    private MLTextPropertyValue makeMLText() {
        return this.makeMLText(0);
    }

    private MLTextPropertyValue makeMLText(int position) {
        MLTextPropertyValue ml = new MLTextPropertyValue();
        ml.addValue(Locale.ENGLISH, mlOrderable_en[position]);
        ml.addValue(Locale.FRENCH, mlOrderable_fr[position]);
        return ml;
    }

    private MultiPropertyValue makeMLTextMVP() {
        return this.makeMLTextMVP(0);
    }

    private MultiPropertyValue makeMLTextMVP(int position) {
        MLTextPropertyValue m1 = new MLTextPropertyValue();
        m1.addValue(Locale.ENGLISH, mlOrderable_en[position]);
        MLTextPropertyValue m2 = new MLTextPropertyValue();
        m2.addValue(Locale.FRENCH, mlOrderable_fr[position]);
        MultiPropertyValue answer = new MultiPropertyValue();
        answer.addValue(m1);
        answer.addValue(m2);
        return answer;
    }

    private void testAFTS(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("AFS", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID desc", new int[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy and dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-lazy and -dog", 15, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy and -dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "|lazy and |dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "|eager and |dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "|lazy and |wolf", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "|eager and |wolf", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-lazy or -dog", 15, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-lazy or -wolf", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -wolf", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy and not dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy not dog", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy and !dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy !dog", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy and -dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy -dog", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm_content:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "=cm_content:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "~cm_content:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:big OR cm:content:lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:big AND cm:content:lazy", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "{http://www.alfresco.org/model/content/1.0}content:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "=lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm:content:big OR @cm:content:lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm:content:big AND @cm:content:lazy", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@{http://www.alfresco.org/model/content/1.0}content:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "~@cm:content:big OR ~@cm:content:lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown * quick", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown * dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown * dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(0) dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(1) dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(2) dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(3) dog", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(4) dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(5) dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "brown *(6) dog", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(\"lazy\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy and dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(-lazy and -dog)", 15, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(-lazy and dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy and -dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(|lazy and |dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(|eager and |dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(|lazy and |wolf)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(|eager and |wolf)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(-lazy or -dog)", 15, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(-eager or -dog)", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(-lazy or -wolf)", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(-eager or -wolf)", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy and not dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy not dog)", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy and !dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy !dog)", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy and -dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(lazy -dog)", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm_content:(\"lazy\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(big OR lazy)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(big AND lazy)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "{http://www.alfresco.org/model/content/1.0}content:(\"lazy\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(=lazy)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm:content:(big) OR @cm:content:(lazy)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm:content:(big) AND @cm:content:(lazy)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@{http://www.alfresco.org/model/content/1.0}content:(\"lazy\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm:content:(~big OR ~lazy)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown * quick)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown * dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown * dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(0) dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(1) dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(2) dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(3) dog)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(4) dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(5) dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(6) dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm_content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm:content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@cm_content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "@{http://www.alfresco.org/model/content/1.0}content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "{http://www.alfresco.org/model/content/1.0}content.mimetype:\"text/plain\"", 1, null, null, null, null, null, new String[]{null});
        QName qname = QName.createQName((String)TEST_NAMESPACE, (String)"float\\-ista");
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":3.40", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":3..4", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":3..3.39", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":3..3.40", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":3.41..3.9", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":3.40..3.9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":[3 TO 4]", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":[3 TO 3.39]", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":[3 TO 3.4]", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":[3.41 TO 4]", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":[3.4 TO 4]", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":[3 TO 3.4>", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":<3.4 TO 4]", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":<3.4 TO 3.4>", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(3.40)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(3..4)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(3..3.39)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(3..3.40)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(3.41..3.9)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(3.40..3.9)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":([3 TO 4])", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":([3 TO 3.39])", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":([3 TO 3.4])", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":([3.41 TO 4])", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":([3.4 TO 4])", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":([3 TO 3.4>)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(<3.4 TO 4])", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", qname + ":(<3.4 TO 3.4>)", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "test:float_x002D_ista:3.40", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "laz*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "l*y", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "l??y", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "?az?", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "*zy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"laz*\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"l*y\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"l??y\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"?az?\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"*zy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:laz*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:l*y", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:l??y", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:?az?", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:*zy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:\"lazy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:\"laz*\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:\"l*y\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:\"l??y\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:\"?az?\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:\"*zy\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(lazy)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(laz*)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(l*y)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(l??y)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(?az?)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(*zy)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(\"lazy\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(\"laz*\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(\"l*y\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(\"l??y\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(\"?az?\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:(\"*zy\")", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy^2 dog^4.2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy~0.7", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:laxy~0.7", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "laxy~0.7", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "=laxy~0.7", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "~laxy~0.7", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"quick fox\"~0", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"quick fox\"~1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"quick fox\"~2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"quick fox\"~3", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"fox quick\"~0", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"fox quick\"~1", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"fox quick\"~2", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"fox quick\"~3", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-lazy", 15, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy -lazy", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy^20 -lazy", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "lazy^20 -lazy^20", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "content:lazy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "+PATH:\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "+PATH:\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\" -TYPE:\"{http://www.alfresco.org/model/content/1.0}thumbnail\"", 15, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "+PATH:\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\" AND -TYPE:\"{http://www.alfresco.org/model/content/1.0}thumbnail\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "(brown *(6) dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TEXT:(brown *(6) dog)", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "\"//.\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "cm:content:brown", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "modified:*", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "modified:[MIN TO NOW]", 2, null, null, null, null, null, new String[]{null});
    }

    private void testSort(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Sort", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "ID asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "ID desc", new int[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "_docid_ asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "_docid_ desc", new int[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "score asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "score desc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.createdDate + " asc", new int[]{1, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.createdDate + " desc", new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.createdTime + " asc", new int[]{1, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.createdTime + " desc", new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_MODIFIED + " asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_MODIFIED + " desc", new int[]{15, 16, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderDouble + " asc", new int[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderDouble + " desc", new int[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderFloat + " asc", new int[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderFloat + " desc", new int[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLong + " asc", new int[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLong + " desc", new int[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderInt + " asc", new int[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderInt + " desc", new int[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderText + " asc", new int[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderText + " desc", new int[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " asc", new int[]{1, 10, 11, 2, 3, 4, 5, 13, 12, 6, 7, 8, 14, 15, 16, 9}, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " desc", new int[]{9, 16, 15, 14, 8, 7, 6, 12, 13, 5, 4, 3, 2, 11, 10, 1}, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " asc", new int[]{1, 10, 11, 2, 3, 4, 5, 13, 12, 6, 8, 7, 14, 15, 16, 9}, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " desc", new int[]{9, 16, 15, 14, 7, 8, 6, 12, 13, 5, 4, 3, 2, 11, 10, 1}, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " asc", new int[]{1, 10, 11, 2, 3, 4, 5, 13, 12, 6, 7, 8, 14, 15, 16, 9}, Locale.GERMAN, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " desc", new int[]{9, 16, 15, 14, 8, 7, 6, 12, 13, 5, 4, 3, 2, 11, 10, 1}, Locale.GERMAN, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " asc", new int[]{1, 11, 2, 3, 4, 5, 13, 6, 7, 8, 12, 14, 15, 16, 9, 10}, new Locale("sv"), null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedText + " desc", new int[]{10, 9, 16, 15, 14, 12, 8, 7, 6, 13, 5, 4, 3, 2, 11, 1}, new Locale("sv"), null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderMLText + " asc", new int[]{1, 15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 14, 16}, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderMLText + " desc", new int[]{16, 14, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15, 1}, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderMLText + " asc", new int[]{1, 14, 16, 12, 10, 8, 6, 4, 2, 3, 5, 7, 9, 11, 13, 15}, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderMLText + " desc", new int[]{15, 13, 11, 9, 7, 5, 3, 2, 4, 6, 8, 10, 12, 16, 14, 1}, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " asc", new int[]{1, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2}, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " desc", new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 1}, Locale.ENGLISH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " asc", new int[]{1, 16, 15, 14, 13, 12, 2, 3, 4, 5, 11, 10, 9, 8, 7, 6}, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " desc", new int[]{6, 7, 8, 9, 10, 11, 5, 4, 3, 2, 12, 13, 14, 15, 16, 1}, Locale.FRENCH, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " asc", new int[]{1, 16, 15, 2, 3, 4, 5, 6, 7, 9, 8, 10, 12, 14, 11, 13}, Locale.GERMAN, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " desc", new int[]{13, 11, 14, 12, 10, 8, 9, 7, 6, 5, 4, 3, 2, 15, 16, 1}, Locale.GERMAN, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " asc", new int[]{1, 16, 15, 7, 14, 8, 9, 10, 11, 12, 13, 2, 3, 4, 5, 6}, new Locale("es"), null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + this.orderLocalisedMLText + " desc", new int[]{6, 5, 4, 3, 2, 13, 12, 11, 10, 9, 8, 14, 7, 15, 16, 1}, new Locale("es"), null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "cabbage desc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "PARENT desc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@PARENT:PARENT desc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_CONTENT + ".size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_CONTENT + ".size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_CONTENT + ".mimetype asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/alfresco", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_CONTENT + ".mimetype desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
    }

    private void testCMIS(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("CMIS", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select * from cmis:document", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "select * from cmis:document D WHERE CONTAINS(D,'lazy')", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/cmis", "SELECT * FROM cmis:document D JOIN cm:ownable O ON D.cmis:objectId = O.cmis:objectId", 0, null, null, null, null, null, new String[]{null});
    }

    private void testAFTSandSort(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("AFS and Sort", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_CONTENT.toString() + ".size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "@" + ContentModel.PROP_CONTENT.toString() + ".size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, ContentModel.PROP_CONTENT.toString() + ".size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, ContentModel.PROP_CONTENT.toString() + ".size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "@cm:content.size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "@cm:content.size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "cm:content.size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "cm:content.size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "@content.size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "@content.size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "content.size asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 15}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "content.size desc", new int[]{15, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "@" + ContentModel.PROP_NAME.toString() + " asc", new int[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "@" + ContentModel.PROP_NAME.toString() + " desc", new int[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, ContentModel.PROP_NAME.toString() + " asc", new int[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, ContentModel.PROP_NAME.toString() + " desc", new int[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "@cm:name asc", new int[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "@cm:name desc", new int[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "cm:name asc", new int[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "cm:name desc", new int[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "@name asc", new int[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "@name desc", new int[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "name asc", new int[]{1, 9, 12, 16, 6, 5, 15, 10, 2, 8, 7, 11, 14, 4, 13, 3}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "-eager or -dog", 16, "name desc", new int[]{3, 13, 4, 14, 11, 7, 8, 2, 10, 15, 5, 6, 16, 12, 9, 1}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID desc", new int[]{16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1}, null, null, null, new String[]{null});
    }

    private void testQueryByHandler(NamedList report, SolrCore core, String handler, String query, int count, String sort, int[] sorted, Locale locale, Integer rows, Integer start, String ... filters) throws IOException {
        SimpleOrderedMap queryReport = new SimpleOrderedMap();
        report.add(GUID.generate(), (Object)queryReport);
        queryReport.add("Query", (Object)query);
        boolean passed = true;
        boolean ordered = true;
        SolrServletRequest solrReq = new SolrServletRequest(core, null);
        SolrQueryResponse solrRsp = new SolrQueryResponse();
        SolrRequestHandler afts = core.getRequestHandler(handler);
        ModifiableSolrParams newParams = new ModifiableSolrParams(solrReq.getParams());
        newParams.set("q", new String[]{query});
        if (rows != null) {
            newParams.set("rows", new String[]{"" + rows});
            queryReport.add("Rows", (Object)rows);
        } else {
            newParams.set("rows", new String[]{"2147483647"});
        }
        if (start != null) {
            newParams.set("start", new String[]{"" + start});
            queryReport.add("Start", (Object)start);
        }
        if (sort != null) {
            newParams.set("sort", new String[]{sort});
            queryReport.add("Sort", (Object)sort);
        }
        if (locale != null) {
            newParams.set("locale", new String[]{locale.toString()});
            queryReport.add("Locale", (Object)locale.toString());
        }
        if (filters != null) {
            newParams.set("fq", filters);
            queryReport.add("Filters", (Object)filters);
        }
        solrReq.setParams((SolrParams)newParams);
        ArrayList streams = new ArrayList();
        afts.handleRequest((SolrQueryRequest)solrReq, solrRsp);
        DocSlice ds = (DocSlice)solrRsp.getValues().get("response");
        if (ds != null) {
            if (ds.matches() != count) {
                passed = false;
                ordered = false;
                queryReport.add("Expected", (Object)count);
                queryReport.add("Found", (Object)ds.matches());
            } else {
                queryReport.add("Found", (Object)ds.matches());
            }
            int sz = ds.size();
            if (sorted != null) {
                int[] dbids = new int[sz];
                SolrIndexSearcher searcher = solrReq.getSearcher();
                DocIterator iterator = ds.iterator();
                for (int i = 0; i < sz; ++i) {
                    int id = iterator.nextDoc();
                    Document doc = searcher.doc(id);
                    Fieldable dbidField = doc.getFieldable("DBID");
                    dbids[i] = Integer.valueOf(dbidField.stringValue());
                    if (!ordered || dbids[i] == sorted[i]) continue;
                    ordered = false;
                    queryReport.add("Sort at " + i + " expected", (Object)sorted[i]);
                    queryReport.add("Sort at " + i + " found", (Object)dbids[i]);
                }
                if (ordered) {
                    queryReport.add("Order", (Object)"Passed");
                } else {
                    queryReport.add("Order", (Object)"FAILED");
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < dbids.length; ++i) {
                        if (builder.length() > 0) {
                            builder.append(", ");
                        }
                        builder.append(dbids[i]);
                    }
                    queryReport.add("Sorted as ", (Object)builder.toString());
                }
            }
            if (passed) {
                queryReport.add("Count", (Object)"Passed");
            } else {
                queryReport.add("Count", (Object)"FAILED");
            }
        } else {
            queryReport.add("Test", (Object)"ERROR");
        }
        solrReq.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChildNameEscaping(NamedList<Object> after, SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef rootNodeRef) throws IOException, ParseException {
        String COMPLEX_LOCAL_NAME = " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_";
        String NUMERIC_LOCAL_NAME = "12Woof12";
        NodeRef childNameEscapingNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
        QName childNameEscapingQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)COMPLEX_LOCAL_NAME);
        QName pathChildNameEscapingQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)ISO9075.encode((String)COMPLEX_LOCAL_NAME));
        ChildAssociationRef complexCAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, childNameEscapingQName, childNameEscapingNodeRef, true, 0);
        this.addNode(core, dataModel, 1, 17, 1, this.testSuperType, null, null, null, "system", new ChildAssociationRef[]{complexCAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + pathChildNameEscapingQName.toString()}, childNameEscapingNodeRef, true);
        NodeRef numericNameEscapingNodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), this.createGUID());
        QName numericNameEscapingQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)NUMERIC_LOCAL_NAME);
        QName pathNumericNameEscapingQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)ISO9075.encode((String)NUMERIC_LOCAL_NAME));
        ChildAssociationRef numericCAR = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, rootNodeRef, numericNameEscapingQName, numericNameEscapingNodeRef, true, 0);
        this.addNode(core, dataModel, 1, 18, 1, this.testSuperType, null, null, null, "system", new ChildAssociationRef[]{numericCAR}, new NodeRef[]{rootNodeRef}, new String[]{"/" + pathNumericNameEscapingQName.toString()}, numericNameEscapingNodeRef, true);
        SimpleOrderedMap report = new SimpleOrderedMap();
        after.add("TestChildNameEscaping", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME) + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:" + ISO9075.encode((String)NUMERIC_LOCAL_NAME) + "\"", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    public Map<QName, PropertyValue> getOrderProperties() {
        double orderDoubleCount = -0.11 + (double)this.orderTextCount * (this.orderTextCount % 2 == 0 ? 0.1 : -0.1);
        float orderFloatCount = -3.5556f + (float)this.orderTextCount * (this.orderTextCount % 2 == 0 ? 0.82f : -0.82f);
        long orderLongCount = -1999999999999999L + (long)this.orderTextCount * (this.orderTextCount % 2 == 0 ? 299999999999999L : -299999999999999L);
        int orderIntCount = -45764576 + this.orderTextCount * (this.orderTextCount % 2 == 0 ? 8576457 : -8576457);
        HashMap<QName, PropertyValue> testProperties = new HashMap<QName, PropertyValue>();
        testProperties.put(this.createdDate, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.orderDate)));
        testProperties.put(this.createdTime, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.orderDate)));
        testProperties.put(this.orderDouble, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)orderDoubleCount)));
        testProperties.put(this.orderFloat, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)Float.valueOf(orderFloatCount))));
        testProperties.put(this.orderLong, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)orderLongCount)));
        testProperties.put(this.orderInt, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)orderIntCount)));
        testProperties.put(this.orderText, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)(new String(new char[]{(char)(108 + (this.orderTextCount % 2 == 0 ? this.orderTextCount : -this.orderTextCount))}) + " cabbage"))));
        testProperties.put(ContentModel.PROP_NAME, new StringPropertyValue(this.orderNames[this.orderTextCount]));
        testProperties.put(this.orderLocalisedText, new StringPropertyValue(this.orderLocalisedNames[this.orderTextCount]));
        MLTextPropertyValue mlTextPropLocalisedOrder = new MLTextPropertyValue();
        if (this.orderLocaliseMLText_en[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(Locale.ENGLISH, this.orderLocaliseMLText_en[this.orderTextCount]);
        }
        if (this.orderLocaliseMLText_fr[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(Locale.FRENCH, this.orderLocaliseMLText_fr[this.orderTextCount]);
        }
        if (this.orderLocaliseMLText_es[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(new Locale("es"), this.orderLocaliseMLText_es[this.orderTextCount]);
        }
        if (this.orderLocaliseMLText_de[this.orderTextCount].length() > 0) {
            mlTextPropLocalisedOrder.addValue(Locale.GERMAN, this.orderLocaliseMLText_de[this.orderTextCount]);
        }
        testProperties.put(this.orderLocalisedMLText, mlTextPropLocalisedOrder);
        MLTextPropertyValue mlTextPropVal = new MLTextPropertyValue();
        mlTextPropVal.addValue(Locale.ENGLISH, new String(new char[]{(char)(108 + (this.orderTextCount % 2 == 0 ? this.orderTextCount : -this.orderTextCount))}) + " banana");
        mlTextPropVal.addValue(Locale.FRENCH, new String(new char[]{(char)(76 + (this.orderTextCount % 2 == 0 ? -this.orderTextCount : this.orderTextCount))}) + " banane");
        mlTextPropVal.addValue(Locale.CHINESE, new String(new char[]{(char)(39321 + (this.orderTextCount % 2 == 0 ? this.orderTextCount : -this.orderTextCount))}) + " \u9999\u8549");
        testProperties.put(this.orderMLText, mlTextPropVal);
        this.orderDate = Duration.subtract((Date)this.orderDate, (Duration)new Duration("P1D"));
        ++this.orderTextCount;
        return testProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRootNode(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("RootNode", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/.\"", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQNames(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("QNames", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "QNAME:\"nine\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PRIMARYASSOCTYPEQNAME:\"cm:contains\"", 11);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PRIMARYASSOCTYPEQNAME:\"sys:children\"", 4);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ASSOCTYPEQNAME:\"cm:contains\"", 11);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ASSOCTYPEQNAME:\"sys:children\"", 5);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkType(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Type", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + this.testType.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + this.testType.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "EXACTTYPE:\"" + this.testType.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "EXACTTYPE:\"" + this.testType.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + this.testSuperType.toString() + "\"", 13);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + this.testSuperType.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 13);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + ContentModel.TYPE_CONTENT.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"cm:content\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"cm:CONTENT\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"CM:CONTENT\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"CONTENT\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"content\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + ContentModel.TYPE_THUMBNAIL.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TYPE:\"" + ContentModel.TYPE_THUMBNAIL.toString() + "\" TYPE:\"" + ContentModel.TYPE_CONTENT.toString() + "\"", 2);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "EXACTTYPE:\"" + this.testSuperType.toString() + "\"", 12);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "EXACTTYPE:\"" + this.testSuperType.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 12);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ASPECT:\"" + this.testAspect.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ASPECT:\"" + this.testAspect.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "EXACTASPECT:\"" + this.testAspect.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "EXACTASPECT:\"" + this.testAspect.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkText(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Text", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:fox AND TYPE:\"" + ContentModel.PROP_CONTENT.toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:fox cm\\:name:fox", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:fo AND TYPE:\"" + ContentModel.PROP_CONTENT.toString() + "\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"the\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"and\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"over the lazy\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"over a lazy\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":*a*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":*A*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":\"*a*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":\"*A*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":*s*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":*S*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":\"*s*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic").toString()) + ":\"*S*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*A*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*a*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*A*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*a*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*Z*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*z*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*Z*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*z*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:laz*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:laz~", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:la?y", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:?a?y", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*azy", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*az*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"\u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"aeidnouy\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"fox\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":\"fox\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".mimetype:\"text/plain\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".locale:\"en_GB\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".locale:en_*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".locale:e*_GB", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".size:\"298\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"fox\"", 0, null, new String[]{"@" + ContentModel.PROP_NAME.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"fox\"", 1, null, new String[]{"@" + ContentModel.PROP_NAME.toString(), "@" + ContentModel.PROP_CONTENT.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"cabbage\"", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"cab*\"", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*bage\"", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*ba*\"", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:cabbage", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*cab*", 15, Locale.ENGLISH, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*bage", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:dabbage~0.7", 15, null, new String[]{"@" + this.orderText.toString()}, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfresc?\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfres??\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfre???\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfr????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alf?????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"al??????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"a???????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"????????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"a??re???\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"?lfresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"??fresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"???resco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"????esco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"?????sco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"??????co\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"???????o\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"???res?o\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"????e?co\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"????e?c?\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"???re???\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfresc*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfres*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfre*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfr*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alf*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"al*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"a*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"a****\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*lfresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*fresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*resco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*esco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*sco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*co\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*o\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"****lf**sc***\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*??*lf**sc***\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alfresc*tutorial\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"alf* tut*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"*co *al\"", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAll(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("ALL", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ALL:\"fox\"", 1, null, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ALL:\"fox\"", 0, null, null, new String[]{"@" + ContentModel.PROP_NAME.toString()}, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ALL:\"fox\"", 1, null, null, new String[]{"@" + ContentModel.PROP_NAME.toString(), "@" + ContentModel.PROP_CONTENT.toString()}, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ALL:\"5.6\"", 1, null, null, null, new String[0]);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDataType(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("DataType", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "d\\:double:\"5.6\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "d\\:content:\"fox\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "d\\:content:\"fox\"", 1, Locale.US, null, null, new String[0]);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNullAndUnset(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("ISNULL/ISUNSET/ISNOTNULL", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ISUNSET:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"null").toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ISUNSET:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"path-ista").toString() + "\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ISNOTNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"null").toString() + "\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ISNOTNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"path-ista").toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ISUNSET:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"aspectProperty").toString() + "\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "ISNOTNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"aspectProperty").toString() + "\"", 0);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNonField(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("NonField", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:fox", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:fo*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:f*x", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:*ox", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":fox", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":fo*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":f*x", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":*ox", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":fox", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":fo*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":f*x", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO())) + ":*ox", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRanges(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Ranges", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + LuceneQueryParser.escape((String)this.orderText.toString()) + ":[a TO b]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + LuceneQueryParser.escape((String)this.orderText.toString()) + ":[a TO \uffff]", 15);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + LuceneQueryParser.escape((String)this.orderText.toString()) + ":[\u0000 TO b]", 2);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + LuceneQueryParser.escape((String)this.orderText.toString()) + ":[d TO \uffff]", 12);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    private void checkInternalFields(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel, String nodeRef) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Internal", (Object)report);
        for (int i = 1; i < 16; ++i) {
            this.testQueryByHandler((NamedList)report, core, "/afts", "ID:LEAF-" + i, 1, null, null, null, null, null, new String[]{null});
            this.testQueryByHandler((NamedList)report, core, "/afts", "ID:AUX-" + i, 1, null, null, null, null, null, new String[]{null});
        }
        this.testQueryByHandler((NamedList)report, core, "/afts", "ID:LEAF-*", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ID:AUX-*", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ID:ACL-*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ID:ACLTX-*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ID:TX-*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ID:\"" + nodeRef + "\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PARENT:\"" + nodeRef + "\"", 4, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ANCESTOR:\"" + nodeRef + "\"", 10, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:one\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:two\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:three\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:four\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:five\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:six\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:seven\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:eight-0\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:eight-1\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:eight-2\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:nine\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:ten\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:eleven\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:twelve\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:thirteen\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:fourteen\"", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:fifteen\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:common\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "QNAME:\"cm:link\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:one\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:two\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:three\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:four\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:five\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:six\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:seven\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:eight-0\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:eight-1\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:eight-2\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:nine\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:ten\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:eleven\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:twelve\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:thirteen\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:fourteen\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:fifteen\"", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:common\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCQNAME:\"cm:link\"", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYASSOCTYPEQNAME:\"" + ContentModel.ASSOC_CHILDREN.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 4, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ISNODE:T", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ASSOCTYPEQNAME:\"" + ContentModel.ASSOC_CHILDREN.toPrefixString((NamespacePrefixResolver)dataModel.getNamespaceDAO()) + "\"", 5, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PRIMARYPARENT:\"" + nodeRef + "\"", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "FTSSTATUS:\"Clean\"", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:2", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:3", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:4", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:5", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:6", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:7", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:8", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:9", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:10", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:11", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:12", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:13", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:14", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:15", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:16", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "DBID:17", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TXID:1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "INTXID:1", 33, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ACLTXID:1", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "INACLTXID:1", 2, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "INACLTXID:2", 0, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "TXCOMMITTIME:*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ACLTXCOMMITTIME:*", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "ACLID:1", 17, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "READER:\"GROUP_EVERYONE\"", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:andy", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:bob", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:cid", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:dave", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:eoin", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:fred", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:gail", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:hal", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:ian", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:jake", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:kara", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:loon", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:mike", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:noodle", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "OWNER:ood", 1, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PARENTASSOCCRC:0", 16, null, null, null, null, null, new String[]{null});
    }

    private void checkAuthorityFilter(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Read Access", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:andy");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:bob");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:cid");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:dave");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:eoin");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:fred");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:gail");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:hal");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:ian");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:jake");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:kara");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:loon");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:mike");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:noodle");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHORITY:ood");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, null, null, null, null, null, "{!afts}|AUTHORITY:GROUP_EVERYONE");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 3, null, null, null, null, null, "{!afts}|AUTHORITY:andy |AUTHORITY:bob |AUTHORITY:cid");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, null, null, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":andy\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":bob\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":cid\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":dave\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":eoin\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":fred\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":gail\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":hal\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":ian\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":jake\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":kara\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":loon\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":mike\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":noodle\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 1, null, null, null, null, null, "{!afts}|AUTHSET:\":ood\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, null, null, null, null, null, "{!afts}|AUTHSET:\":GROUP_EVERYONE\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 3, null, null, null, null, null, "{!afts}|AUTHSET:\":andy\" |AUTHSET:\":bob\" |AUTHSET:\":cid\"");
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 3, null, null, null, null, null, "{!afts}|AUTHSET:\":andy:bob:cid\"");
    }

    private void checkPaging(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Paging", (Object)report);
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, null, null, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID asc", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, null, 20, 0, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID asc", new int[]{1, 2, 3, 4, 5, 6}, null, 6, 0, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID asc", new int[]{7, 8, 9, 10, 11, 12}, null, 6, 6, new String[]{null});
        this.testQueryByHandler((NamedList)report, core, "/afts", "PATH:\"//.\"", 16, "DBID asc", new int[]{13, 14, 15, 16}, null, 6, 12, new String[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMLText(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("MLText", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfresc?\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfres??\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfre???\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfr????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alf?????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"al??????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a???????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"????????\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a??re???\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"?lfresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"??fresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???resco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"????esco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"?????sco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"??????co\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???????o\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???resco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???res?o\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"????e?co\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"????e?c?\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???re???\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfresc*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfres*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfre*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfr*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alf*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"al*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a*****\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*lfresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*fresco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*resco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*esco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*sco\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*co\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*o\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"****lf**sc***\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*??*lf**sc***\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Alfresc*tutorial\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Alf* tut*\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*co *al\"", 1);
            QName mlQName = QName.createQName((String)TEST_NAMESPACE, (String)"ml");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":and", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\"and\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana", 1, Locale.UK, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana", 1, Locale.ENGLISH, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banane", 1, Locale.FRENCH, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u9999\u8549", 1, Locale.CHINESE, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banaan", 1, new Locale("nl"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banane", 1, Locale.GERMAN, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1", 1, new Locale("el"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana", 1, Locale.ITALIAN, null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u30d0\u30ca\u30ca", 1, new Locale("ja"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\ubc14\ub098\ub098", 1, new Locale("ko"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana", 1, new Locale("pt"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u0431\u0430\u043d\u0430\u043d", 1, new Locale("ru"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":pl\u00e1tano", 1, new Locale("es"), null, null, new String[0]);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPropertyTypes(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel, Date testDate, String n01NodeRef) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("PropertyTypes", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            QName qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"1\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":1", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"01\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":01", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"001\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"0001\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[A TO 2]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[0 TO 2]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[0 TO A]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 1}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{0 TO 1}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{0 TO A}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 2}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{1 TO 2}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{1 TO A}", 0);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"2\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"02\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"002\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"0002\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[A TO 2]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[0 TO 2]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[0 TO A]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 2}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{0 TO 2}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{0 TO A}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 3}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{2 TO 3}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{2 TO A}", 0);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"3.4\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[A TO 4]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[3 TO 4]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[3 TO A]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[A TO 3.4]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[3.3 TO 3.4]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[3.3 TO A]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 3.4}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{3.3 TO 3.4}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{3.3 TO A}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"3.40\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"03.4\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"03.40\"", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"5.6\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"05.6\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"5.60\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"05.60\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[A TO 5.7]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[5.5 TO 5.7]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":[5.5 TO A]", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 5.6}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{5.5 TO 5.6}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{5.5 TO A}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{A TO 5.7}", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{5.6 TO 5.7}", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":{5.6 TO A}", 0);
            Date date = new Date();
            for (CachingDateFormat.SimpleDateFormatAndResolution df : CachingDateFormat.getLenientFormatters()) {
                if (df.getResolution() < 5) continue;
                String sDate = df.getSimpleDateFormat().format(testDate);
                SimpleOrderedMap subReport = new SimpleOrderedMap();
                report.add(sDate, (Object)subReport);
                if (sDate.length() >= 9) {
                    this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"date-ista").toString()) + ":\"" + sDate + "\"", 1);
                }
                this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":\"" + sDate + "\"", 1);
                sDate = df.getSimpleDateFormat().format(date);
                this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@cm\\:CrEaTeD:[MIN TO " + sDate + "]", 1);
                this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@cm\\:created:[MIN TO NOW]", 1);
                this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)ContentModel.PROP_CREATED.toString()) + ":[MIN TO " + sDate + "]", 1);
                if (sDate.length() >= 9) {
                    sDate = df.getSimpleDateFormat().format(testDate);
                    this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"date-ista").toString()) + ":[" + sDate + " TO " + sDate + "]", 1);
                    this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"date-ista").toString()) + ":[MIN  TO " + sDate + "]", 1);
                    this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"date-ista").toString()) + ":[" + sDate + " TO MAX]", 1);
                }
                sDate = CachingDateFormat.getDateFormat().format(testDate);
                this.testQuery(dataModel, (NamedList<Object>)subReport, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":[MIN TO " + sDate + "]", 1);
                sDate = df.getSimpleDateFormat().format(testDate);
                for (long i : new long[]{333L, 20000L, 1200000L, 28800000L, 864000000L, 1778065408L, 1802354688L}) {
                    SimpleOrderedMap subSubReport1 = new SimpleOrderedMap();
                    SimpleOrderedMap subSubReport2 = new SimpleOrderedMap();
                    SimpleOrderedMap subSubReport3 = new SimpleOrderedMap();
                    SimpleOrderedMap subSubReport4 = new SimpleOrderedMap();
                    SimpleOrderedMap subSubReport5 = new SimpleOrderedMap();
                    subReport.add("1_" + i, (Object)subSubReport1);
                    subReport.add("2_" + i, (Object)subSubReport2);
                    subReport.add("3_" + i, (Object)subSubReport3);
                    subReport.add("4_" + i, (Object)subSubReport4);
                    subReport.add("5_" + i, (Object)subSubReport5);
                    String startDate = df.getSimpleDateFormat().format(new Date(testDate.getTime() - i));
                    String endDate = df.getSimpleDateFormat().format(new Date(testDate.getTime() + i));
                    this.testQuery(dataModel, (NamedList<Object>)subSubReport1, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":[" + startDate + " TO " + endDate + "]", 1);
                    this.testQuery(dataModel, (NamedList<Object>)subSubReport2, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":[" + sDate + " TO " + endDate + "]", 1);
                    this.testQuery(dataModel, (NamedList<Object>)subSubReport3, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":[" + startDate + " TO " + sDate + "]", 1);
                    this.testQuery(dataModel, (NamedList<Object>)subSubReport4, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":{" + sDate + " TO " + endDate + "}", 0);
                    this.testQuery(dataModel, (NamedList<Object>)subSubReport5, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista").toString()) + ":{" + startDate + " TO " + sDate + "}", 0);
                }
            }
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"boolean-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"true\"", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"qname-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"{wibble}wobble\"", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"category-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"" + (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new NodeRef(new StoreRef("proto", "id"), "CategoryId")) + "\"", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"noderef-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"" + n01NodeRef + "\"", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"path-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"/{" + "http://www.alfresco.org/model/content/1.0" + "}three\"", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"100\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "\\@" + SolrQueryParser.escape((String)qname.toString()) + ":\"anyValueAsString\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"Tutorial Alfresco\"~0", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"Tutorial Alfresco\"~1", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"Tutorial Alfresco\"~2", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "TEXT:\"Tutorial Alfresco\"~3", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Alfresco Tutorial\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~0", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~1", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~2", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~3", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"mltext-many-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":\u043b\u0435\u043c\u0443\u0440", 1, new Locale("ru"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":lemur", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":chou", 1, new Locale("fr"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":cabbage", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":cabba*", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":ca*ge", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":*bage", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":cabage~", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":*b?ag?", 1, new Locale("en"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":cho*", 1, new Locale("fr"), null, null, new String[0]);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista").toString()) + ":multicontent", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":\"en_GB_\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":en_GB_", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":en_*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":*_GB_*", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":*_gb_*", 1);
            qname = QName.createQName((String)TEST_NAMESPACE, (String)"period-ista");
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "@" + LuceneQueryParser.escape((String)qname.toString()) + ":\"period|12\"", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkPaths(NamedList<Object> before, SolrCore core, AlfrescoSolrDataModel dataModel) throws IOException, ParseException {
        SimpleOrderedMap report = new SimpleOrderedMap();
        before.add("Paths", (Object)report);
        RefCounted refCounted = null;
        try {
            refCounted = core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:three\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:four\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:eight-0\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:five\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:one\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:two\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two/cm:one\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two/cm:two\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:six\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two/cm:seven\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:eight-1\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two/cm:eight-2\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:eight-2\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two/cm:eight-1\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:two/cm:eight-0\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:eight-0\"", 0);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:nine\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:ten\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:eleven\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:twelve\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen/cm:fourteen\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:twelve/cm:thirteen/cm:common\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:five/cm:twelve/cm:common\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:*\"", 5);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:*/cm:*\"", 6);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:*/cm:five\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:*/cm:*/cm:*\"", 6);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:*\"", 4);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:*/cm:five/cm:*\"", 5);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/cm:*/cm:nine\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/*\"", 5);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/*/*\"", 6);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/*/cm:five\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/*/*/*\"", 6);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/*\"", 4);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/*/cm:five/*\"", 5);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/cm:one/*/cm:nine\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//.\"", 16);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//*\"", 15);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//*/.\"", 15);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//*/./.\"", 15);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//./*\"", 15);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//././*/././.\"", 15);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"//cm:common\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one//common\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one/five//*\"", 7);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one/five//.\"", 8);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one//five/nine\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one//thirteen/fourteen\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one//thirteen/fourteen/.\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one//thirteen/fourteen//.\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one//thirteen/fourteen//.//.\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/one\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/two\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/three\"", 1);
            this.testQuery(dataModel, (NamedList<Object>)report, solrIndexSearcher, "PATH:\"/four\"", 1);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
        return "PASSED";
    }

    private void testQuery(AlfrescoSolrDataModel dataModel, NamedList<Object> report, SolrIndexSearcher solrIndexSearcher, String queryString, Integer count, Locale locale, String[] textAttributes, String[] allAttributes, String ... name) throws ParseException, IOException {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setQuery(queryString);
        if (locale != null) {
            searchParameters.addLocale(locale);
        }
        if (textAttributes != null) {
            for (String textAttribute : textAttributes) {
                searchParameters.addTextAttribute(textAttribute);
            }
        }
        if (allAttributes != null) {
            for (String allAttribute : allAttributes) {
                searchParameters.addAllAttribute(allAttribute);
            }
        }
        long start = System.nanoTime();
        Query query = dataModel.getLuceneQueryParser(searchParameters, solrIndexSearcher.getIndexReader()).parse(queryString);
        TopDocs docs = solrIndexSearcher.search(query, count * 2 + 10);
        SimpleOrderedMap subReport = new SimpleOrderedMap();
        report.add(GUID.generate(), (Object)subReport);
        long end = System.nanoTime();
        if (count != null) {
            if (docs.totalHits != count) {
                subReport.add("FAILED: " + this.fixQueryString(queryString, name), (Object)docs.totalHits);
            } else {
                subReport.add("Passed: " + this.fixQueryString(queryString, name), (Object)docs.totalHits);
            }
        }
        subReport.add("Time (s): " + this.fixQueryString(queryString, name), (Object)Float.valueOf((float)(end - start) / 1.0E9f));
    }

    private void testFTSQuery(AlfrescoSolrDataModel dataModel, NamedList<Object> report, SolrIndexSearcher solrIndexSearcher, String queryString, Integer count, Locale locale, String[] textAttributes, String[] allAttributes, String ... name) throws ParseException, IOException {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setQuery(queryString);
        if (locale != null) {
            searchParameters.addLocale(locale);
        }
        if (textAttributes != null) {
            for (String textAttribute : textAttributes) {
                searchParameters.addTextAttribute(textAttribute);
            }
        }
        if (allAttributes != null) {
            for (String allAttribute : allAttributes) {
                searchParameters.addAllAttribute(allAttribute);
            }
        }
        long start = System.nanoTime();
        Query query = dataModel.getFTSQuery((Pair<SearchParameters, Boolean>)new Pair((Object)searchParameters, (Object)Boolean.FALSE), solrIndexSearcher.getIndexReader());
        TopDocs docs = solrIndexSearcher.search(query, count * 2 + 10);
        SimpleOrderedMap subReport = new SimpleOrderedMap();
        report.add(GUID.generate(), (Object)subReport);
        long end = System.nanoTime();
        if (count != null) {
            if (docs.totalHits != count) {
                subReport.add("FAILED: " + this.fixQueryString(queryString, name), (Object)docs.totalHits);
            } else {
                subReport.add("Passed: " + this.fixQueryString(queryString, name), (Object)docs.totalHits);
            }
        }
        subReport.add("Time (s): " + this.fixQueryString(queryString, name), (Object)Float.valueOf((float)(end - start) / 1.0E9f));
    }

    private String fixQueryString(String queryString, String ... name) {
        if (name.length > 0) {
            return name[0].replace("\uffff", "<Unicode FFFF>");
        }
        return queryString.replace("\uffff", "<Unicode FFFF>");
    }

    private void testQuery(AlfrescoSolrDataModel dataModel, NamedList<Object> report, SolrIndexSearcher solrIndexSearcher, String queryString, int count) throws ParseException, IOException {
        this.testQuery(dataModel, report, solrIndexSearcher, queryString, count, null, null, null, new String[0]);
    }

    private NodeRef addNode(SolrCore core, AlfrescoSolrDataModel dataModel, int txid, int dbid, int aclid, QName type, QName[] aspects, Map<QName, PropertyValue> properties, Map<QName, String> content, String owner, ChildAssociationRef[] parentAssocs, NodeRef[] ancestors, String[] paths, NodeRef nodeRef, boolean commit) throws IOException {
        AddUpdateCommand leafDocCmd = new AddUpdateCommand();
        leafDocCmd.overwriteCommitted = true;
        leafDocCmd.overwritePending = true;
        leafDocCmd.solrDoc = this.createLeafDocument(dataModel, txid, dbid, nodeRef, type, aspects, properties, content);
        leafDocCmd.doc = CoreTracker.toDocument(leafDocCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        AddUpdateCommand auxDocCmd = new AddUpdateCommand();
        auxDocCmd.overwriteCommitted = true;
        auxDocCmd.overwritePending = true;
        auxDocCmd.solrDoc = this.createAuxDocument(txid, dbid, aclid, paths, owner, parentAssocs, ancestors);
        auxDocCmd.doc = CoreTracker.toDocument(auxDocCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        if (leafDocCmd.doc != null) {
            core.getUpdateHandler().addDoc(leafDocCmd);
        }
        if (auxDocCmd.doc != null) {
            core.getUpdateHandler().addDoc(auxDocCmd);
        }
        if (commit) {
            core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
        return nodeRef;
    }

    private void addAcl(SolrCore core, AlfrescoSolrDataModel dataModel, int acltxid, int aclid, int maxReader, int totalReader) throws IOException {
        AddUpdateCommand aclTxCmd = new AddUpdateCommand();
        aclTxCmd.overwriteCommitted = true;
        aclTxCmd.overwritePending = true;
        SolrInputDocument aclTxSol = new SolrInputDocument();
        aclTxSol.addField("ID", (Object)("ACLTX-" + acltxid));
        aclTxSol.addField("ACLTXID", (Object)acltxid);
        aclTxSol.addField("INACLTXID", (Object)acltxid);
        aclTxSol.addField("ACLTXCOMMITTIME", (Object)new Date().getTime());
        aclTxCmd.solrDoc = aclTxSol;
        aclTxCmd.doc = CoreTracker.toDocument(aclTxCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        core.getUpdateHandler().addDoc(aclTxCmd);
        AddUpdateCommand aclCmd = new AddUpdateCommand();
        aclCmd.overwriteCommitted = true;
        aclCmd.overwritePending = true;
        SolrInputDocument aclSol = new SolrInputDocument();
        aclSol.addField("ID", (Object)("ACL-" + aclid));
        aclSol.addField("ACLID", (Object)aclid);
        aclSol.addField("INACLTXID", (Object)("" + acltxid));
        aclSol.addField("READER", (Object)"GROUP_EVERYONE");
        aclSol.addField("READER", (Object)"pig");
        for (int i = 0; i <= maxReader; ++i) {
            aclSol.addField("READER", (Object)("READER-" + (totalReader - i)));
        }
        aclCmd.solrDoc = aclSol;
        aclCmd.doc = CoreTracker.toDocument(aclCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        core.getUpdateHandler().addDoc(aclCmd);
    }

    private void addStoreRoot(SolrCore core, AlfrescoSolrDataModel dataModel, NodeRef rootNodeRef, int txid, int dbid, int acltxid, int aclid) throws IOException {
        AddUpdateCommand leafDocCmd = new AddUpdateCommand();
        leafDocCmd.overwriteCommitted = true;
        leafDocCmd.overwritePending = true;
        leafDocCmd.solrDoc = this.createLeafDocument(dataModel, txid, dbid, rootNodeRef, ContentModel.TYPE_STOREROOT, new QName[]{ContentModel.ASPECT_ROOT}, null, null);
        leafDocCmd.doc = CoreTracker.toDocument(leafDocCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        AddUpdateCommand auxDocCmd = new AddUpdateCommand();
        auxDocCmd.overwriteCommitted = true;
        auxDocCmd.overwritePending = true;
        auxDocCmd.solrDoc = this.createAuxDocument(txid, dbid, aclid, new String[]{"/"}, "system", null, null);
        auxDocCmd.doc = CoreTracker.toDocument(auxDocCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        if (leafDocCmd.doc != null) {
            core.getUpdateHandler().addDoc(leafDocCmd);
        }
        if (auxDocCmd.doc != null) {
            core.getUpdateHandler().addDoc(auxDocCmd);
        }
        this.addAcl(core, dataModel, acltxid, aclid, 0, 0);
        AddUpdateCommand txCmd = new AddUpdateCommand();
        txCmd.overwriteCommitted = true;
        txCmd.overwritePending = true;
        SolrInputDocument input = new SolrInputDocument();
        input.addField("ID", (Object)("TX-" + txid));
        input.addField("TXID", (Object)txid);
        input.addField("INTXID", (Object)txid);
        input.addField("TXCOMMITTIME", (Object)new Date().getTime());
        txCmd.solrDoc = input;
        txCmd.doc = CoreTracker.toDocument(txCmd.getSolrInputDocument(), core.getSchema(), dataModel);
        core.getUpdateHandler().addDoc(txCmd);
        core.getUpdateHandler().commit(new CommitUpdateCommand(false));
    }

    public SolrInputDocument createLeafDocument(AlfrescoSolrDataModel dataModel, int txid, int dbid, NodeRef nodeRef, QName type, QName[] aspects, Map<QName, PropertyValue> properties, Map<QName, String> content) throws IOException {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ID", (Object)("LEAF-" + dbid));
        doc.addField("DBID", (Object)("" + dbid));
        doc.addField("LID", (Object)nodeRef);
        doc.addField("INTXID", (Object)("" + txid));
        if (properties != null) {
            for (QName propertyQname : properties.keySet()) {
                PropertyValue value;
                if (!dataModel.isIndexedOrStored(propertyQname) || (value = properties.get(propertyQname)) == null) continue;
                if (value instanceof ContentPropertyValue) {
                    this.addContentPropertyToDoc(doc, propertyQname, (ContentPropertyValue)value, content);
                    continue;
                }
                if (value instanceof MLTextPropertyValue) {
                    this.addMLTextPropertyToDoc(dataModel, doc, propertyQname, (MLTextPropertyValue)value);
                    continue;
                }
                if (value instanceof MultiPropertyValue) {
                    MultiPropertyValue typedValue = (MultiPropertyValue)value;
                    for (PropertyValue singleValue : typedValue.getValues()) {
                        if (singleValue instanceof ContentPropertyValue) {
                            this.addContentPropertyToDoc(doc, propertyQname, (ContentPropertyValue)singleValue, content);
                            continue;
                        }
                        if (singleValue instanceof MLTextPropertyValue) {
                            this.addMLTextPropertyToDoc(dataModel, doc, propertyQname, (MLTextPropertyValue)singleValue);
                            continue;
                        }
                        if (!(singleValue instanceof StringPropertyValue)) continue;
                        this.addStringPropertyToDoc(dataModel, doc, propertyQname, (StringPropertyValue)singleValue, properties);
                    }
                    continue;
                }
                if (!(value instanceof StringPropertyValue)) continue;
                this.addStringPropertyToDoc(dataModel, doc, propertyQname, (StringPropertyValue)value, properties);
            }
        }
        doc.addField("TYPE", (Object)type);
        if (aspects != null) {
            for (QName aspect : aspects) {
                doc.addField("ASPECT", (Object)aspect);
            }
        }
        doc.addField("ISNODE", (Object)"T");
        doc.addField("FTSSTATUS", (Object)"Clean");
        doc.addField("TENANT", (Object)"_DEFAULT_");
        return doc;
    }

    private void addStringPropertyToDoc(AlfrescoSolrDataModel dataModel, SolrInputDocument doc, QName propertyQName, StringPropertyValue stringPropertyValue, Map<QName, PropertyValue> properties) throws IOException {
        PropertyDefinition propertyDefinition = dataModel.getPropertyDefinition(propertyQName);
        if (propertyDefinition != null) {
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
                doc.addField("@" + propertyQName.toString() + ".sort", (Object)stringPropertyValue.getValue());
            } else if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                Locale locale = null;
                PropertyValue localePropertyValue = properties.get(ContentModel.PROP_LOCALE);
                if (localePropertyValue != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)((StringPropertyValue)localePropertyValue).getValue());
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                StringBuilder builder = new StringBuilder();
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(stringPropertyValue.getValue());
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString(), (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".u", (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__.u", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".sort", (Object)builder.toString());
                }
            } else {
                doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
            }
        } else {
            doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
        }
    }

    private void addContentPropertyToDoc(SolrInputDocument doc, QName propertyQName, ContentPropertyValue contentPropertyValue, Map<QName, String> content) throws IOException {
        doc.addField("@" + propertyQName.toString() + ".size", (Object)contentPropertyValue.getLength());
        doc.addField("@" + propertyQName.toString() + ".locale", (Object)contentPropertyValue.getLocale());
        doc.addField("@" + propertyQName.toString() + ".mimetype", (Object)contentPropertyValue.getMimetype());
        doc.addField("@" + propertyQName.toString() + ".encoding", (Object)contentPropertyValue.getEncoding());
        String value = "";
        if (content != null && (value = content.get(propertyQName)) == null) {
            value = "";
        }
        StringReader isr = new StringReader(value);
        StringBuilder builder = new StringBuilder();
        builder.append("\u0000").append(contentPropertyValue.getLocale().toString()).append("\u0000");
        StringReader prefix = new StringReader(builder.toString());
        MultiReader multiReader = new MultiReader((Reader)prefix, (Reader)isr);
        doc.addField("@" + propertyQName.toString(), (Object)multiReader);
        isr = new StringReader(value);
        builder = new StringBuilder();
        builder.append("\u0000").append(contentPropertyValue.getLocale().toString()).append("\u0000");
        prefix = new StringReader(builder.toString());
        multiReader = new MultiReader((Reader)prefix, (Reader)isr);
        doc.addField("@" + propertyQName.toString() + ".__", (Object)multiReader);
    }

    private void addMLTextPropertyToDoc(AlfrescoSolrDataModel dataModel, SolrInputDocument doc, QName propertyQName, MLTextPropertyValue mlTextPropertyValue) throws IOException {
        PropertyDefinition propertyDefinition = dataModel.getPropertyDefinition(propertyQName);
        if (propertyDefinition != null) {
            StringBuilder sort = new StringBuilder();
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                StringBuilder builder = new StringBuilder();
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(mlTextPropertyValue.getValue(locale));
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString(), (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".u", (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__.u", (Object)builder.toString());
                }
                if (sort.length() > 0) {
                    sort.append("\u0000");
                }
                sort.append(builder.toString());
            }
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                doc.addField("@" + propertyQName.toString() + ".sort", (Object)sort.toString());
            }
        } else {
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                doc.addField("@" + propertyQName.toString(), (Object)mlTextPropertyValue.getValue(locale));
            }
        }
    }

    private SolrInputDocument createAuxDocument(int txid, int dbid, int aclid, String[] paths, String owner, ChildAssociationRef[] parentAssocs, NodeRef[] ancestors) {
        SolrInputDocument aux = new SolrInputDocument();
        aux.addField("ID", (Object)("AUX-" + dbid));
        aux.addField("DBID", (Object)("" + dbid));
        aux.addField("ACLID", (Object)("" + aclid));
        aux.addField("INTXID", (Object)("" + txid));
        if (paths != null) {
            for (String path : paths) {
                aux.addField("PATH", (Object)path);
            }
        }
        if (owner != null) {
            aux.addField("OWNER", (Object)owner);
        }
        aux.addField("PARENTASSOCCRC", (Object)"0");
        StringBuilder qNameBuffer = new StringBuilder(64);
        StringBuilder assocTypeQNameBuffer = new StringBuilder(64);
        if (parentAssocs != null) {
            ChildAssociationRef[] arr$ = parentAssocs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ChildAssociationRef childAssocRef = arr$[i$];
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                aux.addField("PARENT", (Object)childAssocRef.getParentRef());
                if (!childAssocRef.isPrimary()) continue;
                aux.addField("PRIMARYPARENT", (Object)childAssocRef.getParentRef());
                aux.addField("PRIMARYASSOCTYPEQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                aux.addField("PRIMARYASSOCQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getQName()));
            }
            aux.addField("ASSOCTYPEQNAME", (Object)assocTypeQNameBuffer.toString());
            aux.addField("QNAME", (Object)qNameBuffer.toString());
        }
        if (ancestors != null) {
            for (NodeRef ancestor : ancestors) {
                aux.addField("ANCESTOR", (Object)ancestor.toString());
            }
        }
        return aux;
    }

    public static SolrInputDocument createRootAclDocument() {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("ACLID", (Object)"1");
        doc.addField("READER", (Object)"ROLE_ALL");
        doc.addField("READER", (Object)"ROLE_JUST_ROOT");
        doc.addField("ID", (Object)"ACL-1");
        return doc;
    }

    private void addCoreSummary(String cname, boolean detail, boolean hist, boolean values, CoreTracker tracker, NamedList<Object> report) throws IOException {
        long txLagSeconds;
        SimpleOrderedMap coreSummary = new SimpleOrderedMap();
        coreSummary.addAll(tracker.getCoreStats());
        long lastIndexTxCommitTime = tracker.getLastIndexedTxCommitTime();
        long lastIndexedTxId = tracker.getLastIndexedTxId();
        long lastTxCommitTimeOnServer = tracker.getLastTxCommitTimeOnServer();
        long lastTxIdOnServer = tracker.getLastTxIdOnServer();
        Date lastIndexTxCommitDate = new Date(lastIndexTxCommitTime);
        Date lastTxOnServerDate = new Date(lastTxCommitTimeOnServer);
        long transactionsToDo = lastTxIdOnServer - lastIndexedTxId;
        if (transactionsToDo < 0L) {
            transactionsToDo = 0L;
        }
        long lastIndexChangeSetCommitTime = tracker.getLastIndexedChangeSetCommitTime();
        long lastIndexedChangeSetId = tracker.getLastIndexedChangeSetId();
        long lastChangeSetCommitTimeOnServer = tracker.getLastChangeSetCommitTimeOnServer();
        long lastChangeSetIdOnServer = tracker.getLastChangeSetIdOnServer();
        Date lastIndexChangeSetCommitDate = new Date(lastIndexChangeSetCommitTime);
        Date lastChangeSetOnServerDate = new Date(lastChangeSetCommitTimeOnServer);
        long changeSetsToDo = lastChangeSetIdOnServer - lastIndexedChangeSetId;
        if (changeSetsToDo < 0L) {
            changeSetsToDo = 0L;
        }
        long remainingTxTimeMillis = (long)((double)transactionsToDo * tracker.getTrackerStats().getMeanDocsPerTx() * tracker.getTrackerStats().getMeanNodeIndexTime() / tracker.getTrackerStats().getNodeIndexingThreadCount());
        Date now = new Date();
        Date end = new Date(now.getTime() + remainingTxTimeMillis);
        Duration remainingTx = new Duration(now, end);
        long remainingChangeSetTimeMillis = (long)((double)changeSetsToDo * tracker.getTrackerStats().getMeanAclsPerChangeSet() * tracker.getTrackerStats().getMeanAclIndexTime() / tracker.getTrackerStats().getNodeIndexingThreadCount());
        now = new Date();
        end = new Date(now.getTime() + remainingChangeSetTimeMillis);
        Duration remainingChangeSet = new Duration(now, end);
        Duration txLag = new Duration(lastIndexTxCommitDate, lastTxOnServerDate);
        if (lastIndexTxCommitDate.compareTo(lastTxOnServerDate) > 0) {
            txLag = new Duration();
        }
        if ((txLagSeconds = (lastTxCommitTimeOnServer - lastIndexTxCommitTime) / 1000L) < 0L) {
            txLagSeconds = 0L;
        }
        Duration changeSetLag = new Duration(lastIndexChangeSetCommitDate, lastChangeSetOnServerDate);
        if (lastIndexChangeSetCommitDate.compareTo(lastChangeSetOnServerDate) > 0) {
            changeSetLag = new Duration();
        }
        long changeSetLagSeconds = (lastChangeSetCommitTimeOnServer - lastIndexChangeSetCommitTime) / 1000L;
        if (txLagSeconds < 0L) {
            txLagSeconds = 0L;
        }
        coreSummary.add("Active", (Object)tracker.isRunning());
        coreSummary.add("Last Index TX Commit Time", (Object)lastIndexTxCommitTime);
        coreSummary.add("Last Index TX Commit Date", (Object)lastIndexTxCommitDate);
        coreSummary.add("TX Lag", (Object)(txLagSeconds + " s"));
        coreSummary.add("TX Duration", (Object)txLag.toString());
        coreSummary.add("Timestamp for last TX on server", (Object)lastTxCommitTimeOnServer);
        coreSummary.add("Date for last TX on server", (Object)lastTxOnServerDate);
        coreSummary.add("Id for last TX on server", (Object)lastTxIdOnServer);
        coreSummary.add("Id for last TX in index", (Object)lastIndexedTxId);
        coreSummary.add("Approx transactions remaining", (Object)transactionsToDo);
        coreSummary.add("Approx transaction indexing time remaining", (Object)remainingTx.largestComponentformattedString());
        coreSummary.add("Last Index Change Set Commit Time", (Object)lastIndexChangeSetCommitTime);
        coreSummary.add("Last Index Change Set Commit Date", (Object)lastIndexChangeSetCommitDate);
        coreSummary.add("Change Set Lag", (Object)(changeSetLagSeconds + " s"));
        coreSummary.add("Change Set Duration", (Object)changeSetLag.toString());
        coreSummary.add("Timestamp for last Change Set on server", (Object)lastChangeSetCommitTimeOnServer);
        coreSummary.add("Date for last Change Set on server", (Object)lastChangeSetOnServerDate);
        coreSummary.add("Id for last Change Set on server", (Object)lastChangeSetIdOnServer);
        coreSummary.add("Id for last Change Set in index", (Object)lastIndexedChangeSetId);
        coreSummary.add("Approx change sets remaining", (Object)changeSetsToDo);
        coreSummary.add("Approx change set indexing time remaining", (Object)remainingChangeSet.largestComponentformattedString());
        coreSummary.add("Model sync times (ms)", tracker.getTrackerStats().getModelTimes().getNamedList(detail, hist, values));
        coreSummary.add("Acl index time (ms)", tracker.getTrackerStats().getAclTimes().getNamedList(detail, hist, values));
        coreSummary.add("Node index time (ms)", tracker.getTrackerStats().getNodeTimes().getNamedList(detail, hist, values));
        coreSummary.add("Docs/Tx", tracker.getTrackerStats().getTxDocs().getNamedList(detail, hist, values));
        coreSummary.add("Doc Transformation time (ms)", tracker.getTrackerStats().getDocTransformationTimes().getNamedList(detail, hist, values));
        Map<String, Set<String>> modelErrors = tracker.getModelErrors();
        if (modelErrors.size() > 0) {
            SimpleOrderedMap errorList = new SimpleOrderedMap();
            for (String modelName : modelErrors.keySet()) {
                Set<String> errors = modelErrors.get(modelName);
                errorList.add(modelName, errors);
            }
            coreSummary.add("Model changes are not compatible with the existing data model and have not been applied", (Object)errorList);
        }
        report.add(cname, (Object)coreSummary);
    }

    private NamedList<Object> buildAclTxReport(CoreTracker tracker, Long acltxid) throws AuthenticationException, IOException, JSONException {
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("TXID", (Object)acltxid);
        nr.add("transaction", this.buildTrackerReport(tracker, 0L, 0L, acltxid, acltxid, null, null));
        SimpleOrderedMap nodes = new SimpleOrderedMap();
        List<Long> dbAclIds = tracker.getAclsForDbAclTransaction(acltxid);
        for (Long aclid : dbAclIds) {
            nodes.add("ACLID " + aclid, this.buildAclReport(tracker, aclid));
        }
        nr.add("aclTxDbAclCount", (Object)dbAclIds.size());
        nr.add("nodes", (Object)nodes);
        return nr;
    }

    private NamedList<Object> buildAclReport(CoreTracker tracker, Long aclid) throws IOException, JSONException {
        AclReport aclReport = tracker.checkAcl(aclid);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Acl Id", (Object)aclReport.getAclId());
        nr.add("Acl doc in index", (Object)aclReport.getIndexAclDoc());
        if (aclReport.getIndexAclDoc() != null) {
            nr.add("Acl tx in Index", (Object)aclReport.getIndexAclTx());
        }
        return nr;
    }

    private NamedList<Object> buildTxReport(CoreTracker tracker, Long txid) throws AuthenticationException, IOException, JSONException {
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("TXID", (Object)txid);
        nr.add("transaction", this.buildTrackerReport(tracker, txid, txid, 0L, 0L, null, null));
        SimpleOrderedMap nodes = new SimpleOrderedMap();
        List<Node> dbNodes = tracker.getFullNodesForDbTransaction(txid);
        for (Node node : dbNodes) {
            nodes.add("DBID " + node.getId(), this.buildNodeReport(tracker, node));
        }
        nr.add("txDbNodeCount", (Object)dbNodes.size());
        nr.add("nodes", (Object)nodes);
        return nr;
    }

    private NamedList<Object> buildNodeReport(CoreTracker tracker, Node node) throws IOException, JSONException {
        NodeReport nodeReport = tracker.checkNode(node);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Node DBID", (Object)nodeReport.getDbid());
        nr.add("DB TX", (Object)nodeReport.getDbTx());
        nr.add("DB TX status", (Object)nodeReport.getDbNodeStatus().toString());
        nr.add("Leaf doc in Index", (Object)nodeReport.getIndexLeafDoc());
        nr.add("Aux doc in Index", (Object)nodeReport.getIndexAuxDoc());
        if (nodeReport.getIndexLeafDoc() != null) {
            nr.add("Leaf tx in Index", (Object)nodeReport.getIndexLeafTx());
        }
        if (nodeReport.getIndexAuxDoc() != null) {
            nr.add("Aux tx in Index", (Object)nodeReport.getIndexAuxTx());
        }
        return nr;
    }

    private NamedList<Object> buildNodeReport(CoreTracker tracker, Long dbid) throws IOException, JSONException {
        NodeReport nodeReport = tracker.checkNode(dbid);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Node DBID", (Object)nodeReport.getDbid());
        nr.add("DB TX", (Object)nodeReport.getDbTx());
        nr.add("DB TX status", (Object)nodeReport.getDbNodeStatus().toString());
        nr.add("Leaf doc in Index", (Object)nodeReport.getIndexLeafDoc());
        nr.add("Aux doc in Index", (Object)nodeReport.getIndexAuxDoc());
        if (nodeReport.getIndexLeafDoc() != null) {
            nr.add("Leaf tx in Index", (Object)nodeReport.getIndexLeafTx());
        }
        if (nodeReport.getIndexAuxDoc() != null) {
            nr.add("Aux tx in Index", (Object)nodeReport.getIndexAuxTx());
        }
        return nr;
    }

    private NamedList<Object> buildTrackerReport(CoreTracker tracker, Long fromTx, Long toTx, Long fromAclTx, Long toAclTx, Long fromTime, Long toTime) throws IOException, JSONException, AuthenticationException {
        IndexHealthReport indexHealthReport = tracker.checkIndex(fromTx, toTx, fromAclTx, toAclTx, fromTime, toTime);
        SimpleOrderedMap ihr = new SimpleOrderedMap();
        ihr.add("DB transaction count", (Object)indexHealthReport.getDbTransactionCount());
        ihr.add("DB acl transaction count", (Object)indexHealthReport.getDbAclTransactionCount());
        ihr.add("Count of duplicated transactions in the index", (Object)indexHealthReport.getDuplicatedTxInIndex().cardinality());
        if (indexHealthReport.getDuplicatedTxInIndex().cardinality() > 0L) {
            ihr.add("First duplicate", (Object)indexHealthReport.getDuplicatedTxInIndex().nextSetBit(0L));
        }
        ihr.add("Count of duplicated acl transactions in the index", (Object)indexHealthReport.getDuplicatedAclTxInIndex().cardinality());
        if (indexHealthReport.getDuplicatedAclTxInIndex().cardinality() > 0L) {
            ihr.add("First duplicate acl tx", (Object)indexHealthReport.getDuplicatedAclTxInIndex().nextSetBit(0L));
        }
        ihr.add("Count of transactions in the index but not the DB", (Object)indexHealthReport.getTxInIndexButNotInDb().cardinality());
        if (indexHealthReport.getTxInIndexButNotInDb().cardinality() > 0L) {
            ihr.add("First transaction in the index but not the DB", (Object)indexHealthReport.getTxInIndexButNotInDb().nextSetBit(0L));
        }
        ihr.add("Count of acl transactions in the index but not the DB", (Object)indexHealthReport.getAclTxInIndexButNotInDb().cardinality());
        if (indexHealthReport.getAclTxInIndexButNotInDb().cardinality() > 0L) {
            ihr.add("First acl transaction in the index but not the DB", (Object)indexHealthReport.getAclTxInIndexButNotInDb().nextSetBit(0L));
        }
        ihr.add("Count of missing transactions from the Index", (Object)indexHealthReport.getMissingTxFromIndex().cardinality());
        if (indexHealthReport.getMissingTxFromIndex().cardinality() > 0L) {
            ihr.add("First transaction missing from the Index", (Object)indexHealthReport.getMissingTxFromIndex().nextSetBit(0L));
        }
        ihr.add("Count of missing acl transactions from the Index", (Object)indexHealthReport.getMissingAclTxFromIndex().cardinality());
        if (indexHealthReport.getMissingAclTxFromIndex().cardinality() > 0L) {
            ihr.add("First acl transaction missing from the Index", (Object)indexHealthReport.getMissingAclTxFromIndex().nextSetBit(0L));
        }
        ihr.add("Index transaction count", (Object)indexHealthReport.getTransactionDocsInIndex());
        ihr.add("Index acl transaction count", (Object)indexHealthReport.getAclTransactionDocsInIndex());
        ihr.add("Index unique transaction count", (Object)indexHealthReport.getTransactionDocsInIndex());
        ihr.add("Index unique acl transaction count", (Object)indexHealthReport.getAclTransactionDocsInIndex());
        ihr.add("Index leaf count", (Object)indexHealthReport.getLeafDocCountInIndex());
        ihr.add("Count of duplicate leaves in the index", (Object)indexHealthReport.getDuplicatedLeafInIndex().cardinality());
        if (indexHealthReport.getDuplicatedLeafInIndex().cardinality() > 0L) {
            ihr.add("First duplicate leaf in the index", (Object)("LEAF-" + indexHealthReport.getDuplicatedLeafInIndex().nextSetBit(0L)));
        }
        ihr.add("Index aux count", (Object)indexHealthReport.getAuxDocCountInIndex());
        ihr.add("Count of duplicate aux docs in the index", (Object)indexHealthReport.getDuplicatedAuxInIndex().cardinality());
        if (indexHealthReport.getDuplicatedAuxInIndex().cardinality() > 0L) {
            ihr.add("First duplicate aux in the index", (Object)("AUX-" + indexHealthReport.getDuplicatedAuxInIndex().nextSetBit(0L)));
        }
        ihr.add("Index error count", (Object)indexHealthReport.getErrorDocCountInIndex());
        ihr.add("Count of duplicate error docs in the index", (Object)indexHealthReport.getDuplicatedErrorInIndex().cardinality());
        if (indexHealthReport.getDuplicatedErrorInIndex().cardinality() > 0L) {
            ihr.add("First duplicate error in the index", (Object)("ERROR-" + indexHealthReport.getDuplicatedErrorInIndex().nextSetBit(0L)));
        }
        ihr.add("Index unindexed count", (Object)indexHealthReport.getUnindexedDocCountInIndex());
        ihr.add("Count of duplicate unindexed docs in the index", (Object)indexHealthReport.getDuplicatedUnindexedInIndex().cardinality());
        if (indexHealthReport.getDuplicatedUnindexedInIndex().cardinality() > 0L) {
            ihr.add("First duplicate unindexed in the index", (Object)("UNINDEXED-" + indexHealthReport.getDuplicatedErrorInIndex().nextSetBit(0L)));
        }
        ihr.add("Last index commit time", (Object)indexHealthReport.getLastIndexedCommitTime());
        Date lastDate = new Date(indexHealthReport.getLastIndexedCommitTime());
        ihr.add("Last Index commit date", (Object)CachingDateFormat.getDateFormat().format(lastDate));
        ihr.add("Last TX id before holes", (Object)indexHealthReport.getLastIndexedIdBeforeHoles());
        return ihr;
    }

    private void copyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws IOException {
        if (destDir.exists()) {
            throw new IOException("Destination should be created from clean");
        }
        if (!destDir.mkdirs()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (preserveFileDate) {
            destDir.setLastModified(srcDir.lastModified());
        }
        if (!destDir.canWrite()) {
            throw new IOException("No acces to destination directory" + destDir);
        }
        File[] files = srcDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File currentCopyTarget = new File(destDir, files[i].getName());
                if (files[i].isDirectory()) {
                    this.copyDirectory(files[i], currentCopyTarget, preserveFileDate);
                    continue;
                }
                this.copyFile(files[i], currentCopyTarget, preserveFileDate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        try {
            if (destFile.exists()) {
                throw new IOException("File shoud not exist " + destFile);
            }
            FileInputStream input = new FileInputStream(srcFile);
            try {
                FileOutputStream output = new FileOutputStream(destFile);
                try {
                    this.copy(input, output);
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (IOException io) {}
                }
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException io) {}
            }
            if (srcFile.length() != destFile.length()) {
                throw new IOException("Failed to copy full from '" + srcFile + "' to '" + destFile + "'");
            }
            if (preserveFileDate) {
                destFile.setLastModified(srcFile.lastModified());
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + directory);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to delete director - no access" + directory);
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            throw new IOException("Unable to delete file: " + file);
        }
        if (!directory.delete()) {
            throw new IOException("Unable to delete directory " + directory);
        }
    }

    public static void main(String[] args) {
        int i;
        AlfrescoCoreAdminHandler handler = new AlfrescoCoreAdminHandler();
        String[] toSort = handler.orderLocalisedNames;
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        Arrays.sort(toSort, collator);
        System.out.println(Locale.ENGLISH);
        for (i = 0; i < toSort.length; ++i) {
            System.out.println(toSort[i]);
        }
        collator = Collator.getInstance(Locale.FRENCH);
        Arrays.sort(toSort, collator);
        System.out.println(Locale.FRENCH);
        for (i = 0; i < toSort.length; ++i) {
            System.out.println(toSort[i]);
        }
        collator = Collator.getInstance(Locale.GERMAN);
        Arrays.sort(toSort, collator);
        System.out.println(Locale.GERMAN);
        for (i = 0; i < toSort.length; ++i) {
            System.out.println(toSort[i]);
        }
        collator = Collator.getInstance(new Locale("sv"));
        Arrays.sort(toSort, collator);
        System.out.println(new Locale("sv"));
        for (i = 0; i < toSort.length; ++i) {
            System.out.println(toSort[i]);
        }
    }

    class SolrServletRequest
    extends SolrQueryRequestBase {
        public SolrServletRequest(SolrCore core, HttpServletRequest req) {
            super(core, (SolrParams)new MultiMapSolrParams(Collections.emptyMap()));
        }
    }
}

