/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoUpdateHandler
extends UpdateHandler {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoUpdateHandler.class);
    AtomicLong addCommands = new AtomicLong();
    AtomicLong addCommandsCumulative = new AtomicLong();
    AtomicLong deleteByIdCommands = new AtomicLong();
    AtomicLong deleteByIdCommandsCumulative = new AtomicLong();
    AtomicLong deleteByQueryCommands = new AtomicLong();
    AtomicLong deleteByQueryCommandsCumulative = new AtomicLong();
    AtomicLong expungeDeleteCommands = new AtomicLong();
    AtomicLong mergeIndexesCommands = new AtomicLong();
    AtomicLong commitCommands = new AtomicLong();
    AtomicLong optimizeCommands = new AtomicLong();
    AtomicLong rollbackCommands = new AtomicLong();
    AtomicLong numDocsPending = new AtomicLong();
    AtomicLong numErrors = new AtomicLong();
    AtomicLong numErrorsCumulative = new AtomicLong();
    ConcurrentHashMap<Long, Long> deletedLeaves = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> addedLeaves = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> updatedLeaves = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> deletedAux = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> addedAux = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> updatedAux = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> deletedAcl = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> addedAcl = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> updatedAcl = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> deletedTx = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> addedTx = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> updatedTx = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> deletedAclTx = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> addedAclTx = new ConcurrentHashMap();
    ConcurrentHashMap<Long, Long> updatedAclTx = new ConcurrentHashMap();
    AtomicBoolean deleteAll = new AtomicBoolean(false);
    AtomicBoolean checkCache = new AtomicBoolean(false);
    protected final CommitTracker tracker;
    protected final Lock iwAccess;
    protected final Lock iwCommit;
    protected IndexWriter writer;

    public AlfrescoUpdateHandler(SolrCore core) throws IOException {
        super(core);
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.iwAccess = rwl.readLock();
        this.iwCommit = rwl.writeLock();
        this.tracker = new CommitTracker();
    }

    private void deleteAll() throws IOException {
        SolrCore.log.info(this.core.getLogId() + "REMOVING ALL DOCUMENTS FROM INDEX");
        this.closeWriter();
        this.writer = this.createMainIndexWriter("DirectUpdateHandler2", true);
    }

    protected void openWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.createMainIndexWriter("DirectUpdateHandler2", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWriter() throws IOException {
        try {
            this.numDocsPending.set(0L);
            if (this.writer != null) {
                this.writer.close();
            }
        }
        finally {
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackWriter() throws IOException {
        try {
            this.numDocsPending.set(0L);
            if (this.writer != null) {
                this.writer.rollback();
            }
        }
        finally {
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDoc(AddUpdateCommand cmd) throws IOException {
        this.addCommands.incrementAndGet();
        this.addCommandsCumulative.incrementAndGet();
        int rc = -1;
        if (this.idField == null) {
            cmd.allowDups = true;
            cmd.overwriteCommitted = false;
            cmd.overwritePending = false;
        }
        this.iwAccess.lock();
        try {
            AlfrescoUpdateHandler alfrescoUpdateHandler = this;
            synchronized (alfrescoUpdateHandler) {
                this.openWriter();
                this.tracker.addedDocument(cmd.commitWithin);
            }
            Term updateTerm = null;
            if (cmd.overwriteCommitted || cmd.overwritePending) {
                if (cmd.indexedId == null) {
                    cmd.indexedId = this.getIndexedId(cmd.doc);
                }
                Term idTerm = this.idTerm.createTerm(cmd.indexedId);
                boolean del = false;
                if (cmd.updateTerm == null) {
                    updateTerm = idTerm;
                } else {
                    del = true;
                    updateTerm = cmd.updateTerm;
                }
                if (idTerm.text().equals("CHECK_CACHE")) {
                    this.checkCache.set(true);
                } else {
                    this.writer.updateDocument(updateTerm, cmd.getLuceneDocument(this.schema));
                    if (del) {
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new TermQuery(updateTerm), BooleanClause.Occur.MUST_NOT));
                        bq.add(new BooleanClause((Query)new TermQuery(idTerm), BooleanClause.Occur.MUST));
                        this.writer.deleteDocuments((Query)bq);
                    }
                    DbidAndAclid dbidAncAclid = new DbidAndAclid(cmd.getLuceneDocument(this.schema));
                    switch (dbidAncAclid.getDocType()) {
                        case ACL: {
                            this.updatedAcl.put(dbidAncAclid.aclid, dbidAncAclid.aclid);
                            break;
                        }
                        case AUX: 
                        case ERROR: 
                        case UNINDEXED: {
                            this.updatedAux.put(dbidAncAclid.dbid, dbidAncAclid.dbid);
                            break;
                        }
                        case LEAF: {
                            this.updatedLeaves.put(dbidAncAclid.dbid, dbidAncAclid.dbid);
                            break;
                        }
                        case TX: {
                            this.updatedTx.put(dbidAncAclid.txid, dbidAncAclid.txid);
                            break;
                        }
                        case ACLTX: {
                            this.updatedAclTx.put(dbidAncAclid.acltxid, dbidAncAclid.acltxid);
                            break;
                        }
                    }
                }
            } else {
                Term idTerm;
                if (cmd.indexedId == null) {
                    cmd.indexedId = this.getIndexedId(cmd.doc);
                }
                if ((idTerm = this.idTerm.createTerm(cmd.indexedId)).text().equals("CHECK_CACHE")) {
                    this.checkCache.set(true);
                } else {
                    this.writer.addDocument(cmd.getLuceneDocument(this.schema));
                    DbidAndAclid dbidAncAclid = new DbidAndAclid(cmd.getLuceneDocument(this.schema));
                    switch (dbidAncAclid.getDocType()) {
                        case ACL: {
                            this.addedAcl.put(dbidAncAclid.aclid, dbidAncAclid.aclid);
                            break;
                        }
                        case AUX: 
                        case ERROR: 
                        case UNINDEXED: {
                            this.addedAux.put(dbidAncAclid.dbid, dbidAncAclid.aclid);
                            break;
                        }
                        case LEAF: {
                            this.addedLeaves.put(dbidAncAclid.dbid, dbidAncAclid.dbid);
                            break;
                        }
                        case TX: {
                            this.addedTx.put(dbidAncAclid.txid, dbidAncAclid.txid);
                            break;
                        }
                        case ACLTX: {
                            this.addedAclTx.put(dbidAncAclid.acltxid, dbidAncAclid.acltxid);
                            break;
                        }
                    }
                }
            }
            rc = 1;
        }
        finally {
            this.iwAccess.unlock();
            if (rc != 1) {
                this.numErrors.incrementAndGet();
                this.numErrorsCumulative.incrementAndGet();
            } else {
                this.numDocsPending.incrementAndGet();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteUpdateCommand cmd) throws IOException {
        this.deleteByIdCommands.incrementAndGet();
        this.deleteByIdCommandsCumulative.incrementAndGet();
        if (!cmd.fromPending && !cmd.fromCommitted) {
            this.numErrors.incrementAndGet();
            this.numErrorsCumulative.incrementAndGet();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "meaningless command: " + cmd);
        }
        if (!cmd.fromPending || !cmd.fromCommitted) {
            this.numErrors.incrementAndGet();
            this.numErrorsCumulative.incrementAndGet();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "operation not supported" + cmd);
        }
        this.iwCommit.lock();
        try {
            this.openWriter();
            Term term = this.idTerm.createTerm(this.idFieldType.toInternal(cmd.id));
            this.writer.deleteDocuments(term);
            if (cmd.id.startsWith("LEAF-")) {
                Long dbid = Long.valueOf(cmd.id.substring(5));
                this.deletedLeaves.put(dbid, dbid);
            } else if (cmd.id.startsWith("ERROR-")) {
                Long dbid = Long.valueOf(cmd.id.substring(6));
                this.deletedAux.put(dbid, dbid);
            } else if (cmd.id.startsWith("UNINDEXED-")) {
                Long dbid = Long.valueOf(cmd.id.substring(10));
                this.deletedAux.put(dbid, dbid);
            } else if (cmd.id.startsWith("AUX-")) {
                Long dbid = Long.valueOf(cmd.id.substring(4));
                this.deletedAux.put(dbid, dbid);
            } else if (cmd.id.startsWith("ACL-")) {
                Long aclid = Long.valueOf(cmd.id.substring(4));
                this.deletedAcl.put(aclid, aclid);
            } else if (cmd.id.startsWith("TX-")) {
                Long txid = Long.valueOf(cmd.id.substring(3));
                this.deletedTx.put(txid, txid);
            } else if (cmd.id.startsWith("ACLTX-")) {
                Long txid = Long.valueOf(cmd.id.substring(6));
                this.deletedAclTx.put(txid, txid);
            }
        }
        finally {
            this.iwCommit.unlock();
        }
        if (this.tracker.timeUpperBound > 0L) {
            this.tracker.scheduleCommitWithin(this.tracker.timeUpperBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        this.deleteByQueryCommands.incrementAndGet();
        this.deleteByQueryCommandsCumulative.incrementAndGet();
        if (!cmd.fromPending && !cmd.fromCommitted) {
            this.numErrors.incrementAndGet();
            this.numErrorsCumulative.incrementAndGet();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "meaningless command: " + cmd);
        }
        if (!cmd.fromPending || !cmd.fromCommitted) {
            this.numErrors.incrementAndGet();
            this.numErrorsCumulative.incrementAndGet();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "operation not supported" + cmd);
        }
        boolean madeIt = false;
        boolean delAll = false;
        try {
            block11: {
                Query q = QueryParsing.parseQuery((String)cmd.query, (IndexSchema)this.schema);
                delAll = MatchAllDocsQuery.class == q.getClass();
                this.iwCommit.lock();
                try {
                    if (delAll) {
                        this.deleteAll();
                        this.deleteAll.set(true);
                        break block11;
                    }
                    throw new UnsupportedOperationException();
                }
                finally {
                    this.iwCommit.unlock();
                }
            }
            madeIt = true;
            if (this.tracker.timeUpperBound > 0L) {
                this.tracker.scheduleCommitWithin(this.tracker.timeUpperBound);
            }
        }
        finally {
            if (!madeIt) {
                this.numErrors.incrementAndGet();
                this.numErrorsCumulative.incrementAndGet();
            }
        }
    }

    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceOpenWriter() throws IOException {
        this.iwCommit.lock();
        try {
            this.openWriter();
        }
        finally {
            this.iwCommit.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommitUpdateCommand cmd) throws IOException {
        if (cmd.optimize) {
            this.optimizeCommands.incrementAndGet();
        } else {
            this.commitCommands.incrementAndGet();
            if (cmd.expungeDeletes) {
                this.expungeDeleteCommands.incrementAndGet();
            }
        }
        Future[] waitSearcher = null;
        if (cmd.waitSearcher) {
            waitSearcher = new Future[1];
        }
        boolean error = true;
        this.iwCommit.lock();
        try {
            log.info("start " + cmd);
            if (cmd.optimize) {
                this.openWriter();
                this.writer.optimize(cmd.maxOptimizeSegments);
            } else if (cmd.expungeDeletes) {
                this.openWriter();
                this.writer.expungeDeletes();
            }
            this.closeWriter();
            this.callPostCommitCallbacks();
            if (cmd.optimize) {
                this.callPostOptimizeCallbacks();
            }
            RefCounted refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher oldSearcher = (SolrIndexSearcher)refCounted.get();
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_ADDED_LEAVES", this.addedLeaves);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_ADDED_AUX", this.addedAux);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_ADDED_ACL", this.addedAcl);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_UPDATED_LEAVES", this.updatedLeaves);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_UPDATED_AUX", this.updatedAux);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_UPDATED_ALC", this.updatedAcl);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_DELETED_LEAVES", this.deletedLeaves);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_DELETED_AUX", this.deletedAux);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_DELETED_ACL", this.deletedAcl);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_DELETE_ALL", (Object)this.deleteAll);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_CHECK_CACHE, (Object)this.checkCache);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_ADDED_TX", this.addedTx);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_DELETED_TX", this.deletedTx);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_UPDATED_TX", this.updatedTx);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_ADDED_ACL_TX", this.addedAclTx);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_DELETED_ACL_TX", this.deletedAclTx);
            oldSearcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)"KEY_UPDATED_ACL_TX", this.updatedAclTx);
            refCounted.decref();
            this.core.getSearcher(true, false, waitSearcher);
            this.tracker.didCommit();
            log.info("end_commit_flush");
            this.addedLeaves = new ConcurrentHashMap();
            this.addedAux = new ConcurrentHashMap();
            this.addedAcl = new ConcurrentHashMap();
            this.updatedLeaves = new ConcurrentHashMap();
            this.updatedAux = new ConcurrentHashMap();
            this.updatedAcl = new ConcurrentHashMap();
            this.deletedLeaves = new ConcurrentHashMap();
            this.deletedAux = new ConcurrentHashMap();
            this.deletedAcl = new ConcurrentHashMap();
            this.deleteAll = new AtomicBoolean(false);
            this.checkCache = new AtomicBoolean(false);
            this.addedTx = new ConcurrentHashMap();
            this.deletedTx = new ConcurrentHashMap();
            this.updatedTx = new ConcurrentHashMap();
            this.addedAclTx = new ConcurrentHashMap();
            this.deletedAclTx = new ConcurrentHashMap();
            this.updatedAclTx = new ConcurrentHashMap();
            error = false;
            this.iwCommit.unlock();
            this.addCommands.set(0L);
            this.deleteByIdCommands.set(0L);
            this.deleteByQueryCommands.set(0L);
            this.numErrors.set(error ? 1L : 0L);
        }
        catch (Throwable throwable) {
            this.iwCommit.unlock();
            this.addCommands.set(0L);
            this.deleteByIdCommands.set(0L);
            this.deleteByQueryCommands.set(0L);
            this.numErrors.set(error ? 1L : 0L);
            throw throwable;
        }
        if (waitSearcher != null && waitSearcher[0] != null) {
            try {
                waitSearcher[0].get();
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
            catch (ExecutionException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        this.rollbackCommands.incrementAndGet();
        boolean error = true;
        this.iwCommit.lock();
        try {
            log.info("start " + cmd);
            this.rollbackWriter();
            this.tracker.didRollback();
            log.info("end_rollback");
            this.addedLeaves = new ConcurrentHashMap();
            this.addedAux = new ConcurrentHashMap();
            this.addedAcl = new ConcurrentHashMap();
            this.updatedLeaves = new ConcurrentHashMap();
            this.updatedAux = new ConcurrentHashMap();
            this.updatedAcl = new ConcurrentHashMap();
            this.deletedLeaves = new ConcurrentHashMap();
            this.deletedAux = new ConcurrentHashMap();
            this.deletedAcl = new ConcurrentHashMap();
            this.deleteAll = new AtomicBoolean(false);
            this.checkCache = new AtomicBoolean(false);
            this.addedTx = new ConcurrentHashMap();
            this.deletedTx = new ConcurrentHashMap();
            this.updatedTx = new ConcurrentHashMap();
            this.addedAclTx = new ConcurrentHashMap();
            this.deletedAclTx = new ConcurrentHashMap();
            this.updatedAclTx = new ConcurrentHashMap();
            error = false;
            this.iwCommit.unlock();
            this.addCommandsCumulative.set(this.addCommandsCumulative.get() - this.addCommands.getAndSet(0L));
            this.deleteByIdCommandsCumulative.set(this.deleteByIdCommandsCumulative.get() - this.deleteByIdCommands.getAndSet(0L));
            this.deleteByQueryCommandsCumulative.set(this.deleteByQueryCommandsCumulative.get() - this.deleteByQueryCommands.getAndSet(0L));
            this.numErrors.set(error ? 1L : 0L);
        }
        catch (Throwable throwable) {
            this.iwCommit.unlock();
            this.addCommandsCumulative.set(this.addCommandsCumulative.get() - this.addCommands.getAndSet(0L));
            this.deleteByIdCommandsCumulative.set(this.deleteByIdCommandsCumulative.get() - this.deleteByIdCommands.getAndSet(0L));
            this.deleteByQueryCommandsCumulative.set(this.deleteByQueryCommandsCumulative.get() - this.deleteByQueryCommands.getAndSet(0L));
            this.numErrors.set(error ? 1L : 0L);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        log.info("closing " + (Object)((Object)this));
        this.iwCommit.lock();
        try {
            if (this.tracker.pending != null) {
                this.tracker.pending.cancel(true);
                this.tracker.pending = null;
            }
            this.tracker.scheduler.shutdown();
            this.closeWriter();
        }
        finally {
            this.iwCommit.unlock();
        }
        log.info("closed " + (Object)((Object)this));
    }

    public String getName() {
        return DirectUpdateHandler2.class.getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Update handler that efficiently directly updates the on-disk main lucene index";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.UPDATEHANDLER;
    }

    public String getSourceId() {
        return "$Id: DirectUpdateHandler2.java 824380 2009-10-12 15:18:08Z koji $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/update/DirectUpdateHandler2.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("commits", (Object)this.commitCommands.get());
        if (this.tracker.docsUpperBound > 0) {
            lst.add("autocommit maxDocs", (Object)this.tracker.docsUpperBound);
        }
        if (this.tracker.timeUpperBound > 0L) {
            lst.add("autocommit maxTime", (Object)("" + this.tracker.timeUpperBound + "ms"));
        }
        lst.add("autocommits", (Object)this.tracker.autoCommitCount);
        lst.add("optimizes", (Object)this.optimizeCommands.get());
        lst.add("rollbacks", (Object)this.rollbackCommands.get());
        lst.add("expungeDeletes", (Object)this.expungeDeleteCommands.get());
        lst.add("docsPending", (Object)this.numDocsPending.get());
        lst.add("adds", (Object)this.addCommands.get());
        lst.add("deletesById", (Object)this.deleteByIdCommands.get());
        lst.add("deletesByQuery", (Object)this.deleteByQueryCommands.get());
        lst.add("errors", (Object)this.numErrors.get());
        lst.add("cumulative_adds", (Object)this.addCommandsCumulative.get());
        lst.add("cumulative_deletesById", (Object)this.deleteByIdCommandsCumulative.get());
        lst.add("cumulative_deletesByQuery", (Object)this.deleteByQueryCommandsCumulative.get());
        lst.add("cumulative_errors", (Object)this.numErrorsCumulative.get());
        return lst;
    }

    public String toString() {
        return "DirectUpdateHandler2" + this.getStatistics();
    }

    static class DbidAndAclid {
        Long dbid;
        Long aclid;
        Long txid;
        Long acltxid;
        String id;
        DocType docType;

        DbidAndAclid(Document doc) {
            Fieldable[] idField;
            Fieldable[] aclTxIdField;
            Fieldable[] txIdField;
            Fieldable[] aclField;
            Fieldable[] dbidField = doc.getFieldables("DBID");
            if (dbidField != null && dbidField.length > 0) {
                this.dbid = Long.valueOf(dbidField[0].stringValue());
            }
            if ((aclField = doc.getFieldables("ACLID")) != null && aclField.length > 0) {
                this.aclid = Long.valueOf(aclField[0].stringValue());
            }
            if ((txIdField = doc.getFieldables("TXID")) != null && txIdField.length > 0) {
                this.txid = Long.valueOf(txIdField[0].stringValue());
            }
            if ((aclTxIdField = doc.getFieldables("ACLTXID")) != null && aclTxIdField.length > 0) {
                this.acltxid = Long.valueOf(aclTxIdField[0].stringValue());
            }
            if ((idField = doc.getFieldables("ID")) != null && idField.length > 0) {
                this.id = idField[0].stringValue();
            }
            this.docType = this.id.startsWith("LEAF-") ? DocType.LEAF : (this.id.startsWith("ERROR-") ? DocType.ERROR : (this.id.startsWith("UNINDEXED-") ? DocType.UNINDEXED : (this.id.startsWith("AUX-") ? DocType.AUX : (this.id.startsWith("ACL-") ? DocType.ACL : (this.id.startsWith("TX-") ? DocType.TX : (this.id.startsWith("ACLTX-") ? DocType.ACLTX : DocType.UNKOWN))))));
        }

        DbidAndAclid() {
        }

        DocType getDocType() {
            return this.docType;
        }
    }

    static enum DocType {
        LEAF,
        AUX,
        ACL,
        UNKOWN,
        TX,
        ACLTX,
        ERROR,
        UNINDEXED;

    }

    class CommitTracker
    implements Runnable {
        public final int DOC_COMMIT_DELAY_MS = 250;
        int docsUpperBound;
        long timeUpperBound;
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        private ScheduledFuture pending = null;
        long docsSinceCommit = 0L;
        int autoCommitCount = 0;
        long lastAddedTime = -1L;

        public CommitTracker() {
            this.docsUpperBound = ((AlfrescoUpdateHandler)AlfrescoUpdateHandler.this).core.getSolrConfig().getUpdateHandlerInfo().autoCommmitMaxDocs;
            this.timeUpperBound = ((AlfrescoUpdateHandler)AlfrescoUpdateHandler.this).core.getSolrConfig().getUpdateHandlerInfo().autoCommmitMaxTime;
            SolrCore.log.info("AutoCommit: " + this);
        }

        public synchronized void scheduleCommitWithin(long commitMaxTime) {
            this._scheduleCommitWithin(commitMaxTime);
        }

        private void _scheduleCommitWithin(long commitMaxTime) {
            if (this.pending != null && this.pending.getDelay(TimeUnit.MILLISECONDS) >= commitMaxTime) {
                this.pending.cancel(false);
                this.pending = null;
            }
            if (this.pending == null) {
                this.pending = this.scheduler.schedule(this, commitMaxTime, TimeUnit.MILLISECONDS);
            }
        }

        public void addedDocument(int commitWithin) {
            long ctime;
            ++this.docsSinceCommit;
            this.lastAddedTime = System.currentTimeMillis();
            if (this.docsUpperBound > 0 && this.docsSinceCommit > (long)this.docsUpperBound) {
                this._scheduleCommitWithin(250L);
            }
            long l = ctime = commitWithin > 0 ? (long)commitWithin : this.timeUpperBound;
            if (ctime > 0L) {
                this._scheduleCommitWithin(ctime);
            }
        }

        public void didCommit() {
            if (this.pending != null) {
                this.pending.cancel(false);
                this.pending = null;
            }
            this.docsSinceCommit = 0L;
        }

        public void didRollback() {
            if (this.pending != null) {
                this.pending.cancel(false);
                this.pending = null;
            }
            this.docsSinceCommit = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            long started = System.currentTimeMillis();
            try {
                CommitUpdateCommand command = new CommitUpdateCommand(false);
                command.waitFlush = true;
                command.waitSearcher = true;
                AlfrescoUpdateHandler.this.commit(command);
                ++this.autoCommitCount;
            }
            catch (Exception e) {
                log.error("auto commit error...");
                e.printStackTrace();
            }
            finally {
                this.pending = null;
            }
            if (this.lastAddedTime > started) {
                if (this.docsUpperBound > 0 && this.docsSinceCommit > (long)this.docsUpperBound) {
                    this.pending = this.scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
                } else if (this.timeUpperBound > 0L) {
                    this.pending = this.scheduler.schedule(this, this.timeUpperBound, TimeUnit.MILLISECONDS);
                }
            }
        }

        public synchronized int getCommitCount() {
            return this.autoCommitCount;
        }

        public String toString() {
            if (this.timeUpperBound > 0L || this.docsUpperBound > 0) {
                return (this.timeUpperBound > 0L ? "if uncommited for " + this.timeUpperBound + "ms; " : "") + (this.docsUpperBound > 0 ? "if " + this.docsUpperBound + " uncommited docs " : "");
            }
            return "disabled";
        }
    }
}

