/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.alfresco.solr.DualPivotQuickSort;

public class ResizeableArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] values;
    private int size;
    boolean active = false;

    public ResizeableArrayList() {
        this(10);
    }

    public ResizeableArrayList(int initialSize) {
        this.values = new Object[initialSize];
        this.size = initialSize;
    }

    @Override
    public E get(int index) {
        this.checkSize(index);
        return (E)this.values[index];
    }

    private void checkSize(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + this.values.length);
        }
    }

    public void resize(int minSize) {
        this.isActive();
        int oldSize = this.values.length;
        if (minSize > oldSize) {
            int newSize = oldSize * 3 / 2 + 1;
            if (newSize < minSize) {
                newSize = minSize;
            }
            this.values = Arrays.copyOf(this.values, newSize);
        }
        this.size = minSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    public <T> void copyFrom(ResizeableArrayList<T> from) {
        this.isActive();
        this.values = Arrays.copyOf(from.values, from.values.length);
        this.size = from.size;
    }

    @Override
    public E set(int index, E value) {
        this.checkSize(index);
        this.isActive();
        Object oldValue = this.values[index];
        this.values[index] = value;
        return (E)oldValue;
    }

    protected Object clone() throws CloneNotSupportedException {
        try {
            ResizeableArrayList v = (ResizeableArrayList)super.clone();
            v.values = Arrays.copyOf(this.values, this.values.length);
            v.size = this.size;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void isActive() {
        if (!this.active) {
            throw new IllegalStateException("Not active");
        }
    }

    void activate() {
        this.active = true;
    }

    void deactivate() {
        this.active = false;
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public <T> void sort(Comparator<T> comparator) {
        DualPivotQuickSort.sort(this.values, 0, this.size - 1, comparator);
    }
}

