/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.GetRequest;
import org.alfresco.httpclient.PostRequest;
import org.alfresco.httpclient.Request;
import org.alfresco.httpclient.Response;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.Pair;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.util.DateUtil;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOLRAPIClient {
    protected static final Logger log = LoggerFactory.getLogger(SOLRAPIClient.class);
    private static final String GET_ACL_CHANGESETS_URL = "api/solr/aclchangesets";
    private static final String GET_ACLS = "api/solr/acls";
    private static final String GET_ACLS_READERS = "api/solr/aclsReaders";
    private static final String GET_TRANSACTIONS_URL = "api/solr/transactions";
    private static final String GET_METADATA_URL = "api/solr/metadata";
    private static final String GET_NODES_URL = "api/solr/nodes";
    private static final String GET_CONTENT = "api/solr/textContent";
    private static final String GET_MODEL = "api/solr/model";
    private static final String GET_MODELS_DIFF = "api/solr/modelsdiff";
    private static final String CHECKSUM_HEADER = "XAlfresco-modelChecksum";
    private AlfrescoHttpClient repositoryHttpClient;
    private SOLRDeserializer deserializer;
    private DictionaryService dictionaryService;
    private JsonFactory jsonFactory;
    private NamespaceDAO namespaceDAO;

    public SOLRAPIClient(AlfrescoHttpClient repositoryHttpClient, DictionaryService dictionaryService, NamespaceDAO namespaceDAO) {
        this.repositoryHttpClient = repositoryHttpClient;
        this.dictionaryService = dictionaryService;
        this.namespaceDAO = namespaceDAO;
        this.deserializer = new SOLRDeserializer(namespaceDAO);
        this.jsonFactory = new JsonFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AclChangeSets getAclChangeSets(Long fromCommitTime, Long minAclChangeSetId, Long toCommitTime, Long maxAclChangeSetId, int maxResults) throws AuthenticationException, IOException, JSONException {
        StringBuilder url = new StringBuilder(GET_ACL_CHANGESETS_URL);
        StringBuilder args = new StringBuilder();
        if (fromCommitTime != null) {
            args.append("?").append("fromTime").append("=").append(fromCommitTime);
        }
        if (minAclChangeSetId != null) {
            args.append(args.length() == 0 ? "?" : "&").append("fromId").append("=").append(minAclChangeSetId);
        }
        if (toCommitTime != null) {
            args.append(args.length() == 0 ? "?" : "&").append("toTime").append("=").append(toCommitTime);
        }
        if (maxAclChangeSetId != null) {
            args.append(args.length() == 0 ? "?" : "&").append("toId").append("=").append(maxAclChangeSetId);
        }
        if (maxResults != 0 && maxResults != Integer.MAX_VALUE) {
            args.append(args.length() == 0 ? "?" : "&").append("maxResults").append("=").append(maxResults);
        }
        url.append((CharSequence)args);
        GetRequest req = new GetRequest(url.toString());
        Response response = null;
        JSONObject json = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("api/solr/aclchangesets return status:" + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            json = new JSONObject(new JSONTokener((Reader)reader));
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(json.toString(3));
        }
        JSONArray aclChangeSetsJSON = json.getJSONArray("aclChangeSets");
        ArrayList<AclChangeSet> aclChangeSets = new ArrayList<AclChangeSet>(aclChangeSetsJSON.length());
        for (int i = 0; i < aclChangeSetsJSON.length(); ++i) {
            JSONObject aclChangeSetJSON = aclChangeSetsJSON.getJSONObject(i);
            long aclChangeSetId = aclChangeSetJSON.getLong("id");
            long commitTimeMs = aclChangeSetJSON.getLong("commitTimeMs");
            int aclCount = aclChangeSetJSON.getInt("aclCount");
            AclChangeSet aclChangeSet = new AclChangeSet(aclChangeSetId, commitTimeMs, aclCount);
            aclChangeSets.add(aclChangeSet);
        }
        Long maxChangeSetCommitTime = null;
        if (json.has("maxChangeSetCommitTime")) {
            maxChangeSetCommitTime = json.getLong("maxChangeSetCommitTime");
        }
        Long maxChangeSetIdOnServer = null;
        if (json.has("maxChangeSetId")) {
            maxChangeSetIdOnServer = json.getLong("maxChangeSetId");
        }
        return new AclChangeSets(aclChangeSets, maxChangeSetCommitTime, maxChangeSetIdOnServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Acl> getAcls(List<AclChangeSet> aclChangeSets, Long minAclId, int maxResults) throws AuthenticationException, IOException, JSONException {
        if (aclChangeSets.size() > 512) {
            throw new IllegalArgumentException("Cannot query for more than 512 ACL ChangeSets.");
        }
        StringBuilder url = new StringBuilder(GET_ACLS);
        StringBuilder args = new StringBuilder();
        if (minAclId != null) {
            args.append("?").append("fromId").append("=").append(minAclId);
        }
        if (maxResults >= 0) {
            args.append(args.length() == 0 ? "?" : "&").append("maxResults").append("=").append(maxResults);
        }
        url.append((CharSequence)args);
        JSONObject jsonReq = new JSONObject();
        JSONArray aclChangeSetIdsJSON = new JSONArray();
        ArrayList<Long> aclChangeSetIds = new ArrayList<Long>();
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            Long aclChangeSetId = aclChangeSet.getId();
            aclChangeSetIdsJSON.put((Object)aclChangeSetId);
            aclChangeSetIds.add(aclChangeSetId);
        }
        jsonReq.put("aclChangeSetIds", (Object)aclChangeSetIdsJSON);
        PostRequest req = new PostRequest(url.toString(), jsonReq.toString(), "application/json");
        Response response = null;
        JSONObject json = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("api/solr/aclchangesets return status:" + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            json = new JSONObject(new JSONTokener((Reader)reader));
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(json.toString(3));
        }
        JSONArray aclsJSON = json.getJSONArray("acls");
        ArrayList<Acl> acls = new ArrayList<Acl>(aclsJSON.length());
        for (int i = 0; i < aclsJSON.length(); ++i) {
            JSONObject aclJSON = aclsJSON.getJSONObject(i);
            long aclChangeSetId = aclJSON.getLong("aclChangeSetId");
            long aclId = aclJSON.getLong("id");
            Acl acl = new Acl(aclChangeSetId, aclId);
            acls.add(acl);
        }
        return acls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AclReaders> getAclReaders(List<Acl> acls) throws AuthenticationException, IOException, JSONException {
        if (acls.size() > 512) {
            throw new IllegalArgumentException("Cannot query for more than 512 ACLs.");
        }
        StringBuilder url = new StringBuilder(GET_ACLS_READERS);
        JSONObject jsonReq = new JSONObject();
        JSONArray aclIdsJSON = new JSONArray();
        ArrayList<Long> aclIds = new ArrayList<Long>();
        for (Acl acl : acls) {
            Long aclId = acl.getId();
            aclIdsJSON.put((Object)aclId);
            aclIds.add(aclId);
        }
        jsonReq.put("aclIds", (Object)aclIdsJSON);
        PostRequest req = new PostRequest(url.toString(), jsonReq.toString(), "application/json");
        Response response = null;
        JSONObject json = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("api/solr/aclsReaders return status:" + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            json = new JSONObject(new JSONTokener((Reader)reader));
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(json.toString(3));
        }
        JSONArray aclsReadersJSON = json.getJSONArray("aclsReaders");
        ArrayList<AclReaders> aclsReaders = new ArrayList<AclReaders>(aclsReadersJSON.length());
        for (int i = 0; i < aclsReadersJSON.length(); ++i) {
            JSONObject aclReadersJSON = aclsReadersJSON.getJSONObject(i);
            long aclId = aclReadersJSON.getLong("aclId");
            JSONArray readersJSON = aclReadersJSON.getJSONArray("readers");
            ArrayList<String> readers = new ArrayList<String>(aclReadersJSON.length());
            for (int j = 0; j < readersJSON.length(); ++j) {
                String readerJSON = readersJSON.getString(j);
                readers.add(readerJSON);
            }
            long aclChangeSetId = aclReadersJSON.getLong("aclChangeSetId");
            String tenantDomain = aclReadersJSON.getString("tenantDomain");
            if (tenantDomain == null) {
                tenantDomain = "";
            }
            AclReaders aclReaders = new AclReaders(aclId, readers, aclChangeSetId, tenantDomain);
            aclsReaders.add(aclReaders);
        }
        return aclsReaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transactions getTransactions(Long fromCommitTime, Long minTxnId, Long toCommitTime, Long maxTxnId, int maxResults) throws AuthenticationException, IOException, JSONException {
        StringBuilder url = new StringBuilder(GET_TRANSACTIONS_URL);
        StringBuilder args = new StringBuilder();
        if (fromCommitTime != null) {
            args.append("?").append("fromCommitTime").append("=").append(fromCommitTime);
        }
        if (minTxnId != null) {
            args.append(args.length() == 0 ? "?" : "&").append("minTxnId").append("=").append(minTxnId);
        }
        if (toCommitTime != null) {
            args.append(args.length() == 0 ? "?" : "&").append("toCommitTime").append("=").append(toCommitTime);
        }
        if (maxTxnId != null) {
            args.append(args.length() == 0 ? "?" : "&").append("maxTxnId").append("=").append(maxTxnId);
        }
        if (maxResults != 0 && maxResults != Integer.MAX_VALUE) {
            args.append(args.length() == 0 ? "?" : "&").append("maxResults").append("=").append(maxResults);
        }
        url.append((CharSequence)args);
        GetRequest req = new GetRequest(url.toString());
        Response response = null;
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        Long maxTxnCommitTime = null;
        Long maxTxnIdOnServer = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("GetTransactions return status is " + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            JsonParser parser = this.jsonFactory.createJsonParser((Reader)reader);
            JsonToken token = parser.nextValue();
            while (token != null) {
                if ("transactions".equals(parser.getCurrentName())) {
                    token = parser.nextToken();
                    while (token == JsonToken.START_OBJECT) {
                        token = parser.nextValue();
                        long id = parser.getLongValue();
                        token = parser.nextValue();
                        long commitTime = parser.getLongValue();
                        token = parser.nextValue();
                        long updates = parser.getLongValue();
                        token = parser.nextValue();
                        long deletes = parser.getLongValue();
                        Transaction txn = new Transaction();
                        txn.setCommitTimeMs(commitTime);
                        txn.setDeletes(deletes);
                        txn.setId(id);
                        txn.setUpdates(updates);
                        transactions.add(txn);
                        token = parser.nextToken();
                        token = parser.nextToken();
                    }
                } else if ("maxTxnCommitTime".equals(parser.getCurrentName())) {
                    maxTxnCommitTime = parser.getLongValue();
                } else if ("maxTxnId".equals(parser.getCurrentName())) {
                    maxTxnIdOnServer = parser.getLongValue();
                }
                token = parser.nextValue();
            }
            parser.close();
            ((Reader)reader).close();
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        return new Transactions(transactions, maxTxnCommitTime, maxTxnIdOnServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getNodes(GetNodesParameters parameters, int maxResults) throws AuthenticationException, IOException, JSONException {
        StringBuilder url = new StringBuilder(GET_NODES_URL);
        JSONObject body = new JSONObject();
        if (parameters.getTransactionIds() != null) {
            JSONArray jsonTxnIds = new JSONArray();
            for (Long txnId : parameters.getTransactionIds()) {
                jsonTxnIds.put((Object)txnId);
            }
            body.put("txnIds", (Object)jsonTxnIds);
        }
        if (parameters.getFromNodeId() != null) {
            body.put("fromNodeId", (Object)parameters.getFromNodeId());
        }
        if (parameters.getToNodeId() != null) {
            body.put("toNodeId", (Object)parameters.getToNodeId());
        }
        if (parameters.getExcludeAspects() != null) {
            JSONArray jsonExcludeAspects = new JSONArray();
            for (QName excludeAspect : parameters.getExcludeAspects()) {
                jsonExcludeAspects.put((Object)excludeAspect.toString());
            }
            body.put("excludeAspects", (Object)jsonExcludeAspects);
        }
        if (parameters.getIncludeAspects() != null) {
            JSONArray jsonIncludeAspects = new JSONArray();
            for (QName includeAspect : parameters.getIncludeAspects()) {
                jsonIncludeAspects.put((Object)includeAspect.toString());
            }
            body.put("includeAspects", (Object)jsonIncludeAspects);
        }
        if (parameters.getStoreProtocol() != null) {
            body.put("storeProtocol", (Object)parameters.getStoreProtocol());
        }
        if (parameters.getStoreIdentifier() != null) {
            body.put("storeIdentifier", (Object)parameters.getStoreIdentifier());
        }
        body.put("maxResults", maxResults);
        PostRequest req = new PostRequest(url.toString(), body.toString(), "application/json");
        Response response = null;
        JSONObject json = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("GetNodes return status is " + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            json = new JSONObject(new JSONTokener((Reader)reader));
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(json.toString());
        }
        JSONArray jsonNodes = json.getJSONArray("nodes");
        ArrayList<Node> nodes = new ArrayList<Node>(jsonNodes.length());
        for (int i = 0; i < jsonNodes.length(); ++i) {
            JSONObject jsonNodeInfo = jsonNodes.getJSONObject(i);
            Node nodeInfo = new Node();
            if (jsonNodeInfo.has("id")) {
                nodeInfo.setId(jsonNodeInfo.getLong("id"));
            }
            if (jsonNodeInfo.has("nodeRef")) {
                nodeInfo.setNodeRef(jsonNodeInfo.getString("nodeRef"));
            }
            if (jsonNodeInfo.has("txnId")) {
                nodeInfo.setTxnId(jsonNodeInfo.getLong("txnId"));
            }
            if (jsonNodeInfo.has("status")) {
                String statusStr = jsonNodeInfo.getString("status");
                Node.SolrApiNodeStatus status = statusStr.equals("u") ? Node.SolrApiNodeStatus.UPDATED : (statusStr.equals("d") ? Node.SolrApiNodeStatus.DELETED : Node.SolrApiNodeStatus.UNKNOWN);
                nodeInfo.setStatus(status);
            }
            nodes.add(nodeInfo);
        }
        return nodes;
    }

    private PropertyValue getSinglePropertyValue(DataTypeDefinition dataType, Object value) throws JSONException {
        PropertyValue ret = null;
        QName dataTypeName = dataType.getName();
        if (value == null || value == JSONObject.NULL) {
            ret = null;
        } else if (dataTypeName.equals((Object)DataTypeDefinition.MLTEXT)) {
            JSONArray a = (JSONArray)value;
            HashMap<Locale, String> mlValues = new HashMap<Locale, String>(a.length());
            for (int k = 0; k < a.length(); ++k) {
                JSONObject pair = a.getJSONObject(k);
                Locale locale = this.deserializer.deserializeValue(Locale.class, pair.getString("locale"));
                String mlValue = pair.has("value") ? pair.getString("value") : null;
                mlValues.put(locale, mlValue);
            }
            ret = new MLTextPropertyValue(mlValues);
        } else if (dataTypeName.equals((Object)DataTypeDefinition.CONTENT)) {
            JSONObject o = (JSONObject)value;
            String localeStr = o.has("locale") ? o.getString("locale") : null;
            Locale locale = o.has("locale") ? this.deserializer.deserializeValue(Locale.class, localeStr) : null;
            Long size = o.has("size") ? Long.valueOf(o.getLong("size")) : null;
            String encoding = o.has("encoding") ? o.getString("encoding") : null;
            String mimetype = o.has("mimetype") ? o.getString("mimetype") : null;
            ret = new ContentPropertyValue(locale, size, encoding, mimetype);
        } else {
            ret = new StringPropertyValue((String)value);
        }
        return ret;
    }

    private PropertyValue getPropertyValue(PropertyDefinition propertyDef, Object value) throws JSONException {
        PropertyValue ret = null;
        if (value == null || value == JSONObject.NULL) {
            ret = null;
        } else if (propertyDef == null) {
            ret = new StringPropertyValue((String)value);
        } else {
            DataTypeDefinition dataType = propertyDef.getDataType();
            boolean isMulti = propertyDef.isMultiValued();
            if (isMulti) {
                if (!(value instanceof JSONArray)) {
                    throw new IllegalArgumentException("Expected json array, got " + value.getClass().getName());
                }
                MultiPropertyValue multi = new MultiPropertyValue();
                JSONArray array = (JSONArray)value;
                for (int j = 0; j < array.length(); ++j) {
                    multi.addValue(this.getSinglePropertyValue(dataType, array.get(j)));
                }
                ret = multi;
            } else {
                ret = this.getSinglePropertyValue(dataType, value);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeMetaData> getNodesMetaData(NodeMetaDataParameters params, int maxResults) throws AuthenticationException, IOException, JSONException {
        List<Long> nodeIds = params.getNodeIds();
        StringBuilder url = new StringBuilder(GET_METADATA_URL);
        JSONObject body = new JSONObject();
        if (nodeIds != null && nodeIds.size() > 0) {
            JSONArray jsonNodeIds = new JSONArray();
            for (Long nodeId : nodeIds) {
                jsonNodeIds.put((Object)nodeId);
            }
            body.put("nodeIds", (Object)jsonNodeIds);
        }
        if (params.getFromNodeId() != null) {
            body.put("fromNodeId", (Object)params.getFromNodeId());
        }
        if (params.getToNodeId() != null) {
            body.put("toNodeId", (Object)params.getToNodeId());
        }
        if (!params.isIncludeAclId()) {
            body.put("includeAclId", params.isIncludeAclId());
        }
        if (!params.isIncludeAspects()) {
            body.put("includeAspects", params.isIncludeAspects());
        }
        if (!params.isIncludeProperties()) {
            body.put("includeProperties", params.isIncludeProperties());
        }
        if (!params.isIncludeChildAssociations()) {
            body.put("includeChildAssociations", params.isIncludeChildAssociations());
        }
        if (!params.isIncludeParentAssociations()) {
            body.put("includeParentAssociations", params.isIncludeParentAssociations());
        }
        if (!params.isIncludeChildIds()) {
            body.put("includeChildIds", params.isIncludeChildIds());
        }
        if (!params.isIncludePaths()) {
            body.put("includePaths", params.isIncludePaths());
        }
        if (!params.isIncludeOwner()) {
            body.put("includeOwner", params.isIncludeOwner());
        }
        if (!params.isIncludeNodeRef()) {
            body.put("includeNodeRef", params.isIncludeNodeRef());
        }
        if (!params.isIncludeTxnId()) {
            body.put("includeTxnId", params.isIncludeTxnId());
        }
        body.put("maxResults", maxResults);
        PostRequest req = new PostRequest(url.toString(), body.toString(), "application/json");
        Response response = null;
        JSONObject json = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("GetNodeMetaData return status is " + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            json = new JSONObject(new JSONTokener((Reader)reader));
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(json.toString(3));
        }
        JSONArray jsonNodes = json.getJSONArray("nodes");
        ArrayList<NodeMetaData> nodes = new ArrayList<NodeMetaData>(jsonNodes.length());
        for (int i = 0; i < jsonNodes.length(); ++i) {
            ChildAssociationRef childAssociationRef;
            String childAssocRefStr;
            ArrayList<ChildAssociationRef> assocs;
            JSONArray jsonParentAssocs;
            int j;
            JSONObject jsonNodeInfo = jsonNodes.getJSONObject(i);
            NodeMetaData metaData = new NodeMetaData();
            if (jsonNodeInfo.has("id")) {
                metaData.setId(jsonNodeInfo.getLong("id"));
            }
            if (jsonNodeInfo.has("tenantDomain")) {
                metaData.setTenantDomain(jsonNodeInfo.getString("tenantDomain"));
            }
            if (jsonNodeInfo.has("txnId")) {
                metaData.setTxnId(jsonNodeInfo.getLong("txnId"));
            }
            if (jsonNodeInfo.has("aclId")) {
                metaData.setAclId(jsonNodeInfo.getLong("aclId"));
            }
            if (jsonNodeInfo.has("nodeRef")) {
                metaData.setNodeRef(new NodeRef(jsonNodeInfo.getString("nodeRef")));
            }
            if (jsonNodeInfo.has("type")) {
                metaData.setType(this.deserializer.deserializeValue(QName.class, jsonNodeInfo.getString("type")));
            }
            if (jsonNodeInfo.has("aspects")) {
                JSONArray jsonAspects = jsonNodeInfo.getJSONArray("aspects");
                HashSet<QName> aspects = new HashSet<QName>(jsonAspects.length());
                for (j = 0; j < jsonAspects.length(); ++j) {
                    String jsonAspect = (String)jsonAspects.get(j);
                    aspects.add(this.deserializer.deserializeValue(QName.class, jsonAspect));
                }
                metaData.setAspects(aspects);
            }
            if (jsonNodeInfo.has("paths")) {
                JSONArray jsonPaths = jsonNodeInfo.getJSONArray("paths");
                ArrayList<Pair<String, QName>> paths = new ArrayList<Pair<String, QName>>(jsonPaths.length());
                for (j = 0; j < jsonPaths.length(); ++j) {
                    JSONObject path = new JSONObject(jsonPaths.getString(j));
                    String pathValue = path.getString("path");
                    QName qname = path.has("qname") ? this.deserializer.deserializeValue(QName.class, path.getString("qname")) : null;
                    paths.add((Pair<String, QName>)new Pair((Object)pathValue, (Object)qname));
                }
                metaData.setPaths(paths);
            }
            if (jsonNodeInfo.has("ancestors")) {
                JSONArray jsonAncestors = jsonNodeInfo.getJSONArray("ancestors");
                HashSet<NodeRef> ancestors = new HashSet<NodeRef>(jsonAncestors.length());
                for (j = 0; j < jsonAncestors.length(); ++j) {
                    String ancestorNodeRefString = jsonAncestors.getString(j);
                    NodeRef ancestorNodeRef = new NodeRef(ancestorNodeRefString);
                    ancestors.add(ancestorNodeRef);
                }
                metaData.setAncestors(ancestors);
            }
            if (jsonNodeInfo.has("properties")) {
                JSONObject jsonProperties = jsonNodeInfo.getJSONObject("properties");
                HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>(jsonProperties.length());
                Iterator propKeysIterator = jsonProperties.keys();
                while (propKeysIterator.hasNext()) {
                    String propName = (String)propKeysIterator.next();
                    QName propQName = this.deserializer.deserializeValue(QName.class, propName);
                    Object propValueObj = jsonProperties.opt(propName);
                    PropertyDefinition propertyDef = this.dictionaryService.getProperty(propQName);
                    properties.put(propQName, this.getPropertyValue(propertyDef, propValueObj));
                }
                metaData.setProperties(properties);
            }
            if (jsonNodeInfo.has("parentAssocsCrc")) {
                metaData.setParentAssocsCrc(jsonNodeInfo.getLong("parentAssocsCrc"));
            }
            if (jsonNodeInfo.has("parentAssocs")) {
                jsonParentAssocs = jsonNodeInfo.getJSONArray("parentAssocs");
                assocs = new ArrayList<ChildAssociationRef>(jsonParentAssocs.length());
                for (int j2 = 0; j2 < jsonParentAssocs.length(); ++j2) {
                    childAssocRefStr = jsonParentAssocs.getString(j2);
                    childAssociationRef = new ChildAssociationRef(childAssocRefStr);
                    assocs.add(childAssociationRef);
                }
                metaData.setParentAssocs(assocs);
            }
            if (jsonNodeInfo.has("childAssocs")) {
                jsonParentAssocs = jsonNodeInfo.getJSONArray("childAssocs");
                assocs = new ArrayList(jsonParentAssocs.length());
                for (int j3 = 0; j3 < jsonParentAssocs.length(); ++j3) {
                    childAssocRefStr = jsonParentAssocs.getString(j3);
                    childAssociationRef = new ChildAssociationRef(childAssocRefStr);
                    assocs.add(childAssociationRef);
                }
                metaData.setChildAssocs(assocs);
            }
            if (jsonNodeInfo.has("childIds")) {
                JSONArray jsonChildIds = jsonNodeInfo.getJSONArray("childIds");
                ArrayList<Long> childIds = new ArrayList<Long>(jsonChildIds.length());
                for (int j4 = 0; j4 < jsonChildIds.length(); ++j4) {
                    Long childId = jsonChildIds.getLong(j4);
                    childIds.add(childId);
                }
                metaData.setChildIds(childIds);
            }
            if (jsonNodeInfo.has("owner")) {
                metaData.setOwner(jsonNodeInfo.getString("owner"));
            }
            nodes.add(metaData);
        }
        return nodes;
    }

    public GetTextContentResponse getTextContent(Long nodeId, QName propertyQName, Long modifiedSince) throws AuthenticationException, IOException {
        StringBuilder url = new StringBuilder(GET_CONTENT);
        StringBuilder args = new StringBuilder();
        if (nodeId == null) {
            throw new NullPointerException();
        }
        args.append("?");
        args.append("nodeId");
        args.append("=");
        args.append(nodeId);
        if (propertyQName != null) {
            if (args.length() == 0) {
                args.append("?");
            } else {
                args.append("&");
            }
            args.append("propertyQName");
            args.append("=");
            URLCodec encoder = new URLCodec();
            args.append(encoder.encode(propertyQName.toString(), "UTF-8"));
        }
        url.append((CharSequence)args);
        GetRequest req = new GetRequest(url.toString());
        HashMap<String, String> headers = new HashMap<String, String>(2);
        if (modifiedSince != null) {
            headers.put("If-Modified-Since", String.valueOf(DateUtil.formatDate((Date)new Date(modifiedSince))));
        }
        req.setHeaders(headers);
        Response response = this.repositoryHttpClient.sendRequest((Request)req);
        if (response.getStatus() != 304 && response.getStatus() != 204 && response.getStatus() != 200) {
            throw new AlfrescoRuntimeException("GetTextContentResponse return status is " + response.getStatus());
        }
        return new GetTextContentResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlfrescoModel getModel(QName modelName) throws AuthenticationException, IOException, JSONException {
        StringBuilder url = new StringBuilder(GET_MODEL);
        URLCodec encoder = new URLCodec();
        url.append("?modelQName=").append(encoder.encode(modelName.toString(), "UTF-8"));
        GetRequest req = new GetRequest(url.toString());
        Response response = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("GetModel return status is " + response.getStatus());
            }
            AlfrescoModel alfrescoModel = new AlfrescoModel(M2Model.createModel((InputStream)response.getContentAsStream()), Long.valueOf(response.getHeader(CHECKSUM_HEADER)));
            return alfrescoModel;
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlfrescoModelDiff> getModelsDiff(List<AlfrescoModel> currentModels) throws AuthenticationException, IOException, JSONException {
        JSONArray jsonDiffs;
        StringBuilder url = new StringBuilder(GET_MODELS_DIFF);
        JSONObject body = new JSONObject();
        JSONArray jsonModels = new JSONArray();
        for (AlfrescoModel model : currentModels) {
            JSONObject jsonModel = new JSONObject();
            QName modelQName = QName.createQName((String)model.getModel().getName(), (NamespacePrefixResolver)this.namespaceDAO);
            jsonModel.put("name", (Object)modelQName.toString());
            jsonModel.put("checksum", (Object)model.getChecksum());
            jsonModels.put((Object)jsonModel);
        }
        body.put("models", (Object)jsonModels);
        PostRequest req = new PostRequest(url.toString(), body.toString(), "application/json");
        Response response = null;
        JSONObject json = null;
        try {
            response = this.repositoryHttpClient.sendRequest((Request)req);
            if (response.getStatus() != 200) {
                throw new AlfrescoRuntimeException("GetModelsDiff return status is " + response.getStatus());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContentAsStream(), "UTF-8"));
            json = new JSONObject(new JSONTokener((Reader)reader));
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(json.toString());
        }
        if ((jsonDiffs = json.getJSONArray("diffs")) == null) {
            throw new AlfrescoRuntimeException("GetModelsDiff badly formatted response");
        }
        ArrayList<AlfrescoModelDiff> diffs = new ArrayList<AlfrescoModelDiff>(jsonDiffs.length());
        for (int i = 0; i < jsonDiffs.length(); ++i) {
            JSONObject jsonDiff = jsonDiffs.getJSONObject(i);
            diffs.add(new AlfrescoModelDiff(QName.createQName((String)jsonDiff.getString("name")), AlfrescoModelDiff.TYPE.valueOf(jsonDiff.getString("type")), jsonDiff.isNull("oldChecksum") ? null : Long.valueOf(jsonDiff.getLong("oldChecksum")), jsonDiff.isNull("newChecksum") ? null : Long.valueOf(jsonDiff.getLong("newChecksum"))));
        }
        return diffs;
    }

    public void close() {
        this.repositoryHttpClient.close();
    }

    public static class GetTextContentResponse
    extends SOLRResponse {
        private InputStream content;
        private SolrApiContentStatus status;
        private String transformException;
        private String transformStatusStr;
        private Long transformDuration;

        public GetTextContentResponse(Response response) throws IOException {
            super(response);
            this.content = response.getContentAsStream();
            this.transformStatusStr = response.getHeader("X-Alfresco-transformStatus");
            this.transformException = response.getHeader("X-Alfresco-transformException");
            String tmp = response.getHeader("X-Alfresco-transformDuration");
            this.transformDuration = tmp != null ? Long.valueOf(tmp) : null;
            this.setStatus();
        }

        public InputStream getContent() {
            return this.content;
        }

        public SolrApiContentStatus getStatus() {
            return this.status;
        }

        private void setStatus() {
            int status = this.response.getStatus();
            if (status == 304) {
                this.status = SolrApiContentStatus.NOT_MODIFIED;
            } else if (status == 500) {
                this.status = SolrApiContentStatus.GENERAL_FAILURE;
            } else if (status == 200) {
                this.status = SolrApiContentStatus.OK;
            } else if (status == 204) {
                this.status = this.transformStatusStr == null ? SolrApiContentStatus.UNKNOWN : (this.transformStatusStr.equals("noTransform") ? SolrApiContentStatus.NO_TRANSFORM : (this.transformStatusStr.equals("transformFailed") ? SolrApiContentStatus.TRANSFORM_FAILED : SolrApiContentStatus.UNKNOWN));
            }
        }

        public String getTransformException() {
            return this.transformException;
        }

        public void release() {
            this.response.release();
        }

        public Long getTransformDuration() {
            return this.transformDuration;
        }
    }

    public static enum SolrApiContentStatus {
        NOT_MODIFIED,
        OK,
        NO_TRANSFORM,
        NO_CONTENT,
        UNKNOWN,
        TRANSFORM_FAILED,
        GENERAL_FAILURE;


        public static SolrApiContentStatus getStatus(String statusStr) {
            if (statusStr.equals("ok")) {
                return OK;
            }
            if (statusStr.equals("transformFailed")) {
                return TRANSFORM_FAILED;
            }
            if (statusStr.equals("noTransform")) {
                return NO_TRANSFORM;
            }
            if (statusStr.equals("noContent")) {
                return NO_CONTENT;
            }
            return UNKNOWN;
        }
    }

    public static class GetNodesMetaDataResponse
    extends SOLRResponse {
        private List<NodeMetaData> nodes;

        public GetNodesMetaDataResponse(Response response, List<NodeMetaData> nodes) {
            super(response);
            this.nodes = nodes;
        }

        public List<NodeMetaData> getNodes() {
            return this.nodes;
        }
    }

    public static class GetNodesResponse
    extends SOLRResponse {
        private List<Node> nodes;

        public GetNodesResponse(Response response, List<Node> nodes) {
            super(response);
            this.nodes = nodes;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }
    }

    public static class GetTransactionsResponse
    extends SOLRResponse {
        private List<Transaction> txns;

        public GetTransactionsResponse(Response response, List<Transaction> txns) {
            super(response);
            this.txns = txns;
        }

        public List<Transaction> getTransaction() {
            return this.txns;
        }
    }

    private static class SOLRResponse {
        protected Response response;

        public SOLRResponse(Response response) {
            this.response = response;
        }

        public Response getResponse() {
            return this.response;
        }
    }

    private class SOLRDeserializer {
        private SOLRTypeConverter typeConverter;

        public SOLRDeserializer(NamespaceDAO namespaceDAO) {
            this.typeConverter = new SOLRTypeConverter(namespaceDAO);
        }

        public <T> T deserializeValue(Class<T> targetClass, Object value) throws JSONException {
            return this.typeConverter.convert(targetClass, value);
        }
    }

    private class SOLRTypeConverter {
        private TypeConverter instance = new TypeConverter();
        private NamespaceDAO namespaceDAO;

        SOLRTypeConverter(NamespaceDAO namespaceDAO) {
            this.namespaceDAO = namespaceDAO;
            Map converters = DefaultTypeConverter.INSTANCE.getConverters();
            for (Class source : converters.keySet()) {
                Map converters1 = (Map)converters.get(source);
                for (Class dest : converters1.keySet()) {
                    TypeConverter.Converter converter = (TypeConverter.Converter)converters1.get(dest);
                    this.instance.addConverter(source, dest, converter);
                }
            }
            this.instance.addConverter(String.class, Date.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Date>(){

                public Date convert(String source) {
                    try {
                        Date date = ISO8601DateFormat.parse((String)source);
                        return date;
                    }
                    catch (Exception e) {
                        throw new TypeConversionException("Failed to convert date " + source + " to string", (Throwable)e);
                    }
                }
            });
            this.instance.addConverter(String.class, NodeRef.class, (TypeConverter.Converter)new TypeConverter.Converter<String, NodeRef>(){

                public NodeRef convert(String source) {
                    return new NodeRef(source);
                }
            });
            this.instance.addConverter(String.class, Path.AttributeElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.AttributeElement>(){

                public Path.AttributeElement convert(String source) {
                    return new Path.AttributeElement(source);
                }
            });
            this.instance.addConverter(String.class, Path.ChildAssocElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.ChildAssocElement>(){

                public Path.ChildAssocElement convert(String source) {
                    return new Path.ChildAssocElement((ChildAssociationRef)SOLRTypeConverter.this.instance.convert(ChildAssociationRef.class, (Object)source));
                }
            });
            this.instance.addConverter(String.class, Path.DescendentOrSelfElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.DescendentOrSelfElement>(){

                public Path.DescendentOrSelfElement convert(String source) {
                    return new Path.DescendentOrSelfElement();
                }
            });
            this.instance.addConverter(String.class, Path.ParentElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.ParentElement>(){

                public Path.ParentElement convert(String source) {
                    return new Path.ParentElement();
                }
            });
            this.instance.addConverter(String.class, Path.SelfElement.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path.SelfElement>(){

                public Path.SelfElement convert(String source) {
                    return new Path.SelfElement();
                }
            });
            this.instance.addConverter(String.class, ChildAssociationRef.class, (TypeConverter.Converter)new TypeConverter.Converter<String, ChildAssociationRef>(){

                public ChildAssociationRef convert(String source) {
                    return new ChildAssociationRef(source);
                }
            });
            this.instance.addConverter(String.class, AssociationRef.class, (TypeConverter.Converter)new TypeConverter.Converter<String, AssociationRef>(){

                public AssociationRef convert(String source) {
                    return new AssociationRef(source);
                }
            });
            this.instance.addConverter(String.class, QName.class, (TypeConverter.Converter)new TypeConverter.Converter<String, QName>(){

                public QName convert(String source) {
                    return QName.createQName((String)source, (NamespacePrefixResolver)SOLRTypeConverter.this.namespaceDAO);
                }
            });
            this.instance.addConverter(String.class, MLText.class, (TypeConverter.Converter)new TypeConverter.Converter<String, MLText>(){

                public MLText convert(String source) {
                    return new MLText(source);
                }
            });
        }

        public final <T> T convert(Class<T> c, Object value) {
            return (T)this.instance.convert(c, value);
        }
    }
}

