/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.ResizeableArrayList;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingOwnerScorer
extends AbstractSolrCachingScorer {
    SolrCachingOwnerScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingOwnerScorer createOwnerScorer(SolrIndexSearcher searcher, Similarity similarity, String authority, SolrIndexReader reader) throws IOException {
        BitDocSet authorityOwnedDocs;
        block4: {
            HashMap ownerLookUp;
            block3: {
                authorityOwnedDocs = new BitDocSet(new OpenBitSet((long)searcher.getReader().maxDoc()));
                ownerLookUp = (HashMap)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_OWNER_LOOKUP);
                if (!authority.contains("\\|")) break block3;
                for (String current : authority.split("|")) {
                    AlfrescoSolrEventListener.OwnerLookUp lookUp = (AlfrescoSolrEventListener.OwnerLookUp)ownerLookUp.get(current);
                    if (lookUp == null) continue;
                    ResizeableArrayList indexedOderedByOwnerIdThenDoc = (ResizeableArrayList)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF);
                    for (int i = lookUp.getStart(); i < lookUp.getEnd(); ++i) {
                        authorityOwnedDocs.addUnique(((AlfrescoSolrEventListener.CacheEntry)indexedOderedByOwnerIdThenDoc.get(i)).getLeaf());
                    }
                }
                break block4;
            }
            AlfrescoSolrEventListener.OwnerLookUp lookUp = (AlfrescoSolrEventListener.OwnerLookUp)ownerLookUp.get(authority);
            if (lookUp == null) break block4;
            ResizeableArrayList indexedOderedByOwnerIdThenDoc = (ResizeableArrayList)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF);
            for (int i = lookUp.getStart(); i < lookUp.getEnd(); ++i) {
                authorityOwnedDocs.addUnique(((AlfrescoSolrEventListener.CacheEntry)indexedOderedByOwnerIdThenDoc.get(i)).getLeaf());
            }
        }
        return new SolrCachingOwnerScorer(similarity, (DocSet)authorityOwnedDocs, reader);
    }
}

