/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.ResizeableArrayList;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingReaderScorer
extends AbstractSolrCachingScorer {
    SolrCachingReaderScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingReaderScorer createReaderScorer(SolrIndexSearcher searcher, Similarity similarity, String authority, SolrIndexReader reader) throws IOException {
        DocSet aclDocSet;
        long[] aclByDocId = (long[])searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ACL_ID_BY_DOC_ID);
        HashMap lookups = (HashMap)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ACL_LOOKUP);
        ResizeableArrayList aclThenLeafOrderedEntries = (ResizeableArrayList)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_ACL_ID_THEN_LEAF);
        if (authority.contains("|")) {
            BooleanQuery bQuery = new BooleanQuery();
            for (String current : authority.split("\\|")) {
                bQuery.add((Query)new TermQuery(new Term("READER", current)), BooleanClause.Occur.SHOULD);
            }
            aclDocSet = searcher.getDocSet((Query)bQuery);
        } else {
            aclDocSet = searcher.getDocSet((Query)new TermQuery(new Term("READER", authority)));
        }
        BitDocSet readableDocSet = new BitDocSet(new OpenBitSet((long)searcher.getReader().maxDoc()));
        AlfrescoSolrEventListener.AclLookUp key = new AlfrescoSolrEventListener.AclLookUp(0L);
        if (aclDocSet instanceof BitDocSet) {
            BitDocSet source = (BitDocSet)aclDocSet;
            OpenBitSet openBitSet = source.getBits();
            int current = -1;
            while ((current = openBitSet.nextSetBit(current + 1)) != -1) {
                long acl = aclByDocId[current];
                key.setAclid(acl);
                AlfrescoSolrEventListener.AclLookUp value = (AlfrescoSolrEventListener.AclLookUp)lookups.get(key);
                if (value == null) continue;
                for (int i = value.getStart(); i < value.getEnd(); ++i) {
                    readableDocSet.add(((AlfrescoSolrEventListener.CacheEntry)aclThenLeafOrderedEntries.get(i)).getLeaf());
                }
            }
        } else {
            DocIterator it = aclDocSet.iterator();
            while (it.hasNext()) {
                int doc = it.nextDoc();
                long acl = aclByDocId[doc];
                key.setAclid(acl);
                AlfrescoSolrEventListener.AclLookUp value = (AlfrescoSolrEventListener.AclLookUp)lookups.get(key);
                if (value == null) continue;
                for (int i = value.getStart(); i < value.getEnd(); ++i) {
                    readableDocSet.add(((AlfrescoSolrEventListener.CacheEntry)aclThenLeafOrderedEntries.get(i)).getLeaf());
                }
            }
        }
        return new SolrCachingReaderScorer(similarity, (DocSet)readableDocSet, reader);
    }
}

