/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.SolrOwnerSetScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrOwnerSetQuery
extends Query {
    String authorities;

    public SolrOwnerSetQuery(String authorities) {
        this.authorities = authorities;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrOwnerSetQueryWeight((SolrIndexSearcher)searcher);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OWNERSET:");
        stringBuilder.append(this.authorities);
        return stringBuilder.toString();
    }

    public String toString(String field) {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.authorities == null ? 0 : this.authorities.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SolrOwnerSetQuery other = (SolrOwnerSetQuery)((Object)obj);
        return !(this.authorities == null ? other.authorities != null : !this.authorities.equals(other.authorities));
    }

    private class SolrOwnerSetQueryWeight
    extends Weight {
        SolrIndexSearcher searcher;
        private Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public SolrOwnerSetQueryWeight(SolrIndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            this.similarity = SolrOwnerSetQuery.this.getSimilarity((Searcher)searcher);
            this.idfExp = this.similarity.idfExplain(new Term("OWNERSET", SolrOwnerSetQuery.this.authorities), (Searcher)searcher);
            this.idf = this.idfExp.getIdf();
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Query getQuery() {
            return SolrOwnerSetQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = this.idf * SolrOwnerSetQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (!(reader instanceof SolrIndexReader)) {
                throw new IllegalStateException("Must have a SolrIndexReader");
            }
            return SolrOwnerSetScorer.createOwnerSetScorer(this.searcher, SolrOwnerSetQuery.this.getSimilarity((Searcher)this.searcher), SolrOwnerSetQuery.this.authorities, (SolrIndexReader)reader);
        }
    }
}

