/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.ssl.SSLEncryptionParameters;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.search.impl.lucene.MultiReader;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.ResizeableArrayList;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.AlfrescoModelDiff;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.SolrKeyResourceLoader;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.solr.tracker.CoreTrackerJob;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.TrackerStats;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.util.RefCounted;
import org.json.JSONException;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

public class CoreTracker
implements CloseHook {
    protected static final Logger log = LoggerFactory.getLogger(CoreTracker.class);
    private AlfrescoCoreAdminHandler adminHandler;
    protected SOLRAPIClient client;
    protected TrackerState state = new TrackerState();
    SolrCore core;
    private String alfrescoHost;
    private int alfrescoPort;
    private int alfrescoPortSSL;
    private String baseUrl;
    private String cron;
    protected StoreRef storeRef;
    private long lag;
    private long holeRetention;
    protected long batchCount;
    private String secureCommsType;
    private String keyStoreType;
    private String keyStoreProvider;
    private String passwordFileLocation;
    private String keyStoreLocation;
    private String sslKeyStoreType;
    private String sslKeyStoreProvider;
    private String sslKeyStoreLocation;
    private String sslKeyStorePasswordFileLocation;
    private String sslTrustStoreType;
    private String sslTrustStoreProvider;
    private String sslTrustStoreLocation;
    private String sslTrustStorePasswordFileLocation;
    private int maxTotalConnections = 40;
    private int maxHostConnections = 40;
    private int socketTimeout = 120000;
    private String id;
    private AlfrescoSolrDataModel dataModel;
    private ConcurrentLinkedQueue<Long> transactionsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> transactionsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> transactionsToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> nodesToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> nodesToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> nodesToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToPurge = new ConcurrentLinkedQueue();
    protected TrackerStats trackerStats = new TrackerStats();
    private boolean runPostModelLoadInit = true;
    private HashSet<StoreRef> indexedStores = new HashSet();
    private HashSet<String> indexedTenants = new HashSet();
    private HashSet<QName> indexedDataTypes = new HashSet();
    private HashSet<QName> indexedTypes = new HashSet();
    private HashSet<QName> indexedAspects = new HashSet();
    private HashSet<String> indexedFields = new HashSet();
    private HashSet<StoreRef> ignoredStores = new HashSet();
    private HashSet<String> ignoredTenants = new HashSet();
    private HashSet<QName> ignoredDataTypes = new HashSet();
    private HashSet<QName> ignoredTypes = new HashSet();
    private HashSet<QName> ignoredAspects = new HashSet();
    private HashSet<String> ignoredFields = new HashSet();
    private boolean transformContent = true;
    private int maxLiveSearchers;
    private volatile boolean shutdown = false;
    private int filterCacheSize;
    private int authorityCacheSize;
    private int pathCacheSize;

    public long getLastIndexedTxCommitTime() {
        return this.state.lastIndexedTxCommitTime;
    }

    public long getLastIndexedChangeSetCommitTime() {
        return this.state.lastIndexedChangeSetCommitTime;
    }

    public long getLastIndexedTxId() {
        return this.state.lastIndexedTxId;
    }

    public long getLastIndexedChangeSetId() {
        return this.state.lastIndexedChangeSetId;
    }

    public boolean isRunning() {
        return this.state.running;
    }

    public long getLastTxCommitTimeOnServer() {
        return this.state.lastTxCommitTimeOnServer;
    }

    public long getLastChangeSetCommitTimeOnServer() {
        return this.state.lastChangeSetCommitTimeOnServer;
    }

    public long getLastTxIdOnServer() {
        return this.state.lastTxIdOnServer;
    }

    public long getLastChangeSetIdOnServer() {
        return this.state.lastChangeSetIdOnServer;
    }

    public TrackerStats getTrackerStats() {
        return this.trackerStats;
    }

    public Map<String, Set<String>> getModelErrors() {
        return this.dataModel.getModelErrors();
    }

    public int getMaxLiveSearchers() {
        return this.maxLiveSearchers;
    }

    CoreTracker(AlfrescoCoreAdminHandler adminHandler, SolrCore core) {
        this.adminHandler = adminHandler;
        this.core = core;
        boolean storeAll = false;
        SolrResourceLoader loader = core.getSchema().getResourceLoader();
        this.id = loader.getInstanceDir();
        this.dataModel = AlfrescoSolrDataModel.getInstance(this.id);
        this.dataModel.setStoreAll(storeAll);
        Properties p = core.getResourceLoader().getCoreProperties();
        this.alfrescoHost = p.getProperty("alfresco.host", "localhost");
        this.alfrescoPort = Integer.parseInt(p.getProperty("alfresco.port", "8080"));
        this.alfrescoPortSSL = Integer.parseInt(p.getProperty("alfresco.port.ssl", "8443"));
        this.baseUrl = p.getProperty("alfresco.baseUrl", "/alfresco");
        this.cron = p.getProperty("alfresco.cron", "0/15 * * * * ? *");
        this.storeRef = new StoreRef(p.getProperty("alfresco.stores"));
        this.lag = Integer.parseInt(p.getProperty("alfresco.lag", "1000"));
        this.holeRetention = Integer.parseInt(p.getProperty("alfresco.hole.retention", "3600000"));
        this.batchCount = Integer.parseInt(p.getProperty("alfresco.batch.count", "1000"));
        storeAll = Boolean.parseBoolean(p.getProperty("alfresco.storeAll", "false"));
        this.keyStoreType = p.getProperty("alfresco.encryption.keystore.type", "JCEKS");
        this.keyStoreProvider = p.getProperty("alfresco.encryption.keystore.provider");
        this.passwordFileLocation = p.getProperty("alfresco.encryption.keystore.passwordFileLocation");
        this.keyStoreLocation = p.getProperty("alfresco.encryption.keystore.location");
        this.sslKeyStoreType = p.getProperty("alfresco.encryption.ssl.keystore.type");
        this.sslKeyStoreProvider = p.getProperty("alfresco.encryption.ssl.keystore.provider", "");
        this.sslKeyStoreLocation = p.getProperty("alfresco.encryption.ssl.keystore.location", "ssl.repo.client.keystore");
        this.sslKeyStorePasswordFileLocation = p.getProperty("alfresco.encryption.ssl.keystore.passwordFileLocation", "ssl-keystore-passwords.properties");
        this.sslTrustStoreType = p.getProperty("alfresco.encryption.ssl.truststore.type", "JCEKS");
        this.sslTrustStoreProvider = p.getProperty("alfresco.encryption.ssl.truststore.provider", "");
        this.sslTrustStoreLocation = p.getProperty("alfresco.encryption.ssl.truststore.location", "ssl.repo.client.truststore");
        this.sslTrustStorePasswordFileLocation = p.getProperty("alfresco.encryption.ssl.truststore.passwordFileLocation", "ssl-truststore-passwords.properties");
        this.secureCommsType = p.getProperty("alfresco.secureComms", "https");
        this.maxTotalConnections = Integer.parseInt(p.getProperty("alfresco.maxTotalConnections", "40"));
        this.maxHostConnections = Integer.parseInt(p.getProperty("alfresco.maxHostConnections", "40"));
        this.transformContent = Boolean.parseBoolean(p.getProperty("alfresco.index.transformContent", "true"));
        this.socketTimeout = Integer.parseInt(p.getProperty("alfresco.socketTimeout", "0"));
        this.maxLiveSearchers = Integer.parseInt(p.getProperty("alfresco.maxLiveSearchers", "2"));
        this.filterCacheSize = Integer.parseInt(p.getProperty("solr.filterCache.size", "64"));
        this.authorityCacheSize = Integer.parseInt(p.getProperty("solr.authorityCache.size", "64"));
        this.pathCacheSize = Integer.parseInt(p.getProperty("solr.pathCache.size", "64"));
        this.client = new SOLRAPIClient(this.getRepoClient(loader), (DictionaryService)this.dataModel.getDictionaryService("DEFAULT_DICTIONARY"), this.dataModel.getNamespaceDAO());
        JobDetail job = new JobDetail("CoreTracker-" + core.getName(), "Solr", CoreTrackerJob.class);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"TRACKER", (Object)this);
        job.setJobDataMap(jobDataMap);
        try {
            CronTrigger trigger = new CronTrigger("CoreTrackerTrigger" + core.getName(), "Solr", this.cron);
            adminHandler.getScheduler().scheduleJob(job, (Trigger)trigger);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        core.addCloseHook((CloseHook)this);
    }

    protected AlfrescoHttpClient getRepoClient(SolrResourceLoader loader) {
        KeyStoreParameters keyStoreParameters = new KeyStoreParameters("SSL Key Store", this.sslKeyStoreType, this.sslKeyStoreProvider, this.sslKeyStorePasswordFileLocation, this.sslKeyStoreLocation);
        KeyStoreParameters trustStoreParameters = new KeyStoreParameters("SSL Trust Store", this.sslTrustStoreType, this.sslTrustStoreProvider, this.sslTrustStorePasswordFileLocation, this.sslTrustStoreLocation);
        SSLEncryptionParameters sslEncryptionParameters = new SSLEncryptionParameters(keyStoreParameters, trustStoreParameters);
        SolrKeyResourceLoader keyResourceLoader = new SolrKeyResourceLoader(loader);
        HttpClientFactory httpClientFactory = new HttpClientFactory(HttpClientFactory.SecureCommsType.getType((String)this.secureCommsType), sslEncryptionParameters, (KeyResourceLoader)keyResourceLoader, null, null, this.alfrescoHost, this.alfrescoPort, this.alfrescoPortSSL, this.maxTotalConnections, this.maxHostConnections, this.socketTimeout);
        AlfrescoHttpClient repoClient = httpClientFactory.getRepoClient(this.alfrescoHost, this.alfrescoPortSSL);
        repoClient.setBaseUrl(this.baseUrl);
        return repoClient;
    }

    public boolean isCheck() {
        return this.state.check;
    }

    public void setCheck(boolean check) {
        this.state.check = check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex() {
        CoreTracker coreTracker = this;
        synchronized (coreTracker) {
            if (this.state.running) {
                log.info("... update for " + this.core.getName() + " is already running");
                return;
            }
            log.info("... updating " + this.core.getName());
            this.state.running = true;
        }
        try {
            this.purgeAclChangeSets();
            this.purgeAcls();
            this.purgeTransactions();
            this.purgeNodes();
            this.reindexAclChangeSets();
            this.reindexAcls();
            this.reindexTransactions();
            this.reindexNodes();
            this.indexAclChangeSets();
            this.indexAcls();
            this.indexTransactions();
            this.indexNodes();
            this.trackRepository();
        }
        catch (IndexTrackingShutdownException t) {
            try {
                this.core.getUpdateHandler().rollback(new RollbackUpdateCommand());
            }
            catch (IOException e) {
                log.error("Failed to roll back pending work on error", (Throwable)t);
            }
            log.info("Stopping index tracking for " + this.core.getName());
        }
        catch (Throwable t) {
            try {
                this.core.getUpdateHandler().rollback(new RollbackUpdateCommand());
            }
            catch (IOException e) {
                log.error("Failed to roll back pending work on error", t);
            }
            if (t instanceof SocketTimeoutException) {
                if (log.isDebugEnabled()) {
                    log.warn("Tracking communication timed out.", t);
                } else {
                    log.warn("Tracking communication timed out.");
                }
            } else {
                log.error("Tracking failed", t);
            }
        }
        finally {
            this.state.running = false;
            this.state.check = false;
        }
    }

    public void indexAclChangeSets() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclChangeSetsToIndex.peek() != null) {
            AclChangeSets aclChangeSets;
            Long aclChangeSetId = this.aclChangeSetsToIndex.poll();
            if (aclChangeSetId != null && (aclChangeSets = this.client.getAclChangeSets(null, aclChangeSetId, null, aclChangeSetId + 1L, 1)).getAclChangeSets().size() > 0 && aclChangeSetId.equals(aclChangeSets.getAclChangeSets().get(0).getId())) {
                AclChangeSet changeSet = aclChangeSets.getAclChangeSets().get(0);
                List<Acl> acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                for (Acl acl : acls) {
                    List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                    this.indexAcl(readers, false);
                }
                this.indexAclTransaction(changeSet, false);
                requiresCommit = true;
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    public void indexAcls() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclsToIndex.peek() != null) {
            Long aclId = this.aclsToIndex.poll();
            if (aclId != null) {
                Acl acl = new Acl(0L, aclId);
                List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                this.indexAcl(readers, false);
                requiresCommit = true;
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexAclChangeSets() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclChangeSetsToReindex.peek() != null) {
                Long aclChangeSetId = this.aclChangeSetsToReindex.poll();
                if (aclChangeSetId != null) {
                    this.deleteByAclChangeSetId(solrIndexSearcher, aclChangeSetId);
                    AclChangeSets aclChangeSets = this.client.getAclChangeSets(null, aclChangeSetId, null, aclChangeSetId + 1L, 1);
                    if (aclChangeSets.getAclChangeSets().size() > 0 && aclChangeSetId.equals(aclChangeSets.getAclChangeSets().get(0).getId())) {
                        AclChangeSet changeSet = aclChangeSets.getAclChangeSets().get(0);
                        List<Acl> acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                        for (Acl acl : acls) {
                            List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                            this.indexAcl(readers, true);
                        }
                        this.indexAclTransaction(changeSet, true);
                        requiresCommit = true;
                    }
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexAcls() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclsToReindex.peek() != null) {
                Long aclId = this.aclsToReindex.poll();
                if (aclId != null) {
                    this.deleteByAclId(solrIndexSearcher, aclId);
                    Acl acl = new Acl(0L, aclId);
                    List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                    this.indexAcl(readers, true);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAclChangeSets() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclChangeSetsToPurge.peek() != null) {
                Long aclChangeSetId = this.aclChangeSetsToPurge.poll();
                if (aclChangeSetId != null) {
                    this.deleteByAclChangeSetId(solrIndexSearcher, aclChangeSetId);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    protected void checkShutdown() {
        if (this.shutdown) {
            throw new IndexTrackingShutdownException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAcls() throws AuthenticationException, IOException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.aclsToPurge.peek() != null) {
                Long aclId = this.aclsToPurge.poll();
                if (aclId != null) {
                    this.deleteByAclId(solrIndexSearcher, aclId);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    public void deleteByAclChangeSetId(SolrIndexSearcher solrIndexSearcher, Long aclChangeSetId) throws IOException {
        TermQuery query = new TermQuery(new Term("INACLTXID", NumericEncoder.encode((long)aclChangeSetId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    public void deleteByAclId(SolrIndexSearcher solrIndexSearcher, Long aclId) throws IOException {
        TermQuery query = new TermQuery(new Term("ACLID", NumericEncoder.encode((long)aclId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    private void deleteByQuery(SolrIndexSearcher solrIndexSearcher, Query query) throws IOException {
        HashSet<String> idsToDelete = new HashSet<String>();
        DocSet docSet = solrIndexSearcher.getDocSet(query);
        if (docSet instanceof BitDocSet) {
            BitDocSet source = (BitDocSet)docSet;
            OpenBitSet openBitSet = source.getBits();
            int current = -1;
            while ((current = openBitSet.nextSetBit(current + 1)) != -1) {
                Document doc = solrIndexSearcher.doc(current, Collections.singleton("ID"));
                Fieldable fieldable = doc.getFieldable("ID");
                if (fieldable == null) continue;
                idsToDelete.add(fieldable.stringValue());
            }
        } else {
            DocIterator it = docSet.iterator();
            while (it.hasNext()) {
                Document doc = solrIndexSearcher.doc(it.nextDoc(), Collections.singleton("ID"));
                Fieldable fieldable = doc.getFieldable("ID");
                if (fieldable == null) continue;
                idsToDelete.add(fieldable.stringValue());
            }
        }
        for (String idToDelete : idsToDelete) {
            DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
            docCmd.id = idToDelete;
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
        }
    }

    public void addTransactionToReindex(Long transactionToReindex) {
        this.transactionsToReindex.offer(transactionToReindex);
    }

    public void addTransactionToIndex(Long transactionToIndex) {
        this.transactionsToIndex.offer(transactionToIndex);
    }

    public void addTransactionToPurge(Long transactionToPurge) {
        this.transactionsToPurge.offer(transactionToPurge);
    }

    public void addNodeToReindex(Long nodeToReindex) {
        this.nodesToReindex.offer(nodeToReindex);
    }

    public void addNodeToIndex(Long nodeToIndex) {
        this.nodesToIndex.offer(nodeToIndex);
    }

    public void addNodeToPurge(Long nodeToPurge) {
        this.nodesToPurge.offer(nodeToPurge);
    }

    public void addAclChangeSetToReindex(Long aclChangeSetToReindex) {
        this.aclChangeSetsToReindex.offer(aclChangeSetToReindex);
    }

    public void addAclChangeSetToIndex(Long aclChangeSetToIndex) {
        this.aclChangeSetsToIndex.offer(aclChangeSetToIndex);
    }

    public void addAclChangeSetToPurge(Long aclChangeSetToPurge) {
        this.aclChangeSetsToPurge.offer(aclChangeSetToPurge);
    }

    public void addAclToReindex(Long aclToReindex) {
        this.aclsToReindex.offer(aclToReindex);
    }

    public void addAclToIndex(Long aclToIndex) {
        this.aclsToIndex.offer(aclToIndex);
    }

    public void addAclToPurge(Long aclToPurge) {
        this.aclsToPurge.offer(aclToPurge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexTransactions() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            int docCount = 0;
            boolean requiresCommit = false;
            while (this.transactionsToReindex.peek() != null) {
                Long transactionId = this.transactionsToReindex.poll();
                if (transactionId != null) {
                    this.deleteByTransactionId(solrIndexSearcher, transactionId);
                    Transactions transactions = this.client.getTransactions(null, transactionId, null, transactionId + 1L, 1);
                    if (transactions.getTransactions().size() > 0 && transactionId.equals(transactions.getTransactions().get(0).getId())) {
                        Transaction info = transactions.getTransactions().get(0);
                        GetNodesParameters gnp = new GetNodesParameters();
                        ArrayList<Long> txs = new ArrayList<Long>();
                        txs.add(info.getId());
                        gnp.setTransactionIds(txs);
                        gnp.setStoreProtocol(this.storeRef.getProtocol());
                        gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                        List<Node> nodes = this.client.getNodes(gnp, (int)info.getUpdates());
                        for (Node node : nodes) {
                            ++docCount;
                            if (log.isDebugEnabled()) {
                                log.debug(node.toString());
                            }
                            this.indexNode(node, solrIndexSearcher, true);
                            this.checkShutdown();
                        }
                        this.indexTransaction(info, true);
                        requiresCommit = true;
                    }
                }
                if ((long)docCount <= this.batchCount || this.getRegisteredSearcherCount() >= this.getMaxLiveSearchers()) continue;
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                docCount = 0;
                requiresCommit = false;
            }
            if (requiresCommit || docCount > 0) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexNodes() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.nodesToReindex.peek() != null) {
                Long nodeId = this.nodesToReindex.poll();
                if (nodeId != null) {
                    this.deleteByNodeId(solrIndexSearcher, nodeId);
                    Node node = new Node();
                    node.setId(nodeId);
                    node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                    node.setTxnId(Long.MAX_VALUE);
                    this.indexNode(node, solrIndexSearcher, true);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNodes() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.nodesToIndex.peek() != null) {
                Long nodeId = this.nodesToIndex.poll();
                if (nodeId != null) {
                    Node node = new Node();
                    node.setId(nodeId);
                    node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                    node.setTxnId(Long.MAX_VALUE);
                    this.indexNode(node, solrIndexSearcher, false);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexTransactions() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            int docCount = 0;
            boolean requiresCommit = false;
            while (this.transactionsToIndex.peek() != null) {
                Transactions transactions;
                Long transactionId = this.transactionsToIndex.poll();
                if (transactionId != null && (transactions = this.client.getTransactions(null, transactionId, null, transactionId + 1L, 1)).getTransactions().size() > 0 && transactionId.equals(transactions.getTransactions().get(0).getId())) {
                    Transaction info = transactions.getTransactions().get(0);
                    GetNodesParameters gnp = new GetNodesParameters();
                    ArrayList<Long> txs = new ArrayList<Long>();
                    txs.add(info.getId());
                    gnp.setTransactionIds(txs);
                    gnp.setStoreProtocol(this.storeRef.getProtocol());
                    gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                    List<Node> nodes = this.client.getNodes(gnp, (int)info.getUpdates());
                    for (Node node : nodes) {
                        ++docCount;
                        if (log.isDebugEnabled()) {
                            log.debug(node.toString());
                        }
                        this.indexNode(node, solrIndexSearcher, false);
                        this.checkShutdown();
                    }
                    this.indexTransaction(info, false);
                    requiresCommit = true;
                }
                if ((long)docCount <= this.batchCount || this.getRegisteredSearcherCount() >= this.getMaxLiveSearchers()) continue;
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                docCount = 0;
                requiresCommit = false;
            }
            if (requiresCommit || docCount > 0) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTransactions() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.transactionsToPurge.peek() != null) {
                Long transactionId = this.transactionsToPurge.poll();
                if (transactionId != null) {
                    this.deleteByTransactionId(solrIndexSearcher, transactionId);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeNodes() throws IOException, AuthenticationException, JSONException {
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            boolean requiresCommit = false;
            while (this.nodesToPurge.peek() != null) {
                Long nodeId = this.nodesToPurge.poll();
                if (nodeId != null) {
                    this.deleteByNodeId(solrIndexSearcher, nodeId);
                    requiresCommit = true;
                }
                this.checkShutdown();
            }
            if (requiresCommit) {
                this.checkShutdown();
                this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
    }

    private void deleteByTransactionId(SolrIndexSearcher solrIndexSearcher, Long transactionId) throws IOException {
        TermQuery query = new TermQuery(new Term("INTXID", NumericEncoder.encode((long)transactionId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    private void deleteByNodeId(SolrIndexSearcher solrIndexSearcher, Long nodeId) throws IOException {
        TermQuery query = new TermQuery(new Term("DBID", NumericEncoder.encode((long)nodeId)));
        this.deleteByQuery(solrIndexSearcher, (Query)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackRepository() throws IOException, AuthenticationException, JSONException {
        int registeredSearcherCount = this.getRegisteredSearcherCount();
        if (registeredSearcherCount >= this.getMaxLiveSearchers()) {
            log.info(".... skipping tracking registered searcher count = " + registeredSearcherCount);
            return;
        }
        this.checkShutdown();
        this.trackModels();
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            this.setTrackerInitialState(solrIndexSearcher);
            this.checkRepoAndIndexConsistency(solrIndexSearcher);
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
        this.checkShutdown();
        this.trackAclChangeSets();
        this.checkShutdown();
        this.trackTransactions();
        if (this.state.check) {
            AddUpdateCommand checkDocCmd = new AddUpdateCommand();
            checkDocCmd.indexedId = "CHECK_CACHE";
            this.core.getUpdateHandler().addDoc(checkDocCmd);
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackTransactions() throws AuthenticationException, IOException, JSONException {
        Transactions transactions;
        boolean indexed = false;
        boolean upToDate = false;
        ArrayList transactionsOrderedById = new ArrayList(10000);
        BoundedDeque<Transaction> txnsFound = new BoundedDeque<Transaction>(100);
        do {
            Long maxTxnId;
            int docCount = 0;
            Long fromCommitTime = this.getTxFromCommitTime(txnsFound, this.state.lastGoodTxCommitTimeInIndex);
            transactions = this.getSomeTransactions(txnsFound, fromCommitTime, 3600000L, 2000, this.state.timeToStopIndexing);
            Long maxTxnCommitTime = transactions.getMaxTxnCommitTime();
            if (maxTxnCommitTime != null) {
                this.state.lastTxCommitTimeOnServer = transactions.getMaxTxnCommitTime();
            }
            if ((maxTxnId = transactions.getMaxTxnId()) != null) {
                this.state.lastTxIdOnServer = transactions.getMaxTxnId();
            }
            log.info("Scanning transactions ...");
            if (transactions.getTransactions().size() > 0) {
                log.info(".... from " + transactions.getTransactions().get(0));
                log.info(".... to " + transactions.getTransactions().get(transactions.getTransactions().size() - 1));
            } else {
                log.info(".... non found after lastTxCommitTime " + (txnsFound.size() > 0 ? txnsFound.getLast().getCommitTimeMs() : this.state.lastIndexedTxCommitTime));
            }
            for (Transaction info : transactions.getTransactions()) {
                boolean index = false;
                String target = NumericEncoder.encode((long)info.getId());
                RefCounted refCounted = null;
                Term term = null;
                try {
                    refCounted = this.core.getSearcher(false, true, null);
                    TermEnum termEnum = ((SolrIndexSearcher)refCounted.get()).getReader().terms(new Term("TXID", target));
                    term = termEnum.term();
                    termEnum.close();
                }
                finally {
                    if (refCounted != null) {
                        refCounted.decref();
                    }
                    refCounted = null;
                }
                if (term == null) {
                    index = true;
                } else if (target.equals(term.text())) {
                    txnsFound.add(info);
                } else {
                    index = true;
                }
                if (index) {
                    if (info.getCommitTimeMs() > this.state.timeToStopIndexing) {
                        upToDate = true;
                    } else {
                        indexed = true;
                        GetNodesParameters gnp = new GetNodesParameters();
                        ArrayList<Long> txs = new ArrayList<Long>();
                        txs.add(info.getId());
                        gnp.setTransactionIds(txs);
                        gnp.setStoreProtocol(this.storeRef.getProtocol());
                        gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                        List<Node> nodes = this.client.getNodes(gnp, Integer.MAX_VALUE);
                        for (Node node : nodes) {
                            ++docCount;
                            if (log.isDebugEnabled()) {
                                log.debug(node.toString());
                            }
                            refCounted = null;
                            try {
                                refCounted = this.core.getSearcher(false, true, null);
                                this.indexNode(node, (SolrIndexSearcher)refCounted.get(), true);
                            }
                            finally {
                                if (refCounted != null) {
                                    refCounted.decref();
                                }
                                refCounted = null;
                            }
                            this.checkShutdown();
                        }
                        this.indexTransaction(info, true);
                        this.trackerStats.addTxDocs(nodes.size());
                        if (info.getCommitTimeMs() > this.state.lastIndexedTxCommitTime) {
                            this.state.lastIndexedTxCommitTime = info.getCommitTimeMs();
                            this.state.lastIndexedTxId = info.getId();
                        }
                        txnsFound.add(info);
                    }
                }
                if ((long)docCount > this.batchCount && this.getRegisteredSearcherCount() < this.getMaxLiveSearchers()) {
                    this.checkShutdown();
                    this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                    docCount = 0;
                }
                this.checkShutdown();
            }
        } while (transactions.getTransactions().size() > 0 && !upToDate);
        if (indexed) {
            this.checkShutdown();
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackAclChangeSets() throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclChangeSets;
        boolean aclIndexing = false;
        boolean aclsUpToDate = false;
        BoundedDeque<AclChangeSet> changeSetsFound = new BoundedDeque<AclChangeSet>(100);
        do {
            Long maxChangeSetId;
            Long fromCommitTime;
            Long maxChangeSetCommitTime;
            if ((maxChangeSetCommitTime = (aclChangeSets = this.getSomeAclChangeSets(changeSetsFound, fromCommitTime = this.getChangeSetFromCommitTime(changeSetsFound, this.state.lastGoodChangeSetCommitTimeInIndex), 3600000L, 2000, this.state.timeToStopIndexing)).getMaxChangeSetCommitTime()) != null) {
                this.state.lastChangeSetCommitTimeOnServer = aclChangeSets.getMaxChangeSetCommitTime();
            }
            if ((maxChangeSetId = aclChangeSets.getMaxChangeSetId()) != null) {
                this.state.lastChangeSetIdOnServer = aclChangeSets.getMaxChangeSetId();
            }
            log.info("Scanning Acl change sets ...");
            if (aclChangeSets.getAclChangeSets().size() > 0) {
                log.info(".... from " + aclChangeSets.getAclChangeSets().get(0));
                log.info(".... to " + aclChangeSets.getAclChangeSets().get(aclChangeSets.getAclChangeSets().size() - 1));
            } else {
                log.info(".... non found after lastTxCommitTime " + fromCommitTime);
            }
            for (AclChangeSet changeSet : aclChangeSets.getAclChangeSets()) {
                if (!aclIndexing) {
                    String target = NumericEncoder.encode((long)changeSet.getId());
                    RefCounted refCounted = null;
                    Term term = null;
                    try {
                        refCounted = this.core.getSearcher(false, true, null);
                        TermEnum termEnum = ((SolrIndexSearcher)refCounted.get()).getReader().terms(new Term("ACLTXID", target));
                        term = termEnum.term();
                        termEnum.close();
                    }
                    finally {
                        if (refCounted != null) {
                            refCounted.decref();
                        }
                        refCounted = null;
                    }
                    if (term == null) {
                        aclIndexing = true;
                    } else if (target.equals(term.text())) {
                        changeSetsFound.add(changeSet);
                    } else {
                        aclIndexing = true;
                    }
                }
                if (aclIndexing) {
                    if (changeSet.getCommitTimeMs() > this.state.timeToStopIndexing) {
                        aclsUpToDate = true;
                    } else {
                        List<Acl> acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                        for (Acl acl : acls) {
                            List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(acl));
                            this.indexAcl(readers, true);
                        }
                        this.indexAclTransaction(changeSet, true);
                        changeSetsFound.add(changeSet);
                        this.trackerStats.addChangeSetAcls(acls.size());
                        if (changeSet.getCommitTimeMs() > this.state.lastIndexedChangeSetCommitTime) {
                            this.state.lastIndexedChangeSetCommitTime = changeSet.getCommitTimeMs();
                            this.state.lastIndexedChangeSetId = changeSet.getId();
                        }
                    }
                }
                this.checkShutdown();
            }
        } while (aclChangeSets.getAclChangeSets().size() > 0 && !aclsUpToDate);
        if (aclIndexing) {
            this.checkShutdown();
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    private void checkRepoAndIndexConsistency(SolrIndexSearcher solrIndexSearcher) throws AuthenticationException, IOException, JSONException {
        AclChangeSets firstChangeSets;
        Transaction firstTransaction;
        Transactions firstTransactions;
        SolrIndexReader reader = solrIndexSearcher.getReader();
        if (this.state.lastGoodTxCommitTimeInIndex == 0L) {
            this.state.checkedFirstTransactionTime = true;
            log.info("No transactions found - no verification required");
            firstTransactions = this.client.getTransactions(null, 0L, null, 2000L, 1);
            if (firstTransactions.getTransactions().size() > 0) {
                long firstTransactionCommitTime;
                firstTransaction = firstTransactions.getTransactions().get(0);
                this.state.lastGoodTxCommitTimeInIndex = firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
            }
        }
        if (this.state.lastGoodChangeSetCommitTimeInIndex == 0L && (firstChangeSets = this.client.getAclChangeSets(null, 0L, null, 2000L, 1)).getAclChangeSets().size() > 0) {
            long firstChangeSetCommitTimex;
            AclChangeSet firstChangeSet = firstChangeSets.getAclChangeSets().get(0);
            this.state.lastGoodChangeSetCommitTimeInIndex = firstChangeSetCommitTimex = firstChangeSet.getCommitTimeMs();
        }
        if (!this.state.checkedFirstTransactionTime && (firstTransactions = this.client.getTransactions(null, 0L, null, 2000L, 1)).getTransactions().size() > 0) {
            firstTransaction = firstTransactions.getTransactions().get(0);
            long firstTxId = firstTransaction.getId();
            String targetTxId = NumericEncoder.encode((long)firstTxId);
            long firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
            String targetTxCommitTime = NumericEncoder.encode((long)firstTransactionCommitTime);
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("TXID", targetTxId)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term("TXCOMMITTIME", targetTxCommitTime)), BooleanClause.Occur.MUST);
            DocSet set = solrIndexSearcher.getDocSet((Query)query);
            if (set.size() == 0) {
                log.error("First transaction was not found with the correct timestamp.");
                log.error("SOLR has successfully connected to your repository  however the SOLR indexes and repository database do not match.");
                log.error("If this is a new or rebuilt database you SOLR indexes also need to be re-built to match the database.");
                log.error("You can also check your SOLR connection details in solrcore.properties.");
                throw new AlfrescoRuntimeException("Initial transaction not found with correct timestamp");
            }
            if (set.size() == 1) {
                this.state.checkedFirstTransactionTime = true;
                log.info("Verified first transaction and timetsamp in index");
            } else {
                log.warn("Duplicate initial transaction found with correct timestamp");
            }
        }
    }

    private void setTrackerInitialState(SolrIndexSearcher solrIndexSearcher) throws IOException {
        long currentBestFromIndex;
        SolrIndexReader reader = solrIndexSearcher.getReader();
        if (this.state.lastIndexedTxCommitTime == 0L) {
            this.state.lastIndexedTxCommitTime = this.getLastTransactionCommitTime(reader);
        }
        if (this.state.lastIndexedTxId == 0L) {
            this.state.lastIndexedTxId = this.getLastTransactionId(reader);
        }
        if (this.state.lastIndexedChangeSetCommitTime == 0L) {
            this.state.lastIndexedChangeSetCommitTime = this.getLastChangeSetCommitTime(reader);
        }
        if (this.state.lastIndexedChangeSetId == 0L) {
            this.state.lastIndexedChangeSetId = this.getLastChangeSetId(reader);
        }
        long startTime = System.currentTimeMillis();
        this.state.timeToStopIndexing = startTime - this.lag;
        this.state.timeBeforeWhichThereCanBeNoHoles = startTime - this.holeRetention;
        long timeBeforeWhichThereCanBeNoTxHolesInIndex = this.state.lastIndexedTxCommitTime - this.holeRetention;
        this.state.lastGoodTxCommitTimeInIndex = this.getLastTxCommitTimeBeforeHoles(reader, timeBeforeWhichThereCanBeNoTxHolesInIndex);
        long timeBeforeWhichThereCanBeNoChangeSetHolesInIndex = this.state.lastIndexedChangeSetCommitTime - this.holeRetention;
        this.state.lastGoodChangeSetCommitTimeInIndex = this.getLastChangeSetCommitTimeBeforeHoles(reader, timeBeforeWhichThereCanBeNoChangeSetHolesInIndex);
        if (this.state.lastGoodTxCommitTimeInIndex > 0L) {
            if (this.state.lastIndexedTxIdBeforeHoles == -1L) {
                this.state.lastIndexedTxIdBeforeHoles = this.getLargestTxIdByCommitTime(reader, this.state.lastGoodTxCommitTimeInIndex);
            } else {
                currentBestFromIndex = this.getLargestTxIdByCommitTime(reader, this.state.lastGoodTxCommitTimeInIndex);
                if (currentBestFromIndex > this.state.lastIndexedTxIdBeforeHoles) {
                    this.state.lastIndexedTxIdBeforeHoles = currentBestFromIndex;
                }
            }
        }
        if (this.state.lastGoodChangeSetCommitTimeInIndex > 0L) {
            if (this.state.lastIndexedChangeSetIdBeforeHoles == -1L) {
                this.state.lastIndexedChangeSetIdBeforeHoles = this.getLargestChangeSetIdByCommitTime(reader, this.state.lastGoodChangeSetCommitTimeInIndex);
            } else {
                currentBestFromIndex = this.getLargestChangeSetIdByCommitTime(reader, this.state.lastGoodChangeSetCommitTimeInIndex);
                if (currentBestFromIndex > this.state.lastIndexedTxIdBeforeHoles) {
                    this.state.lastIndexedChangeSetIdBeforeHoles = currentBestFromIndex;
                }
            }
        }
    }

    protected Long getTxFromCommitTime(BoundedDeque<Transaction> txnsFound, long lastGoodTxCommitTimeInIndex) {
        if (txnsFound.size() > 0) {
            return txnsFound.getLast().getCommitTimeMs();
        }
        return lastGoodTxCommitTimeInIndex;
    }

    protected Long getChangeSetFromCommitTime(BoundedDeque<AclChangeSet> changeSetsFound, long lastGoodChangeSetCommitTimeInIndex) {
        if (changeSetsFound.size() > 0) {
            return changeSetsFound.getLast().getCommitTimeMs();
        }
        return lastGoodChangeSetCommitTimeInIndex;
    }

    protected AclChangeSets getSomeAclChangeSets(BoundedDeque<AclChangeSet> changeSetsFound, Long fromCommitTime, long timeStep, int maxResults, long endTime) throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclChangeSets;
        long actualTimeStep = timeStep;
        Long startTime = fromCommitTime == null ? Long.valueOf(0L) : fromCommitTime;
        do {
            aclChangeSets = this.client.getAclChangeSets(startTime, null, startTime + actualTimeStep, null, maxResults);
            startTime = startTime + actualTimeStep;
            if ((actualTimeStep *= 2L) <= 2764800000L) continue;
            actualTimeStep = 2764800000L;
        } while (aclChangeSets.getAclChangeSets().size() == 0 && startTime < endTime || aclChangeSets.getAclChangeSets().size() > 0 && this.alreadyFoundChangeSets(changeSetsFound, aclChangeSets));
        return aclChangeSets;
    }

    private boolean alreadyFoundChangeSets(BoundedDeque<AclChangeSet> changeSetsFound, AclChangeSets aclChangeSets) {
        if (changeSetsFound.size() == 0) {
            return false;
        }
        if (aclChangeSets.getAclChangeSets().size() == 1) {
            return aclChangeSets.getAclChangeSets().get(0).getId() == changeSetsFound.getLast().getId();
        }
        HashSet alreadyFound = new HashSet(((BoundedDeque)changeSetsFound).deque);
        for (AclChangeSet aclChangeSet : aclChangeSets.getAclChangeSets()) {
            if (alreadyFound.contains(aclChangeSet)) continue;
            return false;
        }
        return true;
    }

    protected Transactions getSomeTransactions(BoundedDeque<Transaction> txnsFound, Long fromCommitTime, long timeStep, int maxResults, long endTime) throws AuthenticationException, IOException, JSONException {
        Transactions transactions;
        long actualTimeStep = timeStep;
        Long startTime = fromCommitTime == null ? Long.valueOf(0L) : fromCommitTime;
        do {
            transactions = this.client.getTransactions(startTime, null, startTime + actualTimeStep, null, maxResults);
            startTime = startTime + actualTimeStep;
            if ((actualTimeStep *= 2L) <= 2764800000L) continue;
            actualTimeStep = 2764800000L;
        } while (transactions.getTransactions().size() == 0 && startTime < endTime || transactions.getTransactions().size() > 0 && this.alreadyFoundTransactions(txnsFound, transactions));
        return transactions;
    }

    private boolean alreadyFoundTransactions(BoundedDeque<Transaction> txnsFound, Transactions transactions) {
        if (txnsFound.size() == 0) {
            return false;
        }
        if (transactions.getTransactions().size() == 1) {
            return transactions.getTransactions().get(0).getId() == txnsFound.getLast().getId();
        }
        HashSet alreadyFound = new HashSet(((BoundedDeque)txnsFound).deque);
        for (Transaction txn : transactions.getTransactions()) {
            if (alreadyFound.contains(txn)) continue;
            return false;
        }
        return true;
    }

    private void trackModels() throws AuthenticationException, IOException, JSONException {
        File alfrescoModelDir;
        long start = System.nanoTime();
        List<AlfrescoModelDiff> modelDiffs = this.client.getModelsDiff(this.dataModel.getAlfrescoModels());
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        block9: for (AlfrescoModelDiff modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: {
                    AlfrescoModel changedModel = this.client.getModel(modelDiff.getModelName());
                    for (M2Namespace namespace : changedModel.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), changedModel.getModel());
                    }
                    continue block9;
                }
                case NEW: {
                    AlfrescoModel newModel = this.client.getModel(modelDiff.getModelName());
                    for (M2Namespace namespace : newModel.getModel().getNamespaces()) {
                        modelMap.put(namespace.getUri(), newModel.getModel());
                    }
                    continue block9;
                }
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model, this.dataModel);
        }
        if (loadedModels.size() > 0) {
            this.dataModel.afterInitModels();
        }
        if (!(alfrescoModelDir = new File(this.id, "alfrescoModels")).exists()) {
            alfrescoModelDir.mkdir();
        }
        for (AlfrescoModelDiff modelDiff : modelDiffs) {
            switch (modelDiff.getType()) {
                case CHANGED: {
                    this.removeMatchingModels(alfrescoModelDir, modelDiff.getModelName());
                    M2Model changedModel = this.dataModel.getM2Model(modelDiff.getModelName());
                    File changedFile = new File(alfrescoModelDir, this.getModelFileName(changedModel));
                    FileOutputStream cos = new FileOutputStream(changedFile);
                    changedModel.toXML((OutputStream)cos);
                    cos.flush();
                    cos.close();
                    break;
                }
                case NEW: {
                    M2Model newModel = this.dataModel.getM2Model(modelDiff.getModelName());
                    File newFile = new File(alfrescoModelDir, this.getModelFileName(newModel));
                    FileOutputStream nos = new FileOutputStream(newFile);
                    newModel.toXML((OutputStream)nos);
                    nos.flush();
                    nos.close();
                    break;
                }
                case REMOVED: {
                    this.removeMatchingModels(alfrescoModelDir, modelDiff.getModelName());
                }
            }
        }
        long end = System.nanoTime();
        this.trackerStats.addModelTime(end - start);
        if (this.runPostModelLoadInit) {
            Properties p = this.core.getResourceLoader().getCoreProperties();
            for (Object key : p.keySet()) {
                String name;
                QName qname;
                StoreRef store;
                String stringKey = (String)key;
                if (stringKey.startsWith("alfresco.index.store")) {
                    store = new StoreRef(p.getProperty(stringKey));
                    this.indexedStores.add(store);
                }
                if (stringKey.startsWith("alfresco.ignore.store")) {
                    store = new StoreRef(p.getProperty(stringKey));
                    this.ignoredStores.add(store);
                }
                if (stringKey.startsWith("alfresco.index.tenant")) {
                    this.indexedTenants.add(p.getProperty(stringKey));
                }
                if (stringKey.startsWith("alfresco.ignore.tenant")) {
                    this.ignoredTenants.add(p.getProperty(stringKey));
                }
                if (stringKey.startsWith("alfresco.index.datatype")) {
                    qname = this.expandQName(p.getProperty(stringKey));
                    this.indexedDataTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.ignore.datatype")) {
                    qname = this.expandQName(p.getProperty(stringKey));
                    this.ignoredDataTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.index.type")) {
                    qname = this.expandQName(p.getProperty(stringKey));
                    this.indexedTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.ignore.type")) {
                    qname = this.expandQName(p.getProperty(stringKey));
                    this.ignoredTypes.add(qname);
                }
                if (stringKey.startsWith("alfresco.index.aspect")) {
                    qname = this.expandQName(p.getProperty(stringKey));
                    this.indexedAspects.add(qname);
                }
                if (stringKey.startsWith("alfresco.ignore.aspect")) {
                    qname = this.expandQName(p.getProperty(stringKey));
                    this.ignoredAspects.add(qname);
                }
                if (stringKey.startsWith("alfresco.index.field")) {
                    name = this.expandName(p.getProperty(stringKey));
                    this.indexedFields.add(name);
                }
                if (!stringKey.startsWith("alfresco.ignore.field")) continue;
                name = this.expandName(p.getProperty(stringKey));
                this.ignoredFields.add(name);
            }
            this.runPostModelLoadInit = false;
        }
    }

    QName expandQName(String qName) {
        String expandedQName = qName;
        if (qName.startsWith("@")) {
            return this.expandQName(qName.substring(1));
        }
        if (qName.startsWith("{")) {
            expandedQName = this.expandQNameImpl(qName);
        } else if (qName.contains(":")) {
            expandedQName = this.expandQNameImpl(qName);
        } else if (AlfrescoSolrDataModel.nonDictionaryFields.get(qName) == null) {
            expandedQName = this.expandQNameImpl(qName);
        }
        return QName.createQName((String)expandedQName);
    }

    String expandQNameImpl(String q) {
        String eq = q;
        if (q.charAt(0) != '{') {
            int colonPosition = q.indexOf(58);
            eq = colonPosition == -1 ? "{" + this.dataModel.getNamespaceDAO().getNamespaceURI("") + "}" + q : "{" + this.dataModel.getNamespaceDAO().getNamespaceURI(q.substring(0, colonPosition)) + "}" + q.substring(colonPosition + 1);
        }
        return eq;
    }

    String expandName(String qName) {
        String expandedQName = qName;
        if (qName.startsWith("@")) {
            return this.expandName(qName.substring(1));
        }
        if (qName.startsWith("{")) {
            expandedQName = this.expandQNameImpl(qName);
        } else if (qName.contains(":")) {
            expandedQName = this.expandQNameImpl(qName);
        } else if (AlfrescoSolrDataModel.nonDictionaryFields.get(qName) == null) {
            expandedQName = this.expandQNameImpl(qName);
        }
        return expandedQName;
    }

    String expandNameImpl(String q) {
        String eq = q;
        if (q.charAt(0) != '{') {
            int colonPosition = q.indexOf(58);
            eq = colonPosition == -1 ? "{" + this.dataModel.getNamespaceDAO().getNamespaceURI("") + "}" + q : "{" + this.dataModel.getNamespaceDAO().getNamespaceURI(q.substring(0, colonPosition)) + "}" + q.substring(colonPosition + 1);
        }
        return eq;
    }

    private void removeMatchingModels(File alfrescoModelDir, QName modelName) {
        final String prefix = modelName.toPrefixString((NamespacePrefixResolver)this.dataModel.getNamespaceDAO()).replace(":", ".") + ".";
        String postFix = ".xml";
        File[] toDelete = alfrescoModelDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return false;
                }
                String name = pathname.getName();
                if (!name.endsWith(".xml")) {
                    return false;
                }
                if (!name.startsWith(prefix)) {
                    return false;
                }
                String checksum = name.substring(prefix.length(), name.length() - ".xml".length());
                try {
                    Long.parseLong(checksum);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        });
        if (toDelete != null) {
            for (File file : toDelete) {
                file.delete();
            }
        }
    }

    protected void indexAcl(List<AclReaders> aclReaderList, boolean overwrite) throws IOException {
        long start = System.nanoTime();
        for (AclReaders aclReaders : aclReaderList) {
            AddUpdateCommand cmd = new AddUpdateCommand();
            cmd.overwriteCommitted = overwrite;
            cmd.overwritePending = overwrite;
            SolrInputDocument input = new SolrInputDocument();
            input.addField("ID", (Object)("ACL-" + aclReaders.getId()));
            input.addField("ACLID", (Object)aclReaders.getId());
            input.addField("INACLTXID", (Object)aclReaders.getAclChangeSetId());
            String tenant = aclReaders.getTenantDomain();
            block5: for (String reader : aclReaders.getReaders()) {
                switch (AuthorityType.getAuthorityType((String)reader)) {
                    case USER: {
                        input.addField("READER", (Object)reader);
                        continue block5;
                    }
                    case GROUP: 
                    case EVERYONE: 
                    case GUEST: {
                        if (tenant.length() == 0) {
                            input.addField("READER", (Object)reader);
                            continue block5;
                        }
                        input.addField("READER", (Object)(reader + "@" + tenant));
                        continue block5;
                    }
                }
                input.addField("READER", (Object)reader);
            }
            cmd.solrDoc = input;
            cmd.doc = CoreTracker.toDocument(cmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
            this.core.getUpdateHandler().addDoc(cmd);
        }
        long end = System.nanoTime();
        this.trackerStats.addAclTime(end - start);
    }

    protected void indexTransaction(Transaction info, boolean overwrite) throws IOException {
        AddUpdateCommand cmd = new AddUpdateCommand();
        cmd.overwriteCommitted = overwrite;
        cmd.overwritePending = overwrite;
        SolrInputDocument input = new SolrInputDocument();
        input.addField("ID", (Object)("TX-" + info.getId()));
        input.addField("TXID", (Object)info.getId());
        input.addField("INTXID", (Object)info.getId());
        input.addField("TXCOMMITTIME", (Object)info.getCommitTimeMs());
        cmd.solrDoc = input;
        cmd.doc = CoreTracker.toDocument(cmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
        this.core.getUpdateHandler().addDoc(cmd);
    }

    protected void indexAclTransaction(AclChangeSet changeSet, boolean overwrite) throws IOException {
        AddUpdateCommand cmd = new AddUpdateCommand();
        cmd.overwriteCommitted = overwrite;
        cmd.overwritePending = overwrite;
        SolrInputDocument input = new SolrInputDocument();
        input.addField("ID", (Object)("ACLTX-" + changeSet.getId()));
        input.addField("ACLTXID", (Object)changeSet.getId());
        input.addField("INACLTXID", (Object)changeSet.getId());
        input.addField("ACLTXCOMMITTIME", (Object)changeSet.getCommitTimeMs());
        cmd.solrDoc = input;
        cmd.doc = CoreTracker.toDocument(cmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
        this.core.getUpdateHandler().addDoc(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexNode(Node node, SolrIndexSearcher solrIndexSearcher, boolean overwrite) throws IOException, AuthenticationException, JSONException {
        try {
            List<NodeMetaData> nodeMetaDatas;
            NodeMetaDataParameters nmdp;
            long start = System.nanoTime();
            if (node.getStatus() == Node.SolrApiNodeStatus.DELETED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN) {
                nmdp = new NodeMetaDataParameters();
                nmdp.setFromNodeId(node.getId());
                nmdp.setToNodeId(node.getId());
                if (node.getStatus() == Node.SolrApiNodeStatus.DELETED) {
                    NodeMetaData nodeMetaData = new NodeMetaData();
                    nodeMetaData.setId(node.getId());
                    nodeMetaData.setType(ContentModel.TYPE_DELETED);
                    nodeMetaData.setNodeRef(new NodeRef(node.getNodeRef()));
                    nodeMetaData.setTxnId(node.getTxnId());
                    nodeMetaDatas = Collections.singletonList(nodeMetaData);
                } else {
                    nodeMetaDatas = this.client.getNodesMetaData(nmdp, 1);
                }
                for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                    if (nodeMetaData.getTxnId() > node.getTxnId()) continue;
                    LinkedHashSet<Long> visited = new LinkedHashSet<Long>();
                    this.updateDescendantAuxDocs(nodeMetaData, overwrite, solrIndexSearcher, visited);
                }
                log.debug(".. deleting");
                DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
                docCmd.id = "LEAF-" + node.getId();
                docCmd.fromPending = true;
                docCmd.fromCommitted = true;
                this.core.getUpdateHandler().delete(docCmd);
                docCmd = new DeleteUpdateCommand();
                docCmd.id = "AUX-" + node.getId();
                docCmd.fromPending = true;
                docCmd.fromCommitted = true;
                this.core.getUpdateHandler().delete(docCmd);
                docCmd = new DeleteUpdateCommand();
                docCmd.id = "UNINDEXED-" + node.getId();
                docCmd.fromPending = true;
                docCmd.fromCommitted = true;
                this.core.getUpdateHandler().delete(docCmd);
                docCmd = new DeleteUpdateCommand();
                docCmd.id = "ERROR-" + node.getId();
                docCmd.fromPending = true;
                docCmd.fromCommitted = true;
                this.core.getUpdateHandler().delete(docCmd);
            }
            if (node.getStatus() == Node.SolrApiNodeStatus.UPDATED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN) {
                log.info(".. updating");
                nmdp = new NodeMetaDataParameters();
                nmdp.setFromNodeId(node.getId());
                nmdp.setToNodeId(node.getId());
                nodeMetaDatas = this.client.getNodesMetaData(nmdp, 1);
                AddUpdateCommand leafDocCmd = new AddUpdateCommand();
                leafDocCmd.overwriteCommitted = overwrite;
                leafDocCmd.overwritePending = overwrite;
                AddUpdateCommand auxDocCmd = new AddUpdateCommand();
                auxDocCmd.overwriteCommitted = overwrite;
                auxDocCmd.overwritePending = overwrite;
                ArrayList<Reader> toClose = new ArrayList<Reader>();
                ArrayList<File> toDelete = new ArrayList<File>();
                for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                    SolrInputDocument aux;
                    Boolean isIndexed;
                    StringPropertyValue pValue;
                    Boolean isIndexed2;
                    StringPropertyValue pValue2;
                    Map<QName, PropertyValue> properties;
                    if (nodeMetaData.getTxnId() > node.getTxnId()) continue;
                    if (this.mayHaveChildren(nodeMetaData)) {
                        log.info(".. checking for path change");
                        BooleanQuery bQuery = new BooleanQuery();
                        bQuery.add((Query)new TermQuery(new Term("DBID", NumericEncoder.encode((long)nodeMetaData.getId()))), BooleanClause.Occur.MUST);
                        bQuery.add((Query)new TermQuery(new Term("PARENTASSOCCRC", NumericEncoder.encode((long)nodeMetaData.getParentAssocsCrc()))), BooleanClause.Occur.MUST);
                        DocSet docSet = solrIndexSearcher.getDocSet((Query)bQuery);
                        if (docSet.size() > 0) {
                            log.debug("... found aux match");
                        } else {
                            docSet = solrIndexSearcher.getDocSet((Query)new TermQuery(new Term("DBID", NumericEncoder.encode((long)nodeMetaData.getId()))));
                            if (docSet.size() > 0) {
                                log.debug("... cascade updating aux doc");
                                LinkedHashSet<Long> visited = new LinkedHashSet<Long>();
                                this.updateDescendantAuxDocs(nodeMetaData, overwrite, solrIndexSearcher, visited);
                            } else {
                                log.debug("... no aux doc");
                            }
                        }
                    }
                    if ((properties = nodeMetaData.getProperties()).containsKey(ContentModel.PROP_IS_INDEXED) && (pValue2 = (StringPropertyValue)properties.get(ContentModel.PROP_IS_INDEXED)) != null && (isIndexed2 = Boolean.valueOf(pValue2.getValue())) != null && !isIndexed2.booleanValue()) {
                        DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
                        docCmd.id = "LEAF-" + node.getId();
                        docCmd.fromPending = true;
                        docCmd.fromCommitted = true;
                        this.core.getUpdateHandler().delete(docCmd);
                        docCmd = new DeleteUpdateCommand();
                        docCmd.id = "AUX-" + node.getId();
                        docCmd.fromPending = true;
                        docCmd.fromCommitted = true;
                        this.core.getUpdateHandler().delete(docCmd);
                        docCmd = new DeleteUpdateCommand();
                        docCmd.id = "ERROR-" + node.getId();
                        docCmd.fromPending = true;
                        docCmd.fromCommitted = true;
                        this.core.getUpdateHandler().delete(docCmd);
                        SolrInputDocument doc = new SolrInputDocument();
                        doc.addField("ID", (Object)("UNINDEXED-" + nodeMetaData.getId()));
                        doc.addField("DBID", (Object)nodeMetaData.getId());
                        doc.addField("LID", (Object)nodeMetaData.getNodeRef());
                        doc.addField("INTXID", (Object)nodeMetaData.getTxnId());
                        leafDocCmd.solrDoc = doc;
                        leafDocCmd.doc = CoreTracker.toDocument(leafDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
                        if (leafDocCmd.doc != null) {
                            this.core.getUpdateHandler().addDoc(leafDocCmd);
                        }
                        long end = System.nanoTime();
                        this.trackerStats.addNodeTime(end - start);
                        return;
                    }
                    boolean isContentIndexedForNode = true;
                    if (properties.containsKey(ContentModel.PROP_IS_CONTENT_INDEXED) && (pValue = (StringPropertyValue)properties.get(ContentModel.PROP_IS_CONTENT_INDEXED)) != null && (isIndexed = Boolean.valueOf(pValue.getValue())) != null && !isIndexed.booleanValue()) {
                        isContentIndexedForNode = false;
                    }
                    DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
                    docCmd.id = "UNINDEXED-" + node.getId();
                    docCmd.fromPending = true;
                    docCmd.fromCommitted = true;
                    this.core.getUpdateHandler().delete(docCmd);
                    docCmd = new DeleteUpdateCommand();
                    docCmd.id = "ERROR-" + node.getId();
                    docCmd.fromPending = true;
                    docCmd.fromCommitted = true;
                    this.core.getUpdateHandler().delete(docCmd);
                    SolrInputDocument doc = new SolrInputDocument();
                    doc.addField("ID", (Object)("LEAF-" + nodeMetaData.getId()));
                    doc.addField("DBID", (Object)nodeMetaData.getId());
                    doc.addField("LID", (Object)nodeMetaData.getNodeRef());
                    doc.addField("INTXID", (Object)nodeMetaData.getTxnId());
                    for (QName propertyQname : properties.keySet()) {
                        PropertyValue value;
                        if (!this.dataModel.isIndexedOrStored(propertyQname) || (value = properties.get(propertyQname)) == null) continue;
                        if (value instanceof ContentPropertyValue) {
                            if (!isContentIndexedForNode) continue;
                            this.addContentPropertyToDoc(doc, toClose, toDelete, nodeMetaData, propertyQname, (ContentPropertyValue)value);
                            continue;
                        }
                        if (value instanceof MLTextPropertyValue) {
                            this.addMLTextPropertyToDoc(doc, propertyQname, (MLTextPropertyValue)value);
                            continue;
                        }
                        if (value instanceof MultiPropertyValue) {
                            MultiPropertyValue typedValue = (MultiPropertyValue)value;
                            for (PropertyValue singleValue : typedValue.getValues()) {
                                if (singleValue instanceof ContentPropertyValue) {
                                    if (!isContentIndexedForNode) continue;
                                    this.addContentPropertyToDoc(doc, toClose, toDelete, nodeMetaData, propertyQname, (ContentPropertyValue)singleValue);
                                    continue;
                                }
                                if (singleValue instanceof MLTextPropertyValue) {
                                    this.addMLTextPropertyToDoc(doc, propertyQname, (MLTextPropertyValue)singleValue);
                                    continue;
                                }
                                if (!(singleValue instanceof StringPropertyValue)) continue;
                                this.addStringPropertyToDoc(doc, propertyQname, (StringPropertyValue)singleValue, properties);
                            }
                            continue;
                        }
                        if (!(value instanceof StringPropertyValue)) continue;
                        this.addStringPropertyToDoc(doc, propertyQname, (StringPropertyValue)value, properties);
                    }
                    doc.addField("TYPE", (Object)nodeMetaData.getType().toString());
                    for (QName aspect : nodeMetaData.getAspects()) {
                        doc.addField("ASPECT", (Object)aspect.toString());
                    }
                    doc.addField("ISNODE", (Object)"T");
                    doc.addField("FTSSTATUS", (Object)"Clean");
                    String tenant = nodeMetaData.getTenantDomain();
                    if (tenant.length() > 0) {
                        doc.addField("TENANT", (Object)nodeMetaData.getTenantDomain());
                    } else {
                        doc.addField("TENANT", (Object)"_DEFAULT_");
                    }
                    leafDocCmd.solrDoc = doc;
                    leafDocCmd.doc = CoreTracker.toDocument(leafDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
                    auxDocCmd.solrDoc = aux = this.createAuxDoc(nodeMetaData);
                    auxDocCmd.doc = CoreTracker.toDocument(auxDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
                }
                if (leafDocCmd.doc != null) {
                    this.core.getUpdateHandler().addDoc(leafDocCmd);
                }
                if (auxDocCmd.doc != null) {
                    this.core.getUpdateHandler().addDoc(auxDocCmd);
                }
                for (Reader forClose : toClose) {
                    try {
                        forClose.close();
                    }
                    catch (IOException ioe) {}
                }
                for (File file : toDelete) {
                    file.delete();
                }
            }
            long end = System.nanoTime();
            this.trackerStats.addNodeTime(end - start);
        }
        catch (Exception e) {
            DeleteUpdateCommand docCmd = new DeleteUpdateCommand();
            docCmd.id = "LEAF-" + node.getId();
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
            docCmd = new DeleteUpdateCommand();
            docCmd.id = "AUX-" + node.getId();
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
            docCmd = new DeleteUpdateCommand();
            docCmd.id = "UNINDEXED-" + node.getId();
            docCmd.fromPending = true;
            docCmd.fromCommitted = true;
            this.core.getUpdateHandler().delete(docCmd);
            AddUpdateCommand leafDocCmd = new AddUpdateCommand();
            leafDocCmd.overwriteCommitted = overwrite;
            leafDocCmd.overwritePending = overwrite;
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("ID", (Object)("ERROR-" + node.getId()));
            doc.addField("DBID", (Object)node.getId());
            doc.addField("INTXID", (Object)node.getTxnId());
            doc.addField("EXCEPTIONMESSAGE", (Object)e.getMessage());
            StringWriter stringWriter = new StringWriter(4096);
            try (PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);){
                e.printStackTrace(printWriter);
                doc.addField("EXCEPTIONSTACK", (Object)stringWriter.toString());
            }
            leafDocCmd.solrDoc = doc;
            leafDocCmd.doc = CoreTracker.toDocument(leafDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
            if (leafDocCmd.doc != null) {
                this.core.getUpdateHandler().addDoc(leafDocCmd);
            }
            log.warn("Node index failed and skipped for " + node.getId() + " in Tx " + node.getTxnId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDescendantAuxDocs(NodeMetaData parentNodeMetaData, boolean overwrite, SolrIndexSearcher solrIndexSearcher, LinkedHashSet<Long> stack) throws AuthenticationException, IOException, JSONException {
        if (stack.contains(parentNodeMetaData.getId())) {
            log.warn("Found aux data loop for node id " + parentNodeMetaData.getId());
            log.warn("... stack to node =" + stack);
            return;
        }
        try {
            stack.add(parentNodeMetaData.getId());
            this.doUpdateDescendantAuxDocs(parentNodeMetaData, overwrite, solrIndexSearcher, stack);
        }
        finally {
            stack.remove(parentNodeMetaData.getId());
        }
    }

    private void doUpdateDescendantAuxDocs(NodeMetaData parentNodeMetaData, boolean overwrite, SolrIndexSearcher solrIndexSearcher, LinkedHashSet<Long> stack) throws AuthenticationException, IOException, JSONException {
        HashSet<Long> childIds = new HashSet<Long>();
        if (parentNodeMetaData.getChildIds() != null) {
            childIds.addAll(parentNodeMetaData.getChildIds());
        }
        BooleanQuery bQuery = new BooleanQuery();
        bQuery.add((Query)new TermQuery(new Term("PARENT", parentNodeMetaData.getNodeRef().toString())), BooleanClause.Occur.MUST);
        DocSet docSet = solrIndexSearcher.getDocSet((Query)bQuery);
        ResizeableArrayList indexedByDocId = (ResizeableArrayList)solrIndexSearcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_DOC_ID);
        if (docSet instanceof BitDocSet) {
            BitDocSet source = (BitDocSet)docSet;
            OpenBitSet openBitSet = source.getBits();
            int current = -1;
            while ((current = openBitSet.nextSetBit(current + 1)) != -1) {
                AlfrescoSolrEventListener.CacheEntry entry = (AlfrescoSolrEventListener.CacheEntry)indexedByDocId.get(current);
                childIds.add(entry.getDbid());
            }
        } else {
            DocIterator it = docSet.iterator();
            while (it.hasNext()) {
                AlfrescoSolrEventListener.CacheEntry entry = (AlfrescoSolrEventListener.CacheEntry)indexedByDocId.get(it.nextDoc());
                childIds.add(entry.getDbid());
            }
        }
        for (Long childId : childIds) {
            NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
            nmdp.setFromNodeId(childId);
            nmdp.setToNodeId(childId);
            nmdp.setIncludeAclId(true);
            nmdp.setIncludeAspects(true);
            nmdp.setIncludeChildAssociations(false);
            nmdp.setIncludeChildIds(true);
            nmdp.setIncludeNodeRef(true);
            nmdp.setIncludeOwner(true);
            nmdp.setIncludeParentAssociations(true);
            nmdp.setIncludePaths(true);
            nmdp.setIncludeProperties(false);
            nmdp.setIncludeType(true);
            nmdp.setIncludeTxnId(true);
            List<NodeMetaData> nodeMetaDatas = this.client.getNodesMetaData(nmdp, 1);
            for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                if (this.mayHaveChildren(nodeMetaData)) {
                    this.updateDescendantAuxDocs(nodeMetaData, overwrite, solrIndexSearcher, stack);
                }
                log.info(".. checking aux doc exists in index before we update it");
                TermQuery query = new TermQuery(new Term("ID", "AUX-" + childId));
                DocSet auxSet = solrIndexSearcher.getDocSet((Query)query);
                if (auxSet.size() > 0) {
                    log.debug("... cascade update aux doc " + childId);
                    SolrInputDocument aux = this.createAuxDoc(nodeMetaData);
                    AddUpdateCommand auxDocCmd = new AddUpdateCommand();
                    auxDocCmd.overwriteCommitted = overwrite;
                    auxDocCmd.overwritePending = overwrite;
                    auxDocCmd.solrDoc = aux;
                    auxDocCmd.doc = CoreTracker.toDocument(auxDocCmd.getSolrInputDocument(), this.core.getSchema(), this.dataModel);
                    this.core.getUpdateHandler().addDoc(auxDocCmd);
                    continue;
                }
                log.debug("... no aux doc found to update " + childId);
            }
        }
    }

    private SolrInputDocument createAuxDoc(NodeMetaData nodeMetaData) {
        SolrInputDocument aux = new SolrInputDocument();
        aux.addField("ID", (Object)("AUX-" + nodeMetaData.getId()));
        aux.addField("DBID", (Object)nodeMetaData.getId());
        aux.addField("ACLID", (Object)nodeMetaData.getAclId());
        aux.addField("INTXID", (Object)nodeMetaData.getTxnId());
        for (Pair<String, QName> path : nodeMetaData.getPaths()) {
            aux.addField("PATH", path.getFirst());
        }
        if (nodeMetaData.getOwner() != null) {
            aux.addField("OWNER", (Object)nodeMetaData.getOwner());
        }
        aux.addField("PARENTASSOCCRC", (Object)nodeMetaData.getParentAssocsCrc());
        StringBuilder qNameBuffer = new StringBuilder(64);
        StringBuilder assocTypeQNameBuffer = new StringBuilder(64);
        if (nodeMetaData.getParentAssocs() != null) {
            for (ChildAssociationRef childAssocRef : nodeMetaData.getParentAssocs()) {
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                aux.addField("PARENT", (Object)childAssocRef.getParentRef());
                if (!childAssocRef.isPrimary()) continue;
                aux.addField("PRIMARYPARENT", (Object)childAssocRef.getParentRef());
                aux.addField("PRIMARYASSOCTYPEQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                aux.addField("PRIMARYASSOCQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getQName()));
            }
            aux.addField("ASSOCTYPEQNAME", (Object)assocTypeQNameBuffer.toString());
            aux.addField("QNAME", (Object)qNameBuffer.toString());
        }
        if (nodeMetaData.getAncestors() != null) {
            for (NodeRef ancestor : nodeMetaData.getAncestors()) {
                aux.addField("ANCESTOR", (Object)ancestor.toString());
            }
        }
        return aux;
    }

    private boolean mayHaveChildren(NodeMetaData nodeMetaData) {
        TypeDefinition nodeTypeDef = this.dataModel.getDictionaryService("DEFAULT_DICTIONARY").getType(nodeMetaData.getType());
        if (nodeTypeDef != null && nodeTypeDef.getChildAssociations().size() > 0) {
            return true;
        }
        for (QName aspect : nodeMetaData.getAspects()) {
            AspectDefinition aspectDef = this.dataModel.getDictionaryService("DEFAULT_DICTIONARY").getAspect(aspect);
            if (aspectDef == null || aspectDef.getChildAssociations().size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContentPropertyToDoc(SolrInputDocument doc, ArrayList<Reader> toClose, ArrayList<File> toDelete, NodeMetaData nodeMetaData, QName propertyQName, ContentPropertyValue contentPropertyValue) throws AuthenticationException, IOException {
        if (this.indexedDataTypes.size() > 0 && !this.indexedDataTypes.contains(DataTypeDefinition.CONTENT)) {
            return;
        }
        if (this.ignoredDataTypes.contains(DataTypeDefinition.CONTENT)) {
            return;
        }
        doc.addField("@" + propertyQName.toString() + ".size", (Object)contentPropertyValue.getLength());
        doc.addField("@" + propertyQName.toString() + ".locale", (Object)contentPropertyValue.getLocale());
        doc.addField("@" + propertyQName.toString() + ".mimetype", (Object)contentPropertyValue.getMimetype());
        doc.addField("@" + propertyQName.toString() + ".encoding", (Object)contentPropertyValue.getEncoding());
        if (!this.transformContent) {
            return;
        }
        long start = System.nanoTime();
        SOLRAPIClient.GetTextContentResponse response = this.client.getTextContent(nodeMetaData.getId(), propertyQName, null);
        doc.addField("@" + propertyQName.toString() + ".transformationStatus", (Object)response.getStatus());
        doc.addField("@" + propertyQName.toString() + ".transformationTime", (Object)response.getTransformDuration());
        doc.addField("@" + propertyQName.toString() + ".transformationException", (Object)response.getTransformException());
        InputStreamReader isr = null;
        InputStream ris = response.getContent();
        File temp = null;
        try {
            if (ris != null) {
                temp = TempFileProvider.createTempFile((String)"solr", (String)"content");
                toDelete.add(temp);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(temp));
                FileCopyUtils.copy((InputStream)ris, (OutputStream)os);
            }
        }
        finally {
            response.release();
        }
        long end = System.nanoTime();
        this.trackerStats.addDocTransformationTime(end - start);
        if (ris != null) {
            ris = new BufferedInputStream(new FileInputStream(temp));
            try {
                isr = new InputStreamReader(ris, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(ris);
            }
            toClose.add(isr);
            StringBuilder builder = new StringBuilder();
            builder.append("\u0000").append(contentPropertyValue.getLocale().toString()).append("\u0000");
            StringReader prefix = new StringReader(builder.toString());
            MultiReader multiReader = new MultiReader((Reader)prefix, (Reader)isr);
            doc.addField("@" + propertyQName.toString(), (Object)multiReader);
            ris = new BufferedInputStream(new FileInputStream(temp));
            try {
                isr = new InputStreamReader(ris, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(ris);
            }
            toClose.add(isr);
            builder = new StringBuilder();
            builder.append("\u0000").append(contentPropertyValue.getLocale().toString()).append("\u0000");
            prefix = new StringReader(builder.toString());
            multiReader = new MultiReader((Reader)prefix, (Reader)isr);
            doc.addField("@" + propertyQName.toString() + ".__", (Object)multiReader);
        }
    }

    private void addMLTextPropertyToDoc(SolrInputDocument doc, QName propertyQName, MLTextPropertyValue mlTextPropertyValue) throws IOException {
        PropertyDefinition propertyDefinition = this.dataModel.getPropertyDefinition(propertyQName);
        if (propertyDefinition != null) {
            StringBuilder sort = new StringBuilder();
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                StringBuilder builder = new StringBuilder();
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(mlTextPropertyValue.getValue(locale));
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString(), (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".u", (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__.u", (Object)builder.toString());
                }
                if (sort.length() > 0) {
                    sort.append("\u0000");
                }
                sort.append(builder.toString());
            }
            if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                doc.addField("@" + propertyQName.toString() + ".sort", (Object)sort.toString());
            }
        } else {
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                doc.addField("@" + propertyQName.toString(), (Object)mlTextPropertyValue.getValue(locale));
            }
        }
    }

    private void addStringPropertyToDoc(SolrInputDocument doc, QName propertyQName, StringPropertyValue stringPropertyValue, Map<QName, PropertyValue> properties) throws IOException {
        PropertyDefinition propertyDefinition = this.dataModel.getPropertyDefinition(propertyQName);
        if (propertyDefinition != null) {
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
                doc.addField("@" + propertyQName.toString() + ".sort", (Object)stringPropertyValue.getValue());
            } else if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                Locale locale = null;
                PropertyValue localePropertyValue = properties.get(ContentModel.PROP_LOCALE);
                if (localePropertyValue != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)((StringPropertyValue)localePropertyValue).getValue());
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                StringBuilder builder = new StringBuilder();
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(stringPropertyValue.getValue());
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.TRUE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString(), (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".u", (Object)builder.toString());
                    doc.addField("@" + propertyQName.toString() + ".__.u", (Object)builder.toString());
                }
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    doc.addField("@" + propertyQName.toString() + ".sort", (Object)builder.toString());
                }
            } else {
                doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
            }
        } else {
            doc.addField("@" + propertyQName.toString(), (Object)stringPropertyValue.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexHealthReport checkIndex(Long fromTx, Long toTx, Long fromAclTx, Long toAclTx, Long fromTime, Long toTime) throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclTransactions;
        Transactions transactions;
        IndexHealthReport indexHealthReport = new IndexHealthReport();
        Long minTxId = null;
        Long minAclTxId = null;
        long firstTransactionCommitTime = 0L;
        Transactions firstTransactions = this.client.getTransactions(null, 0L, null, 2000L, 1);
        if (firstTransactions.getTransactions().size() > 0) {
            Transaction firstTransaction = firstTransactions.getTransactions().get(0);
            firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
        }
        OpenBitSet txIdsInDb = new OpenBitSet();
        Long lastTxCommitTime = firstTransactionCommitTime;
        if (fromTime != null) {
            lastTxCommitTime = fromTime;
        }
        long maxTxId = 0L;
        BoundedDeque<Transaction> txnsFound = new BoundedDeque<Transaction>(100);
        long endTime = System.currentTimeMillis() + this.holeRetention;
        block3: do {
            transactions = this.getSomeTransactions(txnsFound, lastTxCommitTime, 3600000L, 2000, endTime);
            for (Transaction info : transactions.getTransactions()) {
                if (toTime != null && info.getCommitTimeMs() > toTime || toTx != null && info.getId() > toTx) break block3;
                if (minTxId == null) {
                    minTxId = info.getId();
                }
                if (maxTxId < info.getId()) {
                    maxTxId = info.getId();
                }
                lastTxCommitTime = info.getCommitTimeMs();
                txIdsInDb.set(info.getId());
                txnsFound.add(info);
            }
        } while (transactions.getTransactions().size() > 0);
        indexHealthReport.setDbTransactionCount(txIdsInDb.cardinality());
        long firstChangeSetCommitTimex = 0L;
        AclChangeSets firstChangeSets = this.client.getAclChangeSets(null, 0L, null, 2000L, 1);
        if (firstChangeSets.getAclChangeSets().size() > 0) {
            AclChangeSet firstChangeSet = firstChangeSets.getAclChangeSets().get(0);
            firstChangeSetCommitTimex = firstChangeSet.getCommitTimeMs();
        }
        OpenBitSet aclTxIdsInDb = new OpenBitSet();
        Long lastAclTxCommitTime = firstChangeSetCommitTimex;
        if (fromTime != null) {
            lastAclTxCommitTime = fromTime;
        }
        long maxAclTxId = 0L;
        BoundedDeque<AclChangeSet> changeSetsFound = new BoundedDeque<AclChangeSet>(100);
        block5: do {
            aclTransactions = this.getSomeAclChangeSets(changeSetsFound, lastAclTxCommitTime, 3600000L, 2000, endTime);
            for (AclChangeSet set : aclTransactions.getAclChangeSets()) {
                if (toTime != null && set.getCommitTimeMs() > toTime || toAclTx != null && set.getId() > toAclTx) break block5;
                if (minAclTxId == null) {
                    minAclTxId = set.getId();
                }
                if (maxAclTxId < set.getId()) {
                    maxAclTxId = set.getId();
                }
                lastAclTxCommitTime = set.getCommitTimeMs();
                aclTxIdsInDb.set(set.getId());
                changeSetsFound.add(set);
            }
        } while (aclTransactions.getAclChangeSets().size() > 0);
        indexHealthReport.setDbAclTransactionCount(aclTxIdsInDb.cardinality());
        OpenBitSet txIdsInIndex = new OpenBitSet();
        OpenBitSet aclTxIdsInIndex = new OpenBitSet();
        RefCounted refCounted = this.core.getSearcher(false, true, null);
        if (refCounted == null) {
            return indexHealthReport;
        }
        try {
            Term term;
            Term term2;
            Term term3;
            Term term4;
            int doc;
            Term term5;
            String target;
            int docCount;
            long i;
            int count;
            TermDocs termDocs;
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            SolrIndexReader reader = solrIndexSearcher.getReader();
            if (minTxId != null) {
                termDocs = null;
                count = 0;
                for (i = minTxId.longValue(); i <= maxTxId; ++i) {
                    docCount = 0;
                    target = NumericEncoder.encode((long)i);
                    term5 = new Term("TXID", target);
                    if (termDocs == null) {
                        termDocs = reader.termDocs(term5);
                    } else {
                        termDocs.seek(term5);
                    }
                    while (termDocs.next()) {
                        doc = termDocs.doc();
                        if (reader.isDeleted(doc)) continue;
                        ++docCount;
                    }
                    if (docCount == 0) {
                        if (!txIdsInDb.get(i)) continue;
                        indexHealthReport.setMissingTxFromIndex(i);
                        continue;
                    }
                    if (docCount == 1) {
                        txIdsInIndex.set(i);
                        if (!txIdsInDb.get(i)) {
                            indexHealthReport.setTxInIndexButNotInDb(i);
                        }
                        ++count;
                        continue;
                    }
                    if (docCount <= 1) continue;
                    indexHealthReport.setDuplicatedTxInIndex(i);
                    if (!txIdsInDb.get(i)) {
                        indexHealthReport.setTxInIndexButNotInDb(i);
                    }
                    ++count;
                }
                if (termDocs != null) {
                    termDocs.close();
                }
                indexHealthReport.setUniqueTransactionDocsInIndex(txIdsInIndex.cardinality());
                indexHealthReport.setTransactionDocsInIndex(count);
            }
            if (minAclTxId != null) {
                termDocs = null;
                count = 0;
                for (i = minAclTxId.longValue(); i <= maxAclTxId; ++i) {
                    docCount = 0;
                    target = NumericEncoder.encode((long)i);
                    term5 = new Term("ACLTXID", target);
                    if (termDocs == null) {
                        termDocs = reader.termDocs(term5);
                    } else {
                        termDocs.seek(term5);
                    }
                    while (termDocs.next()) {
                        doc = termDocs.doc();
                        if (reader.isDeleted(doc)) continue;
                        ++docCount;
                    }
                    if (docCount == 0) {
                        if (!aclTxIdsInDb.get(i)) continue;
                        indexHealthReport.setMissingAclTxFromIndex(i);
                        continue;
                    }
                    if (docCount == 1) {
                        aclTxIdsInIndex.set(i);
                        if (!aclTxIdsInDb.get(i)) {
                            indexHealthReport.setAclTxInIndexButNotInDb(i);
                        }
                        ++count;
                        continue;
                    }
                    if (docCount <= 1) continue;
                    indexHealthReport.setDuplicatedAclTxInIndex(i);
                    if (!aclTxIdsInDb.get(i)) {
                        indexHealthReport.setAclTxInIndexButNotInDb(i);
                    }
                    ++count;
                }
                if (termDocs != null) {
                    termDocs.close();
                }
                indexHealthReport.setUniqueAclTransactionDocsInIndex(aclTxIdsInIndex.cardinality());
                indexHealthReport.setAclTransactionDocsInIndex(count);
            }
            int leafCount = 0;
            TermEnum termEnum = reader.terms(new Term("ID", "LEAF-"));
            while ((term4 = termEnum.term()).field().equals("ID") && term4.text().startsWith("LEAF-")) {
                int docCount2 = 0;
                TermDocs termDocs2 = reader.termDocs(new Term("ID", term4.text()));
                while (termDocs2.next()) {
                    if (reader.isDeleted(termDocs2.doc())) continue;
                    ++docCount2;
                }
                if (docCount2 > 1) {
                    long txid = Long.parseLong(term4.text().substring(5));
                    indexHealthReport.setDuplicatedLeafInIndex(txid);
                }
                ++leafCount;
                if (termEnum.next()) continue;
            }
            termEnum.close();
            indexHealthReport.setLeafDocCountInIndex(leafCount);
            int auxCount = 0;
            termEnum = reader.terms(new Term("ID", "AUX-"));
            while ((term3 = termEnum.term()).field().equals("ID") && term3.text().startsWith("AUX-")) {
                int docCount3 = 0;
                TermDocs termDocs3 = reader.termDocs(new Term("ID", term3.text()));
                while (termDocs3.next()) {
                    if (reader.isDeleted(termDocs3.doc())) continue;
                    ++docCount3;
                }
                if (docCount3 > 1) {
                    long txid = Long.parseLong(term3.text().substring(4));
                    indexHealthReport.setDuplicatedAuxInIndex(txid);
                }
                ++auxCount;
                if (termEnum.next()) continue;
            }
            termEnum.close();
            indexHealthReport.setAuxDocCountInIndex(auxCount);
            int errorCount = 0;
            termEnum = reader.terms(new Term("ID", "ERROR-"));
            while ((term2 = termEnum.term()).field().equals("ID") && term2.text().startsWith("ERROR-")) {
                int docCount4 = 0;
                TermDocs termDocs4 = reader.termDocs(new Term("ID", term2.text()));
                while (termDocs4.next()) {
                    if (reader.isDeleted(termDocs4.doc())) continue;
                    ++docCount4;
                }
                if (docCount4 > 1) {
                    long txid = Long.parseLong(term2.text().substring(6));
                    indexHealthReport.setDuplicatedErrorInIndex(txid);
                }
                ++errorCount;
                if (termEnum.next()) continue;
            }
            termEnum.close();
            indexHealthReport.setErrorDocCountInIndex(errorCount);
            int unindexedCount = 0;
            termEnum = reader.terms(new Term("ID", "UNINDEXED-"));
            while ((term = termEnum.term()).field().equals("ID") && term.text().startsWith("UNINDEXED-")) {
                int docCount5 = 0;
                TermDocs termDocs5 = reader.termDocs(new Term("ID", term.text()));
                while (termDocs5.next()) {
                    if (reader.isDeleted(termDocs5.doc())) continue;
                    ++docCount5;
                }
                if (docCount5 > 1) {
                    long txid = Long.parseLong(term.text().substring(10));
                    indexHealthReport.setDuplicatedUnindexedInIndex(txid);
                }
                ++unindexedCount;
                if (termEnum.next()) continue;
            }
            termEnum.close();
            indexHealthReport.setUnindexedDocCountInIndex(unindexedCount);
            indexHealthReport.setLastIndexedCommitTime(this.state.lastIndexedTxCommitTime);
            indexHealthReport.setLastIndexedIdBeforeHoles(this.state.lastIndexedTxIdBeforeHoles);
            IndexHealthReport indexHealthReport2 = indexHealthReport;
            return indexHealthReport2;
        }
        finally {
            refCounted.decref();
        }
    }

    private long getLastTxCommitTimeBeforeHoles(SolrIndexReader reader, Long cutOffTime) throws IOException {
        Long txCommitTime;
        Term term;
        long lastTxCommitTimeBeforeHoles = 0L;
        TermEnum termEnum = reader.terms(new Term("TXCOMMITTIME", ""));
        while ((term = termEnum.term()) != null && term.field().equals("TXCOMMITTIME") && (txCommitTime = Long.valueOf(NumericEncoder.decodeLong((String)term.text()))) < cutOffTime) {
            lastTxCommitTimeBeforeHoles = txCommitTime;
            if (termEnum.next()) continue;
        }
        termEnum.close();
        return lastTxCommitTimeBeforeHoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getErrorDocIds() throws IOException {
        HashSet<Long> errorDocIds = new HashSet<Long>();
        RefCounted refCounted = this.core.getSearcher(false, true, null);
        if (refCounted == null) {
            return errorDocIds;
        }
        try {
            Term term;
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            SolrIndexReader reader = solrIndexSearcher.getReader();
            TermEnum termEnum = reader.terms(new Term("ID", "ERROR-"));
            while ((term = termEnum.term()).field().equals("ID") && term.text().startsWith("ERROR-")) {
                int docCount = 0;
                TermDocs termDocs = reader.termDocs(new Term("ID", term.text()));
                while (termDocs.next()) {
                    if (reader.isDeleted(termDocs.doc())) continue;
                    ++docCount;
                }
                long txid = Long.parseLong(term.text().substring(6));
                errorDocIds.add(txid);
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        finally {
            refCounted.decref();
        }
        return errorDocIds;
    }

    private long getLastChangeSetCommitTimeBeforeHoles(SolrIndexReader reader, Long cutOffTime) throws IOException {
        Long txCommitTime;
        Term term;
        long lastTxCommitTimeBeforeHoles = 0L;
        TermEnum termEnum = reader.terms(new Term("ACLTXCOMMITTIME", ""));
        while ((term = termEnum.term()) != null && term.field().equals("ACLTXCOMMITTIME") && (txCommitTime = Long.valueOf(NumericEncoder.decodeLong((String)term.text()))) < cutOffTime) {
            lastTxCommitTimeBeforeHoles = txCommitTime;
            if (termEnum.next()) continue;
        }
        termEnum.close();
        return lastTxCommitTimeBeforeHoles;
    }

    private long getLargestTxIdByCommitTime(SolrIndexReader reader, Long lastTxCommitTimeBeforeHoles) throws IOException {
        long txid = -1L;
        if (lastTxCommitTimeBeforeHoles != -1L) {
            TermDocs docs = reader.termDocs(new Term("TXCOMMITTIME", NumericEncoder.encode((long)lastTxCommitTimeBeforeHoles)));
            while (docs.next()) {
                long currentTxId;
                Document doc = reader.document(docs.doc());
                Fieldable field = doc.getFieldable("TXID");
                if (field == null || (currentTxId = Long.valueOf(field.stringValue()).longValue()) <= txid) continue;
                txid = currentTxId;
            }
        }
        return txid;
    }

    private long getLargestChangeSetIdByCommitTime(SolrIndexReader reader, Long lastChangeSetCommitTimeBeforeHoles) throws IOException {
        long txid = -1L;
        if (lastChangeSetCommitTimeBeforeHoles != -1L) {
            TermDocs docs = reader.termDocs(new Term("ACLTXCOMMITTIME", NumericEncoder.encode((long)lastChangeSetCommitTimeBeforeHoles)));
            while (docs.next()) {
                long currentTxId;
                Document doc = reader.document(docs.doc());
                Fieldable field = doc.getFieldable("ACLTXID");
                if (field == null || (currentTxId = Long.valueOf(field.stringValue()).longValue()) <= txid) continue;
                txid = currentTxId;
            }
        }
        return txid;
    }

    private long getLastTransactionCommitTime(SolrIndexReader reader) throws IOException {
        long lastTxCommitTime = 0L;
        try {
            Term term;
            TermEnum termEnum = reader.terms(new Term("TXCOMMITTIME", ""));
            while ((term = termEnum.term()) != null && term.field().equals("TXCOMMITTIME")) {
                Long txCommitTime = NumericEncoder.decodeLong((String)term.text());
                lastTxCommitTime = txCommitTime;
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        return lastTxCommitTime;
    }

    private long getLastTransactionId(SolrIndexReader reader) throws IOException {
        long lastTxCommitTime = 0L;
        try {
            Term term;
            TermEnum termEnum = reader.terms(new Term("TXID", ""));
            while ((term = termEnum.term()) != null && term.field().equals("TXID")) {
                Long txCommitTime = NumericEncoder.decodeLong((String)term.text());
                lastTxCommitTime = txCommitTime;
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        return lastTxCommitTime;
    }

    private long getLastChangeSetId(SolrIndexReader reader) throws IOException {
        long lastTxCommitTime = 0L;
        try {
            Term term;
            TermEnum termEnum = reader.terms(new Term("ACLTXID", ""));
            while ((term = termEnum.term()) != null && term.field().equals("ACLTXID")) {
                Long txCommitTime = NumericEncoder.decodeLong((String)term.text());
                lastTxCommitTime = txCommitTime;
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        return lastTxCommitTime;
    }

    private long getLastChangeSetCommitTime(SolrIndexReader reader) throws IOException {
        long lastTxCommitTime = 0L;
        try {
            Term term;
            TermEnum termEnum = reader.terms(new Term("ACLTXCOMMITTIME", ""));
            while ((term = termEnum.term()) != null && term.field().equals("ACLTXCOMMITTIME")) {
                Long txCommitTime = NumericEncoder.decodeLong((String)term.text());
                lastTxCommitTime = txCommitTime;
                if (termEnum.next()) continue;
            }
            termEnum.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        return lastTxCommitTime;
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema, AlfrescoSolrDataModel model) {
        Document out = new Document();
        out.setBoost(doc.getDocumentBoost());
        for (SolrInputField field : doc) {
            String name = field.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            float boost = field.getBoost();
            if (sfield != null && !sfield.multiValued() && field.getValueCount() > 1) {
                String id = "";
                SchemaField sf = schema.getUniqueKeyField();
                if (sf != null) {
                    id = "[" + doc.getFieldValue(sf.getName()) + "] ";
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + id + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + field.getValue());
            }
            boolean hasField = false;
            for (Object v : field) {
                if (v == null) continue;
                String val = null;
                hasField = true;
                boolean isBinaryField = false;
                if (sfield != null && sfield.getType() instanceof BinaryField) {
                    isBinaryField = true;
                    BinaryField binaryField = (BinaryField)sfield.getType();
                    Field f = binaryField.createField(sfield, v, boost);
                    if (f != null) {
                        out.add((Fieldable)f);
                    }
                    used = true;
                } else {
                    if (sfield != null && v instanceof Date && sfield.getType() instanceof DateField) {
                        DateField df = (DateField)sfield.getType();
                        val = df.toInternal((Date)v) + 'Z';
                    } else if (v != null) {
                        val = v.toString();
                    }
                    if (sfield != null) {
                        Field f;
                        if (v instanceof Reader) {
                            used = true;
                            f = new Field(field.getName(), (Reader)v, model.getFieldTermVec(sfield));
                            f.setOmitNorms(model.getOmitNorms(sfield));
                            f.setOmitTermFreqAndPositions(sfield.omitTf());
                            if (f != null) {
                                out.add((Fieldable)f);
                            }
                        } else {
                            used = true;
                            f = sfield.createField(val, boost);
                            if (f != null) {
                                out.add((Fieldable)f);
                            }
                        }
                    }
                }
                List copyFields = schema.getCopyFieldsList(name);
                for (CopyField cf : copyFields) {
                    SchemaField destinationField = cf.getDestination();
                    if (!destinationField.multiValued() && out.get(destinationField.getName()) != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + val);
                    }
                    used = true;
                    Field f = null;
                    if (isBinaryField) {
                        if (destinationField.getType() instanceof BinaryField) {
                            BinaryField binaryField = (BinaryField)destinationField.getType();
                            f = binaryField.createField(destinationField, v, boost);
                        }
                    } else {
                        f = destinationField.createField(cf.getLimitedValue(val), boost);
                    }
                    if (f == null) continue;
                    out.add((Fieldable)f);
                }
                boost = 1.0f;
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR:unknown field '" + name + "'");
        }
        for (SolrInputField field : schema.getRequiredFields()) {
            if (out.getField(field.getName()) != null) continue;
            if (field.getDefaultValue() != null) {
                out.add((Fieldable)field.createField(field.getDefaultValue(), 1.0f));
                continue;
            }
            String id = schema.printableUniqueKey(out);
            String msg = "Document [" + id + "] missing required field: " + field.getName();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return out;
    }

    protected int getRegisteredSearcherCount() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.core.getInfoRegistry().keySet()) {
            SolrInfoMBean mBean = (SolrInfoMBean)this.core.getInfoRegistry().get(key);
            if (mBean == null || !mBean.getName().equals(SolrIndexSearcher.class.getName()) || key.equals("searcher")) continue;
            keys.add(key);
        }
        log.info(".... registered Searchers for " + this.core.getName() + " = " + keys.size());
        return keys.size();
    }

    protected List<SolrIndexSearcher> getRegisteredSearchers() {
        ArrayList<SolrIndexSearcher> searchers = new ArrayList<SolrIndexSearcher>();
        for (String key : this.core.getInfoRegistry().keySet()) {
            SolrInfoMBean mBean = (SolrInfoMBean)this.core.getInfoRegistry().get(key);
            if (mBean == null || !mBean.getName().equals(SolrIndexSearcher.class.getName()) || key.equals("searcher")) continue;
            searchers.add((SolrIndexSearcher)mBean);
        }
        return searchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeReport checkNodeCommon(NodeReport nodeReport) {
        long dbid = nodeReport.getDbid();
        try {
            RefCounted refCounted = this.core.getSearcher(false, true, null);
            refCounted = this.core.getSearcher(false, true, null);
            if (refCounted == null) {
                return nodeReport;
            }
            try {
                SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
                String dbidString = NumericEncoder.encode((long)dbid);
                DocSet docSet = solrIndexSearcher.getDocSet((Query)new TermQuery(new Term("DBID", dbidString)));
                DocIterator it = docSet.iterator();
                while (it.hasNext()) {
                    String value;
                    int doc = it.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("ID");
                    if (fieldable == null || (value = fieldable.stringValue()) == null) continue;
                    if (value.startsWith("LEAF-")) {
                        nodeReport.setIndexLeafDoc(Long.valueOf(doc));
                        continue;
                    }
                    if (!value.startsWith("AUX-")) continue;
                    nodeReport.setIndexAuxDoc(Long.valueOf(doc));
                }
                DocSet txDocSet = solrIndexSearcher.getDocSet((Query)new WildcardQuery(new Term("TXID", "*")));
                DocIterator it2 = txDocSet.iterator();
                while (it2.hasNext()) {
                    long txid;
                    String value;
                    int doc = it2.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("TXID");
                    if (fieldable == null) continue;
                    if (nodeReport.getIndexLeafDoc() == null || (long)doc < nodeReport.getIndexLeafDoc()) {
                        value = fieldable.stringValue();
                        txid = Long.parseLong(value);
                        nodeReport.setIndexLeafTx(txid);
                    }
                    if (nodeReport.getIndexAuxDoc() != null && (long)doc >= nodeReport.getIndexAuxDoc()) continue;
                    value = fieldable.stringValue();
                    txid = Long.parseLong(value);
                    nodeReport.setIndexAuxTx(txid);
                }
            }
            finally {
                refCounted.decref();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return nodeReport;
    }

    public NodeReport checkNode(Node node) {
        NodeReport nodeReport = new NodeReport();
        nodeReport.setDbid(node.getId());
        nodeReport.setDbNodeStatus(node.getStatus());
        nodeReport.setDbTx(node.getTxnId());
        this.checkNodeCommon(nodeReport);
        return nodeReport;
    }

    public NodeReport checkNode(Long dbid) {
        NodeReport nodeReport = new NodeReport();
        nodeReport.setDbid(dbid);
        GetNodesParameters parameters = new GetNodesParameters();
        parameters.setFromNodeId(dbid);
        parameters.setToNodeId(dbid);
        try {
            List<Node> dbnodes = this.client.getNodes(parameters, 1);
            if (dbnodes.size() == 1) {
                Node dbnode = dbnodes.get(0);
                nodeReport.setDbNodeStatus(dbnode.getStatus());
                nodeReport.setDbTx(dbnode.getTxnId());
            } else {
                nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
                nodeReport.setDbTx(-1L);
            }
        }
        catch (IOException e) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(-2L);
        }
        catch (JSONException e) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(-3L);
        }
        catch (AuthenticationException e1) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(-4L);
        }
        this.checkNodeCommon(nodeReport);
        return nodeReport;
    }

    public List<Node> getFullNodesForDbTransaction(Long txid) {
        try {
            GetNodesParameters gnp = new GetNodesParameters();
            ArrayList<Long> txs = new ArrayList<Long>();
            txs.add(txid);
            gnp.setTransactionIds(txs);
            gnp.setStoreProtocol(this.storeRef.getProtocol());
            gnp.setStoreIdentifier(this.storeRef.getIdentifier());
            return this.client.getNodes(gnp, Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", (Throwable)e);
        }
    }

    public List<Long> getAclsForDbAclTransaction(Long acltxid) {
        try {
            ArrayList<Long> answer = new ArrayList<Long>();
            AclChangeSets changeSet = this.client.getAclChangeSets(null, acltxid, null, acltxid + 1L, 1);
            List<Acl> acls = this.client.getAcls(changeSet.getAclChangeSets(), null, Integer.MAX_VALUE);
            for (Acl acl : acls) {
                answer.add(acl.getId());
            }
            return answer;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", (Throwable)e);
        }
        catch (JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AclReport checkAcl(Long aclid) {
        AclReport aclReport = new AclReport();
        aclReport.setAclId(aclid);
        try {
            List<AclReaders> readers = this.client.getAclReaders(Collections.singletonList(new Acl(0L, aclid)));
            aclReport.setExistsInDb(readers.size() == 1);
        }
        catch (IOException e) {
            aclReport.setExistsInDb(false);
        }
        catch (JSONException e) {
            aclReport.setExistsInDb(false);
        }
        catch (AuthenticationException e) {
            aclReport.setExistsInDb(false);
        }
        try {
            RefCounted refCounted = this.core.getSearcher(false, true, null);
            refCounted = this.core.getSearcher(false, true, null);
            if (refCounted == null) {
                return aclReport;
            }
            try {
                SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
                SolrIndexReader reader = solrIndexSearcher.getReader();
                String aclIdString = NumericEncoder.encode((long)aclid);
                DocSet docSet = solrIndexSearcher.getDocSet((Query)new TermQuery(new Term("ACLID", aclIdString)));
                DocIterator it = docSet.iterator();
                while (it.hasNext()) {
                    String value;
                    int doc = it.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("ID");
                    if (fieldable == null || (value = fieldable.stringValue()) == null || !value.startsWith("ACL-")) continue;
                    aclReport.setIndexAclDoc(Long.valueOf(doc));
                }
                DocSet txDocSet = solrIndexSearcher.getDocSet((Query)new WildcardQuery(new Term("ACLTXID", "*")));
                DocIterator it2 = txDocSet.iterator();
                while (it2.hasNext()) {
                    int doc = it2.nextDoc();
                    Document document = solrIndexSearcher.doc(doc);
                    Fieldable fieldable = document.getFieldable("ACLTXID");
                    if (fieldable == null || aclReport.getIndexAclDoc() != null && (long)doc >= aclReport.getIndexAclDoc()) continue;
                    String value = fieldable.stringValue();
                    long acltxid = Long.parseLong(value);
                    aclReport.setIndexAclTx(acltxid);
                }
            }
            finally {
                refCounted.decref();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return aclReport;
    }

    private void loadModel(Map<String, M2Model> modelMap, HashSet<String> loadedModels, M2Model model, AlfrescoSolrDataModel dataModel) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel, dataModel);
            }
            if (dataModel.putModel(model)) {
                loadedModels.add(modelName);
            }
            log.info("Loading model " + model.getName());
        }
    }

    private String getModelFileName(M2Model model) {
        return model.getName().replace(":", ".") + "." + model.getChecksum(ModelDefinition.XMLBindingType.DEFAULT) + ".xml";
    }

    public void close(SolrCore core) {
        try {
            this.shutdown = true;
            this.adminHandler.getScheduler().deleteJob("CoreTracker-" + core.getName(), "Solr");
            this.adminHandler.getTrackers().remove(core.getName());
            if (this.adminHandler.getTrackers().size() == 0 && !this.adminHandler.getScheduler().isShutdown()) {
                this.adminHandler.getScheduler().pauseAll();
                this.adminHandler.getScheduler().shutdown();
            }
            this.client.close();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedList<Object> getCoreStats() throws IOException {
        DecimalFormat df = new DecimalFormat("###,###.######");
        SimpleOrderedMap coreSummary = new SimpleOrderedMap();
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            OpenBitSet allLeafDocs = (OpenBitSet)solrIndexSearcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ALL_LEAF_DOCS);
            long count = allLeafDocs.cardinality();
            coreSummary.add("Alfresco Nodes in Index", (Object)count);
            coreSummary.add("Searcher", (Object)solrIndexSearcher.getStatistics());
            Map infoRegistry = this.core.getInfoRegistry();
            for (String key : infoRegistry.keySet()) {
                SolrInfoMBean infoMBean = (SolrInfoMBean)infoRegistry.get(key);
                if (key.equals("/alfresco")) {
                    coreSummary.add("/alfresco", this.fixStats((NamedList<Object>)infoMBean.getStatistics()));
                }
                if (key.equals("/afts")) {
                    coreSummary.add("/afts", this.fixStats((NamedList<Object>)infoMBean.getStatistics()));
                }
                if (key.equals("/cmis")) {
                    coreSummary.add("/cmis", this.fixStats((NamedList<Object>)infoMBean.getStatistics()));
                }
                if (key.equals("filterCache")) {
                    coreSummary.add("/filterCache", (Object)infoMBean.getStatistics());
                }
                if (key.equals("queryResultCache")) {
                    coreSummary.add("/queryResultCache", (Object)infoMBean.getStatistics());
                }
                if (key.equals("alfrescoAuthorityCache")) {
                    coreSummary.add("/alfrescoAuthorityCache", (Object)infoMBean.getStatistics());
                }
                if (!key.equals("alfrescoPathCache")) continue;
                coreSummary.add("/alfrescoPathCache", (Object)infoMBean.getStatistics());
            }
            long memory = 0L;
            int searcherCount = 0;
            List<SolrIndexSearcher> searchers = this.getRegisteredSearchers();
            for (SolrIndexSearcher searcher : searchers) {
                memory += this.addSearcherStats((NamedList<Object>)coreSummary, searcher, searcherCount);
                ++searcherCount;
            }
            coreSummary.add("Number of Searchers", (Object)searchers.size());
            coreSummary.add("Total Searcher Cache (GB)", (Object)df.format((float)memory / 1024.0f / 1024.0f / 1024.0f));
            IndexDeletionPolicyWrapper delPolicy = this.core.getDeletionPolicy();
            IndexCommit indexCommit = delPolicy.getLatestCommit();
            if (indexCommit == null) {
                indexCommit = solrIndexSearcher.getReader().getIndexCommit();
            }
            if (indexCommit != null) {
                delPolicy.setReserveDuration(Long.valueOf(indexCommit.getVersion()), 20000L);
                Long fileSize = 0L;
                File dir = new File(solrIndexSearcher.getIndexDir());
                for (String name : indexCommit.getFileNames()) {
                    File file = new File(dir, name);
                    if (!file.exists()) continue;
                    fileSize = fileSize + file.length();
                }
                coreSummary.add("On disk (GB)", (Object)df.format((float)fileSize.longValue() / 1024.0f / 1024.0f / 1024.0f));
                coreSummary.add("Per node B", (Object)(count > 0L ? fileSize / count : 0L));
            }
        }
        finally {
            if (refCounted != null) {
                refCounted.decref();
            }
        }
        return coreSummary;
    }

    private long addSearcherStats(NamedList<Object> coreSummary, SolrIndexSearcher solrIndexSearcher, int index) {
        DecimalFormat df = new DecimalFormat("###,###.######");
        OpenBitSet allLeafDocs = (OpenBitSet)solrIndexSearcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ALL_LEAF_DOCS);
        long count = allLeafDocs.cardinality();
        ResizeableArrayList indexedByDocId = (ResizeableArrayList)solrIndexSearcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_DOC_ID);
        ResizeableArrayList indexedOderedByAclIdThenDoc = (ResizeableArrayList)solrIndexSearcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_ACL_ID_THEN_LEAF);
        long memory = count * 40L + (long)(indexedByDocId.size() * 8 * 4) + (long)(indexedOderedByAclIdThenDoc.size() * 8 * 2);
        SimpleOrderedMap details = new SimpleOrderedMap();
        details.add("Searcher", (Object)solrIndexSearcher.getStatistics());
        details.add("Size", (Object)indexedByDocId.size());
        details.add("Node Count", (Object)count);
        details.add("Memory (GB)", (Object)df.format((float)(memory += (long)((this.filterCacheSize + this.pathCacheSize + this.authorityCacheSize) * indexedByDocId.size() / 8)) / 1024.0f / 1024.0f / 1024.0f));
        coreSummary.add("Searcher-" + index, (Object)details);
        return memory;
    }

    private NamedList<Object> fixStats(NamedList<Object> namedList) {
        int sz = namedList.size();
        for (int i = 0; i < sz; ++i) {
            Number number;
            String key = namedList.getName(i);
            Object value = namedList.getVal(i);
            if (!(value instanceof Number) || !Float.isInfinite((number = (Number)value).floatValue()) && !Float.isNaN(number.floatValue()) && !Double.isInfinite(number.doubleValue()) && !Double.isNaN(number.doubleValue())) continue;
            namedList.setVal(i, null);
        }
        return namedList;
    }

    public static class IndexTrackingShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = -1294455847013444397L;
    }

    static class BoundedDeque<T>
    implements Iterable<T> {
        private LinkedBlockingDeque<T> deque;
        private int max = 10;

        BoundedDeque(int max) {
            this.max = max;
            this.deque = new LinkedBlockingDeque();
        }

        public int size() {
            return this.deque.size();
        }

        void add(T add) {
            while (this.deque.size() > this.max - 1) {
                this.deque.removeLast();
            }
            this.deque.addFirst(add);
        }

        T getLast() {
            return this.deque.getFirst();
        }

        @Override
        public Iterator<T> iterator() {
            return this.deque.iterator();
        }
    }

    static class TrackerState {
        volatile long lastChangeSetIdOnServer;
        volatile long lastChangeSetCommitTimeOnServer;
        volatile long lastIndexedChangeSetId;
        volatile long lastIndexedTxCommitTime = 0L;
        volatile long lastIndexedTxId = 0L;
        volatile long lastIndexedChangeSetCommitTime = 0L;
        volatile long lastTxCommitTimeOnServer = 0L;
        volatile long lastTxIdOnServer = 0L;
        volatile long lastIndexedTxIdBeforeHoles = -1L;
        volatile long lastIndexedChangeSetIdBeforeHoles = -1L;
        volatile boolean running = false;
        volatile boolean checkedFirstTransactionTime = false;
        volatile boolean check = false;
        long timeToStopIndexing;
        long lastGoodChangeSetCommitTimeInIndex;
        long lastGoodTxCommitTimeInIndex;
        long timeBeforeWhichThereCanBeNoHoles;

        TrackerState() {
        }
    }
}

