/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.util.Pair;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;

public abstract class CollectionUtils {
    public static final Function<Object, String> TO_STRING_TRANSFORMER = new Function<Object, String>(){

        @Override
        public String apply(Object value) {
            return value.toString();
        }
    };

    public static boolean isEmpty(Map<?, ?> map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static boolean isEmpty(Collection<?> items) {
        if (items == null) {
            return true;
        }
        return items.isEmpty();
    }

    public static <T> Set<T> nullSafeMerge(Set<T> first, Set<T> second) {
        return CollectionUtils.nullSafeMerge(first, second, false);
    }

    public static <T> Set<T> nullSafeMerge(Set<T> first, Set<T> second, boolean emptyResultIsNull) {
        HashSet<T> result = new HashSet<T>();
        if (first != null) {
            result.addAll(first);
        }
        if (second != null) {
            result.addAll(second);
        }
        if (result.isEmpty() && emptyResultIsNull) {
            result = null;
        }
        return result;
    }

    public static <K, V> Map<K, V> nullSafeMerge(Map<K, V> first, Map<K, V> second) {
        return CollectionUtils.nullSafeMerge(first, second, false);
    }

    public static <K, V> Map<K, V> nullSafeMerge(Map<K, V> first, Map<K, V> second, boolean emptyResultIsNull) {
        HashMap<K, V> result = new HashMap<K, V>();
        if (first != null) {
            result.putAll(first);
        }
        if (second != null) {
            result.putAll(second);
        }
        if (result.isEmpty() && emptyResultIsNull) {
            result = null;
        }
        return result;
    }

    public static <T> List<T> nullSafeAppend(List<T> first, List<T> second) {
        return CollectionUtils.nullSafeAppend(first, second, false);
    }

    public static <T> List<T> nullSafeAppend(List<T> first, List<T> second, boolean emptyResultIsNull) {
        ArrayList<T> result = new ArrayList<T>();
        if (first != null) {
            result.addAll(first);
        }
        if (second != null) {
            result.addAll(second);
        }
        if (result.isEmpty() && emptyResultIsNull) {
            result = null;
        }
        return result;
    }

    public static <F, T> List<T> transform(Collection<F> values, Function<? super F, ? extends T> transformer) {
        if (values == null || values.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> results = new ArrayList<T>(values.size());
        for (F value : values) {
            T result = transformer.apply(value);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public static <F, T, V> Map<T, V> transformKeys(Map<F, V> map, Function<? super F, ? extends T> transformer) {
        if (map == null || map.isEmpty()) {
            return new HashMap();
        }
        HashMap<T, V> results = new HashMap<T, V>(map.size());
        for (Map.Entry<F, V> entry : map.entrySet()) {
            T transformedKey = transformer.apply(entry.getKey());
            results.put(transformedKey, entry.getValue());
        }
        return results;
    }

    public static <F, T> List<T> transform(Function<? super F, ? extends T> transformer, F ... values) {
        if (values == null || values.length < 1) {
            return new ArrayList();
        }
        ArrayList<T> results = new ArrayList<T>(values.length);
        for (F value : values) {
            T result = transformer.apply(value);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public static List<String> toListOfStrings(Collection<?> values) {
        return CollectionUtils.transform(values, TO_STRING_TRANSFORMER);
    }

    public static <T> Set<T> asSet(Class<T> clazz, Object ... objects) {
        HashSet<Object> result = new HashSet<Object>();
        Object[] arr$ = objects;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object obj;
            Object cast = obj = arr$[i$];
            result.add(cast);
        }
        return result;
    }

    public static <T> List<T> filter(Collection<T> values, final Function<? super T, Boolean> filter) {
        return CollectionUtils.transform(values, new Function<T, T>(){

            @Override
            public T apply(T value) {
                if (((Boolean)filter.apply(value)).booleanValue()) {
                    return value;
                }
                return null;
            }
        });
    }

    public static <T> List<T> flatten(Collection<? extends Collection<? extends T>> values) {
        ArrayList<T> results = new ArrayList<T>();
        for (Collection<T> collection : values) {
            results.addAll(collection);
        }
        return results;
    }

    public static <F, T> List<T> transformFlat(Collection<F> values, Function<? super F, ? extends Collection<? extends T>> transformer) {
        return CollectionUtils.flatten(CollectionUtils.transform(values, transformer));
    }

    public static <T> T findFirst(Collection<T> values, Function<? super T, Boolean> acceptor) {
        if (values != null) {
            for (T value : values) {
                if (!acceptor.apply(value).booleanValue()) continue;
                return value;
            }
        }
        return null;
    }

    public static <T> Set<T> unmodifiableSet(T ... values) {
        return CollectionUtils.unmodifiableSet(Arrays.asList(values));
    }

    public static <T> Set<T> unmodifiableSet(Collection<T> values) {
        TreeSet<T> set = new TreeSet<T>(values);
        return Collections.unmodifiableSet(set);
    }

    public static <F, T> Map<F, T> transformToMap(Collection<F> values, Function<F, T> transformer) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap<F, T> results = new HashMap<F, T>(values.size());
        for (F value : values) {
            T result = transformer.apply(value);
            results.put(value, result);
        }
        return results;
    }

    public static <K, V> Map<K, V> filterKeys(Map<K, V> map, Function<? super K, ? extends Boolean> filter) {
        HashMap<K, V> results = new HashMap<K, V>();
        Set<Map.Entry<K, V>> entries = map.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            K key = entry.getKey();
            if (!filter.apply(key).booleanValue()) continue;
            results.put(key, entry.getValue());
        }
        return results;
    }

    public static <FK, FV, TK, TV> Map<TK, TV> transform(Map<FK, FV> map, Function<Map.Entry<FK, FV>, Pair<TK, TV>> transformer) {
        HashMap<TK, TV> results = new HashMap<TK, TV>(map.size());
        for (Map.Entry<FK, FV> entry : map.entrySet()) {
            TK key;
            Pair<TK, TV> pair = transformer.apply(entry);
            if (pair == null || (key = pair.getFirst()) == null) continue;
            results.put(key, pair.getSecond());
        }
        return results;
    }

    public static <T> Filter<T> containsFilter(final Collection<T> values) {
        return new Filter<T>(){

            @Override
            public Boolean apply(T value) {
                return values.contains(value);
            }
        };
    }

    public static <T> List<T> intersect(List<? extends T> list1, List<? extends T> list2) {
        if (list1 == null || list1.isEmpty() || list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(list1);
        result.retainAll(list2);
        return result;
    }

    public static <K, V> Map<K, V> intersect(Map<K, V> map1, Map<K, V> map2) {
        if (map1 == null || map1.isEmpty() || map2 == null || map2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> item : map1.entrySet()) {
            V value = map2.get(item.getKey());
            if (value == null || !value.equals(item.getValue())) continue;
            result.put(item.getKey(), item.getValue());
        }
        return result;
    }

    public static <T> Set<T> intersect(Set<? extends T> set1, Set<? extends T> set2) {
        if (set1 == null || set1.isEmpty() || set2 == null || set2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<T> result = new HashSet<T>();
        result.addAll(set1);
        result.retainAll(set2);
        return result;
    }
}

