/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperMethod {
    private SqlSession sqlSession;
    private Configuration config;
    private SqlCommandType type;
    private String commandName;
    private Class<?> declaringInterface;
    private Method method;
    private boolean returnsList;
    private boolean returnsMap;
    private String mapKey;
    private Integer rowBoundsIndex;
    private List<String> paramNames = new ArrayList<String>();
    private List<Integer> paramPositions = new ArrayList<Integer>();
    private boolean hasNamedParameters;

    public MapperMethod(Class<?> declaringInterface, Method method, SqlSession sqlSession) {
        this.sqlSession = sqlSession;
        this.method = method;
        this.config = sqlSession.getConfiguration();
        this.hasNamedParameters = false;
        this.declaringInterface = declaringInterface;
        this.setupFields();
        this.setupMethodSignature();
        this.setupCommandType();
        this.validateStatement();
    }

    public Object execute(Object[] args) {
        Object result;
        if (SqlCommandType.INSERT == this.type) {
            Object param = this.getParam(args);
            result = this.sqlSession.insert(this.commandName, param);
        } else if (SqlCommandType.UPDATE == this.type) {
            Object param = this.getParam(args);
            result = this.sqlSession.update(this.commandName, param);
        } else if (SqlCommandType.DELETE == this.type) {
            Object param = this.getParam(args);
            result = this.sqlSession.delete(this.commandName, param);
        } else if (SqlCommandType.SELECT == this.type) {
            if (this.returnsList) {
                result = this.executeForList(args);
            } else if (this.returnsMap) {
                result = this.executeForMap(args);
            } else {
                Object param = this.getParam(args);
                result = this.sqlSession.selectOne(this.commandName, param);
            }
        } else {
            throw new BindingException("Unkown execution method for: " + this.commandName);
        }
        return result;
    }

    private List executeForList(Object[] args) {
        List result;
        Object param = this.getParam(args);
        if (this.rowBoundsIndex != null) {
            RowBounds rowBounds = (RowBounds)args[this.rowBoundsIndex];
            result = this.sqlSession.selectList(this.commandName, param, rowBounds);
        } else {
            result = this.sqlSession.selectList(this.commandName, param);
        }
        return result;
    }

    private Map executeForMap(Object[] args) {
        Map result;
        Object param = this.getParam(args);
        if (this.rowBoundsIndex != null) {
            RowBounds rowBounds = (RowBounds)args[this.rowBoundsIndex];
            result = this.sqlSession.selectMap(this.commandName, param, this.mapKey, rowBounds);
        } else {
            result = this.sqlSession.selectMap(this.commandName, param, this.mapKey);
        }
        return result;
    }

    private Object getParam(Object[] args) {
        int paramCount = this.paramPositions.size();
        if (args == null || paramCount == 0) {
            return null;
        }
        if (!this.hasNamedParameters && paramCount == 1) {
            return args[this.paramPositions.get(0)];
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        for (int i = 0; i < paramCount; ++i) {
            param.put(this.paramNames.get(i), args[this.paramPositions.get(i)]);
        }
        return param;
    }

    private void setupFields() {
        this.commandName = this.declaringInterface.getName() + "." + this.method.getName();
    }

    private void setupMethodSignature() {
        MapKey mapKeyAnnotation;
        if (List.class.isAssignableFrom(this.method.getReturnType())) {
            this.returnsList = true;
        }
        if (Map.class.isAssignableFrom(this.method.getReturnType()) && (mapKeyAnnotation = this.method.getAnnotation(MapKey.class)) != null) {
            this.mapKey = mapKeyAnnotation.value();
            this.returnsMap = true;
        }
        Class<?>[] argTypes = this.method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (RowBounds.class.isAssignableFrom(argTypes[i])) {
                this.rowBoundsIndex = i;
                continue;
            }
            String paramName = String.valueOf(this.paramPositions.size());
            paramName = this.getParamNameFromAnnotation(i, paramName);
            this.paramNames.add(paramName);
            this.paramPositions.add(i);
        }
    }

    private String getParamNameFromAnnotation(int i, String paramName) {
        Annotation[] paramAnnos = this.method.getParameterAnnotations()[i];
        for (int j = 0; j < paramAnnos.length; ++j) {
            if (!(paramAnnos[j] instanceof Param)) continue;
            this.hasNamedParameters = true;
            paramName = ((Param)paramAnnos[j]).value();
        }
        return paramName;
    }

    private void setupCommandType() {
        MappedStatement ms = this.config.getMappedStatement(this.commandName);
        this.type = ms.getSqlCommandType();
        if (this.type == SqlCommandType.UNKNOWN) {
            throw new BindingException("Unknown execution method for: " + this.commandName);
        }
    }

    private void validateStatement() {
        try {
            this.config.getMappedStatement(this.commandName);
        }
        catch (Exception e) {
            throw new BindingException("Invalid bound statement (not found): " + this.commandName, e);
        }
    }
}

