/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.ognl.ClassResolver;
import org.apache.ibatis.ognl.Evaluation;
import org.apache.ibatis.ognl.ExpressionSyntaxException;
import org.apache.ibatis.ognl.MemberAccess;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.ParseException;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.TokenMgrError;
import org.apache.ibatis.ognl.TypeConverter;

public abstract class Ognl {
    private static final Map<String, Node> expressionCache = new ConcurrentHashMap<String, Node>();
    private static final ReentrantReadWriteLock.ReadLock readLock;
    private static final ReentrantReadWriteLock.WriteLock writeLock;

    static {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        readLock = rwLock.readLock();
        writeLock = rwLock.writeLock();
    }

    private static Node cacheExpression(String expression) throws ParseException {
        try {
            Node node = new OgnlParser(new StringReader(expression)).topLevelExpression();
            writeLock.lock();
            expressionCache.put(expression, node);
            Node node2 = node;
            return node2;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Object parseExpression(String expression) throws OgnlException {
        try {
            Node node = null;
            try {
                readLock.lock();
                node = expressionCache.get(expression);
            }
            finally {
                readLock.unlock();
            }
            if (node == null) {
                node = Ognl.cacheExpression(expression);
            }
            return node;
        }
        catch (ParseException e) {
            throw new ExpressionSyntaxException(expression, e);
        }
        catch (TokenMgrError e) {
            throw new ExpressionSyntaxException(expression, e);
        }
    }

    public static Map createDefaultContext(Object root) {
        return Ognl.addDefaultContext(root, null, null, null, new OgnlContext());
    }

    public static Map createDefaultContext(Object root, ClassResolver classResolver) {
        return Ognl.addDefaultContext(root, classResolver, null, null, new OgnlContext());
    }

    public static Map createDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter) {
        return Ognl.addDefaultContext(root, classResolver, converter, null, new OgnlContext());
    }

    public static Map createDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter, MemberAccess memberAccess) {
        return Ognl.addDefaultContext(root, classResolver, converter, memberAccess, new OgnlContext());
    }

    public static Map addDefaultContext(Object root, Map context) {
        return Ognl.addDefaultContext(root, null, null, null, context);
    }

    public static Map addDefaultContext(Object root, ClassResolver classResolver, Map context) {
        return Ognl.addDefaultContext(root, classResolver, null, null, context);
    }

    public static Map addDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter, Map context) {
        return Ognl.addDefaultContext(root, classResolver, converter, null, context);
    }

    public static Map addDefaultContext(Object root, ClassResolver classResolver, TypeConverter converter, MemberAccess memberAccess, Map context) {
        OgnlContext result;
        if (!(context instanceof OgnlContext)) {
            result = new OgnlContext();
            result.setValues(context);
        } else {
            result = (OgnlContext)context;
        }
        if (classResolver != null) {
            result.setClassResolver(classResolver);
        }
        if (converter != null) {
            result.setTypeConverter(converter);
        }
        if (memberAccess != null) {
            result.setMemberAccess(memberAccess);
        }
        result.setRoot(root);
        return result;
    }

    public static void setClassResolver(Map context, ClassResolver classResolver) {
        context.put("_classResolver", classResolver);
    }

    public static ClassResolver getClassResolver(Map context) {
        return (ClassResolver)context.get("_classResolver");
    }

    public static void setTypeConverter(Map context, TypeConverter converter) {
        context.put("_typeConverter", converter);
    }

    public static TypeConverter getTypeConverter(Map context) {
        return (TypeConverter)context.get("_typeConverter");
    }

    public static void setMemberAccess(Map context, MemberAccess memberAccess) {
        context.put("_memberAccess", memberAccess);
    }

    public static MemberAccess getMemberAccess(Map context) {
        return (MemberAccess)context.get("_memberAccess");
    }

    public static void setRoot(Map context, Object root) {
        context.put("root", root);
    }

    public static Object getRoot(Map context) {
        return context.get("root");
    }

    public static Evaluation getLastEvaluation(Map context) {
        return (Evaluation)context.get("_lastEvaluation");
    }

    public static Object getValue(Object tree, Map context, Object root) throws OgnlException {
        return Ognl.getValue(tree, context, root, null);
    }

    public static Object getValue(Object tree, Map context, Object root, Class resultType) throws OgnlException {
        OgnlContext ognlContext = (OgnlContext)Ognl.addDefaultContext(root, context);
        Object result = ((Node)tree).getValue(ognlContext, root);
        if (resultType != null) {
            result = Ognl.getTypeConverter(context).convertValue(context, root, null, null, result, resultType);
        }
        return result;
    }

    public static Object getValue(String expression, Map context, Object root) throws OgnlException {
        return Ognl.getValue(expression, context, root, null);
    }

    public static Object getValue(String expression, Map context, Object root, Class resultType) throws OgnlException {
        return Ognl.getValue(Ognl.parseExpression(expression), context, root, resultType);
    }

    public static Object getValue(Object tree, Object root) throws OgnlException {
        return Ognl.getValue(tree, root, null);
    }

    public static Object getValue(Object tree, Object root, Class resultType) throws OgnlException {
        return Ognl.getValue(tree, Ognl.createDefaultContext(root), root, resultType);
    }

    public static Object getValue(String expression, Object root) throws OgnlException {
        return Ognl.getValue(expression, root, null);
    }

    public static Object getValue(String expression, Object root, Class resultType) throws OgnlException {
        return Ognl.getValue(Ognl.parseExpression(expression), root, resultType);
    }

    public static void setValue(Object tree, Map context, Object root, Object value) throws OgnlException {
        OgnlContext ognlContext = (OgnlContext)Ognl.addDefaultContext(root, context);
        Node n = (Node)tree;
        n.setValue(ognlContext, root, value);
    }

    public static void setValue(String expression, Map context, Object root, Object value) throws OgnlException {
        Ognl.setValue(Ognl.parseExpression(expression), context, root, value);
    }

    public static void setValue(Object tree, Object root, Object value) throws OgnlException {
        Ognl.setValue(tree, Ognl.createDefaultContext(root), root, value);
    }

    public static void setValue(String expression, Object root, Object value) throws OgnlException {
        Ognl.setValue(Ognl.parseExpression(expression), root, value);
    }

    public static boolean isConstant(Object tree, Map context) throws OgnlException {
        return ((SimpleNode)tree).isConstant((OgnlContext)Ognl.addDefaultContext(null, context));
    }

    public static boolean isConstant(String expression, Map context) throws OgnlException {
        return Ognl.isConstant(Ognl.parseExpression(expression), context);
    }

    public static boolean isConstant(Object tree) throws OgnlException {
        return Ognl.isConstant(tree, Ognl.createDefaultContext(null));
    }

    public static boolean isConstant(String expression) throws OgnlException {
        return Ognl.isConstant(Ognl.parseExpression(expression), Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleProperty(Object tree, Map context) throws OgnlException {
        return ((SimpleNode)tree).isSimpleProperty((OgnlContext)Ognl.addDefaultContext(null, context));
    }

    public static boolean isSimpleProperty(String expression, Map context) throws OgnlException {
        return Ognl.isSimpleProperty(Ognl.parseExpression(expression), context);
    }

    public static boolean isSimpleProperty(Object tree) throws OgnlException {
        return Ognl.isSimpleProperty(tree, Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleProperty(String expression) throws OgnlException {
        return Ognl.isSimpleProperty(Ognl.parseExpression(expression), Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleNavigationChain(Object tree, Map context) throws OgnlException {
        return ((SimpleNode)tree).isSimpleNavigationChain((OgnlContext)Ognl.addDefaultContext(null, context));
    }

    public static boolean isSimpleNavigationChain(String expression, Map context) throws OgnlException {
        return Ognl.isSimpleNavigationChain(Ognl.parseExpression(expression), context);
    }

    public static boolean isSimpleNavigationChain(Object tree) throws OgnlException {
        return Ognl.isSimpleNavigationChain(tree, Ognl.createDefaultContext(null));
    }

    public static boolean isSimpleNavigationChain(String expression) throws OgnlException {
        return Ognl.isSimpleNavigationChain(Ognl.parseExpression(expression), Ognl.createDefaultContext(null));
    }

    private Ognl() {
    }
}

