/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public final class CJKTokenizer
extends Tokenizer {
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 256;
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private final char[] buffer = new char[255];
    private final char[] ioBuffer = new char[256];
    private String tokenType = "word";
    private boolean preIsTokened = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CJKTokenizer(Reader in) {
        this.input = in;
    }

    public final Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        int length = 0;
        int start = this.offset;
        while (true) {
            char c;
            Character.UnicodeBlock ub;
            ++this.offset;
            if (this.bufferIndex >= this.dataLen) {
                this.dataLen = this.input.read(this.ioBuffer);
                this.bufferIndex = 0;
            }
            if (this.dataLen == -1) {
                if (length > 0) {
                    if (!this.preIsTokened) break;
                    length = 0;
                    this.preIsTokened = false;
                    break;
                }
                return null;
            }
            if ((ub = Character.UnicodeBlock.of(c = this.ioBuffer[this.bufferIndex++])) == Character.UnicodeBlock.BASIC_LATIN || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                    char i = c;
                    c = i -= 65248;
                }
                if (Character.isLetterOrDigit(c) || c == '_' || c == '+' || c == '#') {
                    if (length == 0) {
                        start = this.offset - 1;
                    } else if (this.tokenType == "double") {
                        --this.offset;
                        --this.bufferIndex;
                        this.tokenType = "single";
                        if (!this.preIsTokened) break;
                        length = 0;
                        this.preIsTokened = false;
                        break;
                    }
                    this.buffer[length++] = Character.toLowerCase(c);
                    this.tokenType = "single";
                    if (length != 255) continue;
                    break;
                }
                if (length <= 0) continue;
                if (!this.preIsTokened) break;
                length = 0;
                this.preIsTokened = false;
                continue;
            }
            if (Character.isLetter(c)) {
                if (length == 0) {
                    start = this.offset - 1;
                    this.buffer[length++] = c;
                    this.tokenType = "double";
                    continue;
                }
                if (this.tokenType == "single") {
                    --this.offset;
                    --this.bufferIndex;
                    break;
                }
                this.buffer[length++] = c;
                this.tokenType = "double";
                if (length != 2) continue;
                --this.offset;
                --this.bufferIndex;
                this.preIsTokened = true;
                break;
            }
            if (length <= 0) continue;
            if (!this.preIsTokened) break;
            length = 0;
            this.preIsTokened = false;
        }
        return reusableToken.reinit(this.buffer, 0, length, start, start + length, this.tokenType);
    }

    static {
        $assertionsDisabled = !CJKTokenizer.class.desiredAssertionStatus();
    }
}

