/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class ShingleAnalyzerWrapper
extends Analyzer {
    protected Analyzer defaultAnalyzer;
    protected int maxShingleSize = 2;
    protected boolean outputUnigrams = true;

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer, int maxShingleSize) {
        this(defaultAnalyzer);
        this.maxShingleSize = maxShingleSize;
    }

    public ShingleAnalyzerWrapper() {
        this.defaultAnalyzer = new StandardAnalyzer();
    }

    public ShingleAnalyzerWrapper(int nGramSize) {
        this();
        this.maxShingleSize = nGramSize;
    }

    public int getMaxShingleSize() {
        return this.maxShingleSize;
    }

    public void setMaxShingleSize(int maxShingleSize) {
        this.maxShingleSize = maxShingleSize;
    }

    public boolean isOutputUnigrams() {
        return this.outputUnigrams;
    }

    public void setOutputUnigrams(boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        ShingleFilter filter = new ShingleFilter(this.defaultAnalyzer.tokenStream(fieldName, reader));
        filter.setMaxShingleSize(this.maxShingleSize);
        filter.setOutputUnigrams(this.outputUnigrams);
        return filter;
    }
}

