/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.abdera.ext.CMISConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISChoice
extends ExtensibleElementWrapper {
    public CMISChoice(Element internal) {
        super(internal);
    }

    public CMISChoice(Factory factory, QName qname) {
        super(factory, qname);
    }

    public String getValue() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_CHOICE_VALUE);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getDisplayName() {
        return this.getAttributeValue(CMISConstants.PROPDEF_CHOICE_DISPLAY_NAME);
    }

    public List<CMISChoice> getChoices() {
        return this.getChoices(false);
    }

    public List<CMISChoice> getChoices(boolean includeNestedChoices) {
        List children = this.getElements();
        ArrayList<CMISChoice> entries = new ArrayList<CMISChoice>(children.size());
        for (Element child : children) {
            if (!(child instanceof CMISChoice)) continue;
            CMISChoice childChoice = (CMISChoice)child;
            entries.add(childChoice);
            if (!includeNestedChoices) continue;
            entries.addAll(childChoice.getChoices(true));
        }
        return entries;
    }

    public static class CMISChoiceBoolean
    extends CMISChoice {
        public CMISChoiceBoolean(Element internal) {
            super(internal);
        }

        public CMISChoiceBoolean(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceDateTime
    extends CMISChoice {
        public CMISChoiceDateTime(Element internal) {
            super(internal);
        }

        public CMISChoiceDateTime(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceDecimal
    extends CMISChoice {
        public CMISChoiceDecimal(Element internal) {
            super(internal);
        }

        public CMISChoiceDecimal(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceHtml
    extends CMISChoice {
        public CMISChoiceHtml(Element internal) {
            super(internal);
        }

        public CMISChoiceHtml(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceId
    extends CMISChoice {
        public CMISChoiceId(Element internal) {
            super(internal);
        }

        public CMISChoiceId(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceInteger
    extends CMISChoice {
        public CMISChoiceInteger(Element internal) {
            super(internal);
        }

        public CMISChoiceInteger(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceString
    extends CMISChoice {
        public CMISChoiceString(Element internal) {
            super(internal);
        }

        public CMISChoiceString(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISChoiceUri
    extends CMISChoice {
        public CMISChoiceUri(Element internal) {
            super(internal);
        }

        public CMISChoiceUri(Factory factory, QName qname) {
            super(factory, qname);
        }
    }
}

