/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.extensions.surf.extensibility.BasicExtensionModule;
import org.springframework.extensions.surf.extensibility.Customization;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebScriptExtensibilityModuleHandler {
    private static final Log logger = LogFactory.getLog(WebScriptExtensibilityModuleHandler.class);
    private SearchPath configurationSearchPath;
    protected List<BasicExtensionModule> extensionModules = null;

    public void setConfigurationSearchPath(SearchPath configurationSearchPath) {
        this.configurationSearchPath = configurationSearchPath;
    }

    public synchronized List<BasicExtensionModule> getExtensionModules() {
        if (this.extensionModules == null) {
            this.extensionModules = new ArrayList<BasicExtensionModule>();
            if (this.configurationSearchPath != null) {
                for (Store store : this.configurationSearchPath.getStores()) {
                    try {
                        for (String path : store.getDocumentPaths("/", true, "*.xml")) {
                            InputStream is = store.getDocument(path);
                            SAXReader reader = new SAXReader();
                            try {
                                Document document = reader.read(is);
                                Element rootElement = document.getRootElement();
                                if (rootElement.getName().equals("extension")) {
                                    for (Object modules : rootElement.elements("modules")) {
                                        if (!(modules instanceof Element)) continue;
                                        for (Object module : ((Element)modules).elements("module")) {
                                            if (!(module instanceof Element)) continue;
                                            BasicExtensionModule bem = new BasicExtensionModule((Element)module);
                                            this.extensionModules.add(bem);
                                        }
                                    }
                                    continue;
                                }
                                logger.warn((Object)("Extensibility configuration file \"" + path + "\" does not have \"extension\" as its root element"));
                            }
                            catch (DocumentException e) {
                                logger.warn((Object)("Extensibility configuration file \"" + path + "\" was not a valid XML file."), (Throwable)e);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"An error occurred loading the extension modules", (Throwable)e);
                    }
                }
            } else {
                logger.error((Object)"The \"configurationSearchPath\" has not been set for the extensibility module handler");
            }
        }
        return this.extensionModules;
    }

    public List<String> getExtendingModuleFiles(BasicExtensionModule module, String pathBeingProcessed) {
        ArrayList<String> customizationPaths = new ArrayList<String>();
        for (Customization customization : module.getCustomizations()) {
            String targetPackage;
            if (customization.getTargetPackageName() == null || customization.getSourcePackageName() == null || !pathBeingProcessed.startsWith(targetPackage = customization.getTargetPackageName().replace(".", "/"))) continue;
            String packageSubPath = pathBeingProcessed.substring(targetPackage.length());
            String customizationPath = customization.getSourcePackageName().replace(".", "/");
            customizationPath = !customizationPath.endsWith("/") && !packageSubPath.startsWith("/") ? customizationPath + "/" + packageSubPath : customizationPath + packageSubPath;
            if (customizationPath.equals(pathBeingProcessed)) continue;
            customizationPaths.add(customizationPath);
        }
        return customizationPaths;
    }
}

