/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.extensions.webscripts.AbstractBaseDescription;
import org.springframework.extensions.webscripts.BaseDescriptionDocument;
import org.springframework.extensions.webscripts.Store;

public abstract class AbstractBaseDescriptionDocument
extends AbstractBaseDescription
implements BaseDescriptionDocument {
    public static final String COMMON_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String COMMON_XML_NS = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.springsurf.org/schemas/DescriptionXMLSchema.xsd\"";
    public static final String NEW_LINE = "\n";
    public static final String TAB = "    ";
    private Store store;
    private String descPath;

    public void setStore(Store store) {
        this.store = store;
    }

    public void setDescPath(String descPath) {
        this.descPath = descPath;
    }

    public String getDescPath() {
        return this.descPath;
    }

    public InputStream getDescDocument() throws IOException {
        return this.store.getDocument(this.descPath);
    }

    public String getStorePath() {
        return this.store.getBasePath();
    }

    public Store getStore() {
        return this.store;
    }

    public void parseDocument(InputStream doc) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(doc);
        Element rootElement = document.getRootElement();
        this.parse(rootElement);
    }

    public AbstractBaseDescriptionDocument(String id, String shortName, String description) {
        super(id, shortName, description);
    }

    public AbstractBaseDescriptionDocument() {
    }
}

