/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.util.Pair;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.PreviewContext;
import org.springframework.extensions.webscripts.PreviewContextProvider;
import org.springframework.extensions.webscripts.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStore
implements Store {
    public static final String DESC_PATH_PATTERN = "*.desc.xml";
    private PreviewContextProvider previewContextProvider = null;
    private boolean readOnly = false;

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setPreviewContextProvider(PreviewContextProvider previewContextProvider) {
        this.previewContextProvider = previewContextProvider;
    }

    public PreviewContext getPreviewContext() {
        PreviewContext previewContext = null;
        if (this.previewContextProvider != null) {
            previewContext = this.previewContextProvider.provide();
        }
        return previewContext;
    }

    @Override
    public void createDocuments(List<Pair<String, Document>> pathContents) throws IOException {
        for (Pair<String, Document> pathContent : pathContents) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(false);
            StringBuilderWriter writer = new StringBuilderWriter(1024);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write((Document)pathContent.getSecond());
            xmlWriter.flush();
            writer.close();
            this.createDocument((String)pathContent.getFirst(), writer.toString());
        }
    }

    @Override
    public String[] getDocumentPaths(String path, String filePathPattern) {
        ArrayList<String> array = new ArrayList<String>(64);
        String regexPattern = filePathPattern;
        if (regexPattern.endsWith("*.*")) {
            regexPattern = regexPattern.substring(0, regexPattern.length() - 3);
            regexPattern = regexPattern + "*\\..*";
        }
        Pattern pattern = Pattern.compile(regexPattern);
        String[] allDocumentPaths = this.getAllDocumentPaths();
        for (int i = 0; i < allDocumentPaths.length; ++i) {
            String documentPath = allDocumentPaths[i];
            if (!(documentPath = documentPath.replace("\\", "/")).startsWith("/")) {
                documentPath = "/" + documentPath;
            }
            if (!documentPath.startsWith(path)) continue;
            if (!(documentPath = documentPath.substring(path.length())).startsWith("/")) {
                documentPath = "/" + documentPath;
            }
            if (!pattern.matcher(documentPath).matches()) continue;
            if (documentPath.startsWith("/")) {
                documentPath = documentPath.substring(1);
            }
            array.add(documentPath);
        }
        return array.toArray(new String[array.size()]);
    }
}

