/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.surf.extensibility.BasicExtensionModule;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.WebScriptExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityModelImpl;
import org.springframework.extensions.surf.extensibility.impl.MarkupDirective;
import org.springframework.extensions.webscripts.ExtendedScriptConfigModel;
import org.springframework.extensions.webscripts.ExtendedTemplateConfigModel;
import org.springframework.extensions.webscripts.PresentationContainer;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.WebScriptPropertyResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibilityContainer
extends PresentationContainer
implements HandlesExtensibility {
    private static final Log logger = LogFactory.getLog(ExtensibilityContainer.class);
    private WebScriptExtensibilityModuleHandler extensibilityModuleHandler = null;
    private ThreadLocal<ExtensibilityModel> extensibilityModel = new ThreadLocal();
    private ThreadLocal<Map<String, WebScriptPropertyResourceBundle>> extendedBundleCache = new ThreadLocal();
    private ThreadLocal<String> fileBeingProcessed = new ThreadLocal();
    private ThreadLocal<List<BasicExtensionModule>> evaluatedModules = new ThreadLocal();
    private ThreadLocal<ConfigImpl> globalConfig = new ThreadLocal();
    private ThreadLocal<Map<String, List<ConfigSection>>> sectionsByArea = new ThreadLocal();
    private ThreadLocal<List<ConfigSection>> sections = new ThreadLocal();
    public static final String MARKUP_DIRECTIVE_NAME = "markup";

    public void setExtensibilityModuleHandler(WebScriptExtensibilityModuleHandler extensibilityModuleHandler) {
        this.extensibilityModuleHandler = extensibilityModuleHandler;
    }

    @Override
    public ExtensibilityModel openExtensibilityModel() {
        if (this.extensibilityModel.get() == null) {
            this.extendedBundleCache.set(new HashMap());
            this.evaluatedModules.set(null);
            this.fileBeingProcessed.set(null);
            this.globalConfig.set(null);
            this.sections.set(null);
            this.sectionsByArea.set(null);
        }
        ExtensibilityModelImpl model = new ExtensibilityModelImpl(this.extensibilityModel.get(), this);
        this.extensibilityModel.set(model);
        return model;
    }

    @Override
    public void closeExtensibilityModel(ExtensibilityModel model, Writer out) {
        model.flushModel(out);
        this.extensibilityModel.set(model.getParentModel());
        if (this.extensibilityModel.get() != null) {
            this.extensibilityModel.get().setChildDebugData(model.getDebugData());
        }
    }

    @Override
    public ExtensibilityModel getCurrentExtensibilityModel() {
        return this.extensibilityModel.get();
    }

    @Override
    public void updateExtendingModuleDependencies(String pathBeingProcessed, Map<String, Object> model) {
    }

    @Override
    public ResourceBundle getCachedExtendedBundle(String webScriptId) {
        ResourceBundle cachedExtendedBundle = null;
        Map<String, WebScriptPropertyResourceBundle> threadLocal = this.extendedBundleCache.get();
        if (threadLocal != null) {
            cachedExtendedBundle = this.extendedBundleCache.get().get(webScriptId);
        }
        return cachedExtendedBundle;
    }

    @Override
    public void addExtensionBundleToCache(String webScriptId, WebScriptPropertyResourceBundle extensionBundle) {
        Map<String, WebScriptPropertyResourceBundle> threadLocal = this.extendedBundleCache.get();
        if (threadLocal == null) {
            threadLocal = new HashMap<String, WebScriptPropertyResourceBundle>();
            this.extendedBundleCache.set(threadLocal);
        }
        threadLocal.put(webScriptId, extensionBundle);
    }

    @Override
    public String getFileBeingProcessed() {
        return this.fileBeingProcessed.get();
    }

    @Override
    public void setFileBeingProcessed(String file) {
        this.fileBeingProcessed.set(file);
    }

    @Override
    public List<String> getExtendingModuleFiles(String pathBeingProcessed) {
        ArrayList<String> extendingModuleFiles = new ArrayList<String>();
        for (BasicExtensionModule module : this.getEvaluatedModules()) {
            extendingModuleFiles.addAll(this.extensibilityModuleHandler.getExtendingModuleFiles(module, pathBeingProcessed));
        }
        return extendingModuleFiles;
    }

    public List<BasicExtensionModule> getEvaluatedModules() {
        List<BasicExtensionModule> evaluatedModules = this.evaluatedModules.get();
        if (evaluatedModules == null) {
            if (this.extensibilityModuleHandler == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"No 'extensibilityModuleHandler' has been configured for this request context. Extensions cannot be processed");
                }
                evaluatedModules = new ArrayList<BasicExtensionModule>();
                this.evaluatedModules.set(evaluatedModules);
            } else {
                evaluatedModules = this.extensibilityModuleHandler.getExtensionModules();
                this.evaluatedModules.set(evaluatedModules);
            }
        }
        return evaluatedModules;
    }

    @Override
    public ScriptConfigModel getExtendedScriptConfigModel(String xmlConfig) {
        if (this.globalConfig.get() == null && this.sectionsByArea.get() == null && this.sections.get() == null) {
            this.getConfigExtensions();
        }
        return new ExtendedScriptConfigModel(this.getConfigService(), xmlConfig, this.globalConfig.get(), this.sectionsByArea.get(), this.sections.get());
    }

    @Override
    public TemplateConfigModel getExtendedTemplateConfigModel(String xmlConfig) {
        if (this.globalConfig.get() == null && this.sectionsByArea.get() == null && this.sections.get() == null) {
            this.getConfigExtensions();
        }
        return new ExtendedTemplateConfigModel(this.getConfigService(), xmlConfig, this.globalConfig.get(), this.sectionsByArea.get(), this.sections.get());
    }

    private void getConfigExtensions() {
        if (this.getConfigService() instanceof XMLConfigService && this.globalConfig == null && this.sectionsByArea == null && this.sections == null) {
            XMLConfigService xmlConfigService = (XMLConfigService)this.getConfigService();
            this.globalConfig.set(new ConfigImpl((ConfigImpl)xmlConfigService.getGlobalConfig()));
            this.sectionsByArea.set(new HashMap(xmlConfigService.getSectionsByArea()));
            this.sections.set(new ArrayList(xmlConfigService.getSections()));
            List<BasicExtensionModule> evaluatedModules = this.getEvaluatedModules();
            if (evaluatedModules != null && !evaluatedModules.isEmpty()) {
                for (BasicExtensionModule currModule : evaluatedModules) {
                    for (Element currentConfigElement : currModule.getConfigurations()) {
                        HashMap parsedElementReaders = new HashMap();
                        HashMap parsedEvaluators = new HashMap();
                        ArrayList parsedConfigSections = new ArrayList();
                        String currentArea = xmlConfigService.parseFragment(currentConfigElement, parsedElementReaders, parsedEvaluators, parsedConfigSections);
                        for (Map.Entry entry : parsedEvaluators.entrySet()) {
                            parsedEvaluators.put(entry.getKey(), entry.getValue());
                        }
                        for (Map.Entry entry : parsedElementReaders.entrySet()) {
                            parsedElementReaders.put(entry.getKey(), entry.getValue());
                        }
                        for (ConfigSection section : parsedConfigSections) {
                            xmlConfigService.addConfigSection(section, currentArea, this.globalConfig.get(), this.sectionsByArea.get(), this.sections.get());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addExtensibilityDirectives(Map<String, Object> freeMarkerModel, ExtensibilityModel extModel) {
        MarkupDirective mud = new MarkupDirective(MARKUP_DIRECTIVE_NAME, extModel);
        freeMarkerModel.put(MARKUP_DIRECTIVE_NAME, mud);
    }
}

