/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;
import org.springframework.extensions.webscripts.NativeMap;

public final class ScriptValueConverter {
    private static final String TYPE_DATE = "Date";

    private ScriptValueConverter() {
    }

    public static Object unwrapValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Wrapper) {
            value = ScriptValueConverter.unwrapValue(((Wrapper)value).unwrap());
        } else if (value instanceof IdScriptableObject) {
            String className = ((IdScriptableObject)value).getClassName();
            if ("String".equals(className)) {
                value = Context.jsToJava((Object)value, String.class);
            } else if (TYPE_DATE.equals(className)) {
                value = Context.jsToJava((Object)value, Date.class);
            } else {
                Scriptable values = (Scriptable)value;
                Object[] propIds = values.getIds();
                if (values instanceof NativeArray && ScriptValueConverter.isArray(propIds)) {
                    int i;
                    ArrayList<Object> propValues = new ArrayList<Object>(propIds.length);
                    int length = (int)((NativeArray)values).getLength();
                    for (i = 0; i < length; ++i) {
                        propValues.add(null);
                    }
                    for (i = 0; i < propIds.length; ++i) {
                        Integer propId = (Integer)propIds[i];
                        Object val = values.get(propId.intValue(), values);
                        propValues.set(propId, ScriptValueConverter.unwrapValue(val));
                    }
                    value = propValues;
                } else {
                    HashMap<String, Object> propValues = new HashMap<String, Object>(propIds.length);
                    for (int i = 0; i < propIds.length; ++i) {
                        Object propId = propIds[i];
                        if (!(propId instanceof String)) continue;
                        Object val = values.get((String)propId, values);
                        propValues.put((String)propId, ScriptValueConverter.unwrapValue(val));
                    }
                    value = propValues;
                }
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list.add(ScriptValueConverter.unwrapValue(array[i]));
            }
            value = list;
        } else if (value instanceof Map && !(value instanceof JSONObject)) {
            Map map = (Map)((Object)value);
            HashMap copyMap = new HashMap(map.size());
            for (Object key : map.keySet()) {
                copyMap.put(key, ScriptValueConverter.unwrapValue(map.get(key)));
            }
            value = copyMap;
        }
        return value;
    }

    public static Object wrapValue(Scriptable scope, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            value = ScriptRuntime.newObject((Context)Context.getCurrentContext(), (Scriptable)scope, (String)TYPE_DATE, (Object[])new Object[]{date.getTime()});
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Object[] array = new Object[collection.size()];
            int index = 0;
            for (Object obj : collection) {
                array[index++] = ScriptValueConverter.wrapValue(scope, obj);
            }
            value = Context.getCurrentContext().newArray(scope, array);
        } else if (value instanceof Map) {
            value = new NativeMap(scope, (Map)value);
        }
        return value;
    }

    private static boolean isArray(Object[] ids) {
        boolean result = true;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] instanceof Integer) continue;
            result = false;
            break;
        }
        return result;
    }
}

