/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorFactory;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.processor.AbstractTemplateProcessor;

public class TemplateProcessorRegistrar
implements ApplicationContextAware {
    private static final String WEBSCRIPTS_TEMPLATE_REGISTRY_ID = "webscripts.web.templateregistry";
    private static final String WEBSCRIPTS_SEARCHPATH_ID = "webscripts.searchpath";
    private ApplicationContext applicationContext;
    private TemplateProcessorRegistry registry;
    private TemplateProcessorFactory factory;
    private SearchPath searchPath;
    private String name;
    private String extension;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setRegistry(TemplateProcessorRegistry registry) {
        this.registry = registry;
    }

    public void setFactory(TemplateProcessorFactory factory) {
        this.factory = factory;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void init() {
        if (this.registry == null) {
            this.registry = (TemplateProcessorRegistry)this.applicationContext.getBean(WEBSCRIPTS_TEMPLATE_REGISTRY_ID);
        }
        if (this.factory != null) {
            TemplateProcessor templateProcessor = this.factory.newInstance();
            if (templateProcessor instanceof AbstractTemplateProcessor) {
                if (this.searchPath == null) {
                    this.searchPath = (SearchPath)this.applicationContext.getBean(WEBSCRIPTS_SEARCHPATH_ID);
                }
                ((AbstractTemplateProcessor)templateProcessor).setSearchPath(this.searchPath);
            }
            this.registry.registerTemplateProcessor(templateProcessor, this.extension, this.name);
        }
    }
}

