/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.processor.BaseProcessor;

public class TemplateProcessorRegistry {
    private static final Log logger = LogFactory.getLog(TemplateProcessorRegistry.class);
    private String defaultTemplateProcessorName = "freemarker";
    private Map<String, TemplateProcessor> templateProcessors = new HashMap<String, TemplateProcessor>(8);
    private Map<String, String> templateProcessorNamesByExtension = new HashMap<String, String>(8);
    private ReadWriteLock resourceLock = new ReentrantReadWriteLock();

    public void setDefaultTemplateProcessor(String defaultTemplateProcessorName) {
        this.defaultTemplateProcessorName = defaultTemplateProcessorName;
    }

    public void registerTemplateProcessor(TemplateProcessor templateProcessor) {
        this.registerTemplateProcessor(templateProcessor, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTemplateProcessor(TemplateProcessor templateProcessor, String extension, String name) {
        if (name == null && extension == null && templateProcessor instanceof BaseProcessor) {
            name = ((BaseProcessor)((Object)templateProcessor)).getName();
            extension = ((BaseProcessor)((Object)templateProcessor)).getExtension();
        }
        if (name != null && extension != null) {
            this.resourceLock.writeLock().lock();
            try {
                this.templateProcessors.put(name, templateProcessor);
                this.templateProcessorNamesByExtension.put(extension, name);
            }
            finally {
                this.resourceLock.writeLock().unlock();
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registered template processor " + name + " for extension " + extension));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemplateProcessor getDefaultTemplateProcessor() {
        this.resourceLock.readLock().lock();
        try {
            TemplateProcessor templateProcessor = this.templateProcessors.get(this.defaultTemplateProcessorName);
            return templateProcessor;
        }
        finally {
            this.resourceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateProcessor getTemplateProcessor(String path) {
        TemplateProcessor processor = null;
        int i = path.lastIndexOf(46);
        if (i != -1) {
            String extension = path.substring(i + 1);
            this.resourceLock.readLock().lock();
            try {
                String templateProcessorName = this.templateProcessorNamesByExtension.get(extension);
                if (templateProcessorName != null) {
                    processor = this.templateProcessors.get(templateProcessorName);
                }
            }
            finally {
                this.resourceLock.readLock().unlock();
            }
        }
        if (processor == null) {
            processor = this.getDefaultTemplateProcessor();
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateProcessor getTemplateProcessorByExtension(String extension) {
        TemplateProcessor processor = null;
        this.resourceLock.readLock().lock();
        try {
            String templateProcessorName = this.templateProcessorNamesByExtension.get(extension);
            if (templateProcessorName != null) {
                processor = this.templateProcessors.get(templateProcessorName);
            }
        }
        finally {
            this.resourceLock.readLock().unlock();
        }
        return processor;
    }

    public String findValidTemplatePath(String path) {
        TemplateProcessor processor;
        String validTemplatePath = null;
        String extension = null;
        int i = path.lastIndexOf(46);
        if (i != -1 && (processor = this.getTemplateProcessorByExtension(extension = path.substring(i + 1))) != null && processor.hasTemplate(path)) {
            validTemplatePath = path;
        }
        if (validTemplatePath == null) {
            String[] extensions;
            for (String ext : extensions = this.getRegisteredExtensions()) {
                String template;
                TemplateProcessor processor2;
                if (ext.equals(extension) || !(processor2 = this.getTemplateProcessorByExtension(ext)).hasTemplate(template = path + '.' + ext)) continue;
                validTemplatePath = template;
                break;
            }
        }
        return validTemplatePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRegisteredExtensions() {
        this.resourceLock.readLock().lock();
        try {
            String[] stringArray = this.templateProcessorNamesByExtension.keySet().toArray(new String[this.templateProcessorNamesByExtension.keySet().size()]);
            return stringArray;
        }
        finally {
            this.resourceLock.readLock().unlock();
        }
    }

    public String getExtensionForProcessor(TemplateProcessor templateProcessor) {
        String ext = null;
        String[] extensions = this.getRegisteredExtensions();
        for (int n = 0; n < extensions.length; ++n) {
            String extension = extensions[n];
            TemplateProcessor processor = this.getTemplateProcessorByExtension(extension);
            if (processor != templateProcessor) continue;
            ext = extension;
            break;
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.resourceLock.readLock().lock();
        try {
            for (TemplateProcessor p : this.templateProcessors.values()) {
                p.reset();
            }
        }
        finally {
            this.resourceLock.readLock().unlock();
        }
    }
}

