/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.connector.Authenticator;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.connector.Response;

public abstract class AbstractAuthenticator
implements Authenticator,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(Authenticator.class);
    private ApplicationContext applicationContext;
    private static ThreadLocal<RemoteClient> remoteClientBase = new ThreadLocal();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected RemoteClient buildRemoteClient(String endpoint) {
        RemoteClient client = remoteClientBase.get();
        if (client == null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("Application Context must be set programatically for Authenticator.");
            }
            client = (RemoteClient)this.applicationContext.getBean("connector.remoteclient");
            if (client == null) {
                throw new IllegalStateException("The 'connector.remoteclient' bean is required by the WebScript framework.");
            }
            remoteClientBase.set(client);
        }
        try {
            client = (RemoteClient)client.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("RemoteClient must support clone() method.");
        }
        client.setEndpoint(endpoint);
        return client;
    }

    protected void processResponse(Response response, ConnectorSession connectorSession) {
        Map<String, String> headers = response.getStatus().getHeaders();
        for (String headerName : headers.keySet()) {
            String headerValue;
            int z;
            if (!headerName.equalsIgnoreCase("Set-Cookie") || (z = (headerValue = headers.get(headerName)).indexOf(61)) <= -1) continue;
            String cookieName = headerValue.substring(0, z);
            String cookieValue = headerValue.substring(z + 1, headerValue.length());
            int y = cookieValue.indexOf(59);
            if (y > -1) {
                cookieValue = cookieValue.substring(0, y);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticator found Set-Cookie: " + cookieName + " = " + cookieValue));
            }
            if (connectorSession == null) continue;
            connectorSession.setCookie(cookieName, cookieValue);
        }
    }
}

