/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.webscripts.connector.AbstractConnector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.EndpointManager;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.ResponseStatus;

public class HttpConnector
extends AbstractConnector {
    private static Log endpointLogger = LogFactory.getLog(EndpointManager.class);
    private static Log logger = LogFactory.getLog(HttpConnector.class);

    public HttpConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String endpoint) {
        super(descriptor, endpoint);
        EndpointManager.registerEndpoint(endpoint, descriptor);
    }

    public Response call(String uri, ConnectorContext context) {
        Response response;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested Method: " + (context != null ? context.getMethod() : "GET") + " URI: " + uri));
        }
        if (EndpointManager.allowConnect(this.endpoint)) {
            RemoteClient remoteClient = this.initRemoteClient(context);
            response = remoteClient.call(uri);
            this.processResponse(remoteClient, response);
        } else {
            if (endpointLogger.isInfoEnabled()) {
                endpointLogger.info((Object)("Throttled call to: " + uri + " waiting for reconnect timeout on: " + this.endpoint));
            }
            ResponseStatus status = new ResponseStatus();
            status.setCode(500);
            response = new Response(status);
        }
        return response;
    }

    public Response call(String uri, ConnectorContext context, InputStream in) {
        Response response;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested Method: " + (context != null ? context.getMethod() : "GET") + " URI: " + uri));
        }
        if (EndpointManager.allowConnect(this.endpoint)) {
            RemoteClient remoteClient = this.initRemoteClient(context);
            response = remoteClient.call(uri, in);
            this.processResponse(remoteClient, response);
        } else {
            if (endpointLogger.isInfoEnabled()) {
                endpointLogger.info((Object)("Throttled call to: " + uri + " waiting for reconnect timeout on: " + this.endpoint));
            }
            ResponseStatus status = new ResponseStatus();
            status.setCode(500);
            response = new Response(status);
        }
        return response;
    }

    public Response call(String uri, ConnectorContext context, InputStream in, OutputStream out) {
        Response response;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested Method: " + (context != null ? context.getMethod() : "GET") + " URI: " + uri));
        }
        if (EndpointManager.allowConnect(this.endpoint)) {
            RemoteClient remoteClient = this.initRemoteClient(context);
            response = remoteClient.call(uri, in, out);
            this.processResponse(remoteClient, response);
        } else {
            if (endpointLogger.isInfoEnabled()) {
                endpointLogger.info((Object)("Throttled call to: " + uri + " waiting for reconnect timeout on: " + this.endpoint));
            }
            ResponseStatus status = new ResponseStatus();
            status.setCode(500);
            response = new Response(status);
        }
        return response;
    }

    public Response call(String uri, ConnectorContext context, HttpServletRequest req, HttpServletResponse res) {
        Response response;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested Method: " + (context != null ? context.getMethod() : "GET") + " URI: " + uri));
        }
        if (EndpointManager.allowConnect(this.endpoint)) {
            RemoteClient remoteClient = this.initRemoteClient(context);
            response = remoteClient.call(uri, req, res);
            this.processResponse(remoteClient, response);
        } else {
            if (endpointLogger.isInfoEnabled()) {
                endpointLogger.info((Object)("Throttled call to: " + uri + " waiting for reconnect timeout on: " + this.endpoint));
            }
            ResponseStatus status = new ResponseStatus();
            status.setCode(500);
            response = new Response(status);
        }
        return response;
    }

    protected void applyRequestHeaders(RemoteClient remoteClient, ConnectorContext context) {
        ConnectorSession connectorSession = this.getConnectorSession();
        if (connectorSession != null) {
            HashMap<String, String> cookies = new HashMap<String, String>(8);
            for (String cookieName : connectorSession.getCookieNames()) {
                cookies.put(cookieName, connectorSession.getCookie(cookieName));
            }
            remoteClient.setCookies(cookies);
        }
        HashMap<String, String> headers = new HashMap<String, String>(8);
        if (context != null) {
            headers.putAll(context.getHeaders());
        }
        if (this.getCredentials() != null) {
            String user = (String)this.getCredentials().getProperty("cleartextUsername");
            String pass = (String)this.getCredentials().getProperty("cleartextPassword");
            if (pass == null) {
                headers.put("X-Alfresco-Remote-User", user);
            }
        }
        if (headers.size() != 0) {
            remoteClient.setRequestProperties(headers);
        }
    }

    protected void applyRequestAuthentication(RemoteClient remoteClient, ConnectorContext context) {
        if (this.getCredentials() != null) {
            String user = (String)this.getCredentials().getProperty("cleartextUsername");
            String pass = (String)this.getCredentials().getProperty("cleartextPassword");
            if (pass != null) {
                remoteClient.setUsernamePassword(user, pass);
            }
        }
    }

    protected void processResponse(RemoteClient remoteClient, Response response) {
        ConnectorSession connectorSession = this.getConnectorSession();
        if (EndpointManager.processResponseCode(this.endpoint, response.getStatus().getCode()) && connectorSession != null) {
            Map<String, String> cookies = remoteClient.getCookies();
            for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Connector found Set-Cookie: " + cookie.getKey() + " = " + cookie.getValue()));
                }
                connectorSession.setCookie(cookie.getKey(), cookie.getValue());
            }
        }
    }

    protected RemoteClient initRemoteClient(ConnectorContext context) {
        RemoteClient remoteClient = this.buildRemoteClient(this.getEndpoint());
        if (context != null) {
            remoteClient.setRequestContentType(context.getContentType());
            remoteClient.setRequestMethod(context.getMethod());
            remoteClient.setCommitResponseOnAuthenticationError(context.getCommitResponse());
            remoteClient.setExceptionOnError(context.getExceptionOnError());
        }
        this.applyRequestHeaders(remoteClient, context);
        this.applyRequestAuthentication(remoteClient, context);
        return remoteClient;
    }
}

