/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ServerConfigElement;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebScriptServlet
extends HttpServlet {
    private static final long serialVersionUID = 4209892938069597860L;
    private static final Log logger = LogFactory.getLog(WebScriptServlet.class);
    protected RuntimeContainer container;
    protected ServletAuthenticatorFactory authenticatorFactory;
    protected ConfigService configService;
    protected static ServerProperties serverProperties;

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.configService = (ConfigService)context.getBean("web.config");
        String containerName = this.getServletConfig().getInitParameter("container");
        if (containerName == null) {
            containerName = "webscripts.container";
        }
        this.container = (RuntimeContainer)context.getBean(containerName);
        String authenticatorId = this.getInitParameter("authenticator");
        if (authenticatorId != null && authenticatorId.length() > 0) {
            Object bean = context.getBean(authenticatorId);
            if (bean == null || !(bean instanceof ServletAuthenticatorFactory)) {
                throw new ServletException("Initialisation parameter 'authenticator' does not refer to a servlet authenticator factory (" + authenticatorId + ")");
            }
            this.authenticatorFactory = (ServletAuthenticatorFactory)bean;
        }
        Config config = this.configService.getConfig((Object)"Server");
        serverProperties = (ServerConfigElement)config.getConfigElement("server");
        this.initServlet((ApplicationContext)context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialised Web Script Servlet (authenticator='" + authenticatorId + "')"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing request (" + req.getMethod() + ") " + req.getRequestURL() + (req.getQueryString() != null ? "?" + req.getQueryString() : "")));
        }
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        WebScriptServlet.setLanguageFromRequestHeader(req);
        try {
            WebScriptServletRuntime runtime = new WebScriptServletRuntime(this.container, this.authenticatorFactory, req, res, serverProperties);
            if (req.getMethod().equals(HttpMethod.OPTIONS.name())) {
                String allow = HttpMethod.OPTIONS.name();
                for (HttpMethod supportedMethod : runtime.getSupportedMethods()) {
                    allow = allow + ", " + supportedMethod.name();
                }
                res.setHeader("Allow", allow);
            } else {
                runtime.executeScript();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            I18NUtil.setLocale(null);
            throw throwable;
        }
        I18NUtil.setLocale(null);
    }

    protected void initServlet(ApplicationContext context) {
    }

    public static void setLanguageFromRequestHeader(HttpServletRequest req) {
        String acceptLang = req.getHeader("Accept-Language");
        if (acceptLang != null && acceptLang.length() != 0) {
            StringTokenizer t = new StringTokenizer(acceptLang, ",; ");
            String language = t.nextToken().replace('-', '_');
            I18NUtil.setLocale((Locale)I18NUtil.parseLocale((String)language));
        }
    }
}

