/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.support.DefaultUserFactory;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.web.context.ServletContextAware;

public class ConfigBeanFactory
implements ApplicationContextAware,
ServletContextAware {
    private ConfigService configService;
    private ApplicationContext applicationContext;
    private ServletContext servletContext;
    private WebFrameworkConfigElement webFrameworkConfigElement;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public RemoteConfigElement getRemoteConfig() {
        Config remoteConfig = this.configService.getConfig((Object)"Remote");
        RemoteConfigElement remoteConfigElement = (RemoteConfigElement)remoteConfig.getConfigElement("remote");
        return remoteConfigElement;
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        if (this.webFrameworkConfigElement == null) {
            Config webFrameworkConfig = this.configService.getConfig((Object)"WebFramework");
            this.webFrameworkConfigElement = (WebFrameworkConfigElement)webFrameworkConfig.getConfigElement("web-framework");
        }
        return this.webFrameworkConfigElement;
    }

    public UserFactory getUserFactory() {
        UserFactory userFactory = null;
        String defaultUserFactoryId = this.getWebFrameworkConfig().getDefaultUserFactoryId();
        userFactory = defaultUserFactoryId != null ? (UserFactory)this.applicationContext.getBean(defaultUserFactoryId) : new DefaultUserFactory();
        return userFactory;
    }

    public TaglibFactory getTabLibFactory() {
        TaglibFactory tagLibFactory = new TaglibFactory(this.servletContext);
        return tagLibFactory;
    }

    public ScriptConfigModel getScriptConfigModel() {
        ScriptConfigModel scriptConfigModel = new ScriptConfigModel(this.configService, null);
        return scriptConfigModel;
    }

    public TemplateConfigModel getTemplateConfigModel() {
        TemplateConfigModel templateConfigModel = new TemplateConfigModel(this.configService, null);
        return templateConfigModel;
    }

    public ServletContextHashModel getServletContextHashModel() {
        GenericServletAdapter servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig(this.servletContext));
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", (Throwable)ex);
        }
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel((GenericServlet)servlet, ObjectWrapper.DEFAULT_WRAPPER);
        return servletContextHashModel;
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private ServletContext servletContext = null;

        public DelegatingServletConfig(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return FrameworkBean.class.getSimpleName();
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
    }

    private class GenericServletAdapter
    extends GenericServlet {
        private static final long serialVersionUID = 3669237557425980138L;

        private GenericServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

