/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.webscripts.json.JSONWriter;
import org.springframework.extensions.webscripts.json.RawValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWebScriptWidgetsDirective
extends JavaScriptDependencyDirective {
    private static final Log logger = LogFactory.getLog(CreateWebScriptWidgetsDirective.class);
    public static final String REFERENCE_VALUE_KEY = "_alfValue";
    public static final String REFERENCE_TYPE_KEY = "_alfType";

    public CreateWebScriptWidgetsDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    @Override
    protected void addLegacyDependencyRequest(Map params) throws TemplateModelException {
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        TemplateHashModel model = env.getDataModel();
        String htmlId = null;
        TemplateModel o = model.get("args");
        if (o instanceof SimpleHash) {
            TemplateModel _htmlid = ((SimpleHash)o).get("htmlid");
            if (_htmlid instanceof SimpleScalar) {
                htmlId = ((SimpleScalar)_htmlid).toString();
            } else {
                logger.error((Object)("\"htmlid\" is either not available or is not an instance of SimpleScalar: " + _htmlid));
            }
        }
        String messages = "";
        TemplateModel _messages = model.get("messages");
        if (_messages instanceof SimpleScalar) {
            messages = ((SimpleScalar)_messages).toString();
        }
        String group = this.getStringProperty(params, "group", false);
        StringBuilder content = new StringBuilder(">>>");
        for (WidgetData widget : this.buildWidgetDataList(model)) {
            content.append(this.buildWidgetInstantiatationScript(env, widget, htmlId, messages));
        }
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        DependencyDirectiveData directiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, content.toString(), group, this.getWebFrameworkConfig().isAggregateDependenciesEnabled(), targetElement);
        return directiveData;
    }

    protected String buildWidgetInstantiatationScript(Environment env, WidgetData widget, String htmlId, String messages) {
        StringBuilder js = new StringBuilder();
        if (widget.getAssignmentVariableName() != null) {
            js.append("var ");
            js.append(widget.getAssignmentVariableName());
            js.append("=");
        }
        js.append("new ");
        js.append(widget.getName());
        js.append("(");
        if (widget.getAdditionalInstantiationArgs() != null) {
            Iterator<Object> i = widget.getAdditionalInstantiationArgs().iterator();
            while (i.hasNext()) {
                js.append(i.next().toString());
                if (!i.hasNext()) continue;
                js.append(", ");
            }
        } else {
            js.append("\"");
            js.append(htmlId);
            js.append("\"");
        }
        js.append(")");
        if (widget.isProvideOptions()) {
            js.append(".setOptions(");
            Map<Object, Object> processedOptions = this.processCustomOptionsInMap(env, widget.getOptions());
            String jsonString = JSONWriter.encodeToJSON(processedOptions);
            js.append(jsonString);
            js.append(")");
        }
        if (widget.isProvideMessages()) {
            js.append(".setMessages(");
            js.append(messages);
            js.append(")");
        }
        js.append(";\n");
        return js.toString();
    }

    protected Map<Object, Object> processCustomOptionsInMap(Environment env, Map<Object, Object> options) {
        HashMap<Object, Object> processedOptions = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : options.entrySet()) {
            processedOptions.put(entry.getKey(), this.processCustomOptionsInObject(env, entry.getValue()));
        }
        return processedOptions;
    }

    protected Object processCustomOptionsInObject(Environment env, Object object) {
        Object processedOption = null;
        if (object instanceof Map) {
            Map map = object;
            processedOption = map.keySet().size() == 2 && map.containsKey(REFERENCE_TYPE_KEY) && map.containsKey(REFERENCE_VALUE_KEY) ? this.processCustomOption(env, map) : this.processCustomOptionsInMap(env, object);
        } else if (object instanceof List) {
            ArrayList<Object> processedList = new ArrayList<Object>();
            for (Object element : (List)((Object)object)) {
                processedList.add(this.processCustomOptionsInObject(env, element));
            }
            processedOption = processedList;
        } else {
            processedOption = object;
        }
        return processedOption;
    }

    protected RawValue processCustomOption(Environment env, Map<String, String> customOption) {
        return new RawValue(customOption.get(REFERENCE_VALUE_KEY));
    }

    protected List<WidgetData> buildWidgetDataList(TemplateHashModel model) throws TemplateModelException {
        ArrayList<WidgetData> widgetDataList = new ArrayList<WidgetData>();
        TemplateModel o = model.get("widgets");
        if (o instanceof SimpleSequence) {
            SimpleSequence widgetList = (SimpleSequence)o;
            for (Object w : widgetList.toList()) {
                if (w instanceof Map) {
                    Map widgetDataMap = (Map)w;
                    Object _widgetName = widgetDataMap.get("name");
                    if (_widgetName instanceof String) {
                        Object _instantiationArgs;
                        Object _assignmentVariableName;
                        String name = (String)_widgetName;
                        boolean provideOptions = true;
                        boolean provideMessages = true;
                        Map options = null;
                        String assignmentVariable = null;
                        List instantiationArgs = null;
                        Object _provideOptions = widgetDataMap.get("useOptions");
                        if (_provideOptions instanceof Boolean && !((Boolean)_provideOptions).booleanValue()) {
                            provideOptions = false;
                        } else {
                            Object _options = widgetDataMap.get("options");
                            if (_options instanceof Map) {
                                options = (Map)_options;
                            } else {
                                options = null;
                                provideOptions = false;
                            }
                        }
                        Object _provideMessages = widgetDataMap.get("useMessages");
                        if (_provideMessages instanceof Boolean) {
                            provideMessages = (Boolean)_provideMessages;
                        }
                        if ((_assignmentVariableName = widgetDataMap.get("assignTo")) instanceof String) {
                            assignmentVariable = (String)_assignmentVariableName;
                        }
                        if ((_instantiationArgs = widgetDataMap.get("initArgs")) instanceof List) {
                            instantiationArgs = (List)_instantiationArgs;
                        }
                        widgetDataList.add(new WidgetData(name, provideMessages, provideOptions, options, assignmentVariable, instantiationArgs));
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"A \"name\" property must be included in each object in the \"widgets\" array as this is the fully-qualified name of the JavaScript widget to be instantiated. The \"name\" property was either not supplied or was not a String");
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Each object in the \"widgets\" array should be an object that contains the data necessary to instantiate a JavaScript widget. The type detected was a: " + w.getClass()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("When using the outputJavaScript directive it is expected that the associated model should contain an object \"widgets\" that is an array of objects, where each object contains the data necessary to instantiate a JavaScript widget. The type detected was a: " + (o != null ? o.getClass() : null)));
        }
        return widgetDataList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WidgetData {
        private String name;
        private boolean provideMessages;
        private boolean provideOptions;
        private Map<Object, Object> options;
        private String assignmentVariableName;
        private List<Object> additionalInstantiationArgs;

        protected WidgetData(String name, boolean provideMessages, boolean provideOptions, Map<Object, Object> options, String assignmentVariableName, List<Object> additionalInstantiationArgs) {
            this.name = name;
            this.provideMessages = provideMessages;
            this.provideOptions = provideOptions;
            this.options = options == null ? new HashMap<Object, Object>() : options;
            this.assignmentVariableName = assignmentVariableName;
            this.additionalInstantiationArgs = additionalInstantiationArgs;
        }

        public String getName() {
            return this.name;
        }

        public boolean isProvideMessages() {
            return this.provideMessages;
        }

        public boolean isProvideOptions() {
            return this.provideOptions;
        }

        public Map<Object, Object> getOptions() {
            return this.options;
        }

        public String getAssignmentVariableName() {
            return this.assignmentVariableName;
        }

        public List<Object> getAdditionalInstantiationArgs() {
            return this.additionalInstantiationArgs;
        }
    }
}

