/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.directives.AbstractDependencyExtensibilityDirective;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.webscripts.MessagesWebScript;

public class MessagesDependencyDirective
extends JavaScriptDependencyDirective {
    private static final Log logger = LogFactory.getLog(MessagesDependencyDirective.class);
    private static final String SERVICE = "/service/";
    private static final String LOCALE = "locale";
    public static final String LOCALE_REQ_PARM = "?locale=";
    private MessagesWebScript messagesWebScript;

    public MessagesDependencyDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void setMessagesWebScript(MessagesWebScript messagesWebScript) {
        this.messagesWebScript = messagesWebScript;
    }

    protected String getResourceControllerMapping() {
        return SERVICE;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String checksum;
        String src = this.getStringProperty(params, "src", true);
        String locale = this.getStringProperty(params, LOCALE, true);
        String type = this.getStringProperty(params, "type", false);
        if (type == null) {
            type = "text/javascript";
        }
        if ((checksum = this.messagesWebScript.generateCachedLocaleChecksum(locale)) != null) {
            String checksumPath = DependencyHandler.generateCheckSumPath(src, checksum);
            AbstractDependencyExtensibilityDirective.ProcessedDependency pd = this.processDependency(checksumPath);
            StringBuilder s = new StringBuilder();
            s.append("   <script type=\"");
            s.append(type);
            s.append("\" src=\"");
            s.append(this.getToInsert(pd));
            s.append(this.getUpdatedSrc(pd));
            s.append(LOCALE_REQ_PARM);
            s.append(locale);
            s.append("\"></script>\n");
            env.getOut().write(s.toString());
        } else {
            logger.error((Object)("It was not possible to generate a JavaScript import for: \"" + src + "\" because the resource could not be found"));
        }
    }
}

