/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.extensions.directives.DependencyDirectiveData;
import org.springframework.extensions.directives.JavaScriptDependencyDirective;
import org.springframework.extensions.directives.OutputCSSContentModelElement;
import org.springframework.extensions.directives.OutputJavaScriptContentModelElement;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyHandler;
import org.springframework.extensions.surf.I18nDependencyHandler;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.webscripts.json.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessJsonModelDirective
extends JavaScriptDependencyDirective {
    public static final String DIRECTIVE_NAME = "processJsonModel";
    public static final String MODEL_KEY = "jsonModel";
    public static final String TARGET_DOM_ID_KEY = "rootNodeId";
    private DojoDependencyHandler dojoDependencyHandler = null;
    private I18nDependencyHandler i18nDependencyHandler = null;
    public static Pattern pattern = Pattern.compile("\\$\\$([A-Za-z0-9_\\-]*)\\$\\$");

    public ProcessJsonModelDirective(String directiveName, ExtensibilityModel model) {
        super(directiveName, model);
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public void setI18nDependencyHandler(I18nDependencyHandler i18nDependencyHandler) {
        this.i18nDependencyHandler = i18nDependencyHandler;
    }

    @Override
    public ExtensibilityDirectiveData createExtensibilityDirectiveData(String id, String action, String target, Map params, TemplateDirectiveBody body, Environment env) throws TemplateException {
        TemplateHashModel model = env.getDataModel();
        String group = this.getStringProperty(params, "group", false);
        List services = Collections.emptyList();
        List widgets = Collections.emptyList();
        List publishOnLoad = Collections.emptyList();
        String targetDomId = "content";
        TemplateModel o = model.get(MODEL_KEY);
        if (o instanceof SimpleHash) {
            SimpleHash pageConfig = (SimpleHash)o;
            TemplateModel _targetDomId = pageConfig.get(TARGET_DOM_ID_KEY);
            if (_targetDomId instanceof SimpleScalar) {
                targetDomId = _targetDomId.toString().trim();
            }
            if ((o = pageConfig.get("services")) instanceof SimpleSequence) {
                services = ((SimpleSequence)o).toList();
            }
            if ((o = pageConfig.get("widgets")) instanceof SimpleSequence) {
                widgets = ((SimpleSequence)o).toList();
            }
            if ((o = pageConfig.get("publishOnReady")) instanceof SimpleSequence) {
                publishOnLoad = ((SimpleSequence)o).toList();
            }
        }
        String servicesJSONStr = UriUtils.replaceTokens(JSONWriter.encodeToJSON(services), this.getRequestContext(), pattern, 1);
        String widgetsJSONStr = UriUtils.replaceTokens(JSONWriter.encodeToJSON(widgets), this.getRequestContext(), pattern, 1);
        String publishOnLoadJSONStr = UriUtils.replaceTokens(JSONWriter.encodeToJSON(publishOnLoad), this.getRequestContext(), pattern, 1);
        LinkedHashMap<String, DojoDependencies> dependenciesForCurrentRequest = new LinkedHashMap<String, DojoDependencies>();
        String pagePath = this.dojoDependencyHandler.getPath(null, this.getWebFrameworkConfig().getDojoPageWidget()) + ".js";
        DojoDependencies pageDeps = this.dojoDependencyHandler.getDependencies(pagePath);
        this.dojoDependencyHandler.recursivelyProcessDependencies(pageDeps, dependenciesForCurrentRequest);
        String domReadyPath = this.dojoDependencyHandler.getPath(null, "dojo/domReady") + ".js";
        DojoDependencies domReadyDeps = this.dojoDependencyHandler.getDependencies(domReadyPath);
        dependenciesForCurrentRequest.put(domReadyPath, domReadyDeps);
        this.dojoDependencyHandler.recursivelyProcessDependencies(domReadyDeps, dependenciesForCurrentRequest);
        if (services != null) {
            for (Object service : services) {
                String servicePath = null;
                if (service instanceof Map) {
                    Map map = (Map)service;
                    Object s = map.get("name");
                    if (s instanceof String) {
                        servicePath = this.dojoDependencyHandler.getPath(null, (String)s) + ".js";
                    }
                } else if (service instanceof String) {
                    servicePath = this.dojoDependencyHandler.getPath(null, (String)service) + ".js";
                }
                if (servicePath == null) continue;
                DojoDependencies serviceDeps = this.dojoDependencyHandler.getDependencies(servicePath);
                dependenciesForCurrentRequest.put(servicePath, serviceDeps);
                this.dojoDependencyHandler.recursivelyProcessDependencies(serviceDeps, dependenciesForCurrentRequest);
            }
        }
        this.dojoDependencyHandler.processControllerWidgets(widgets, dependenciesForCurrentRequest);
        String checksum = this.dojoDependencyHandler.getChecksumForDependencies(dependenciesForCurrentRequest, pagePath, pageDeps);
        String prefix = this.dependencyAggregator.getServletContext().getContextPath() + this.dependencyHandler.getResourceControllerMapping() + "/";
        OutputCSSContentModelElement outputCss = null;
        DeferredContentTargetModelElement te = this.getModel().getDeferredContent("outputCSSDependenciesDirective", "outputCSS");
        if (te instanceof OutputCSSContentModelElement) {
            outputCss = (OutputCSSContentModelElement)te;
            this.dojoDependencyHandler.processCssDependencies(dependenciesForCurrentRequest, outputCss, prefix, group);
        }
        OutputJavaScriptContentModelElement outputJs = null;
        te = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        if (te instanceof OutputJavaScriptContentModelElement) {
            outputJs = (OutputJavaScriptContentModelElement)te;
            this.dojoDependencyHandler.processNonAmdDependencies(dependenciesForCurrentRequest, outputJs, prefix, group);
        }
        String content = this.buildJavaScriptForPage(checksum, servicesJSONStr, widgetsJSONStr, publishOnLoadJSONStr, targetDomId, dependenciesForCurrentRequest, model);
        DeferredContentTargetModelElement targetElement = this.getModel().getDeferredContent("outputJavaScriptDirective", "outputJavaScript");
        DependencyDirectiveData directiveData = new DependencyDirectiveData(id, action, target, this.getDirectiveName(), body, env, content, group, true, targetElement);
        return directiveData;
    }

    protected String buildJavaScriptForPage(String checksum, String servicesJSONStr, String widgetsJSONStr, String publishOnLoadJSONStr, String rootDomId, Map<String, DojoDependencies> dependenciesForCurrentRequest, TemplateHashModel model) {
        StringBuilder content = new StringBuilder(10240);
        content.append(">>>");
        content.append(this.i18nDependencyHandler.generateI18nJavaScript(dependenciesForCurrentRequest));
        try {
            String messages = "";
            TemplateModel _messages = model.get("messages");
            if (_messages instanceof SimpleScalar) {
                messages = ((SimpleScalar)_messages).toString();
                String globalMessagesObject = this.getWebFrameworkConfig().getDojoMessagesObject();
                content.append("var pageScopeMsgs = ");
                content.append(messages);
                content.append(";\n   if (");
                content.append(globalMessagesObject);
                content.append(".messages.pageScope) {\n   for (var key in pageScopeMsgs) { \n      ");
                content.append(globalMessagesObject);
                content.append(".messages.pageScope[key] = pageScopeMsgs[key];\n}\n}\nelse {\n   ");
                content.append(globalMessagesObject);
                content.append(".messages.pageScope = ");
                content.append(messages);
                content.append(";\n}\n");
            }
        }
        catch (TemplateModelException e) {
            // empty catch block
        }
        if (this.getWebFrameworkConfig().isDojoLoaderTraceEnabled()) {
            content.append("require.trace.set(\"loader-inject\", 1);\nrequire.trace.set(\"loader-define\", 0);\n");
        }
        if (this.dependencyAggregator.isDebugMode()) {
            content.append(this.getWebFrameworkConfig().getDojoMessagesObject());
            content.append(".logging = true;\n");
        }
        content.append("require(['");
        content.append(checksum.substring(3, checksum.length() - 3));
        content.append("','dojo/domReady!");
        content.append("'], function(Page) {\n var p = new Page({services:");
        content.append(servicesJSONStr);
        content.append(",widgets:");
        content.append(widgetsJSONStr);
        content.append(",publishOnReady:");
        content.append(publishOnLoadJSONStr);
        content.append("\n}, '");
        content.append(rootDomId);
        content.append("');\n});\n");
        return content.toString();
    }
}

