/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Theme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssThemeHandler {
    private String tokenRegex = null;
    private int targetGroup;
    private Pattern sourceTokenPattern = null;
    Map<String, String> tokenMap = new HashMap<String, String>();

    public String getTokenRegex() {
        return this.tokenRegex;
    }

    public void setTokenRegex(String tokenRegex) {
        this.tokenRegex = tokenRegex;
        this.sourceTokenPattern = Pattern.compile(this.tokenRegex);
    }

    public int getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(int targetGroup) {
        this.targetGroup = targetGroup;
    }

    public void determineThemeTokens() {
        Theme currentTheme = ThreadLocalRequestContext.getRequestContext().getTheme();
        this.tokenMap.putAll(currentTheme.getCssTokens());
    }

    public Map<String, String> getTokenMap() {
        this.determineThemeTokens();
        return this.tokenMap;
    }

    public String processCssThemes(StringBuilder cssContents) throws IOException {
        StringBuffer processedOutput = new StringBuffer();
        Matcher m = this.sourceTokenPattern.matcher(cssContents);
        while (m.find()) {
            String token = m.group(this.getTargetGroup());
            String replacement = this.getTokenMap().get(token);
            if (replacement == null) {
                m.appendReplacement(processedOutput, "/*TOKEN NOT FOUND*/");
                continue;
            }
            m.appendReplacement(processedOutput, replacement);
        }
        m.appendTail(processedOutput);
        return processedOutput.toString();
    }
}

