/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.OutputCSSContentModelElement;
import org.springframework.extensions.directives.OutputJavaScriptContentModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyRule;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.ScriptConfigModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DojoDependencyHandler {
    private static final Log logger = LogFactory.getLog(DojoDependencyHandler.class);
    public static final String WIDGET_NAME = "name";
    public static final String WIDGET_CONFIG = "config";
    public static final String WIDGETS_LIST = "widgets";
    private DependencyHandler dependencyHandler = null;
    private DependencyAggregator dependencyAggregator = null;
    private WebFrameworkConfigElement webFrameworkConfigElement = null;
    private List<DojoDependencyRule> dependencyRules;
    private final ReadWriteLock depsLock = new ReentrantReadWriteLock();
    private final Map<String, DojoDependencies> cachedDeps = new HashMap<String, DojoDependencies>();
    private final ReadWriteLock cachedResourceLock = new ReentrantReadWriteLock();
    private final Map<String, String> generatedResourceCache = new HashMap<String, String>();
    private final ReadWriteLock dependenciesChecksumLock = new ReentrantReadWriteLock();
    private final Map<Object, String> dependenciesChecksumCache = new HashMap<Object, String>();

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setDependencyRules(List<DojoDependencyRule> dependencyRules) {
        this.dependencyRules = dependencyRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DojoDependencies getCachedDeps(String path) {
        DojoDependencies deps = null;
        this.depsLock.readLock().lock();
        try {
            deps = this.cachedDeps.get(path);
        }
        finally {
            this.depsLock.readLock().unlock();
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDeps(String path, DojoDependencies deps) {
        this.depsLock.writeLock().lock();
        try {
            this.cachedDeps.put(path, deps);
        }
        finally {
            this.depsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        this.depsLock.writeLock().lock();
        try {
            this.cachedDeps.clear();
        }
        finally {
            this.depsLock.writeLock().unlock();
        }
        this.cachedResourceLock.writeLock().lock();
        try {
            this.generatedResourceCache.clear();
        }
        finally {
            this.cachedResourceLock.writeLock().unlock();
        }
    }

    public DojoDependencies getDependencies(String path) {
        DojoDependencies deps = this.getCachedDeps(path);
        if (deps == null) {
            try {
                String compressedFile = this.dependencyAggregator.getCompressedFile(path, DependencyAggregator.CompressionType.JAVASCRIPT);
                if (compressedFile != null) {
                    deps = new DojoDependencies();
                    for (DojoDependencyRule rule : this.dependencyRules) {
                        rule.processRegexRules(path, compressedFile, deps);
                    }
                    this.cacheDeps(path, deps);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return deps;
    }

    public void recursivelyProcessDependencies(DojoDependencies deps, Map<String, DojoDependencies> allDeps) {
        if (deps != null) {
            for (String dep : deps.getJavaScriptDeps()) {
                if (allDeps.containsKey(dep)) continue;
                DojoDependencies requestedDeps = this.getCachedDeps(dep);
                if (requestedDeps == null) {
                    requestedDeps = this.getDependencies(dep);
                }
                allDeps.put(dep, requestedDeps);
                this.recursivelyProcessDependencies(requestedDeps, allDeps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedResource(String path) {
        String resource = null;
        this.cachedResourceLock.readLock().lock();
        try {
            resource = this.generatedResourceCache.get(path);
        }
        finally {
            this.cachedResourceLock.readLock().unlock();
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResource(String checksum, String resource) {
        this.cachedResourceLock.writeLock().lock();
        try {
            this.generatedResourceCache.put(checksum, resource);
        }
        finally {
            this.cachedResourceLock.writeLock().unlock();
        }
    }

    public String getChecksumPathForDependencies(String source) {
        String surfPackage = this.getRequestDojoPackages().get("surf");
        String checksum = surfPackage + "/" + this.dependencyHandler.generateCheckSum(source) + ".js";
        this.cacheResource(checksum, source);
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChecksumForDependencies(Map<String, DojoDependencies> dependencies, String pagePath, DojoDependencies pageDeps) {
        String checksum;
        this.dependenciesChecksumLock.readLock().lock();
        try {
            checksum = this.dependenciesChecksumCache.get(dependencies);
        }
        finally {
            this.dependenciesChecksumLock.readLock().unlock();
        }
        if (checksum == null) {
            StringBuilder aggregatedOutput = this.outputAggregateResource(dependencies, null);
            try {
                aggregatedOutput.append("\n\n").append(this.outputDependency("", pagePath, pageDeps).toString());
            }
            catch (IOException e) {
                throw new PlatformRuntimeException("IO error during dependency aggregation: " + e.getMessage(), (Throwable)e);
            }
            checksum = this.getChecksumPathForDependencies(aggregatedOutput.toString());
            this.dependenciesChecksumLock.writeLock().lock();
            try {
                this.dependenciesChecksumCache.put(dependencies, checksum);
            }
            finally {
                this.dependenciesChecksumLock.writeLock().unlock();
            }
        }
        return checksum;
    }

    protected String reverseAlias(String path) {
        for (Map.Entry<String, String> alias : this.getRequestDojoPackages().entrySet()) {
            if (!path.startsWith(alias.getValue())) continue;
            path = alias.getKey() + path.substring(alias.getValue().length());
            break;
        }
        return path;
    }

    public StringBuilder outputAggregateResource(Map<String, DojoDependencies> depsToOutput, String baseUrl) {
        StringBuilder sb = new StringBuilder(256000);
        sb.append("//>>built\n");
        sb.append("require({cache:{\n");
        Iterator<Map.Entry<String, DojoDependencies>> i = depsToOutput.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Map.Entry<String, DojoDependencies> currentDependency = i.next();
                String depName = currentDependency.getKey();
                String depPath = this.getPath(baseUrl, depName);
                depName = this.reverseAlias(depName);
                if (depName.endsWith(".js")) {
                    depName = depName.substring(0, depName.length() - 3);
                }
                String dep = this.outputDependency(depName, depPath, currentDependency.getValue()).toString();
                sb.append("'");
                sb.append(depName);
                sb.append("':function(){\n");
                sb.append(dep);
                sb.append("}");
                if (i.hasNext()) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Developer Warning: " + e.getMessage()), (Throwable)e);
            }
        }
        sb.append("}});");
        return sb;
    }

    public StringBuilder outputDependency(String name, String path, DojoDependencies deps) throws IOException {
        StringBuilder currentDep = new StringBuilder(4096);
        if (!deps.getTextDeps().isEmpty()) {
            currentDep.append("require({cache:{");
            Iterator<String> j = deps.getTextDeps().iterator();
            while (j.hasNext()) {
                String textDependency = j.next();
                currentDep.append("'url:");
                String textPath = this.getPath(path, textDependency);
                if (textPath.startsWith("/")) {
                    textPath = textPath.substring(1);
                }
                String shortTextPath = this.reverseAlias(textPath);
                currentDep.append(shortTextPath);
                currentDep.append("':");
                currentDep.append("'");
                InputStream in = this.dependencyHandler.getResourceInputStream(textPath);
                if (in != null) {
                    String textContents = this.dependencyHandler.convertResourceToString(in);
                    textContents = textContents.replace("'", "\"").replace("\"", "\\\"").replace("\n", "").replace("\r", "");
                    currentDep.append(textContents);
                }
                currentDep.append("'");
                if (j.hasNext()) {
                    currentDep.append(",");
                }
                currentDep.append("\n");
            }
            currentDep.append("}});");
        }
        if (this.dependencyHandler.isDebugMode()) {
            InputStream in = this.dependencyHandler.getResourceInputStream(path);
            currentDep.append(this.dependencyHandler.convertResourceToString(in));
        } else {
            currentDep.append(this.dependencyAggregator.getCompressedFile(path, DependencyAggregator.CompressionType.JAVASCRIPT));
        }
        return currentDep;
    }

    public Map<String, String> getRequestDojoPackages() {
        Map<String, String> dojoPackages = null;
        ScriptConfigModel config = ThreadLocalRequestContext.getRequestContext().getExtendedScriptConfigModel(null);
        Map configs = (Map)config.getScoped().get("WebFramework");
        if (configs != null) {
            WebFrameworkConfigElement wfce = (WebFrameworkConfigElement)configs.get("web-framework");
            dojoPackages = wfce.getDojoPackages();
        } else {
            dojoPackages = this.webFrameworkConfigElement.getDojoPackages();
        }
        return dojoPackages;
    }

    public String getPath(String sourcePath, String dependencyPath) {
        int idx;
        StringBuilder sb = new StringBuilder(64);
        if (dependencyPath.startsWith("\"") || dependencyPath.startsWith("'")) {
            dependencyPath = dependencyPath.substring(1);
        }
        if (dependencyPath.endsWith("\"") || dependencyPath.endsWith("'")) {
            dependencyPath = dependencyPath.substring(0, dependencyPath.length() - 1);
        }
        boolean usesModuleAlias = false;
        if (!(dependencyPath.startsWith(".") || dependencyPath.startsWith("..") || dependencyPath.startsWith("/") || (idx = dependencyPath.indexOf("/")) == -1)) {
            String firstFolder = dependencyPath.substring(0, idx);
            String alias = this.getRequestDojoPackages().get(firstFolder);
            if (alias != null) {
                usesModuleAlias = true;
                String s = dependencyPath.replace(firstFolder, alias);
                sb.append(s);
            }
        }
        if (!usesModuleAlias) {
            sb.append(this.dependencyHandler.getRelativePath(sourcePath, dependencyPath));
        }
        return sb.toString();
    }

    public void processControllerWidgets(List widgets, Map<String, DojoDependencies> dependenciesForCurrentRequest) {
        if (widgets != null) {
            for (Object w : widgets) {
                Object l;
                Object m;
                if (!(w instanceof Map)) continue;
                Map map = (Map)w;
                Object s = map.get(WIDGET_NAME);
                if (s instanceof String) {
                    String widgetPath = this.getPath(null, (String)s) + ".js";
                    DojoDependencies widgetDeps = this.getDependencies(widgetPath);
                    dependenciesForCurrentRequest.put(widgetPath, widgetDeps);
                    this.recursivelyProcessDependencies(widgetDeps, dependenciesForCurrentRequest);
                }
                if (!((m = map.get(WIDGET_CONFIG)) instanceof Map) || !((l = ((Map)m).get(WIDGETS_LIST)) instanceof List)) continue;
                this.processControllerWidgets((List)l, dependenciesForCurrentRequest);
            }
        }
    }

    public void processCssDependencies(Map<String, DojoDependencies> dependenciesForCurrentRequest, OutputCSSContentModelElement outputCss, String prefix, String group) {
        Set<String> depKeys = dependenciesForCurrentRequest.keySet();
        Object[] a = depKeys.toArray();
        for (int i = a.length - 1; i >= 0; --i) {
            DojoDependencies currDep = dependenciesForCurrentRequest.get(a[i]);
            if (currDep == null || outputCss == null) continue;
            for (DojoDependencies.CssDependency cssDep : currDep.getCssDeps()) {
                outputCss.addDojoCssDependency(cssDep.getPath(), cssDep.getMediaType(), group);
            }
        }
    }

    public void processNonAmdDependencies(Map<String, DojoDependencies> dependenciesForCurrentRequest, OutputJavaScriptContentModelElement outputJs, String prefix, String group) {
        Set<String> depKeys = dependenciesForCurrentRequest.keySet();
        Object[] a = depKeys.toArray();
        for (int i = 0; i < a.length; ++i) {
            DojoDependencies currDep = dependenciesForCurrentRequest.get(a[i]);
            if (currDep == null || outputJs == null) continue;
            for (String dep : currDep.getNonAmdDependencies()) {
                outputJs.addNonAmdJavaScriptFile(dep, group);
            }
        }
    }
}

