/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyRule;

public class DojoI18nDependencyRule
extends DojoDependencyRule {
    private String widgetNamePatternString;
    private Pattern widgetNamePattern;
    private int widgetNameTargetGroup;
    private WebFrameworkConfigElement webFrameworkConfigElement;

    protected void processDependency(String dependency, String sourcePath, String sourceContents, Matcher matcher, DojoDependencies dependencies) {
        String widgetName = null;
        Matcher m1 = this.widgetNamePattern.matcher(sourceContents);
        if (m1.find() && m1.groupCount() >= this.widgetNameTargetGroup) {
            widgetName = m1.group(this.widgetNameTargetGroup);
        }
        String i18nPath = this.getDojoDependencyHandler().getPath(sourcePath, matcher.group(1));
        if (widgetName == null || widgetName.equals("")) {
            widgetName = this.webFrameworkConfigElement.getDojoMessagesDefaultScope();
        }
        dependencies.addI18nDep(i18nPath, widgetName);
    }

    public String getWidgetNamePatternString() {
        return this.widgetNamePatternString;
    }

    public void setWidgetNamePatternString(String widgetNamePatternString) {
        this.widgetNamePatternString = widgetNamePatternString;
        this.widgetNamePattern = Pattern.compile(widgetNamePatternString);
    }

    public int getWidgetNameTargetGroup() {
        return this.widgetNameTargetGroup;
    }

    public void setWidgetNameTargetGroup(int widgetNameTargetGroup) {
        this.widgetNameTargetGroup = widgetNameTargetGroup;
    }

    public WebFrameworkConfigElement getWebFrameworkConfigElement() {
        return this.webFrameworkConfigElement;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }
}

