/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ThreadLocalPreviewContext;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.persister.CachedPersister;
import org.springframework.extensions.surf.persister.PersisterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectPersistenceService {
    private static final Log logger = LogFactory.getLog(ObjectPersistenceService.class);
    private PersisterService persisterService;

    public void setPersisterService(PersisterService persisterService) {
        this.persisterService = persisterService;
    }

    public PersisterService getPersisterService() {
        return this.persisterService;
    }

    public ModelPersistenceContext getPersistenceContext() {
        ModelPersistenceContext mpc = null;
        ThreadLocalPreviewContext previewContext = ThreadLocalPreviewContext.getPreviewContext();
        if (previewContext != null) {
            mpc = new ModelPersistenceContext(previewContext.getUserId());
            mpc.setStoreId(previewContext.getStoreId());
            mpc.setWebappId(previewContext.getWebappId());
        } else {
            mpc = new ModelPersistenceContext(null);
        }
        return mpc;
    }

    public ModelObject getObject(String objectTypeId, String objectId) {
        ModelObject obj = null;
        ModelPersistenceContext context = this.getPersistenceContext();
        ModelObjectPersister preferredPersister = this.persisterService.getTypeToPersisterMap().get(objectTypeId);
        try {
            obj = preferredPersister.getObject(context, objectTypeId, objectId);
        }
        catch (ModelObjectPersisterException e) {
            // empty catch block
        }
        if (obj == null) {
            Iterator<ModelObjectPersister> persisters = this.persisterService.getPersisters().iterator();
            while (obj == null && persisters.hasNext()) {
                try {
                    ModelObjectPersister currentPersister = persisters.next();
                    if (currentPersister == preferredPersister) continue;
                    obj = currentPersister.getObject(context, objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    throw new PlatformRuntimeException("Unable to retrieve object: " + objectId + " of type: " + objectTypeId, (Throwable)mope);
                }
            }
        }
        return obj;
    }

    public ModelObject newObject(String objectTypeId, String objectId) {
        ModelObject obj;
        block3: {
            obj = null;
            ModelObjectPersister persister = this.persisterService.getTypeToPersisterMap().get(objectTypeId);
            if (persister != null) {
                try {
                    obj = persister.newObject(this.getPersistenceContext(), objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)("Unable to create object: " + objectId + " of type: " + objectTypeId), (Throwable)mope);
                }
            }
        }
        return obj;
    }

    public ModelObject newObject(String objectTypeId) {
        ModelObject obj;
        block3: {
            obj = null;
            ModelObjectPersister persister = this.persisterService.getTypeToPersisterMap().get(objectTypeId);
            if (persister != null) {
                String objectId = ObjectPersistenceService.newGUID();
                try {
                    obj = persister.newObject(this.getPersistenceContext(), objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info((Object)("Unable to create object: " + objectId + " of type: " + objectTypeId), (Throwable)mope);
                }
            }
        }
        return obj;
    }

    public boolean saveObject(ModelObject object) throws ModelObjectPersisterException {
        boolean saved = false;
        ModelObjectPersister persister = this.persisterService.getPersisterIdToPersisterMap().get(object.getPersisterId());
        if (persister != null) {
            try {
                if (persister.hasReadOnlyStore()) {
                    persister = this.persisterService.getTypeToPersisterMap().get(object.getTypeId());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attempting to save object '" + object.getId() + "' to persister: " + persister.getId()));
                }
                saved = persister.saveObject(this.getPersistenceContext(), object);
            }
            catch (ModelObjectPersisterException mope) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Unable to save object: " + object.getId() + " of type: " + object.getTypeId() + " to persister: " + persister.getId() + " due to error"), (Throwable)mope);
                }
            }
        } else {
            throw new ModelObjectPersisterException("Object \"" + object.getId() + "\" is configured to use the persister \"" + object.getPersisterId() + "\" that is not configured in the application context: " + this.persisterService.getPersisterIdToPersisterMap().size());
        }
        return saved;
    }

    public boolean saveObjects(List<ModelObject> objects) throws ModelObjectPersisterException {
        boolean saved = false;
        LinkedHashMap<ModelObjectPersister, LinkedList<ModelObject>> saveMap = new LinkedHashMap<ModelObjectPersister, LinkedList<ModelObject>>();
        for (ModelObject object : objects) {
            ModelObjectPersister persister = this.persisterService.getPersisterIdToPersisterMap().get(object.getPersisterId());
            if (persister != null) {
                LinkedList<ModelObject> toAppend;
                if (persister.hasReadOnlyStore()) {
                    persister = this.persisterService.getTypeToPersisterMap().get(object.getTypeId());
                }
                if ((toAppend = (LinkedList<ModelObject>)saveMap.get(persister)) == null) {
                    toAppend = new LinkedList<ModelObject>();
                    saveMap.put(persister, toAppend);
                }
                toAppend.add(object);
                continue;
            }
            throw new ModelObjectPersisterException("Object \"" + object.getId() + "\" is configured to use the persister \"" + object.getPersisterId() + "\" that is not configured in the application context: " + this.persisterService.getPersisterIdToPersisterMap().size());
        }
        for (ModelObjectPersister persister : saveMap.keySet()) {
            try {
                saved = persister.saveObjects(this.getPersistenceContext(), (List)saveMap.get(persister));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("saveObjects save to persister '" + persister.getId() + "' returned: " + saved));
                }
                if (!saved) continue;
                break;
            }
            catch (ModelObjectPersisterException mope) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Unable to save objects to persister: " + persister.getId() + " due to error"), (Throwable)mope);
            }
        }
        return saved;
    }

    public boolean removeObject(ModelObject object) {
        return this.removeObject(object.getTypeId(), object.getId());
    }

    public boolean removeObject(String objectTypeId, String objectId) {
        boolean removed = false;
        ModelPersistenceContext context = this.getPersistenceContext();
        ModelObjectPersister preferredPersister = this.persisterService.getTypeToPersisterMap().get(objectTypeId);
        try {
            removed = preferredPersister.removeObject(context, objectTypeId, objectId);
        }
        catch (ModelObjectPersisterException e) {
            // empty catch block
        }
        if (!removed) {
            Iterator<ModelObjectPersister> persisters = this.persisterService.getPersisters().iterator();
            while (!removed && persisters.hasNext()) {
                try {
                    ModelObjectPersister currentPersister = persisters.next();
                    if (currentPersister == preferredPersister) continue;
                    removed = persisters.next().removeObject(context, objectTypeId, objectId);
                }
                catch (ModelObjectPersisterException mope) {
                    throw new PlatformRuntimeException("Unable to remove object: " + objectId + " of type: " + objectTypeId, (Throwable)mope);
                }
            }
        }
        return removed;
    }

    public boolean hasObject(ModelObject object) {
        return this.hasObject(object.getTypeId(), object.getId());
    }

    public boolean hasObject(String objectTypeId, String objectId) {
        boolean result = false;
        ModelPersistenceContext context = this.getPersistenceContext();
        ModelObjectPersister preferredPersister = this.persisterService.getTypeToPersisterMap().get(objectTypeId);
        try {
            result = preferredPersister.hasObject(context, objectTypeId, objectId);
        }
        catch (ModelObjectPersisterException e) {
            // empty catch block
        }
        if (!result) {
            for (ModelObjectPersister currentPersister : this.persisterService.getPersisters()) {
                try {
                    if (currentPersister != preferredPersister) {
                        result = currentPersister.hasObject(context, objectTypeId, objectId);
                    }
                }
                catch (ModelObjectPersisterException mope) {
                    throw new PlatformRuntimeException("Unable to retrieve object: " + objectId + " of type: " + objectTypeId, (Throwable)mope);
                }
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    public Map<String, ModelObject> getAllObjects(String objectTypeId) {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>();
        for (ModelObjectPersister persister : this.persisterService.getPersisters()) {
            try {
                objects.putAll(persister.getAllObjects(this.getPersistenceContext(), objectTypeId));
            }
            catch (ModelObjectPersisterException mope) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)"ModelObjectManager unable to retrieve all objects", (Throwable)mope);
            }
        }
        return objects;
    }

    public Map<String, ModelObject> getAllObjects(String objectTypeId, String filter) {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(128, 1.0f);
        for (ModelObjectPersister persister : this.persisterService.getPersisters()) {
            try {
                objects.putAll(persister.getAllObjectsByFilter(this.getPersistenceContext(), objectTypeId, filter));
            }
            catch (ModelObjectPersisterException mope) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("ModelObjectManager unable to retrieve all objects by filter: " + filter), (Throwable)mope);
            }
        }
        return objects;
    }

    private static String newGUID() {
        return ModelHelper.newGUID();
    }

    public void invalidateCache() {
        for (ModelObjectPersister persister : this.persisterService.getPersisters()) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).invalidateCache();
        }
    }
}

