/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorProviderException;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorProvider;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.User;

public class WebFrameworkConnectorProvider
implements ConnectorProvider {
    private static final Log logger = LogFactory.getLog(WebFrameworkConnectorProvider.class);
    private ConnectorService connectorService;

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public Connector provide(String endpoint) throws ConnectorProviderException {
        Connector conn = null;
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        if (rc != null) {
            try {
                User user = rc.getUser();
                if (user == null || rc.getCredentialVault() == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"No user was found, creating unauthenticated connector");
                    }
                    conn = this.connectorService.getConnector(endpoint);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User '" + user.getId() + "' was found, creating authenticated connector"));
                }
                HttpSession httpSession = ServletUtil.getSession(true);
                conn = this.connectorService.getConnector(endpoint, rc.getUserId(), httpSession);
            }
            catch (ConnectorServiceException cse) {
                throw new ConnectorProviderException("Unable to provision connector for endpoint: " + endpoint, (Exception)((Object)cse));
            }
        } else {
            try {
                conn = this.connectorService.getConnector(endpoint);
            }
            catch (ConnectorServiceException cse) {
                throw new ConnectorProviderException("Unable to provision non-credential'd connector for endpoint: " + endpoint, (Exception)((Object)cse));
            }
        }
        return conn;
    }
}

