/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractLoginController
extends AbstractController {
    private UserFactory userFactory;

    public void setUserFactory(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setCharacterEncoding("UTF-8");
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        boolean success = false;
        try {
            boolean authenticated;
            HttpSession session = request.getSession(false);
            if (session != null && request.getSession().getAttribute("_alf_USER_ID") != null) {
                AuthenticationUtil.logout(request, response);
            }
            if (authenticated = this.userFactory.authenticate(request, username, password)) {
                AuthenticationUtil.login(request, response, username, false);
                success = true;
            }
        }
        catch (Throwable err) {
            throw new ServletException(err);
        }
        if (success) {
            this.onSuccess(request, response);
        } else {
            this.onFailure(request, response);
        }
        return null;
    }

    protected abstract void onFailure(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected abstract void onSuccess(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

