/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkView;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.connector.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageView
extends AbstractWebFrameworkView {
    private static Log logger = LogFactory.getLog(PageView.class);
    private static final String ALF_REDIRECT_URL = "alfRedirectUrl";
    private static final String ALF_LAST_USERNAME = "alfLastUsername";
    private String pageId = null;

    public PageView(WebFrameworkConfigElement webFrameworkConfiguration, ModelObjectService modelObjectService, ResourceService resourceService, RenderService renderService, TemplatesContainer templatesContainer) {
        super(webFrameworkConfiguration, modelObjectService, resourceService, renderService, templatesContainer);
    }

    public PageView(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    public void setPage(Page page) {
        this.pageId = page.getId();
    }

    @Override
    protected void setupRequestContext(Map<String, Object> mvcModel, HttpServletRequest request) throws Exception {
        if (this.pageId != null) {
            ThreadLocalRequestContext.getRequestContext().setPage(this.getObjectService().getPage(this.pageId));
        } else {
            logger.error((Object)"The current PageView does not have its \"page\" property set. Please ensure that the associated view resolver is calling the setPage() method when building the view!");
        }
    }

    @Override
    protected void validateRequestContext(RequestContext context, HttpServletRequest request) throws Exception {
        Page rootPage;
        if (context.getPage() == null && context.getCurrentObjectId() == null && context.getSiteConfiguration() != null && (rootPage = context.getRootPage()) != null) {
            context.setPage(rootPage);
        }
    }

    protected String buildLoginRedirectURL(HttpServletRequest request) {
        String redirectUrl = request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
        return redirectUrl;
    }

    @Override
    protected void renderView(RequestContext context) throws Exception {
        block15: {
            String formatId = context.getFormatId();
            String objectId = context.getCurrentObjectId();
            String pageId = context.getPageId();
            Page page = context.getPage();
            HttpServletRequest request = ServletUtil.getRequest();
            if (page != null && this.loginRequiredForPage(context, request, page)) {
                Theme theme;
                String loginPageId = null;
                String themeId = context.getThemeId();
                if (themeId != null && (theme = this.getObjectService().getTheme(themeId)) != null) {
                    loginPageId = theme.getPageId("login");
                }
                if (loginPageId == null) {
                    loginPageId = this.getWebFrameworkConfiguration().getDefaultPageTypeInstanceId("login");
                }
                Page loginPage = null;
                if (loginPageId != null && (loginPage = this.lookupPage(loginPageId)) != null) {
                    HashMap<String, String> args = new HashMap<String, String>(request.getParameterMap().size(), 1.0f);
                    Enumeration names = request.getParameterNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        args.put(name, request.getParameter(name));
                    }
                    context.setValue(ALF_REDIRECT_URL, (Serializable)((Object)this.buildLoginRedirectURL(request)));
                    Cookie cookie = AuthenticationUtil.getUsernameCookie(request);
                    if (cookie != null) {
                        context.setValue(ALF_LAST_USERNAME, (Serializable)((Object)URLDecoder.decode((String)cookie.getValue())));
                    }
                    context.setPage(loginPage);
                    this.dispatchPage(context, loginPage.getId(), formatId);
                    return;
                }
                if (loginPageId == null || loginPage == null) {
                    throw new PlatformRuntimeException("No 'login' page type configured - but page auth required it.");
                }
            }
            if (logger.isDebugEnabled()) {
                PageView.debug(context, "Current Page ID: " + pageId);
                PageView.debug(context, "Current Format ID: " + formatId);
                PageView.debug(context, "Current Object ID: " + objectId);
            }
            if (page == null && objectId == null) {
                if (logger.isDebugEnabled()) {
                    PageView.debug(context, "No Page or Object determined");
                }
                try {
                    if (!this.getRenderService().renderSystemPage(context, "page-getting-started")) {
                        throw new RequestDispatchException("Unable to discover a page to be dispatched - no target page or root page specified and a getting started page was not configured.");
                    }
                    break block15;
                }
                catch (RendererExecutionException ree) {
                    throw new RequestDispatchException(ree);
                }
            }
            if (pageId != null) {
                if (logger.isDebugEnabled()) {
                    PageView.debug(context, "Dispatching to Page: " + pageId);
                }
                this.dispatchPage(context, pageId, formatId);
            }
        }
    }

    protected boolean loginRequiredForPage(RequestContext context, HttpServletRequest request, Page page) {
        boolean login = false;
        User user = context.getUser();
        switch (page.getAuthentication()) {
            case guest: {
                login = user == null;
                break;
            }
            case user: {
                login = user == null || AuthenticationUtil.isGuest(user.getId());
                break;
            }
            case admin: {
                boolean bl = login = user == null || !user.isAdmin();
                if (!login) break;
                AuthenticationUtil.clearUserContext(request);
            }
        }
        return login;
    }

    public void dispatchPage(RequestContext context, String pageId, String formatId) throws RequestDispatchException {
        TemplateProcessor templateProcessor;
        TemplateProcessorRegistry templateProcessorRegistry;
        String validTemplatePath;
        TemplateInstance currentTemplate;
        Page page = context.getPage();
        if (page == null || !page.getId().equals(pageId)) {
            page = this.lookupPage(pageId);
            context.setPage(page);
        }
        if (logger.isDebugEnabled()) {
            PageView.debug(context, "Template ID: " + page.getTemplateId());
        }
        if ((currentTemplate = page.getTemplate(context)) == null && (validTemplatePath = (templateProcessorRegistry = this.getTemplatesContainer().getTemplateProcessorRegistry()).findValidTemplatePath(pageId)) != null && (templateProcessor = templateProcessorRegistry.getTemplateProcessor(validTemplatePath)) != null) {
            currentTemplate = this.getObjectService().newTemplate(pageId);
            currentTemplate.setTemplateTypeId(pageId);
            context.setTemplate(currentTemplate);
        }
        if (currentTemplate != null) {
            if (logger.isDebugEnabled()) {
                PageView.debug(context, "Rendering Page with template: " + currentTemplate.getId());
            }
            this.getRenderService().renderPage(context, RenderFocus.BODY);
        } else {
            if (logger.isDebugEnabled()) {
                PageView.debug(context, "Unable to render Page - template was not found");
            }
            try {
                if (!this.getRenderService().renderSystemPage(context, "page-unconfigured")) {
                    throw new RequestDispatchException("The page '" + pageId + "' exists but a template association could not be determined.");
                }
            }
            catch (RendererExecutionException ree) {
                throw new RequestDispatchException(ree);
            }
        }
    }

    protected static void debug(RequestContext context, String value) {
        logger.debug((Object)("[" + context.getId() + "] " + value));
    }
}

