/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.types.Component;

public final class RenderUtil {
    private static Log logger = LogFactory.getLog(RenderUtil.class);
    private static final int MASK = 15;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void page(RequestContext context, HttpServletRequest request, HttpServletResponse response, String pageId, String formatId, String objectId) {
        String url = context.getLinkBuilder().page(context, pageId, formatId, objectId);
        if (url != null) {
            try {
                response.getWriter().write(url);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    public static void object(RequestContext context, HttpServletRequest request, HttpServletResponse response, String objectId, String formatId) {
        String url = context.getLinkBuilder().object(context, objectId, formatId);
        if (url != null) {
            try {
                response.getWriter().write(url);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    public static void pageType(RequestContext context, HttpServletRequest request, HttpServletResponse response, String pageTypeId, String formatId, String objectId) {
        String url = context.getLinkBuilder().pageType(context, pageTypeId, formatId, objectId);
        if (url != null) {
            try {
                response.getWriter().write(url);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    public static String renderScriptImport(RequestContext context, String uri) {
        String src = context.getLinkBuilder().resource(context, uri);
        return "<script type=\"text/javascript\" src=\"" + src + "\"></script>";
    }

    public static String renderLinkImport(RequestContext context, String uri) {
        return RenderUtil.renderLinkImport(context, uri, null);
    }

    public static String renderLinkImport(RequestContext context, String uri, String id) {
        String href = context.getLinkBuilder().resource(context, uri);
        String value = "<link ";
        if (id != null) {
            value = value + "id=\"" + id + "\" ";
        }
        value = value + "rel=\"stylesheet\" type=\"text/css\" href=\"" + href + "\"></link>";
        return value;
    }

    public static String validHtmlId(String id) {
        int len = id.length();
        StringBuilder buf = new StringBuilder(len + (len >> 1) + 8);
        for (int i = 0; i < len; ++i) {
            char c;
            char ci = c = id.charAt(i);
            if (i == 0) {
                if (ci >= 'a' && ci <= 'z' || ci >= 'A' && ci <= 'Z') {
                    buf.append(c);
                    continue;
                }
                RenderUtil.encodef(c, buf);
                continue;
            }
            if (ci >= 'a' && ci <= 'z' || ci >= 'A' && ci <= 'Z' || ci >= '0' && ci <= '9' || ci == '-' || ci == '_') {
                buf.append(c);
                continue;
            }
            RenderUtil.encode(c, buf);
        }
        return buf.toString();
    }

    private static void encode(char c, StringBuilder builder) {
        char[] buf = new char[]{'_', 'x', '0', '0', '0', '0', '_'};
        int charPos = 6;
        do {
            buf[--charPos] = DIGITS[c & 0xF];
        } while ((c = (char)(c >>> 4)) != '\u0000');
        builder.append(buf);
    }

    private static void encodef(char c, StringBuilder builder) {
        char[] buf = new char[]{'x', '0', '0', '0', '0', '_'};
        int charPos = 5;
        do {
            buf[--charPos] = DIGITS[c & 0xF];
        } while ((c = (char)(c >>> 4)) != '\u0000');
        builder.append(buf);
    }

    public static RequestContext getContext(HttpServletRequest request) {
        return (RequestContext)request.getAttribute("renderContext");
    }

    public static String getSourceId(RequestContext context, String scopeId) {
        String sourceId = null;
        if ("global".equals(scopeId)) {
            sourceId = "global";
        } else if ("template".equals(scopeId)) {
            sourceId = context.getTemplateId();
        } else if ("page".equals(scopeId)) {
            sourceId = context.getPageId();
        } else if ("uri".equals(scopeId)) {
            sourceId = context.getViewName() != null ? context.getViewName() : context.getUri();
        } else if ("theme".equals(scopeId)) {
            sourceId = context.getThemeId();
        }
        return sourceId;
    }

    public static Object getComponentBindingSourceObject(RequestContext context, Component component) {
        Object obj = null;
        String scopeId = component.getScope();
        String sourceId = component.getSourceId();
        if ("global".equals(scopeId)) {
            obj = "global";
        } else if ("template".equals(scopeId)) {
            obj = context.getObjectService().getTemplate(sourceId);
        } else if ("page".equals(scopeId)) {
            obj = context.getObjectService().getPage(sourceId);
        } else if ("uri".equals(scopeId)) {
            obj = context.getViewName() != null ? context.getViewName() : context.getUri();
        } else if ("theme".equals(scopeId)) {
            obj = context.getObjectService().getTheme(sourceId);
        }
        return obj;
    }

    public static String generateComponentId(String scopeId, String regionId, String sourceId) {
        String generatedId = null;
        if (scopeId != null && regionId != null) {
            StringBuilder id = new StringBuilder(64);
            id.append(scopeId).append('.').append(regionId);
            if (sourceId != null && !"global".equals(scopeId)) {
                id.append('.').append(sourceId.replace('/', '~'));
            }
            generatedId = id.toString();
        }
        return generatedId;
    }
}

