/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.site;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.util.URLEncoder;

public class AuthenticationUtil {
    private static final String COOKIE_ALFLOGIN = "alfLogin";
    private static final String COOKIE_ALFUSER = "alfUsername3";
    private static final int TIMEOUT = 604800;
    private static final String MT_GUEST_PREFIX = "guest@";

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().invalidate();
        if (response != null) {
            Cookie userCookie = new Cookie(COOKIE_ALFUSER, "");
            userCookie.setPath(request.getContextPath());
            userCookie.setMaxAge(0);
            response.addCookie(userCookie);
        }
    }

    public static void login(HttpServletRequest request, String userId) {
        AuthenticationUtil.login(request, null, userId, true);
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String userId) {
        AuthenticationUtil.login(request, response, userId, true);
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String userId, boolean logout) {
        String currentUserId;
        if (logout && (currentUserId = (String)request.getSession().getAttribute("_alf_USER_ID")) != null) {
            AuthenticationUtil.logout(request, response);
        }
        request.getSession().setAttribute("_alf_USER_ID", (Object)userId);
        if (response != null) {
            long timeInSeconds = System.currentTimeMillis() / 1000L;
            Cookie loginCookie = new Cookie(COOKIE_ALFLOGIN, Long.toString(timeInSeconds));
            loginCookie.setPath(request.getContextPath());
            loginCookie.setMaxAge(604800);
            response.addCookie(loginCookie);
            if (!AuthenticationUtil.isGuest(userId)) {
                Cookie userCookie = new Cookie(COOKIE_ALFUSER, URLEncoder.encode((String)userId));
                userCookie.setPath(request.getContextPath());
                userCookie.setMaxAge(604800);
                response.addCookie(userCookie);
            }
        }
    }

    public static void clearUserContext(HttpServletRequest request) {
        request.getSession().removeAttribute("_alf_USER_ID");
        request.getSession().removeAttribute("_alf_USER_OBJECT");
    }

    public static boolean isAuthenticated(HttpServletRequest request) {
        String userId = (String)request.getSession().getAttribute("_alf_USER_ID");
        return userId != null && !AuthenticationUtil.isGuest(userId);
    }

    public static boolean isGuest(String userId) {
        return userId != null && ("guest".equals(userId) || userId.startsWith(MT_GUEST_PREFIX));
    }

    public static boolean isExternalAuthentication(HttpServletRequest request) {
        return request.getSession().getAttribute("_alfExternalAuth") != null;
    }

    public static String getUserId(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("_alf_USER_ID");
    }

    public static Cookie getLastLoginCookie(HttpServletRequest request) {
        return AuthenticationUtil.getCookie(request, COOKIE_ALFLOGIN);
    }

    public static Cookie getUsernameCookie(HttpServletRequest request) {
        return AuthenticationUtil.getCookie(request, COOKIE_ALFUSER);
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
        }
        return cookie;
    }
}

