/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.support.BaseFactoryBean;

public abstract class ThreadLocalRequestContext
extends BaseFactoryBean
implements RequestContext {
    private static final long serialVersionUID = -5110756572122308893L;
    private static Log logger = LogFactory.getLog(ThreadLocalRequestContext.class);
    private static ThreadLocal<RequestContext> instance = new ThreadLocal();

    protected ThreadLocalRequestContext(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting RequestContext " + this.getId() + " on thread: " + Thread.currentThread().getName()));
        }
        instance.set(this);
    }

    public static RequestContext getRequestContext() {
        return instance.get();
    }

    public void release() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Releasing RequestContext " + this.getId() + " from thread: " + Thread.currentThread().getName()));
        }
        instance.remove();
    }
}

