/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentException;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteExtensionModule
extends DeclarativeWebScript {
    private ModuleDeploymentService moduleDeploymentService;

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        if (this.moduleDeploymentService != null) {
            String moduleId = req.getParameter("moduleId");
            try {
                if (!this.moduleDeploymentService.deleteModuleFromExtension(moduleId)) {
                    status.setCode(404);
                    status.setMessage("The requested module was not found.");
                    status.setRedirect(true);
                }
            }
            catch (ModelObjectPersisterException e) {
                status.setCode(500);
                status.setMessage("An error occurred saving the Extension");
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
            catch (DocumentException e) {
                status.setCode(500);
                status.setMessage("An error occurred parsing the existing Extension XML");
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
        }
        return model;
    }
}

