/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.runner;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.impl.WrapperCmisTestGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunner {
    public static final String OVERRIDE_KEY = "org.apache.chemistry";
    public static final String DEFAULT_TCK_GROUPS = "/cmis-tck-groups.txt";
    public static final String TCK_BUILD_TIMESTAMP = "/META-INF/build-timestamp.txt";
    public static final String TCK_BUILD_TIMESTAMP_PARAMETER = "org.apache.chemistry.opencmis.tck.timestamp";
    public static final String TCK_REVISION = "/META-INF/tck-revision.txt";
    public static final String TCK_REVISION_PARAMETER = "org.apache.chemistry.opencmis.tck.revision";
    private Map<String, String> parameters;
    private final List<CmisTestGroup> groups = new ArrayList<CmisTestGroup>();
    private boolean isCanceled = false;

    public void setParameters(Map<String, String> orgParameters) {
        this.parameters = new HashMap<String, String>();
        if (orgParameters != null) {
            this.parameters.putAll(orgParameters);
        }
        for (Object key : System.getProperties().keySet()) {
            if (!key.toString().startsWith(OVERRIDE_KEY)) continue;
            this.parameters.put(key.toString(), System.getProperties().getProperty(key.toString()));
        }
        this.parameters.put(TCK_BUILD_TIMESTAMP_PARAMETER, this.loadTCKTimestamp());
        String revision = this.loadTCKRevision();
        if (revision != null) {
            this.parameters.put(TCK_REVISION_PARAMETER, revision);
        }
    }

    public void loadParameters(File file) throws IOException {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("File not found!");
        }
        this.loadParameters(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadParameters(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        BufferedReader reader = null;
        HashMap<String, String> loadParams = new HashMap<String, String>();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int x = line.indexOf(61);
                if (x < 0) {
                    loadParams.put(line.trim(), "");
                    continue;
                }
                loadParams.put(line.substring(0, x).trim(), line.substring(x + 1).trim());
            }
            this.setParameters(loadParams);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private String loadTCKTimestamp() {
        StringBuilder result = new StringBuilder();
        InputStream stream = this.getClass().getResourceAsStream(TCK_BUILD_TIMESTAMP);
        if (stream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                String s = null;
                while ((s = br.readLine()) != null) {
                    result.append(s);
                }
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    private String loadTCKRevision() {
        String result = null;
        InputStream stream = this.getClass().getResourceAsStream(TCK_REVISION);
        if (stream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                result = br.readLine();
                br.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result != null) {
                try {
                    result = String.valueOf(Integer.parseInt(result.trim()));
                }
                catch (NumberFormatException nfe) {
                    result = null;
                }
            }
        }
        return result;
    }

    public void loadDefaultTckGroups() throws Exception {
        this.loadGroups(this.getClass().getResourceAsStream(DEFAULT_TCK_GROUPS));
    }

    public void loadGroups(File file) throws Exception {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("File not found!");
        }
        this.loadGroups(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGroups(InputStream stream) throws Exception {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                this.addGroup(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    public void addGroups(String[] groupClasses) throws Exception {
        if (groupClasses == null) {
            return;
        }
        for (String groupClass : groupClasses) {
            this.addGroup(groupClass);
        }
    }

    public void addGroup(String groupClass) throws Exception {
        if (groupClass == null) {
            return;
        }
        if ((groupClass = groupClass.trim()).length() == 0) {
            return;
        }
        Class clazz = ClassLoaderUtil.loadClass((String)groupClass);
        Object o = clazz.newInstance();
        CmisTestGroup group = null;
        if (o instanceof CmisTestGroup) {
            group = (CmisTestGroup)o;
        } else if (o instanceof CmisTest) {
            group = new WrapperCmisTestGroup((CmisTest)o);
        } else {
            throw new Exception("Not a CmisTestGroup or CmisTest class!");
        }
        this.addGroup(group);
    }

    public void addGroup(CmisTestGroup group) throws Exception {
        if (group != null) {
            group.init(this.parameters);
            this.groups.add(group);
        }
    }

    public List<CmisTestGroup> getGroups() {
        return this.groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CmisTestProgressMonitor monitor) throws Exception {
        AbstractRunner abstractRunner = this;
        synchronized (abstractRunner) {
            this.isCanceled = false;
        }
        for (CmisTestGroup group : this.groups) {
            AbstractRunner abstractRunner2 = this;
            synchronized (abstractRunner2) {
                if (this.isCanceled) {
                    break;
                }
            }
            if (group == null || !group.isEnabled()) continue;
            group.setProgressMonitor(monitor);
            group.run();
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void cancel() {
        this.isCanceled = true;
    }
}

