/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationContextTest
extends AbstractSessionTest {
    private static final String CONTENT = "TCK test content.";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Operation Context");
        this.setDescription("Creates a document, retrieves a minimal set of details, checks it, and finally deletes the document.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            Document document = this.createDocument(session, testFolder, "testdoc.txt", CONTENT);
            this.runHighLevelApiTests(session, testFolder, document);
            this.runLowLevelApiTests(session, testFolder, document);
            document.delete(true);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    public void runHighLevelApiTests(Session session, Folder testFolder, Document testDocument) {
        HashSet<String> properties = new HashSet<String>();
        properties.add("cmis:objectId");
        properties.add("cmis:baseTypeId");
        properties.add("cmis:objectTypeId");
        OperationContext context = session.createOperationContext();
        context.setCacheEnabled(false);
        context.setFilter(properties);
        context.setIncludeAcls(false);
        context.setIncludeAllowableActions(false);
        context.setIncludePathSegments(false);
        context.setIncludePolicies(false);
        context.setIncludeRelationships(IncludeRelationships.NONE);
        context.setLoadSecondaryTypeProperties(false);
        context.setRenditionFilterString("cmis:none");
        Document doc1 = (Document)session.getObject((ObjectId)testDocument, context);
        for (Property prop : doc1.getProperties()) {
            if (properties.contains(prop.getDefinition().getQueryName())) continue;
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered the property '" + prop.getId() + "', although it has not been requested."));
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered ACLs, although they have not been requested.");
        this.addResult(this.assertNull(doc1.getAcl(), null, f));
        f = this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered Allowable Actions, although they have not been requested.");
        this.addResult(this.assertNull(doc1.getAllowableActions(), null, f));
        f = this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered policies, although they have not been requested.");
        this.addResult(this.assertIsTrue(doc1.getPolicies() == null || doc1.getPolicies().isEmpty(), null, f));
        f = this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered relationships, although they have not been requested.");
        this.addResult(this.assertIsTrue(doc1.getRelationships() == null || doc1.getRelationships().isEmpty(), null, f));
        f = this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered renditions, although they have not been requested.");
        this.addResult(this.assertIsTrue(doc1.getRenditions() == null || doc1.getRenditions().isEmpty(), null, f));
        for (CmisObject child : testFolder.getChildren(context)) {
            if (!child.getId().equals(testDocument.getId())) continue;
            for (Property prop : child.getProperties()) {
                if (properties.contains(prop.getDefinition().getQueryName())) continue;
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "getChildren() delivered the property '" + prop.getId() + "', although it has not been requested."));
            }
            f = this.createResult(CmisTestResultStatus.INFO, "getChildren() delivered ACLs, which is not required.");
            this.addResult(this.assertNull(child.getAcl(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "getChildren() delivered Allowable Actions, although they have not been requested.");
            this.addResult(this.assertNull(child.getAllowableActions(), null, f));
            f = this.createResult(CmisTestResultStatus.INFO, "getChildren() delivered policies, which is not required.");
            this.addResult(this.assertIsTrue(child.getPolicies() == null || child.getPolicies().isEmpty(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "getChildren() delivered relationships, although they have not been requested.");
            this.addResult(this.assertIsTrue(child.getRelationships() == null || child.getRelationships().isEmpty(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "getChildren() delivered renditions, although they have not been requested.");
            this.addResult(this.assertIsTrue(child.getRenditions() == null || child.getRenditions().isEmpty(), null, f));
            break;
        }
    }

    public void runLowLevelApiTests(Session session, Folder testFolder, Document testDocument) {
        String repositoryId = session.getRepositoryInfo().getId();
        String filter = "cmis:objectId,cmis:baseTypeId,cmis:objectTypeId";
        ObjectData doc1 = session.getBinding().getObjectService().getObject(repositoryId, testDocument.getId(), filter, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, Boolean.FALSE, null);
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.WARNING, "getObject() delivered a change event, which doesn't make sense.");
        this.addResult(this.assertNull(doc1.getChangeEventInfo(), null, f));
        ObjectInFolderList children = session.getBinding().getNavigationService().getChildren(repositoryId, testFolder.getId(), filter, null, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, null, BigInteger.ZERO, null);
        for (ObjectInFolderData child : children.getObjects()) {
            f = this.createResult(CmisTestResultStatus.WARNING, "getChildren() delivered a path segment, although it hasn't been requested.");
            this.addResult(this.assertNull(child.getPathSegment(), null, f));
        }
        List parents = session.getBinding().getNavigationService().getObjectParents(repositoryId, testDocument.getId(), filter, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, null);
        for (ObjectParentData parent : parents) {
            f = this.createResult(CmisTestResultStatus.WARNING, "getObjectParents() delivered a relative path segment, although it hasn't been requested.");
            this.addResult(this.assertNull(parent.getRelativePathSegment(), null, f));
        }
    }
}

