/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLikeTest
extends AbstractQueryTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Query LIKE Test");
        this.setDescription("Performs a query that should return the root folder name and id.");
    }

    @Override
    public void run(Session session) {
        if (this.supportsQuery(session) && !this.isFulltextOnly(session)) {
            OperationContext context = session.createOperationContext();
            context.setFilterString("cmis:name,cmis:creationDate");
            context.setCacheEnabled(false);
            context.setIncludeAcls(false);
            context.setIncludeAllowableActions(false);
            context.setIncludePathSegments(false);
            context.setIncludePolicies(false);
            context.setIncludeRelationships(IncludeRelationships.NONE);
            context.setRenditionFilterString("cmis:none");
            context.setOrderBy("cmis:creationDate");
            for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                long timestamp = Long.MIN_VALUE;
                for (CmisObject o : session.queryObjects("cmis:document", "cmis:name LIKE '" + c + "%'", false, context).getPage(10)) {
                    CmisTestResultImpl f;
                    if (o.getName() == null) {
                        this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Documents without name should not be returned by this query! Document id: " + o.getId()));
                    } else {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Document name should start with '" + c + "' but the name is '" + o.getName() + "'");
                        this.addResult(this.assertIsTrue(o.getName().startsWith("" + c), null, f));
                    }
                    if (o.getCreationDate() == null) {
                        this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Found document without creation date! Document id: " + o.getId()));
                        continue;
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Query results should be ordered by cmis:creationDate but they are not!");
                    this.addResult(this.assertIsTrue(timestamp <= o.getCreationDate().getTimeInMillis(), null, f));
                    timestamp = o.getCreationDate().getTimeInMillis();
                }
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Metadata query not supported. Test Skipped!"));
        }
    }
}

