/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.alfresco.encryption.AlfrescoKeyStoreImpl;
import org.alfresco.encryption.EncryptionUtils;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.ssl.AuthSSLProtocolSocketFactory;
import org.alfresco.encryption.ssl.SSLEncryptionParameters;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AbstractHttpClient;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.EncryptionService;
import org.alfresco.httpclient.HttpMethodResponse;
import org.alfresco.httpclient.MD5EncryptionParameters;
import org.alfresco.httpclient.Request;
import org.alfresco.httpclient.Response;
import org.alfresco.util.Pair;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientFactory {
    private static final Log logger = LogFactory.getLog(HttpClientFactory.class);
    private SSLEncryptionParameters sslEncryptionParameters;
    private KeyResourceLoader keyResourceLoader;
    private SecureCommsType secureCommsType;
    private KeyStoreParameters keyStoreParameters;
    private MD5EncryptionParameters encryptionParameters;
    private String host;
    private int port;
    private int sslPort;
    private AlfrescoKeyStore sslKeyStore;
    private AlfrescoKeyStore sslTrustStore;
    private ProtocolSocketFactory sslSocketFactory;
    private int maxTotalConnections = 40;
    private int maxHostConnections = 40;
    private int socketTimeout = 0;
    private int connectionTimeout = 0;

    public HttpClientFactory() {
    }

    public HttpClientFactory(SecureCommsType secureCommsType, SSLEncryptionParameters sslEncryptionParameters, KeyResourceLoader keyResourceLoader, KeyStoreParameters keyStoreParameters, MD5EncryptionParameters encryptionParameters, String host, int port, int sslPort, int maxTotalConnections, int maxHostConnections, int socketTimeout) {
        this.secureCommsType = secureCommsType;
        this.sslEncryptionParameters = sslEncryptionParameters;
        this.keyResourceLoader = keyResourceLoader;
        this.keyStoreParameters = keyStoreParameters;
        this.encryptionParameters = encryptionParameters;
        this.host = host;
        this.port = port;
        this.sslPort = sslPort;
        this.maxTotalConnections = maxTotalConnections;
        this.maxHostConnections = maxHostConnections;
        this.socketTimeout = socketTimeout;
        this.init();
    }

    public void init() {
        this.sslKeyStore = new AlfrescoKeyStoreImpl(this.sslEncryptionParameters.getKeyStoreParameters(), this.keyResourceLoader);
        this.sslTrustStore = new AlfrescoKeyStoreImpl(this.sslEncryptionParameters.getTrustStoreParameters(), this.keyResourceLoader);
        this.sslSocketFactory = new AuthSSLProtocolSocketFactory(this.sslKeyStore, this.sslTrustStore, this.keyResourceLoader);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public boolean isSSL() {
        return this.secureCommsType == SecureCommsType.HTTPS;
    }

    public void setSecureCommsType(String type) {
        try {
            this.secureCommsType = SecureCommsType.getType(type);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("", e);
        }
    }

    public void setSSLEncryptionParameters(SSLEncryptionParameters sslEncryptionParameters) {
        this.sslEncryptionParameters = sslEncryptionParameters;
    }

    public void setKeyStoreParameters(KeyStoreParameters keyStoreParameters) {
        this.keyStoreParameters = keyStoreParameters;
    }

    public void setEncryptionParameters(MD5EncryptionParameters encryptionParameters) {
        this.encryptionParameters = encryptionParameters;
    }

    public void setKeyResourceLoader(KeyResourceLoader keyResourceLoader) {
        this.keyResourceLoader = keyResourceLoader;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getMaxHostConnections() {
        return this.maxHostConnections;
    }

    public void setMaxHostConnections(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected HttpClient constructHttpClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        HttpClientParams params = httpClient.getParams();
        params.setBooleanParameter("http.tcp.nodelay", true);
        params.setBooleanParameter("http.connection.stalecheck", true);
        params.setSoTimeout(this.socketTimeout);
        HttpConnectionManagerParams connectionManagerParams = httpClient.getHttpConnectionManager().getParams();
        connectionManagerParams.setMaxTotalConnections(this.maxTotalConnections);
        connectionManagerParams.setDefaultMaxConnectionsPerHost(this.maxHostConnections);
        connectionManagerParams.setConnectionTimeout(this.connectionTimeout);
        return httpClient;
    }

    protected HttpClient getHttpsClient() {
        HttpClient httpClient = this.constructHttpClient();
        HttpHostFactory hostFactory = new HttpHostFactory(new Protocol("https", this.sslSocketFactory, this.sslPort));
        httpClient.setHostConfiguration((HostConfiguration)new HostConfigurationWithHostFactory(hostFactory));
        httpClient.getHostConfiguration().setHost(this.host, this.sslPort, "https");
        return httpClient;
    }

    protected HttpClient getDefaultHttpClient() {
        HttpClient httpClient = this.constructHttpClient();
        httpClient.getHostConfiguration().setHost(this.host, this.port);
        return httpClient;
    }

    protected AlfrescoHttpClient getAlfrescoHttpsClient() {
        HttpsClient repoClient = new HttpsClient(this.getHttpsClient());
        return repoClient;
    }

    protected AlfrescoHttpClient getAlfrescoHttpClient() {
        DefaultHttpClient repoClient = new DefaultHttpClient(this.getDefaultHttpClient());
        return repoClient;
    }

    protected HttpClient getMD5HttpClient(String host, int port) {
        HttpClient httpClient = this.constructHttpClient();
        httpClient.getHostConfiguration().setHost(host, port);
        return httpClient;
    }

    protected AlfrescoHttpClient getAlfrescoMD5HttpClient(String host, int port) {
        SecureHttpClient repoClient = new SecureHttpClient(this.getDefaultHttpClient(), this.keyResourceLoader, host, port, this.keyStoreParameters, this.encryptionParameters);
        return repoClient;
    }

    protected AlfrescoHttpClient getAlfrescoMD5HttpClient(String host, int port, EncryptionService encryptionService) {
        SecureHttpClient repoClient = new SecureHttpClient(this.getDefaultHttpClient(), encryptionService);
        return repoClient;
    }

    public AlfrescoHttpClient getRepoClient(String host, int port) {
        AlfrescoHttpClient repoClient = null;
        if (this.secureCommsType == SecureCommsType.HTTPS) {
            repoClient = this.getAlfrescoHttpsClient();
        } else if (this.secureCommsType == SecureCommsType.NONE) {
            repoClient = this.getAlfrescoHttpClient();
        } else {
            throw new AlfrescoRuntimeException("Invalid Solr secure communications type configured in alfresco.secureComms, should be 'ssl'or 'none'");
        }
        return repoClient;
    }

    public HttpClient getHttpClient() {
        HttpClient httpClient = null;
        if (this.secureCommsType == SecureCommsType.HTTPS) {
            httpClient = this.getHttpsClient();
        } else if (this.secureCommsType == SecureCommsType.NONE) {
            httpClient = this.getDefaultHttpClient();
        } else {
            throw new AlfrescoRuntimeException("Invalid Solr secure communications type configured in alfresco.secureComms, should be 'ssl'or 'none'");
        }
        return httpClient;
    }

    private static class HostConfigurationWithHostFactory
    extends HostConfiguration {
        private final HttpHostFactory factory;

        public HostConfigurationWithHostFactory(HttpHostFactory factory) {
            this.factory = factory;
        }

        public synchronized void setHost(String host, int port, String scheme) {
            this.setHost(this.factory.getHost(host, port, scheme));
        }

        public synchronized void setHost(String host, int port) {
            this.setHost(this.factory.getHost(host, port, "http"));
        }

        public synchronized void setHost(URI uri) {
            try {
                this.setHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            catch (URIException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    private static class HttpHostFactory {
        private Map<String, Protocol> protocols = new HashMap<String, Protocol>(2);

        public HttpHostFactory(Protocol httpsProtocol) {
            this.protocols.put("https", httpsProtocol);
        }

        public HttpHost getHost(String host, int port, String scheme) {
            Protocol protocol;
            if (scheme == null) {
                scheme = "http";
            }
            if ((protocol = this.protocols.get(scheme)) == null && (protocol = Protocol.getProtocol((String)"http")) == null) {
                throw new IllegalArgumentException("Unrecognised scheme parameter");
            }
            return new HttpHost(host, port, protocol);
        }
    }

    static class SecureHttpMethodResponse
    extends HttpMethodResponse {
        protected HostConfiguration hostConfig;
        protected EncryptionUtils encryptionUtils;
        protected byte[] decryptedBody;

        public SecureHttpMethodResponse(HttpMethod method, HostConfiguration hostConfig, EncryptionUtils encryptionUtils) throws AuthenticationException, IOException {
            super(method);
            this.hostConfig = hostConfig;
            this.encryptionUtils = encryptionUtils;
            if (method.getStatusCode() == 200) {
                this.decryptedBody = encryptionUtils.decryptResponseBody(method);
                if (!this.authenticate()) {
                    throw new AuthenticationException(method);
                }
            }
        }

        protected boolean authenticate() throws IOException {
            return this.encryptionUtils.authenticateResponse(this.method, this.hostConfig.getHost(), this.decryptedBody);
        }

        @Override
        public InputStream getContentAsStream() throws IOException {
            if (this.decryptedBody != null) {
                return new ByteArrayInputStream(this.decryptedBody);
            }
            return null;
        }
    }

    class SecureHttpClient
    extends AbstractHttpClient {
        private Encryptor encryptor;
        private EncryptionUtils encryptionUtils;
        private EncryptionService encryptionService;

        public SecureHttpClient(HttpClient httpClient, EncryptionService encryptionService) {
            super(httpClient);
            this.encryptionUtils = encryptionService.getEncryptionUtils();
            this.encryptor = encryptionService.getEncryptor();
            this.encryptionService = encryptionService;
        }

        public SecureHttpClient(HttpClient httpClient, KeyResourceLoader keyResourceLoader, String host, int port, KeyStoreParameters keyStoreParameters, MD5EncryptionParameters encryptionParameters) {
            super(httpClient);
            this.encryptionService = new EncryptionService(host, port, keyResourceLoader, keyStoreParameters, encryptionParameters);
            this.encryptionUtils = this.encryptionService.getEncryptionUtils();
            this.encryptor = this.encryptionService.getEncryptor();
        }

        @Override
        protected HttpMethod createMethod(Request req) throws IOException {
            byte[] message = null;
            HttpMethod method = super.createMethod(req);
            if (req.getMethod().equalsIgnoreCase("POST")) {
                message = req.getBody();
                Pair<byte[], AlgorithmParameters> encrypted = this.encryptor.encrypt("solr", null, message);
                this.encryptionUtils.setRequestAlgorithmParameters(method, encrypted.getSecond());
                ((PostMethod)method).getParams().setBooleanParameter("http.protocol.expect-continue", encrypted.getFirst().length > 4096);
                ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(encrypted.getFirst(), "application/octet-stream");
                ((PostMethod)method).setRequestEntity((RequestEntity)requestEntity);
            }
            this.encryptionUtils.setRequestAuthentication(method, message);
            return method;
        }

        @Override
        protected HttpMethod sendRemoteRequest(Request req) throws AuthenticationException, IOException {
            HttpMethod method = super.sendRemoteRequest(req);
            if (method.getStatusCode() == 401) {
                throw new AuthenticationException(method);
            }
            return method;
        }

        @Override
        public Response sendRequest(Request req) throws AuthenticationException, IOException {
            HttpMethod method = super.sendRemoteRequest(req);
            return new SecureHttpMethodResponse(method, this.httpClient.getHostConfiguration(), this.encryptionUtils);
        }
    }

    class DefaultHttpClient
    extends AbstractHttpClient {
        public DefaultHttpClient(HttpClient httpClient) {
            super(httpClient);
        }

        @Override
        public Response sendRequest(Request req) throws AuthenticationException, IOException {
            HttpMethod method = super.sendRemoteRequest(req);
            return new HttpMethodResponse(method);
        }
    }

    class HttpsClient
    extends AbstractHttpClient {
        public HttpsClient(HttpClient httpClient) {
            super(httpClient);
        }

        @Override
        public Response sendRequest(Request req) throws AuthenticationException, IOException {
            HttpMethod method = super.sendRemoteRequest(req);
            return new HttpMethodResponse(method);
        }
    }

    public static enum SecureCommsType {
        HTTPS,
        NONE;


        public static SecureCommsType getType(String type) {
            if (type.equalsIgnoreCase("https")) {
                return HTTPS;
            }
            if (type.equalsIgnoreCase("none")) {
                return NONE;
            }
            throw new IllegalArgumentException("Invalid communications type");
        }
    }
}

