/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.alfresco.error.AlfrescoRuntimeException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ISO8601DateFormat {
    public static String format(Date isoDate) {
        DateTime dt = new DateTime((Object)isoDate, DateTimeZone.UTC);
        return dt.toString();
    }

    public static String formatToZulu(String isoDate) {
        try {
            DateTime dt = new DateTime((Object)isoDate, DateTimeZone.UTC);
            return dt.toString();
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
    }

    public static Date parse(String isoDate) {
        return ISO8601DateFormat.parseInternal(isoDate, null);
    }

    public static Date parse(String isoDate, TimeZone timezone) {
        return ISO8601DateFormat.parseInternal(isoDate, timezone);
    }

    public static Date parseInternal(String isoDate, TimeZone timezone) {
        try {
            DateTimeZone dtz = DateTimeZone.forTimeZone((TimeZone)timezone);
            DateTime dateTime = new DateTime((Object)isoDate, dtz);
            Date date = dateTime.toDate();
            return date;
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
    }

    public static boolean isTimeComponentDefined(String isoDate) {
        boolean defined = false;
        if (isoDate != null && isoDate.length() > 11) {
            int expectedLocation = 10;
            if (isoDate.charAt(0) == '-' || isoDate.charAt(0) == '+') {
                ++expectedLocation;
            }
            defined = isoDate.length() >= expectedLocation && isoDate.charAt(expectedLocation) == 'T';
        }
        return defined;
    }

    public static Date parseDayOnly(String isoDate, TimeZone timezone) {
        try {
            if (isoDate != null && isoDate.length() >= 10) {
                int offset = 0;
                boolean bc = false;
                if (isoDate.charAt(0) == '-') {
                    bc = true;
                } else if (isoDate.charAt(0) == '+') {
                    ++offset;
                }
                int year = Integer.parseInt(isoDate.substring(++offset, offset += 4));
                if (isoDate.charAt(offset) != '-') {
                    throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
                }
                int month = Integer.parseInt(isoDate.substring(++offset, offset += 2));
                if (isoDate.charAt(offset) != '-') {
                    throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
                }
                int day = Integer.parseInt(isoDate.substring(++offset, offset += 2));
                GregorianCalendar calendar = new GregorianCalendar(timezone);
                calendar.setLenient(false);
                calendar.set(1, year);
                calendar.set(2, month - 1);
                calendar.set(5, day);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                if (bc) {
                    calendar.set(0, 0);
                }
                return calendar.getTime();
            }
            throw new AlfrescoRuntimeException("String passed is too short " + isoDate);
        }
        catch (IndexOutOfBoundsException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
        catch (NumberFormatException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
    }
}

