/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TempFileProvider {
    private static final int BUFFER_SIZE = 40960;
    public static final String ALFRESCO_TEMP_FILE_DIR = "Alfresco";
    public static final String ALFRESCO_LONG_LIFE_FILE_DIR = "longLife";
    public static final String SYSTEM_KEY_TEMP_DIR = "java.io.tmpdir";
    private static final Log logger = LogFactory.getLog(TempFileProvider.class);
    private static int MAX_RETRIES = 3;

    private TempFileProvider() {
    }

    public static File getSystemTempDir() {
        String systemTempDirPath = System.getProperty(SYSTEM_KEY_TEMP_DIR);
        if (systemTempDirPath == null) {
            throw new AlfrescoRuntimeException("System property not available: java.io.tmpdir");
        }
        File systemTempDir = new File(systemTempDirPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created system temporary directory: " + systemTempDir));
        }
        return systemTempDir;
    }

    public static File getTempDir() {
        File systemTempDir = TempFileProvider.getSystemTempDir();
        File tempDir = new File(systemTempDir, ALFRESCO_TEMP_FILE_DIR);
        if (!tempDir.exists()) {
            if (!tempDir.mkdirs()) {
                throw new AlfrescoRuntimeException("Failed to create temp directory: " + tempDir);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created temp directory: " + tempDir));
            }
        }
        return tempDir;
    }

    public static File getLongLifeTempDir(String key) {
        String folderName = "longLife_" + key;
        File tempDir = TempFileProvider.getTempDir();
        File longLifeDir = new File(tempDir, folderName);
        if (longLifeDir.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Already exists: " + longLifeDir));
            }
            return longLifeDir;
        }
        for (int retry = 0; retry < MAX_RETRIES; ++retry) {
            boolean created = longLifeDir.mkdirs();
            if (created) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created long life temp directory: " + longLifeDir));
                }
                return longLifeDir;
            }
            if (!longLifeDir.exists()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Another thread created long life temp directory: " + longLifeDir));
            }
            return longLifeDir;
        }
        throw new AlfrescoRuntimeException("Failed to create temp directory: " + longLifeDir);
    }

    public static File createTempFile(InputStream in, String namePrefix, String nameSufix) throws Exception {
        if (null == in) {
            return null;
        }
        File file = TempFileProvider.createTempFile(namePrefix, nameSufix);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 40960);
        try {
            int i;
            byte[] buffer = new byte[40960];
            while ((i = in.read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, i);
            }
        }
        catch (Exception e) {
            file.delete();
            throw e;
        }
        finally {
            in.close();
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        return file;
    }

    private static boolean isLongLifeTempDir(File file) {
        if (file.isDirectory()) {
            return file.getName().startsWith(ALFRESCO_LONG_LIFE_FILE_DIR);
        }
        return false;
    }

    public static File createTempFile(String prefix, String suffix) {
        File tempDir = TempFileProvider.getTempDir();
        return TempFileProvider.createTempFile(prefix, suffix, tempDir);
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        try {
            File tempFile = File.createTempFile(prefix, suffix, directory);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating tmp file: " + tempFile));
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to created temp file: \n   prefix: " + prefix + "\n" + "   suffix: " + suffix + "\n" + "   directory: " + directory, e);
        }
    }

    public static class TempFileCleanerJob
    implements Job {
        public static final String KEY_PROTECT_HOURS = "protectHours";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            String strProtectHours = (String)context.getJobDetail().getJobDataMap().get((Object)KEY_PROTECT_HOURS);
            if (strProtectHours == null) {
                throw new JobExecutionException("Missing job data: protectHours");
            }
            int protectHours = -1;
            try {
                protectHours = Integer.parseInt(strProtectHours);
            }
            catch (NumberFormatException e) {
                throw new JobExecutionException("Invalid job data protectHours: " + strProtectHours);
            }
            if (protectHours < 0 || protectHours > 8760) {
                throw new JobExecutionException("Hours to protect temp files must be 0 <= x <= 8760");
            }
            long now = System.currentTimeMillis();
            long aFewHoursBack = now - 3600000L * (long)protectHours;
            long aLongTimeBack = now - 86400000L;
            File tempDir = TempFileProvider.getTempDir();
            int count = TempFileCleanerJob.removeFiles(tempDir, aFewHoursBack, aLongTimeBack, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed " + count + " files from temp directory: " + tempDir));
            }
        }

        public static int removeFiles(long removeBefore) {
            File tempDir = TempFileProvider.getTempDir();
            return TempFileCleanerJob.removeFiles(tempDir, removeBefore, removeBefore, false);
        }

        private static int removeFiles(File directory, long removeBefore, long longLifeBefore, boolean removeDir) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Expected a directory to clear: " + directory);
            }
            if (!directory.exists()) {
                return 0;
            }
            File[] files = directory.listFiles();
            int count = 0;
            for (File file : files) {
                if (file.isDirectory()) {
                    if (TempFileProvider.isLongLifeTempDir(file)) {
                        int countRemoved = TempFileCleanerJob.removeFiles(file, longLifeBefore, longLifeBefore, true);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Removed " + countRemoved + " files from temp directory: " + file));
                        continue;
                    }
                    int countRemoved = TempFileCleanerJob.removeFiles(file, removeBefore, longLifeBefore, true);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed " + countRemoved + " files from directory: " + file));
                    continue;
                }
                if (file.lastModified() > removeBefore) continue;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting temp file: " + file));
                    }
                    file.delete();
                    ++count;
                }
                catch (Throwable e) {
                    logger.info((Object)("Failed to remove temp file: " + file));
                }
            }
            if (removeDir) {
                try {
                    File[] listing = directory.listFiles();
                    if (listing != null && listing.length == 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Deleting empty directory: " + directory));
                        }
                        directory.delete();
                    }
                }
                catch (Throwable e) {
                    logger.info((Object)("Failed to remove temp directory: " + directory), e);
                }
            }
            return count;
        }
    }
}

