/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.SolrLuceneAnalyser;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoDataType
extends FieldType {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoDataType.class);
    private String id;

    public boolean isTokenized() {
        return true;
    }

    public boolean isMultiValued() {
        return true;
    }

    public boolean multiValuedFieldCache() {
        return true;
    }

    public SortField getSortField(SchemaField field, boolean reverse) {
        return AlfrescoSolrDataModel.getInstance(this.id).getSortField(field, reverse);
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        this.id = schema.getResourceLoader().getInstanceDir();
        File alfrescoModelDir = new File(this.id, "alfrescoModels");
        if (alfrescoModelDir.exists() && alfrescoModelDir.isDirectory()) {
            for (File file : alfrescoModelDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".xml");
                }
            })) {
                try {
                    FileInputStream modelStream = new FileInputStream(file);
                    M2Model model = M2Model.createModel((InputStream)modelStream);
                    ((InputStream)modelStream).close();
                    for (M2Namespace namespace : model.getNamespaces()) {
                        modelMap.put(namespace.getUri(), model);
                    }
                }
                catch (FileNotFoundException e) {
                    throw new AlfrescoRuntimeException("File not found", (Throwable)e);
                }
                catch (IOException e) {
                    throw new AlfrescoRuntimeException("File not found", (Throwable)e);
                }
            }
        }
        HashSet<String> loadedModels = new HashSet<String>();
        for (M2Model model : modelMap.values()) {
            this.loadModel(modelMap, loadedModels, model);
        }
        if (modelMap.size() > 0) {
            AlfrescoSolrDataModel.getInstance(this.id).afterInitModels();
        }
        AlfrescoSolrDataModel.getInstance(this.id).setAlfrescoDataType(this);
        super.init(schema, args);
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, f.stringValue());
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public Analyzer getDefaultAnalyzer() {
        return super.getAnalyzer();
    }

    public Analyzer getDefaultQueryAnalyzer() {
        return super.getQueryAnalyzer();
    }

    public SolrLuceneAnalyser getAnalyzer() {
        return AlfrescoSolrDataModel.getInstance(this.id).getSolrLuceneAnalyser();
    }

    public Field createField(SchemaField field, String externalVal, float boost) {
        String val = this.toInternal(externalVal);
        if (val == null) {
            return null;
        }
        if (!field.indexed() && !field.stored()) {
            return null;
        }
        Field f = new Field(field.getName(), val, this.getFieldStore(field, val), this.getFieldIndex(field, val), this.getFieldTermVec(field, val));
        f.setOmitNorms(this.getOmitNorms(field, val));
        f.setOmitTermFreqAndPositions(field.omitTf());
        return f;
    }

    protected Field.Index getFieldIndex(SchemaField field, String internalVal) {
        return AlfrescoSolrDataModel.getInstance(this.id).getFieldIndex(field);
    }

    protected Field.Store getFieldStore(SchemaField field, String internalVal) {
        return AlfrescoSolrDataModel.getInstance(this.id).getFieldStore(field);
    }

    protected Field.TermVector getFieldTermVec(SchemaField field, String internalVal) {
        return AlfrescoSolrDataModel.getInstance(this.id).getFieldTermVec(field);
    }

    protected boolean getOmitNorms(SchemaField field, String internalVal) {
        return AlfrescoSolrDataModel.getInstance(this.id).getOmitNorms(field);
    }

    public Analyzer getQueryAnalyzer() {
        return AlfrescoSolrDataModel.getInstance(this.id).getSolrLuceneQueryAnalyser();
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        return AlfrescoSolrDataModel.getInstance(this.id).getRangeQuery(field, part1, part2, minInclusive, maxInclusive);
    }

    private void loadModel(Map<String, M2Model> modelMap, HashSet<String> loadedModels, M2Model model) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel);
            }
            AlfrescoSolrDataModel.getInstance(this.id).putModel(model);
            loadedModels.add(modelName);
        }
    }
}

