/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FileUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoReplicationHandler
extends ReplicationHandler
implements SolrCoreAware {
    private static final Logger LOG = LoggerFactory.getLogger((String)AlfrescoReplicationHandler.class.getName());
    public static final String NUMBER_BACKUPS_TO_KEEP = "numberToKeep";
    SolrCore core;

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        int numberToKeep;
        rsp.setHttpCaching(false);
        SolrParams solrParams = req.getParams();
        String command = solrParams.get("command");
        if (command == null) {
            rsp.add("status", (Object)"OK");
            rsp.add("message", (Object)"No command");
            return;
        }
        super.handleRequestBody(req, rsp);
        if (command.equalsIgnoreCase("backup") && (numberToKeep = solrParams.getInt(NUMBER_BACKUPS_TO_KEEP, Integer.MAX_VALUE)) < Integer.MAX_VALUE) {
            new AlfrescoSnapShooter(this.core, solrParams.get("location")).deleteOldBackups(numberToKeep);
        }
    }

    public void inform(SolrCore core) {
        this.core = core;
        super.inform(core);
    }

    static boolean delTree(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        boolean isSuccess = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                boolean success;
                if (file.isDirectory()) {
                    success = AlfrescoReplicationHandler.delTree(file);
                    if (success) continue;
                    LOG.warn("Unable to delete directory : " + file);
                    isSuccess = false;
                    continue;
                }
                success = file.delete();
                if (success) continue;
                LOG.warn("Unable to delete file : " + file);
                isSuccess = false;
                return false;
            }
        }
        return isSuccess && dir.delete();
    }

    public class AlfrescoSnapShooter {
        private String snapDir = null;
        public static final String SNAP_DIR = "snapDir";
        public static final String DATE_FMT = "yyyyMMddHHmmss";

        public AlfrescoSnapShooter(SolrCore core, String location) throws IOException {
            if (location == null) {
                this.snapDir = core.getDataDir();
            } else {
                File base = new File(core.getCoreDescriptor().getInstanceDir());
                this.snapDir = FileUtils.resolvePath((File)base, (String)location).getAbsolutePath();
                File dir = new File(this.snapDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
            }
        }

        private void deleteOldBackups(int numberToKeep) {
            File[] files = new File(this.snapDir).listFiles();
            ArrayList<OldBackupDirectory> dirs = new ArrayList<OldBackupDirectory>();
            for (File f : files) {
                OldBackupDirectory obd = new OldBackupDirectory(f);
                if (obd.dir == null) continue;
                dirs.add(obd);
            }
            Collections.sort(dirs);
            int i = 1;
            for (OldBackupDirectory dir : dirs) {
                if (i > numberToKeep - 1) {
                    AlfrescoReplicationHandler.delTree(dir.dir);
                }
                ++i;
            }
        }

        private class OldBackupDirectory
        implements Comparable<OldBackupDirectory> {
            File dir;
            Date timestamp;
            final Pattern dirNamePattern = Pattern.compile("^snapshot[.](.*)$");

            OldBackupDirectory(File dir) {
                Matcher m;
                if (dir.isDirectory() && (m = this.dirNamePattern.matcher(dir.getName())).find()) {
                    try {
                        this.dir = dir;
                        this.timestamp = new SimpleDateFormat(AlfrescoSnapShooter.DATE_FMT).parse(m.group(1));
                    }
                    catch (Exception e) {
                        this.dir = null;
                        this.timestamp = null;
                    }
                }
            }

            @Override
            public int compareTo(OldBackupDirectory that) {
                return that.timestamp.compareTo(this.timestamp);
            }
        }
    }
}

