/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.QNameFilter;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryParser;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.parsers.AlfrescoFunctionEvaluationContext;
import org.alfresco.repo.search.impl.parsers.FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilder;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryModelFactory;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoDataType;
import org.alfresco.solr.AlfrescoSolrDataModelServicesFactory;
import org.alfresco.solr.ContextAwareQuery;
import org.alfresco.solr.PropertyDefinitionWrapper;
import org.alfresco.solr.SolrLuceneAnalyser;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.query.LuceneQueryBuilderContextSolrImpl;
import org.alfresco.solr.query.SolrQueryParser;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class AlfrescoSolrDataModel {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoSolrDataModel.class);
    private static HashMap<String, AlfrescoSolrDataModel> models = new HashMap();
    private static ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    public static HashMap<String, NonDictionaryField> nonDictionaryFields = new HashMap();
    public static HashMap<String, NonDictionaryField> additionalContentFields = new HashMap();
    public static HashMap<String, NonDictionaryField> additionalTextFields = new HashMap();
    public static HashMap<String, NonDictionaryField> additionalMlTextFields = new HashMap();
    private TenantService tenantService;
    private NamespaceDAOImpl namespaceDAO;
    private DictionaryDAOImpl dictionaryDAO;
    private Map<String, DictionaryComponent> dictionaryServices;
    private Map<AlfrescoSolrDataModelServicesFactory.DictionaryKey, CMISAbstractDictionaryService> cmisDictionaryServices;
    private boolean storeAll = false;
    private AlfrescoDataType alfrescoDataType;
    private String id;
    private HashMap<String, Set<String>> modelErrors = new HashMap();

    private static void addNonDictionaryField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        nonDictionaryFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    private static void addAdditionalContentField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        additionalContentFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    private static void addAdditionalTextField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        additionalTextFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    private static void addAdditionalMlTextField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
        additionalMlTextFields.put(name, new NonDictionaryField(name, store, index, termVector, multiValued));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlfrescoSolrDataModel getInstance(String id) {
        AlfrescoSolrDataModel model;
        readWriteLock.readLock().lock();
        try {
            model = models.get(id);
            if (model != null) {
                AlfrescoSolrDataModel alfrescoSolrDataModel = model;
                return alfrescoSolrDataModel;
            }
        }
        finally {
            readWriteLock.readLock().unlock();
        }
        readWriteLock.writeLock().lock();
        try {
            model = models.get(id);
            if (model == null) {
                model = new AlfrescoSolrDataModel(id);
                models.put(id, model);
            }
            AlfrescoSolrDataModel alfrescoSolrDataModel = model;
            return alfrescoSolrDataModel;
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    private AlfrescoSolrDataModel(String id) {
        this.id = id;
        this.tenantService = new SingleTServiceImpl();
        this.namespaceDAO = new NamespaceDAOImpl();
        this.namespaceDAO.setTenantService(this.tenantService);
        this.namespaceDAO.setNamespaceRegistryCache((SimpleCache)new MemoryCache());
        this.dictionaryDAO = new DictionaryDAOImpl((NamespaceDAO)this.namespaceDAO);
        this.dictionaryDAO.setTenantService(this.tenantService);
        this.dictionaryDAO.setDictionaryRegistryCache((SimpleCache)new MemoryCache());
        this.dictionaryDAO.setDefaultAnalyserResourceBundleName("alfresco/model/dataTypeAnalyzers");
        this.dictionaryDAO.setResourceClassLoader(this.getResourceClassLoader());
        QNameFilter qnameFilter = this.getQNameFilter();
        this.dictionaryServices = AlfrescoSolrDataModelServicesFactory.constructDictionaryServices(qnameFilter, this.dictionaryDAO);
        DictionaryComponent dictionaryComponent = this.getDictionaryService("DEFAULT_DICTIONARY");
        dictionaryComponent.setMessageLookup((MessageLookup)new StaticMessageLookup());
        this.cmisDictionaryServices = AlfrescoSolrDataModelServicesFactory.constructDictionaries(qnameFilter, (NamespaceDAO)this.namespaceDAO, dictionaryComponent, (DictionaryDAO)this.dictionaryDAO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QNameFilter getQNameFilter() {
        QNameFilter qnameFilter = null;
        FileSystemXmlApplicationContext ctx = null;
        File resourceDirectory = this.getResourceDirectory();
        File filterContext = new File(resourceDirectory, "alfresco/model/opencmis-qnamefilter-context.xml");
        try {
            ctx = new FileSystemXmlApplicationContext(new String[]{"file:" + filterContext.getAbsolutePath()}, false);
            ctx.setClassLoader(this.getClass().getClassLoader());
            ctx.refresh();
            qnameFilter = (QNameFilter)ctx.getBean("cmisTypeExclusions");
            if (qnameFilter == null) {
                log.warn("Unable to find type filter at " + filterContext.getAbsolutePath() + ", no type filtering");
            }
        }
        catch (BeansException e) {
            log.warn("Unable to parse type filter at " + filterContext.getAbsolutePath() + ", no type filtering");
        }
        finally {
            if (ctx != null && ctx.getBeanFactory() != null && ctx.isActive()) {
                ctx.close();
            }
        }
        return qnameFilter;
    }

    public DictionaryComponent getDictionaryService(String alternativeDictionary) {
        DictionaryComponent dictionaryComponent = null;
        if (alternativeDictionary != null && !alternativeDictionary.trim().isEmpty()) {
            dictionaryComponent = this.dictionaryServices.get(alternativeDictionary);
        }
        if (dictionaryComponent == null) {
            dictionaryComponent = this.dictionaryServices.get("DEFAULT_DICTIONARY");
        }
        return dictionaryComponent;
    }

    public CMISDictionaryService getCMISDictionary(String alternativeDictionary, CmisVersion cmisVersion) {
        AlfrescoSolrDataModelServicesFactory.DictionaryKey key;
        CMISDictionaryService cmisDictionary = null;
        if (alternativeDictionary != null && !alternativeDictionary.trim().isEmpty()) {
            key = new AlfrescoSolrDataModelServicesFactory.DictionaryKey(cmisVersion, alternativeDictionary);
            cmisDictionary = (CMISDictionaryService)this.cmisDictionaryServices.get(key);
        }
        if (cmisDictionary == null) {
            key = new AlfrescoSolrDataModelServicesFactory.DictionaryKey(cmisVersion, "DEFAULT_DICTIONARY");
            cmisDictionary = (CMISDictionaryService)this.cmisDictionaryServices.get(key);
        }
        return cmisDictionary;
    }

    public NamespaceDAO getNamespaceDAO() {
        return this.namespaceDAO;
    }

    public boolean isStoreAll() {
        return this.storeAll;
    }

    public void setStoreAll(boolean storeAll) {
        this.storeAll = storeAll;
    }

    public MLAnalysisMode getMLAnalysisMode() {
        return MLAnalysisMode.EXACT_LANGUAGE_AND_ALL;
    }

    public boolean isIndexedOrStored(QName propertyQName) {
        if (this.storeAll) {
            return true;
        }
        String fieldName = "@" + propertyQName.toString();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(fieldName);
        if (propertyDefinition != null) {
            if (propertyDefinition.isIndexed()) {
                return true;
            }
            return propertyDefinition.isStoredInIndex();
        }
        return true;
    }

    public Field.Index getFieldIndex(SchemaField field) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            if (propertyDefinition.isIndexed()) {
                switch (propertyDefinition.getIndexTokenisationMode()) {
                    default: {
                        return Field.Index.ANALYZED;
                    }
                    case FALSE: 
                }
                return Field.Index.NOT_ANALYZED;
            }
            return Field.Index.NO;
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return nonDDField.index;
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            return additionalContentFields.get(additionalContentFieldEnding).index;
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            return additionalTextFields.get(additionalTextFieldEnding).index;
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            return additionalMlTextFields.get(additionalMlTextFieldEnding).index;
        }
        return Field.Index.ANALYZED;
    }

    private PropertyDefinition getPropertyDefinition(String fieldName) {
        QName rawPropertyName = QName.createQName((String)this.expandFieldName(fieldName).substring(1));
        QName propertyQName = QName.createQName((String)rawPropertyName.getNamespaceURI(), (String)ISO9075.decode((String)rawPropertyName.getLocalName()));
        return this.getPropertyDefinition(propertyQName);
    }

    String expandFieldName(String fieldName) {
        String expandedFieldName = fieldName;
        if (fieldName.startsWith("@")) {
            expandedFieldName = this.expandAttributeFieldName(fieldName);
        } else if (fieldName.startsWith("{")) {
            expandedFieldName = this.expandFieldName("@" + fieldName);
        } else if (fieldName.contains(":")) {
            expandedFieldName = this.expandFieldName("@" + fieldName);
        } else if (nonDictionaryFields.get(fieldName) == null) {
            expandedFieldName = this.expandFieldName("@" + fieldName);
        }
        return expandedFieldName;
    }

    String expandAttributeFieldName(String field) {
        String fieldName = field;
        if (field.charAt(1) != '{') {
            int colonPosition = field.indexOf(58);
            fieldName = colonPosition == -1 ? "@{" + this.getNamespaceDAO().getNamespaceURI("") + "}" + field.substring(1) : "@{" + this.getNamespaceDAO().getNamespaceURI(field.substring(1, colonPosition)) + "}" + field.substring(colonPosition + 1);
        }
        return fieldName;
    }

    public Field.Store getFieldStore(SchemaField field) {
        if (this.storeAll) {
            return Field.Store.YES;
        }
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            return propertyDefinition.isStoredInIndex() ? Field.Store.YES : Field.Store.NO;
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return nonDDField.store;
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            return additionalContentFields.get(additionalContentFieldEnding).store;
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            return additionalTextFields.get(additionalTextFieldEnding).store;
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            return additionalMlTextFields.get(additionalMlTextFieldEnding).store;
        }
        return Field.Store.NO;
    }

    public Field.TermVector getFieldTermVec(SchemaField field) {
        return Field.TermVector.NO;
    }

    public boolean getOmitNorms(SchemaField field) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                return false;
            }
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                return false;
            }
            return !propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT);
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            nonDDField = additionalContentFields.get(additionalContentFieldEnding);
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            nonDDField = additionalTextFields.get(additionalTextFieldEnding);
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            nonDDField = additionalMlTextFields.get(additionalMlTextFieldEnding);
            return nonDDField.index == Field.Index.ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NOT_ANALYZED_NO_NORMS || nonDDField.index == Field.Index.NO_NORMS;
        }
        return false;
    }

    public org.apache.lucene.search.Query getRangeQuery(SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        SolrLuceneAnalyser defaultAnalyser = new SolrLuceneAnalyser((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultAnalyzer(), this);
        SolrQueryParser parser = new SolrQueryParser("TEXT", (Analyzer)defaultAnalyser);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        parser.setNamespacePrefixResolver((NamespacePrefixResolver)this.namespaceDAO);
        parser.setDictionaryService((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"));
        parser.setTenantService(this.tenantService);
        parser.setSearchParameters(null);
        parser.setDefaultSearchMLAnalysisMode(this.getMLAnalysisMode());
        parser.setIndexReader(null);
        parser.setAllowLeadingWildcard(true);
        try {
            return parser.getRangeQuery(field.getName(), part1, part2, minInclusive, maxInclusive, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        catch (ParseException e) {
            throw new AlfrescoRuntimeException("Parse error building range query", (Throwable)e);
        }
    }

    public boolean putModel(M2Model model) {
        Set<String> errors = this.validateModel(model);
        if (errors.size() == 0) {
            this.modelErrors.remove(model.getName());
            this.dictionaryDAO.putModelIgnoringConstraints(model);
            return true;
        }
        if (!this.modelErrors.containsKey(model.getName())) {
            this.modelErrors.put(model.getName(), errors);
            log.warn(errors.iterator().next());
        }
        return false;
    }

    private Set<String> validateModel(M2Model model) {
        HashSet<String> errors = new HashSet<String>();
        try {
            this.dictionaryDAO.getCompiledModel(QName.createQName((String)model.getName(), (NamespacePrefixResolver)this.namespaceDAO));
        }
        catch (DictionaryException e) {
            return errors;
        }
        catch (NamespaceException e) {
            return errors;
        }
        List modelDiffs = this.dictionaryDAO.diffModelIgnoringConstraints(model);
        for (M2ModelDiff modelDiff : modelDiffs) {
            if (!modelDiff.getDiffType().equals("updated")) continue;
            errors.add("Model not updated: " + model.getName() + "   Failed to validate model update - found non-incrementally updated " + modelDiff.getElementType() + " '" + modelDiff.getElementName() + "'");
        }
        return errors;
    }

    public M2Model getM2Model(QName modelQName) {
        return this.dictionaryDAO.getCompiledModel(modelQName).getM2Model();
    }

    public void afterInitModels() {
        for (CMISAbstractDictionaryService cds : this.cmisDictionaryServices.values()) {
            cds.afterDictionaryInit();
        }
    }

    public void setCMDefaultUri() {
        if (AlfrescoSolrDataModel.getInstance(this.id).getNamespaceDAO().getURIs().contains("http://www.alfresco.org/model/content/1.0")) {
            AlfrescoSolrDataModel.getInstance(this.id).getNamespaceDAO().addPrefix("", "http://www.alfresco.org/model/content/1.0");
        }
    }

    public AbstractLuceneQueryParser getLuceneQueryParser(SearchParameters searchParameters, IndexReader indexReader) {
        SolrLuceneAnalyser analyzer = new SolrLuceneAnalyser((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultAnalyzer(), this);
        SolrQueryParser parser = new SolrQueryParser(searchParameters.getDefaultFieldName(), (Analyzer)analyzer);
        QueryParser.Operator defaultOperator = searchParameters.getDefaultOperator() == SearchParameters.AND ? LuceneQueryParser.AND_OPERATOR : LuceneQueryParser.OR_OPERATOR;
        parser.setDefaultOperator(defaultOperator);
        parser.setNamespacePrefixResolver((NamespacePrefixResolver)this.namespaceDAO);
        parser.setDictionaryService((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"));
        parser.setTenantService(this.tenantService);
        parser.setSearchParameters(searchParameters);
        parser.setDefaultSearchMLAnalysisMode(this.getMLAnalysisMode());
        parser.setIndexReader(indexReader);
        parser.setAllowLeadingWildcard(true);
        return parser;
    }

    public LuceneQueryBuilderContext getLuceneQueryBuilderContext(SearchParameters searchParameters, IndexReader indexReader, String alternativeDictionary) {
        LuceneQueryBuilderContextSolrImpl luceneContext = new LuceneQueryBuilderContextSolrImpl((DictionaryService)this.getDictionaryService(alternativeDictionary), (NamespacePrefixResolver)this.namespaceDAO, this.tenantService, searchParameters, this.getMLAnalysisMode(), indexReader, this.alfrescoDataType.getQueryAnalyzer(), this);
        return luceneContext;
    }

    public org.apache.lucene.search.Query getFTSQuery(Pair<SearchParameters, Boolean> searchParametersAndFilter, IndexReader indexReader) throws ParseException {
        SearchParameters searchParameters = (SearchParameters)searchParametersAndFilter.getFirst();
        Boolean isFilter = (Boolean)searchParametersAndFilter.getSecond();
        LuceneQueryModelFactory factory = new LuceneQueryModelFactory();
        AlfrescoFunctionEvaluationContext functionContext = new AlfrescoFunctionEvaluationContext((NamespacePrefixResolver)this.namespaceDAO, (DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), "http://www.alfresco.org/model/content/1.0");
        FTSParser.Mode mode = searchParameters.getDefaultFTSOperator() == SearchParameters.Operator.AND ? FTSParser.Mode.DEFAULT_CONJUNCTION : FTSParser.Mode.DEFAULT_DISJUNCTION;
        Constraint constraint = FTSQueryParser.buildFTS((String)searchParameters.getQuery(), (QueryModelFactory)factory, (FunctionEvaluationContext)functionContext, null, null, (FTSParser.Mode)mode, (QueryOptions.Connective)(searchParameters.getDefaultFTSOperator() == SearchParameters.Operator.OR ? QueryOptions.Connective.OR : QueryOptions.Connective.AND), (Map)searchParameters.getQueryTemplates(), (String)searchParameters.getDefaultFieldName());
        Query queryModelQuery = factory.createQuery(null, null, constraint, new ArrayList());
        LuceneQueryBuilder builder = (LuceneQueryBuilder)queryModelQuery;
        LuceneQueryBuilderContext luceneContext = this.getLuceneQueryBuilderContext(searchParameters, indexReader, "DEFAULT_DICTIONARY");
        Set selectorGroup = null;
        if (queryModelQuery.getSource() != null) {
            List selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        org.apache.lucene.search.Query luceneQuery = builder.buildQuery(selectorGroup, luceneContext, (FunctionEvaluationContext)functionContext);
        ContextAwareQuery contextAwareQuery = new ContextAwareQuery(luceneQuery, Boolean.TRUE.equals(isFilter) ? null : searchParameters);
        return contextAwareQuery;
    }

    public Query parseCMISQueryToAlfrescoAbstractQuery(CMISQueryOptions.CMISQueryMode mode, SearchParameters searchParameters, IndexReader indexReader, String alternativeDictionary, CmisVersion cmisVersion) throws ParseException {
        CMISQueryOptions options = new CMISQueryOptions(searchParameters.getQuery(), StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        options.setDefaultFieldName(searchParameters.getDefaultFieldName());
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setLocales(searchParameters.getLocales());
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setQueryParameterDefinitions((List)searchParameters.getQueryParameterDefinitions());
        CapabilityJoin joinSupport = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CapabilityJoin.NONE : CapabilityJoin.INNERONLY;
        CmisFunctionEvaluationContext functionContext = this.getCMISFunctionEvaluationContext(mode, cmisVersion, alternativeDictionary);
        CMISDictionaryService cmisDictionary = this.getCMISDictionary(alternativeDictionary, cmisVersion);
        CMISQueryParser parser = new CMISQueryParser(options, cmisDictionary, joinSupport);
        Query queryModelQuery = parser.parse((QueryModelFactory)new LuceneQueryModelFactory(), (FunctionEvaluationContext)functionContext);
        Set selectorGroup = null;
        if (queryModelQuery.getSource() != null) {
            List selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        return queryModelQuery;
    }

    public CmisFunctionEvaluationContext getCMISFunctionEvaluationContext(CMISQueryOptions.CMISQueryMode mode, CmisVersion cmisVersion, String alternativeDictionary) {
        BaseTypeId[] validScopes = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService(this.getCMISDictionary(alternativeDictionary, cmisVersion));
        functionContext.setValidScopes(validScopes);
        return functionContext;
    }

    public org.apache.lucene.search.Query getCMISQuery(CMISQueryOptions.CMISQueryMode mode, Pair<SearchParameters, Boolean> searchParametersAndFilter, IndexReader indexReader, Query queryModelQuery, CmisVersion cmisVersion, String alternativeDictionary) throws ParseException {
        SearchParameters searchParameters = (SearchParameters)searchParametersAndFilter.getFirst();
        Boolean isFilter = (Boolean)searchParametersAndFilter.getSecond();
        BaseTypeId[] validScopes = mode == CMISQueryOptions.CMISQueryMode.CMS_STRICT ? CmisFunctionEvaluationContext.STRICT_SCOPES : CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = this.getCMISFunctionEvaluationContext(mode, cmisVersion, alternativeDictionary);
        Set selectorGroup = (Set)queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext).get(0);
        LuceneQueryBuilderContext luceneContext = this.getLuceneQueryBuilderContext(searchParameters, indexReader, alternativeDictionary);
        LuceneQueryBuilder builder = (LuceneQueryBuilder)queryModelQuery;
        org.apache.lucene.search.Query luceneQuery = builder.buildQuery(selectorGroup, luceneContext, (FunctionEvaluationContext)functionContext);
        ContextAwareQuery contextAwareQuery = new ContextAwareQuery(luceneQuery, Boolean.TRUE.equals(isFilter) ? null : searchParameters);
        return contextAwareQuery;
    }

    public SortField getSortField(SchemaField field, boolean reverse) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(field.getName());
        if (propertyDefinition != null) {
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    return Sorting.getStringSortField((String)(this.expandFieldName(field.getName()) + ".sort"), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
                }
                throw new UnsupportedOperationException("Ordering not supported for " + field.getName());
            }
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    return new SortField(this.expandFieldName(field.getName()) + ".sort", (FieldComparatorSource)new TextSortFieldComparatorSource(), reverse);
                }
                throw new UnsupportedOperationException("Ordering not supported for " + field.getName());
            }
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                if (propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.FALSE || propertyDefinition.getIndexTokenisationMode() == IndexTokenisationMode.BOTH) {
                    return new SortField(this.expandFieldName(field.getName()) + ".sort", (FieldComparatorSource)new MLTextSortFieldComparatorSource(), reverse);
                }
                throw new UnsupportedOperationException("Ordering not supported for " + field.getName());
            }
            return Sorting.getStringSortField((String)this.expandFieldName(field.getName()), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        if (field.getName().equals("ID")) {
            return Sorting.getStringSortField((String)"LID", (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        NonDictionaryField nonDDField = nonDictionaryFields.get(field.getName());
        if (nonDDField != null) {
            return Sorting.getStringSortField((String)field.getName(), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        for (String additionalContentFieldEnding : additionalContentFields.keySet()) {
            if (!field.getName().endsWith(additionalContentFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) == null) continue;
            return Sorting.getStringSortField((String)(this.expandFieldName(field.getName().substring(0, field.getName().length() - additionalContentFieldEnding.length())) + additionalContentFieldEnding), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        for (String additionalTextFieldEnding : additionalTextFields.keySet()) {
            if (!field.getName().endsWith(additionalTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) == null) continue;
            return Sorting.getStringSortField((String)(this.expandFieldName(field.getName().substring(0, field.getName().length() - additionalTextFieldEnding.length())) + additionalTextFieldEnding), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        for (String additionalMlTextFieldEnding : additionalMlTextFields.keySet()) {
            if (!field.getName().endsWith(additionalMlTextFieldEnding) || this.getPropertyDefinition(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) == null) continue;
            return Sorting.getStringSortField((String)(this.expandFieldName(field.getName().substring(0, field.getName().length() - additionalMlTextFieldEnding.length())) + additionalMlTextFieldEnding), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
        }
        return Sorting.getStringSortField((String)field.getName(), (boolean)reverse, (boolean)field.sortMissingLast(), (boolean)field.sortMissingFirst());
    }

    public void setAlfrescoDataType(AlfrescoDataType alfrescoDataType) {
        this.alfrescoDataType = alfrescoDataType;
    }

    public List<AlfrescoModel> getAlfrescoModels() {
        ArrayList<AlfrescoModel> answer = new ArrayList<AlfrescoModel>();
        for (QName modelName : this.dictionaryDAO.getModels()) {
            M2Model m2Model = this.dictionaryDAO.getCompiledModel(modelName).getM2Model();
            answer.add(new AlfrescoModel(m2Model, this.getDictionaryService("DEFAULT_DICTIONARY").getModel(modelName).getChecksum(ModelDefinition.XMLBindingType.DEFAULT)));
        }
        return answer;
    }

    public SolrLuceneAnalyser getSolrLuceneAnalyser() {
        return new SolrLuceneAnalyser((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultAnalyzer(), this);
    }

    public ClassLoader getResourceClassLoader() {
        File f = new File(this.id, "alfrescoResources");
        if (f.canRead() && f.isDirectory()) {
            URL[] urls = new URL[1];
            try {
                URL url;
                urls[0] = url = f.toURI().normalize().toURL();
            }
            catch (MalformedURLException e) {
                throw new AlfrescoRuntimeException("Failed to add resources to classpath ", (Throwable)e);
            }
            return URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        }
        return this.getClass().getClassLoader();
    }

    public SolrLuceneAnalyser getSolrLuceneQueryAnalyser() {
        return new SolrLuceneAnalyser((DictionaryService)this.getDictionaryService("DEFAULT_DICTIONARY"), this.getMLAnalysisMode(), this.alfrescoDataType.getDefaultQueryAnalyzer(), this);
    }

    public PropertyDefinition getPropertyDefinition(QName propertyQName) {
        PropertyDefinition propertyDef = this.getDictionaryService("DEFAULT_DICTIONARY").getProperty(propertyQName);
        if (propertyDef != null && propertyDef.getName().equals((Object)ContentModel.PROP_AUTHOR)) {
            return new PropertyDefinitionWrapper(propertyDef);
        }
        if (propertyDef != null && propertyDef.getName().equals((Object)ContentModel.PROP_CREATOR)) {
            return new PropertyDefinitionWrapper(propertyDef);
        }
        if (propertyDef != null && propertyDef.getName().equals((Object)ContentModel.PROP_MODIFIER)) {
            return new PropertyDefinitionWrapper(propertyDef);
        }
        return propertyDef;
    }

    public Map<String, Set<String>> getModelErrors() {
        return Collections.unmodifiableMap(this.modelErrors);
    }

    private File getResourceDirectory() {
        File f = new File(this.id, "alfrescoResources");
        return f;
    }

    static {
        AlfrescoSolrDataModel.addNonDictionaryField("ID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("LID", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("TX", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("PARENT", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("LINKASPECT", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PATH", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("ANCESTOR", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("ISCONTAINER", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ISCATEGORY", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("QNAME", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PRIMARYASSOCQNAME", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("ISROOT", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("PRIMARYASSOCTYPEQNAME", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ISNODE", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ASSOCTYPEQNAME", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PRIMARYPARENT", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("TYPE", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ASPECT", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("FTSSTATUS", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("DBID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("TXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("INTXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ACLTXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("INACLTXID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("TXCOMMITTIME", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ACLTXCOMMITTIME", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("EXCEPTIONMESSAGE", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("EXCEPTIONSTACK", Field.Store.YES, Field.Index.NO, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("ACLID", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addNonDictionaryField("READER", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("OWNER", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addNonDictionaryField("PARENTASSOCCRC", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalContentField(".size", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".locale", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".mimetype", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".encoding", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".contentDocId", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".transformationException", Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".transformationTime", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".transformationStatus", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalContentField(".__", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalTextField(".__", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalTextField(".u", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalTextField(".__.u", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalTextField(".sort", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".__", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".u", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".__.u", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, true);
        AlfrescoSolrDataModel.addAdditionalMlTextField(".sort", Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO, false);
    }

    public static final class MLTextSortFieldComparator
    extends FieldComparator {
        private final String[] values;
        private String[] currentReaderValues;
        private final String field;
        final Collator collator;
        private String bottom;
        Locale collatorLocale;

        MLTextSortFieldComparator(int numHits, String field, Locale collatorLocale) {
            this.values = new String[numHits];
            this.field = field;
            this.collatorLocale = collatorLocale;
            this.collator = Collator.getInstance(collatorLocale);
        }

        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(val1, val2);
        }

        public int compareBottom(int doc) {
            String val2 = this.findBestValue(this.currentReaderValues[doc]);
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(this.bottom, val2);
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.findBestValue(this.currentReaderValues[doc]);
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(reader, this.field);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable value(int slot) {
            return this.values[slot];
        }

        private String findBestValue(String withLocale) {
            if (withLocale == null) {
                return withLocale;
            }
            if (withLocale.startsWith("\u0000")) {
                MLText mlText = new MLText();
                String[] parts = withLocale.split("\u0000");
                int i = 0;
                while (i + 2 <= parts.length) {
                    Locale locale = null;
                    String[] localeParts = parts[i + 1].split("_");
                    if (localeParts.length == 1) {
                        locale = new Locale(localeParts[0]);
                    } else if (localeParts.length == 2) {
                        locale = new Locale(localeParts[0], localeParts[1]);
                    } else if (localeParts.length == 3) {
                        locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
                    }
                    if (locale != null) {
                        if (i + 2 == parts.length) {
                            mlText.addValue(locale, "");
                        } else {
                            mlText.addValue(locale, parts[i + 2]);
                        }
                    }
                    i += 3;
                }
                return mlText.getClosestValue(this.collatorLocale);
            }
            return withLocale;
        }
    }

    public static class MLTextSortFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new MLTextSortFieldComparator(numHits, fieldname, I18NUtil.getLocale());
        }
    }

    public static final class TextSortFieldComparator
    extends FieldComparator {
        private final String[] values;
        private String[] currentReaderValues;
        private final String field;
        final Collator collator;
        private String bottom;

        TextSortFieldComparator(int numHits, String field, Locale locale) {
            this.values = new String[numHits];
            this.field = field;
            this.collator = Collator.getInstance(locale);
        }

        public int compare(int slot1, int slot2) {
            String val1 = this.values[slot1];
            String val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(val1, val2);
        }

        public int compareBottom(int doc) {
            String val2 = this.stripLocale(this.currentReaderValues[doc]);
            if (this.bottom == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return this.collator.compare(this.bottom, val2);
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.stripLocale(this.currentReaderValues[doc]);
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = FieldCache.DEFAULT.getStrings(reader, this.field);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable value(int slot) {
            return this.values[slot];
        }

        private String stripLocale(String withLocale) {
            if (withLocale == null) {
                return withLocale;
            }
            if (withLocale.startsWith("\u0000")) {
                return withLocale.substring(withLocale.indexOf(0, 1) + 1);
            }
            return withLocale;
        }
    }

    public static class TextSortFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new TextSortFieldComparator(numHits, fieldname, I18NUtil.getLocale());
        }
    }

    private static class NonDictionaryField {
        private String name;
        private Field.Store store;
        private Field.Index index;
        private Field.TermVector termVector;
        private boolean multiValued;

        public NonDictionaryField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, boolean multiValued) {
            this.name = name;
            this.store = store;
            this.index = index;
            this.termVector = termVector;
            this.multiValued = multiValued;
        }
    }
}

