/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISStrictDictionaryService;
import org.alfresco.opencmis.dictionary.FilteredDictionaryComponent;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.QNameFilter;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.opencmis.mapping.RuntimePropertyLuceneBuilderMapping;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespaceService;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;

public class AlfrescoSolrDataModelServicesFactory {
    public static final String DICTIONARY_FILTERED_WITH_EXCLUSIONS = "cmisWithExclusions";

    public static Map<DictionaryKey, CMISAbstractDictionaryService> constructDictionaries(QNameFilter qnameFilter, NamespaceDAO namespaceDAO, DictionaryComponent dictionaryService, DictionaryDAO dictionaryDAO) {
        DictionaryNamespaceComponent namespaceService = new DictionaryNamespaceComponent();
        namespaceService.setNamespaceDAO(namespaceDAO);
        CMISMapping cmisMapping = new CMISMapping();
        cmisMapping.setCmisVersion(CmisVersion.CMIS_1_0);
        cmisMapping.setFilter(qnameFilter);
        cmisMapping.setNamespaceService((NamespaceService)namespaceService);
        cmisMapping.setDictionaryService((DictionaryService)dictionaryService);
        cmisMapping.afterPropertiesSet();
        CMISMapping cmisMapping11 = new CMISMapping();
        cmisMapping11.setCmisVersion(CmisVersion.CMIS_1_1);
        cmisMapping11.setFilter(qnameFilter);
        cmisMapping11.setNamespaceService((NamespaceService)namespaceService);
        cmisMapping11.setDictionaryService((DictionaryService)dictionaryService);
        cmisMapping11.afterPropertiesSet();
        HashMap<DictionaryKey, CMISAbstractDictionaryService> dictionaries = new HashMap<DictionaryKey, CMISAbstractDictionaryService>();
        DictionaryKey key = new DictionaryKey(CmisVersion.CMIS_1_0, "DEFAULT_DICTIONARY");
        dictionaries.put(key, (CMISAbstractDictionaryService)AlfrescoSolrDataModelServicesFactory.newInstance(cmisMapping, (DictionaryService)dictionaryService, dictionaryDAO));
        CMISMapping mappingWithExclusions = AlfrescoSolrDataModelServicesFactory.newInstanceOfExcludedCMISMapping(cmisMapping, qnameFilter);
        key = new DictionaryKey(CmisVersion.CMIS_1_0, DICTIONARY_FILTERED_WITH_EXCLUSIONS);
        dictionaries.put(key, (CMISAbstractDictionaryService)AlfrescoSolrDataModelServicesFactory.newInstance(mappingWithExclusions, (DictionaryService)dictionaryService, dictionaryDAO));
        key = new DictionaryKey(CmisVersion.CMIS_1_1, "DEFAULT_DICTIONARY");
        dictionaries.put(key, (CMISAbstractDictionaryService)AlfrescoSolrDataModelServicesFactory.newInstance(cmisMapping11, (DictionaryService)dictionaryService, dictionaryDAO));
        CMISMapping mappingWithExclusions11 = AlfrescoSolrDataModelServicesFactory.newInstanceOfExcludedCMISMapping(cmisMapping11, qnameFilter);
        key = new DictionaryKey(CmisVersion.CMIS_1_1, DICTIONARY_FILTERED_WITH_EXCLUSIONS);
        dictionaries.put(key, (CMISAbstractDictionaryService)AlfrescoSolrDataModelServicesFactory.newInstance(mappingWithExclusions11, (DictionaryService)dictionaryService, dictionaryDAO));
        return dictionaries;
    }

    public static Map<String, DictionaryComponent> constructDictionaryServices(QNameFilter qnameFilter, DictionaryDAOImpl dictionaryDAO) {
        HashMap<String, DictionaryComponent> dictionaries = new HashMap<String, DictionaryComponent>();
        DictionaryComponent compo = new DictionaryComponent();
        compo.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        dictionaries.put("DEFAULT_DICTIONARY", compo);
        FilteredDictionaryComponent fdc = new FilteredDictionaryComponent();
        fdc.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        fdc.setFilter(qnameFilter);
        dictionaries.put(DICTIONARY_FILTERED_WITH_EXCLUSIONS, (DictionaryComponent)fdc);
        return dictionaries;
    }

    private static CMISMapping newInstanceOfExcludedCMISMapping(CMISMapping cmisMapping, QNameFilter filter) {
        CMISMapping cmisMappingWithExcl = new CMISMapping();
        cmisMappingWithExcl.setNamespaceService(cmisMapping.getNamespaceService());
        cmisMappingWithExcl.setDictionaryService(cmisMapping.getDictionaryService());
        cmisMappingWithExcl.setFilter(filter);
        cmisMappingWithExcl.setCmisVersion(cmisMapping.getCmisVersion());
        cmisMappingWithExcl.afterPropertiesSet();
        return cmisMappingWithExcl;
    }

    protected static CMISStrictDictionaryService newInstance(CMISMapping cmisMapping, DictionaryService dictionaryService, DictionaryDAO dictionaryDAO) {
        CMISStrictDictionaryService cmisDictionaryService = new CMISStrictDictionaryService();
        cmisDictionaryService.setCmisMapping(cmisMapping);
        cmisDictionaryService.setDictionaryService(dictionaryService);
        cmisDictionaryService.setDictionaryDAO(dictionaryDAO);
        cmisDictionaryService.setSingletonCache((SimpleCache)new MemoryCache());
        RuntimePropertyLuceneBuilderMapping luceneBuilderMapping = new RuntimePropertyLuceneBuilderMapping();
        luceneBuilderMapping.setDictionaryService(dictionaryService);
        luceneBuilderMapping.setCmisDictionaryService((CMISDictionaryService)cmisDictionaryService);
        cmisDictionaryService.setPropertyLuceneBuilderMapping((PropertyLuceneBuilderMapping)luceneBuilderMapping);
        luceneBuilderMapping.afterPropertiesSet();
        return cmisDictionaryService;
    }

    public static class DictionaryKey {
        private CmisVersion cmisVersion;
        private String key;

        public DictionaryKey(CmisVersion cmisVersion, String key) {
            this.cmisVersion = cmisVersion;
            this.key = key;
        }

        public CmisVersion getCmisVersion() {
            return this.cmisVersion;
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmisVersion == null ? 0 : this.cmisVersion.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DictionaryKey other = (DictionaryKey)obj;
            if (this.cmisVersion != other.cmisVersion) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

