/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.solr.ResizeableArrayList;
import org.alfresco.util.EqualsHelper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoSolrEventListener
implements SolrEventListener {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoSolrEventListener.class);
    public static final String KEY_ADDED_LEAVES = "KEY_ADDED_LEAVES";
    public static final String KEY_ADDED_ACL = "KEY_ADDED_ACL";
    public static final String KEY_ADDED_AUX = "KEY_ADDED_AUX";
    public static final String KEY_ADDED_TX = "KEY_ADDED_TX";
    public static final String KEY_ADDED_ACL_TX = "KEY_ADDED_ACL_TX";
    public static final String KEY_CHECK_INDEXED_BY_DOC_ID_LIST = "KEY_CHECK_INDEXED_BY_DOC_ID_LIST";
    public static final String KEY_DELETED_LEAVES = "KEY_DELETED_LEAVES";
    public static final String KEY_DELETED_ACL = "KEY_DELETED_ACL";
    public static final String KEY_DELETED_AUX = "KEY_DELETED_AUX";
    public static final String KEY_DELETED_TX = "KEY_DELETED_TX";
    public static final String KEY_DELETED_ACL_TX = "KEY_DELETED_ACL_TX";
    public static final String KEY_UPDATED_LEAVES = "KEY_UPDATED_LEAVES";
    public static final String KEY_UPDATED_ACL = "KEY_UPDATED_ALC";
    public static final String KEY_UPDATED_AUX = "KEY_UPDATED_AUX";
    public static final String KEY_UPDATED_TX = "KEY_UPDATED_TX";
    public static final String KEY_UPDATED_ACL_TX = "KEY_UPDATED_ACL_TX";
    public static final String KEY_DELETE_ALL = "KEY_DELETE_ALL";
    public static String ALFRESCO_CACHE = "alfrescoCache";
    public static String ALFRESCO_ARRAYLIST_CACHE = "alfrescoArrayListCache";
    public static String ALFRESCO_AUTHORITY_CACHE = "alfrescoAuthorityCache";
    public static String ALFRESCO_PATH_CACHE = "alfrescoPathCache";
    public static String ALFRESCO_READER_TO_ACL_IDS_CACHE = "alfrescoReaderToAclIdsCache";
    public static String KEY_DBID_LEAF_PATH_BY_DOC_ID = "KEY_DBID_LEAF_PATH_BY_DOC_ID";
    public static String KEY_ACL_ID_BY_DOC_ID = "KEY_ACL_ID_BY_DOC_ID";
    public static String KEY_TX_ID_BY_DOC_ID = "KEY_TX_ID_BY_DOC_ID";
    public static String KEY_ACL_TX_ID_BY_DOC_ID = "KEY_ACL_TX_ID_BY_DOC_ID";
    public static String KEY_GLOBAL_READERS = "KEY_GLOBAL_READERS";
    public static String KEY_ALL_LEAF_DOCS = "KEY_ALL_LEAF_DOCS";
    public static String KEY_ACL_LOOKUP = "KEY_ACL_LOOKUP";
    public static String KEY_DBID_LEAF_PATH_BY_ACL_ID_THEN_LEAF = "KEY_DBID_LEAF_PATH_BY_ACL_ID_THEN_LEAF";
    public static String KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF = "KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF";
    public static String KEY_OWNER_LOOKUP = "KEY_OWNER_LOOKUP";
    public static String KEY_CHECK_CACHE = "KEY_CHECK_CACHE";
    public static String KEY_OWNER_ID_MANAGER = "KEY_OWNER_ID_MANAGER";
    public static String KEY_PUBLIC_DOC_SET = "KEY_PUBLIC_DOC_SET";
    private NamedList args;
    private boolean forceCheckCache = false;
    private boolean incrementalCacheRebuild = true;
    private SolrCore core;

    public AlfrescoSolrEventListener(SolrCore core) {
        this.core = core;
    }

    public void init(NamedList args) {
        this.args = args;
    }

    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        OwnerIdManager ownerIdManager;
        long[] aclTxByDocId;
        long[] txByDocId;
        long[] aclIdByDocId;
        OpenBitSet allLeafDocs;
        HashSet<String> globalReaders;
        ResizeableArrayList indexedByDocId;
        long startTime;
        SolrIndexReader newReader;
        boolean doPermissionChecks;
        block59: {
            Properties p = this.core.getResourceLoader().getCoreProperties();
            doPermissionChecks = Boolean.parseBoolean(p.getProperty("alfresco.doPermissionChecks", "true"));
            newReader = newSearcher.getReader();
            log.info("Max " + newReader.maxDoc());
            log.info("Docs " + newReader.numDocs());
            log.info("Deleted " + newReader.numDeletedDocs());
            startTime = System.nanoTime();
            indexedByDocId = (ResizeableArrayList)newSearcher.cacheLookup(ALFRESCO_ARRAYLIST_CACHE, (Object)KEY_DBID_LEAF_PATH_BY_DOC_ID);
            indexedByDocId.resize(newReader.maxDoc());
            globalReaders = new HashSet<String>();
            allLeafDocs = new OpenBitSet((long)newReader.maxDoc());
            aclIdByDocId = new long[newReader.maxDoc()];
            txByDocId = new long[newReader.maxDoc()];
            aclTxByDocId = new long[newReader.maxDoc()];
            for (int i = 0; i < aclIdByDocId.length; ++i) {
                aclIdByDocId[i] = -1L;
                txByDocId[i] = -1L;
                aclTxByDocId[i] = -1L;
            }
            OpenBitSet deleted = new OpenBitSet((long)newReader.maxDoc());
            ownerIdManager = new OwnerIdManager();
            HashMap<Long, CacheEntry> unmatchedByDBID = new HashMap<Long, CacheEntry>();
            if (this.incrementalCacheRebuild && currentSearcher != null) {
                boolean hasNew;
                ResizeableArrayList oldIndexedByDocId = (ResizeableArrayList)currentSearcher.cacheLookup(ALFRESCO_ARRAYLIST_CACHE, (Object)KEY_DBID_LEAF_PATH_BY_DOC_ID);
                long[] oldAclIdByDocId = (long[])currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ACL_ID_BY_DOC_ID);
                long[] oldTxIdByDocId = (long[])currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_TX_ID_BY_DOC_ID);
                long[] oldAclTxIdByDocId = (long[])currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ACL_TX_ID_BY_DOC_ID);
                OpenBitSet oldAllLeafDocs = (OpenBitSet)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ALL_LEAF_DOCS);
                OwnerIdManager oldOwnerIdManager = (OwnerIdManager)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_OWNER_ID_MANAGER);
                ownerIdManager.addAll(oldOwnerIdManager);
                ConcurrentHashMap addedLeaves = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ADDED_LEAVES);
                ConcurrentHashMap addedAux = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ADDED_AUX);
                ConcurrentHashMap addedAcl = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ADDED_ACL);
                ConcurrentHashMap addedTx = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ADDED_TX);
                ConcurrentHashMap addedAclTx = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_ADDED_ACL_TX);
                ConcurrentHashMap updatedLeaves = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_UPDATED_LEAVES);
                ConcurrentHashMap updatedAux = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_UPDATED_AUX);
                ConcurrentHashMap updatedAcl = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_UPDATED_ACL);
                ConcurrentHashMap updatedTx = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_UPDATED_TX);
                ConcurrentHashMap updatedAclTx = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_UPDATED_ACL_TX);
                ConcurrentHashMap deletedLeaves = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_DELETED_LEAVES);
                ConcurrentHashMap deletedAux = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_DELETED_AUX);
                ConcurrentHashMap deletedAcl = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_DELETED_ACL);
                ConcurrentHashMap deletedTx = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_DELETED_TX);
                ConcurrentHashMap deletedAclTx = (ConcurrentHashMap)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_DELETED_ACL_TX);
                AtomicBoolean deleteAll = (AtomicBoolean)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_DELETE_ALL);
                AtomicBoolean checkCache = (AtomicBoolean)currentSearcher.cacheLookup(ALFRESCO_CACHE, (Object)KEY_CHECK_CACHE);
                if (checkCache == null) {
                    checkCache = new AtomicBoolean(false);
                }
                boolean bl = hasNew = addedLeaves.size() + addedAux.size() + addedAcl.size() + addedTx.size() + addedAclTx.size() + updatedLeaves.size() + updatedAux.size() + updatedAcl.size() + updatedTx.size() + updatedAclTx.size() > 0;
                if (newReader.maxDoc() != 0) {
                    if (oldIndexedByDocId == null || oldAclIdByDocId == null || oldTxIdByDocId == null || oldAclTxIdByDocId == null || oldAllLeafDocs == null || oldOwnerIdManager == null) {
                        log.warn("Recover from missing cache");
                        this.buildCacheForReader(indexedByDocId, allLeafDocs, aclIdByDocId, txByDocId, aclTxByDocId, (IndexReader)newReader, 0, newReader.maxDoc(), unmatchedByDBID, ownerIdManager);
                    } else if (deleteAll.get()) {
                        this.buildCacheForReader(indexedByDocId, allLeafDocs, aclIdByDocId, txByDocId, aclTxByDocId, (IndexReader)newReader, 0, newReader.maxDoc(), unmatchedByDBID, ownerIdManager);
                    } else {
                        try {
                            int i;
                            CacheEntry entry;
                            SolrIndexReader[] before = currentSearcher.getReader().getSequentialSubReaders();
                            SolrIndexReader[] after = newSearcher.getReader().getSequentialSubReaders();
                            CacheSection[] cacheSectionsBefore = SolrIndexReaderCacheSection.getCacheSections(before);
                            CacheSection[] cacheSectionsAfter = SolrIndexReaderCacheSection.getCacheSections(after);
                            int currentCache = 0;
                            for (int i2 = 0; i2 < oldAclIdByDocId.length; ++i2) {
                                CacheEntry entry2;
                                CacheSection section = cacheSectionsBefore[currentCache];
                                if (section.getStart() + section.getLength() == i2) {
                                    if (++currentCache == cacheSectionsBefore.length) {
                                        --currentCache;
                                    }
                                    section = cacheSectionsBefore[currentCache];
                                }
                                if ((entry2 = (CacheEntry)oldIndexedByDocId.get(i2)) != null) {
                                    if (entry2.getLeaf() == i2) {
                                        if (updatedLeaves.get(entry2.dbid) == null && deletedLeaves.get(entry2.dbid) == null) continue;
                                        section.addDeletion(i2);
                                        deleted.set((long)i2);
                                        continue;
                                    }
                                    if (entry2.getPath() != i2 || updatedAux.get(entry2.dbid) == null && deletedAux.get(entry2.dbid) == null) continue;
                                    section.addDeletion(i2);
                                    deleted.set((long)i2);
                                    continue;
                                }
                                if (updatedAcl.get(oldAclIdByDocId[i2]) != null || deletedAcl.get(oldAclIdByDocId[i2]) != null) {
                                    section.addDeletion(i2);
                                    deleted.set((long)i2);
                                }
                                if (updatedTx.get(oldTxIdByDocId[i2]) != null || deletedTx.get(oldTxIdByDocId[i2]) != null) {
                                    section.addDeletion(i2);
                                    deleted.set((long)i2);
                                }
                                if (updatedAclTx.get(oldAclTxIdByDocId[i2]) == null && deletedAclTx.get(oldAclTxIdByDocId[i2]) == null) continue;
                                section.addDeletion(i2);
                                deleted.set((long)i2);
                            }
                            LinkedList<CacheMatch> operations = this.buildCacheUpdateOperations(hasNew, cacheSectionsBefore, cacheSectionsAfter, (IndexReader[])after);
                            log.info("Cache operatoins ...");
                            for (CacheMatch match : operations) {
                                log.info(match.toString());
                            }
                            CacheUpdateTracker tracker = new CacheUpdateTracker(0, 0, 0);
                            for (CacheMatch match : operations) {
                                match.updateCache(tracker, oldIndexedByDocId, oldAclIdByDocId, oldTxIdByDocId, oldAclTxIdByDocId, indexedByDocId, allLeafDocs, aclIdByDocId, txByDocId, aclTxByDocId, unmatchedByDBID, deleted, newReader, ownerIdManager);
                            }
                            int hiddenDocCount = 0;
                            for (Long unmatchedDBID : unmatchedByDBID.keySet()) {
                                entry = unmatchedByDBID.get(unmatchedDBID);
                                if (entry.getLeaf() != 0 && entry.getPath() == 0) {
                                    log.info("Leaf has no AUX doc for DBID " + unmatchedDBID + " at position " + entry.getLeaf());
                                }
                                if (entry.getLeaf() != 0 || entry.getPath() == 0) continue;
                                ++hiddenDocCount;
                            }
                            log.info("Cache unindexed/error doc count = " + hiddenDocCount);
                            boolean simpleCheckOk = true;
                            for (int i3 = 0; i3 < indexedByDocId.size(); ++i3) {
                                entry = (CacheEntry)indexedByDocId.get(i3);
                                if (entry == null || entry.getLeaf() == i3 || entry.getPath() == i3) continue;
                                log.warn("Core " + newSearcher.getIndexDir());
                                log.warn("Simple cache caheck failed: Incorrect indexedByDocId at " + i3);
                                log.warn(".. leaf and path doc poistion do not match the doc position     .. " + indexedByDocId.get(i3));
                                simpleCheckOk = false;
                                break;
                            }
                            if (simpleCheckOk && !this.forceCheckCache && !checkCache.get()) break block59;
                            ResizeableArrayList checkIndexedByDocId = (ResizeableArrayList)currentSearcher.cacheLookup(ALFRESCO_ARRAYLIST_CACHE, (Object)KEY_CHECK_INDEXED_BY_DOC_ID_LIST);
                            checkIndexedByDocId.resize(newReader.maxDoc());
                            OpenBitSet checkAllLeafDocs = new OpenBitSet((long)newReader.maxDoc());
                            long[] checkAclIdByDocId = new long[newReader.maxDoc()];
                            long[] checkTxIdByDocId = new long[newReader.maxDoc()];
                            long[] checkAclTxIdByDocId = new long[newReader.maxDoc()];
                            this.buildCacheForReader(checkIndexedByDocId, checkAllLeafDocs, checkAclIdByDocId, checkTxIdByDocId, checkAclTxIdByDocId, (IndexReader)newReader, 0, newReader.maxDoc(), new HashMap<Long, CacheEntry>(), ownerIdManager);
                            boolean ok = true;
                            boolean thisTestOk = true;
                            for (i = 0; i < checkIndexedByDocId.size(); ++i) {
                                if (EqualsHelper.nullSafeEquals(checkIndexedByDocId.get(i), indexedByDocId.get(i)) || !thisTestOk) continue;
                                log.warn("Core " + newSearcher.getIndexDir());
                                log.warn("Invalid indexedByDocId at " + i);
                                log.warn(".. found     .. " + indexedByDocId.get(i));
                                log.warn(".. expected  .. " + checkIndexedByDocId.get(i));
                                ok = false;
                                thisTestOk = false;
                            }
                            thisTestOk = true;
                            if (!checkAllLeafDocs.equals((Object)allLeafDocs) && thisTestOk) {
                                log.warn("Core " + newSearcher.getIndexDir());
                                log.warn("Invalid AllLeafDocs cache");
                                ok = false;
                                thisTestOk = false;
                            }
                            thisTestOk = true;
                            for (i = 0; i < checkAclIdByDocId.length; ++i) {
                                if (checkAclIdByDocId[i] == aclIdByDocId[i] || !thisTestOk) continue;
                                log.warn("Core " + newSearcher.getIndexDir());
                                log.warn("Invalid AclIdByDocId cache at " + i);
                                log.warn(".. found    .. " + aclIdByDocId[i]);
                                log.warn(".. expected .. " + checkAclIdByDocId[i]);
                                try {
                                    log.warn(".. expected .. " + newSearcher.doc(i));
                                }
                                catch (IOException e) {
                                    log.error("IO Exception", (Throwable)e);
                                }
                                ok = false;
                                thisTestOk = false;
                            }
                            thisTestOk = true;
                            for (i = 0; i < checkTxIdByDocId.length; ++i) {
                                if (checkTxIdByDocId[i] == txByDocId[i] || !thisTestOk) continue;
                                log.warn("Core " + newSearcher.getIndexDir());
                                log.warn("Invalid txByDocId cache at " + i);
                                log.warn(".. found    .. " + txByDocId[i]);
                                log.warn(".. expected .. " + checkTxIdByDocId[i]);
                                try {
                                    log.warn(".. expected .. " + newSearcher.doc(i));
                                }
                                catch (IOException e) {
                                    log.error("IO Exception", (Throwable)e);
                                }
                                ok = false;
                                thisTestOk = false;
                            }
                            thisTestOk = true;
                            for (i = 0; i < checkAclTxIdByDocId.length; ++i) {
                                if (checkAclTxIdByDocId[i] == aclTxByDocId[i] || !thisTestOk) continue;
                                log.warn("Core " + newSearcher.getIndexDir());
                                log.warn("Invalid aclTxByDocId cache at " + i);
                                log.warn(".. found    .. " + aclTxByDocId[i]);
                                log.warn(".. expected .. " + checkAclTxIdByDocId[i]);
                                try {
                                    log.warn(".. expected .. " + newSearcher.doc(i));
                                }
                                catch (IOException e) {
                                    log.error("IO Exception", (Throwable)e);
                                }
                                ok = false;
                                thisTestOk = false;
                            }
                            if (!ok) {
                                indexedByDocId.copyFrom(checkIndexedByDocId);
                                allLeafDocs = checkAllLeafDocs;
                                aclIdByDocId = checkAclIdByDocId;
                                txByDocId = checkTxIdByDocId;
                                aclTxByDocId = checkAclTxIdByDocId;
                                log.warn("... Using recomputed cache");
                                break block59;
                            }
                            log.info("... cache OK");
                        }
                        catch (IllegalStateException ise) {
                            log.warn("Cache state error -> rebuilding", (Throwable)ise);
                            this.buildCacheForReader(indexedByDocId, allLeafDocs, aclIdByDocId, txByDocId, aclTxByDocId, (IndexReader)newReader, 0, newReader.maxDoc(), new HashMap<Long, CacheEntry>(), ownerIdManager);
                        }
                    }
                }
            } else {
                this.buildCacheForReader(indexedByDocId, allLeafDocs, aclIdByDocId, txByDocId, aclTxByDocId, (IndexReader)newReader, 0, newReader.maxDoc(), new HashMap<Long, CacheEntry>(), ownerIdManager);
            }
        }
        long endTime = System.nanoTime();
        log.info("Core cache rebuilt in " + (double)(endTime - startTime) / 1.0E9);
        startTime = System.nanoTime();
        int size = doPermissionChecks ? (int)allLeafDocs.cardinality() : 0;
        ResizeableArrayList indexedOderedByAclIdThenDoc = (ResizeableArrayList)newSearcher.cacheLookup(ALFRESCO_ARRAYLIST_CACHE, (Object)KEY_DBID_LEAF_PATH_BY_ACL_ID_THEN_LEAF);
        indexedOderedByAclIdThenDoc.resize(size);
        ResizeableArrayList indexedOderedByOwnerIdThenDoc = (ResizeableArrayList)newSearcher.cacheLookup(ALFRESCO_ARRAYLIST_CACHE, (Object)KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF);
        indexedOderedByOwnerIdThenDoc.resize(size);
        if (doPermissionChecks) {
            int doc = -1;
            int pos = 0;
            while ((doc = allLeafDocs.nextSetBit(doc + 1)) != -1) {
                CacheEntry entry = (CacheEntry)indexedByDocId.get(doc);
                indexedOderedByAclIdThenDoc.set(pos, entry);
                indexedOderedByOwnerIdThenDoc.set(pos, entry);
                ++pos;
            }
        }
        indexedOderedByAclIdThenDoc.sort(new Comparator<CacheEntry>(){

            @Override
            public int compare(CacheEntry o1, CacheEntry o2) {
                if (o2 == null) {
                    if (o1 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o1 == null) {
                    return 1;
                }
                long diff = o1.getAclid() - o2.getAclid();
                if (diff == 0L) {
                    return o1.getLeaf() - o2.getLeaf();
                }
                return diff > 0L ? 1 : -1;
            }
        });
        HashMap<AclLookUp, AclLookUp> aclLookUp = new HashMap<AclLookUp, AclLookUp>();
        AclLookUp currentAclLookUp = null;
        for (int i = 0; i < indexedOderedByAclIdThenDoc.size(); ++i) {
            CacheEntry entry = (CacheEntry)indexedOderedByAclIdThenDoc.get(i);
            if (entry != null) {
                if (currentAclLookUp == null) {
                    currentAclLookUp = new AclLookUp(entry.getAclid(), i);
                    continue;
                }
                if (currentAclLookUp.aclid == entry.aclid) continue;
                currentAclLookUp.setEnd(i);
                AclLookUp next = new AclLookUp(entry.getAclid(), i);
                aclLookUp.put(currentAclLookUp, currentAclLookUp);
                currentAclLookUp = next;
                continue;
            }
            if (currentAclLookUp == null) break;
            currentAclLookUp.setEnd(i);
            aclLookUp.put(currentAclLookUp, currentAclLookUp);
            break;
        }
        if (currentAclLookUp != null) {
            currentAclLookUp.setEnd(indexedOderedByAclIdThenDoc.size());
            aclLookUp.put(currentAclLookUp, currentAclLookUp);
        }
        indexedOderedByOwnerIdThenDoc.sort(new Comparator<CacheEntry>(){

            @Override
            public int compare(CacheEntry o1, CacheEntry o2) {
                if (o2 == null) {
                    if (o1 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o1 == null) {
                    return 1;
                }
                int diff = o1.getOwner() - o2.getOwner();
                if (diff == 0) {
                    return o1.getLeaf() - o2.getLeaf();
                }
                return diff;
            }
        });
        HashMap<String, OwnerLookUp> ownerLookUp = new HashMap<String, OwnerLookUp>();
        OwnerLookUp currentOwnerLookUp = null;
        for (int i = 0; i < indexedOderedByOwnerIdThenDoc.size(); ++i) {
            CacheEntry entry = (CacheEntry)indexedOderedByOwnerIdThenDoc.get(i);
            if (entry != null) {
                if (currentOwnerLookUp == null) {
                    currentOwnerLookUp = new OwnerLookUp(entry.getOwner(), i);
                    continue;
                }
                if (currentOwnerLookUp.owner == entry.owner) continue;
                currentOwnerLookUp.setEnd(i);
                OwnerLookUp next = new OwnerLookUp(entry.getOwner(), i);
                try {
                    ownerLookUp.put(ownerIdManager.get(currentOwnerLookUp.owner), currentOwnerLookUp);
                }
                catch (IndexOutOfBoundsException e) {
                    log.warn("  " + ownerIdManager);
                    log.warn("  looking for " + currentOwnerLookUp.owner);
                    throw e;
                }
                currentOwnerLookUp = next;
                continue;
            }
            if (currentOwnerLookUp == null) break;
            currentOwnerLookUp.setEnd(i);
            try {
                ownerLookUp.put(ownerIdManager.get(currentOwnerLookUp.owner), currentOwnerLookUp);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                log.warn("  " + ownerIdManager);
                log.warn("  looking for " + currentOwnerLookUp.owner);
                throw e;
            }
        }
        if (currentOwnerLookUp != null) {
            currentOwnerLookUp.setEnd(indexedOderedByOwnerIdThenDoc.size());
            try {
                ownerLookUp.put(ownerIdManager.get(currentOwnerLookUp.owner), currentOwnerLookUp);
            }
            catch (IndexOutOfBoundsException e) {
                log.warn("  " + ownerIdManager);
                log.warn("  looking for " + currentOwnerLookUp.owner);
                throw e;
            }
        }
        BitDocSet publicDocSet = new BitDocSet(new OpenBitSet((long)newReader.maxDoc()));
        if (doPermissionChecks) {
            try {
                HashSet<Long> globallyReadableAcls = this.buildReaderAclIds(newSearcher, "GROUP_EVERYONE", aclIdByDocId);
                newSearcher.cacheInsert(ALFRESCO_READER_TO_ACL_IDS_CACHE, (Object)"GROUP_EVERYONE", globallyReadableAcls);
                AclLookUp key = new AclLookUp(0L);
                for (Long longAcl : globallyReadableAcls) {
                    key.setAclid(longAcl);
                    AclLookUp value = (AclLookUp)aclLookUp.get(key);
                    if (value == null) continue;
                    for (int i = value.getStart(); i < value.getEnd(); ++i) {
                        publicDocSet.add(((CacheEntry)indexedOderedByAclIdThenDoc.get(i)).getLeaf());
                    }
                }
            }
            catch (IOException e) {
                log.error("IO Exception while warming searcher", (Throwable)e);
            }
        }
        endTime = System.nanoTime();
        log.info("Derived caches rebuilt in " + (double)(endTime - startTime) / 1.0E9);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_ACL_ID_BY_DOC_ID, (Object)aclIdByDocId);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_TX_ID_BY_DOC_ID, (Object)txByDocId);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_ACL_TX_ID_BY_DOC_ID, (Object)aclTxByDocId);
        globalReaders.add("ROLE_OWNER");
        globalReaders.add("ROLE_ADMINISTRATOR");
        globalReaders.add(AuthenticationUtil.getSystemUserName());
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_GLOBAL_READERS, globalReaders);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_ALL_LEAF_DOCS, (Object)allLeafDocs);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_ACL_LOOKUP, aclLookUp);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_OWNER_LOOKUP, ownerLookUp);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_OWNER_ID_MANAGER, (Object)ownerIdManager);
        newSearcher.cacheInsert(ALFRESCO_CACHE, (Object)KEY_PUBLIC_DOC_SET, (Object)publicDocSet);
        try {
            if (currentSearcher != null) {
                newSearcher.warm(currentSearcher);
            }
        }
        catch (IOException e) {
            log.error("IO Exception while warming searcher", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Long> buildReaderAclIds(SolrIndexSearcher searcher, String authority, long[] aclIdByDocId) throws IOException {
        HashSet<Long> aclsAsSet = new HashSet<Long>();
        SolrIndexReader reader = searcher.getReader();
        try (TermEnum termEnum = reader.terms(new Term("READER", authority));){
            Term term = termEnum.term();
            if (term == null) {
                HashSet<Long> hashSet = aclsAsSet;
                return hashSet;
            }
            if (term.field().equals("READER") && term.text().equals(authority)) {
                try (TermDocs termDocs = reader.termDocs(term);){
                    while (termDocs.next()) {
                        int currentDoc = termDocs.doc();
                        long acl = aclIdByDocId[currentDoc];
                        aclsAsSet.add(acl);
                    }
                }
                HashSet<Long> hashSet = aclsAsSet;
                return hashSet;
            }
            HashSet<Long> hashSet = aclsAsSet;
            return hashSet;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LinkedList<CacheMatch> buildCacheUpdateOperations(boolean hasNew, CacheSection[] before, CacheSection[] after, IndexReader[] afterIndexReaders) {
        LinkedList<CacheMatch> operations = new LinkedList<CacheMatch>();
        CacheMatch current = null;
        int currentDocCount = 0;
        int iBefore = 0;
        int iAfter = 0;
        while (iBefore < before.length || iAfter < after.length) {
            if (iBefore < before.length) {
                if (iAfter < after.length) {
                    if (before[iBefore].equals(after[iAfter])) {
                        if (current != null) {
                            operations.add(current);
                            current = null;
                            currentDocCount = 0;
                        }
                        if (before[iBefore].getDocCount() == after[iAfter].getDocCount()) {
                            Match match = new Match(after[iAfter].getLength(), after[iAfter].getDocCount(), afterIndexReaders == null ? null : afterIndexReaders[iAfter]);
                            match.addToOldCacheSize(before[iBefore].getLength());
                            operations.add(match);
                        } else {
                            if (before[iBefore].getDocCount() <= after[iAfter].getDocCount()) throw new IllegalStateException("New section has more than old in match ??");
                            if (before[iBefore].getDocCount() - before[iBefore].getNewDeletionsCount() != after[iAfter].getDocCount()) throw new IllegalStateException("Doc counts and expected deletes do not match");
                            Delete delete = new Delete(after[iAfter].getLength(), after[iAfter].getDocCount(), afterIndexReaders == null ? null : afterIndexReaders[iAfter]);
                            delete.addToOldCacheSize(before[iBefore].getLength());
                            operations.add(delete);
                        }
                        ++iAfter;
                    } else if (current == null) {
                        int thisCount = before[iBefore].getDocCount() - before[iBefore].getNewDeletionsCount();
                        current = new Merge(after[iAfter].getLength(), after[iAfter].getDocCount(), afterIndexReaders == null ? null : afterIndexReaders[iAfter]);
                        current.addToOldCacheSize(before[iBefore].getLength());
                        currentDocCount = thisCount;
                        if (currentDocCount >= current.getFinalDocCount()) {
                            if (currentDocCount != current.getFinalDocCount()) throw new IllegalStateException("Merged section has too few docs");
                            operations.add(current);
                            current = null;
                            currentDocCount = 0;
                        }
                        ++iAfter;
                    } else {
                        current.addToOldCacheSize(before[iBefore].getLength());
                        if ((currentDocCount += before[iBefore].getDocCount() - before[iBefore].getNewDeletionsCount()) >= current.getFinalDocCount()) {
                            if (currentDocCount != current.getFinalDocCount()) throw new IllegalStateException("Merged section has too few docs");
                            operations.add(current);
                            current = null;
                            currentDocCount = 0;
                        }
                    }
                } else {
                    if (current == null) {
                        throw new IllegalStateException("More docs but no targets");
                    }
                    current.addToOldCacheSize(before[iBefore].getLength());
                    if ((currentDocCount += before[iBefore].getDocCount() - before[iBefore].getNewDeletionsCount()) >= current.getFinalDocCount()) {
                        if (currentDocCount != current.getFinalDocCount()) throw new IllegalStateException("Merged section has too few docs");
                        operations.add(current);
                        current = null;
                        currentDocCount = 0;
                    }
                }
                ++iBefore;
                continue;
            }
            if (iAfter >= after.length) throw new IllegalStateException("Violates loop constraint! ??");
            if (current != null) {
                if (hasNew) {
                    if (currentDocCount < current.getFinalDocCount()) {
                        operations.add(new MergeAndNew(current));
                        current = null;
                        currentDocCount = 0;
                        continue;
                    }
                    operations.add(current);
                    current = null;
                    currentDocCount = 0;
                    continue;
                }
                operations.add(current);
                current = null;
                currentDocCount = 0;
                continue;
            }
            if (!hasNew) throw new IllegalStateException("New sub reader but no new docs ??");
            operations.add(new New(after[iAfter].getLength(), after[iAfter].getDocCount(), afterIndexReaders == null ? null : afterIndexReaders[iAfter]));
            ++iAfter;
        }
        if (current == null) return operations;
        if (hasNew) {
            if (currentDocCount < current.getFinalDocCount()) {
                operations.add(new MergeAndNew(current));
                return operations;
            }
            operations.add(current);
            return operations;
        }
        operations.add(current);
        return operations;
    }

    void buildCacheForReader(List<CacheEntry> cache, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, IndexReader reader, int start, int length, HashMap<Long, CacheEntry> unmatchedByDBID, OwnerIdManager ownerIdManager) {
        CacheEntry entry;
        int doc;
        Term term;
        TermDocs termDocs;
        TermEnum termEnum;
        int current = start - 1;
        while ((current = allLeafDocs.nextSetBit(current + 1)) < start + length && current >= 0) {
            allLeafDocs.flip((long)current);
        }
        for (int i = start; i < start + length; ++i) {
            cache.set(i, null);
            aclIdByDocId[i] = -1L;
            txIdByDocId[i] = -1L;
            aclTxIdByDocId[i] = -1L;
        }
        try {
            TermDocs termDocs2 = reader.termDocs(new Term("ISNODE", "T"));
            while (termDocs2.next()) {
                allLeafDocs.set((long)(start + termDocs2.doc()));
            }
            termDocs2.close();
        }
        catch (IOException e1) {
            log.error("Build cache for reader failed to enumerate ISNODE", (Throwable)e1);
        }
        try {
            termEnum = reader.terms(new Term("DBID", ""));
            termDocs = null;
            while ((term = termEnum.term()) != null && term.field().equals("DBID")) {
                Long dbid = NumericEncoder.decodeLong((String)term.text());
                if (termDocs == null) {
                    termDocs = reader.termDocs(term);
                } else {
                    termDocs.seek(term);
                }
                while (termDocs.next()) {
                    doc = start + termDocs.doc();
                    if (allLeafDocs.get(doc)) {
                        entry = unmatchedByDBID.remove(dbid);
                        if (entry == null || entry.getLeaf() > 0) {
                            entry = new CacheEntry(dbid);
                            unmatchedByDBID.put(dbid, entry);
                        }
                        entry.setLeaf(doc);
                    } else {
                        entry = unmatchedByDBID.remove(dbid);
                        if (entry == null || entry.getPath() > 0) {
                            entry = new CacheEntry(dbid);
                            unmatchedByDBID.put(dbid, entry);
                        }
                        entry.setPath(doc);
                    }
                    entry.setAclid(-1L);
                    cache.set(doc, entry);
                }
                if (termEnum.next()) continue;
            }
            if (termDocs != null) {
                termDocs.close();
            }
            termEnum.close();
        }
        catch (IOException e1) {
            log.error("Build cache for reader failed to enumerate DBID", (Throwable)e1);
        }
        try {
            termEnum = reader.terms(new Term("ACLID", ""));
            termDocs = null;
            while ((term = termEnum.term()) != null && term.field().equals("ACLID")) {
                Long aclid = NumericEncoder.decodeLong((String)term.text());
                if (termDocs == null) {
                    termDocs = reader.termDocs(term);
                } else {
                    termDocs.seek(term);
                }
                while (termDocs.next()) {
                    doc = start + termDocs.doc();
                    entry = cache.get(doc);
                    if (entry == null) {
                        aclIdByDocId[doc] = aclid;
                        continue;
                    }
                    entry.setAclid(aclid);
                }
                if (termEnum.next()) continue;
            }
            if (termDocs != null) {
                termDocs.close();
            }
            termEnum.close();
        }
        catch (IOException e1) {
            log.error("Build cache for reader failed to enumerate ACLID", (Throwable)e1);
        }
        try {
            termEnum = reader.terms(new Term("TXID", ""));
            termDocs = null;
            while ((term = termEnum.term()) != null && term.field().equals("TXID")) {
                Long txid = NumericEncoder.decodeLong((String)term.text());
                if (termDocs == null) {
                    termDocs = reader.termDocs(term);
                } else {
                    termDocs.seek(term);
                }
                while (termDocs.next()) {
                    doc = start + termDocs.doc();
                    entry = cache.get(doc);
                    if (entry == null) {
                        txIdByDocId[doc] = txid;
                        continue;
                    }
                    throw new IllegalStateException("Laef and Aux should not have TXID field");
                }
                if (termEnum.next()) continue;
            }
            if (termDocs != null) {
                termDocs.close();
            }
            termEnum.close();
        }
        catch (IOException e1) {
            log.error("Build cache for reader failed to enumerate TXID", (Throwable)e1);
        }
        try {
            termEnum = reader.terms(new Term("ACLTXID", ""));
            termDocs = null;
            while ((term = termEnum.term()) != null && term.field().equals("ACLTXID")) {
                Long acltxid = NumericEncoder.decodeLong((String)term.text());
                if (termDocs == null) {
                    termDocs = reader.termDocs(term);
                } else {
                    termDocs.seek(term);
                }
                while (termDocs.next()) {
                    doc = start + termDocs.doc();
                    entry = cache.get(doc);
                    if (entry == null) {
                        aclTxIdByDocId[doc] = acltxid;
                        continue;
                    }
                    throw new IllegalStateException("Laef and Aux should not have ACLTXID field");
                }
                if (termEnum.next()) continue;
            }
            if (termDocs != null) {
                termDocs.close();
            }
            termEnum.close();
        }
        catch (IOException e1) {
            log.error("Build cache for reader failed to enumerate ACLTXID", (Throwable)e1);
        }
        try {
            termEnum = reader.terms(new Term("OWNER", ""));
            termDocs = null;
            while ((term = termEnum.term()) != null && term.field().equals("OWNER")) {
                String owner = term.text();
                Integer ownerId = ownerIdManager.getOwnerId(owner);
                if (termDocs == null) {
                    termDocs = reader.termDocs(term);
                } else {
                    termDocs.seek(term);
                }
                while (termDocs.next()) {
                    int doc2 = start + termDocs.doc();
                    CacheEntry entry2 = cache.get(doc2);
                    entry2.setOwner(ownerId);
                }
                if (termEnum.next()) continue;
            }
            if (termDocs != null) {
                termDocs.close();
            }
            termEnum.close();
        }
        catch (IOException e1) {
            log.error("Build cache for reader failed to enumerate OWNER", (Throwable)e1);
        }
    }

    public void postCommit() {
        throw new UnsupportedOperationException();
    }

    private void updateCacheByDocId(CacheUpdateTracker tracker, List<CacheEntry> indexedByDocId, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, HashMap<Long, CacheEntry> unmatchedByDBID, OpenBitSet deleted, SolrIndexReader reader, OwnerIdManager osnerIdManager) {
        try {
            if (reader.isDeleted(tracker.inNew)) {
                indexedByDocId.set(tracker.inNew, null);
                aclIdByDocId[tracker.inNew] = -1L;
                txIdByDocId[tracker.inNew] = -1L;
                aclTxIdByDocId[tracker.inNew] = -1L;
                if (allLeafDocs.get(tracker.inNew)) {
                    allLeafDocs.flip((long)tracker.inNew);
                }
            } else {
                Document document = reader.document(tracker.inNew);
                Field field = document.getField("DBID");
                if (field != null) {
                    CacheEntry entry;
                    boolean isLeaf;
                    String string = field.stringValue();
                    long dbid = Long.parseLong(string);
                    field = document.getField("ISNODE");
                    if (field == null) {
                        isLeaf = false;
                    } else {
                        string = field.stringValue();
                        isLeaf = string.equals("T");
                    }
                    long aclId = -1L;
                    field = document.getField("ACLID");
                    if (field != null) {
                        string = field.stringValue();
                        aclId = Long.parseLong(string);
                    }
                    String owner = null;
                    field = document.getField("OWNER");
                    if (field != null) {
                        owner = field.stringValue();
                    }
                    if (isLeaf) {
                        entry = unmatchedByDBID.remove(dbid);
                        if (entry == null || entry.getLeaf() > 0) {
                            entry = new CacheEntry(dbid);
                            unmatchedByDBID.put(dbid, entry);
                        }
                        entry.setLeaf(tracker.inNew);
                        allLeafDocs.set((long)tracker.inNew);
                    } else {
                        entry = unmatchedByDBID.remove(dbid);
                        if (entry == null || entry.getPath() > 0) {
                            entry = new CacheEntry(dbid);
                            unmatchedByDBID.put(dbid, entry);
                        }
                        entry.setPath(tracker.inNew);
                        entry.setAclid(aclId);
                        entry.setOwner(osnerIdManager.getOwnerId(owner));
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                    }
                    indexedByDocId.set(tracker.inNew, entry);
                    aclIdByDocId[tracker.inNew] = -1L;
                    txIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                } else {
                    field = document.getField("ACLID");
                    if (field != null) {
                        String string = field.stringValue();
                        long aclId = Long.parseLong(string);
                        indexedByDocId.set(tracker.inNew, null);
                        aclIdByDocId[tracker.inNew] = aclId;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                    } else {
                        field = document.getField("TXID");
                        if (field != null) {
                            String string = field.stringValue();
                            long txId = Long.parseLong(string);
                            indexedByDocId.set(tracker.inNew, null);
                            aclIdByDocId[tracker.inNew] = -1L;
                            txIdByDocId[tracker.inNew] = txId;
                            aclTxIdByDocId[tracker.inNew] = -1L;
                            if (allLeafDocs.get(tracker.inNew)) {
                                allLeafDocs.flip((long)tracker.inNew);
                            }
                        } else {
                            field = document.getField("ACLTXID");
                            if (field != null) {
                                String string = field.stringValue();
                                long aclTxId = Long.parseLong(string);
                                indexedByDocId.set(tracker.inNew, null);
                                aclIdByDocId[tracker.inNew] = -1L;
                                txIdByDocId[tracker.inNew] = -1L;
                                aclTxIdByDocId[tracker.inNew] = aclTxId;
                                if (allLeafDocs.get(tracker.inNew)) {
                                    allLeafDocs.flip((long)tracker.inNew);
                                }
                            } else {
                                indexedByDocId.set(tracker.inNew, null);
                                aclIdByDocId[tracker.inNew] = -1L;
                                txIdByDocId[tracker.inNew] = -1L;
                                aclTxIdByDocId[tracker.inNew] = -1L;
                                if (allLeafDocs.get(tracker.inNew)) {
                                    allLeafDocs.flip((long)tracker.inNew);
                                }
                            }
                        }
                    }
                }
            }
            ++tracker.inNew;
        }
        catch (IOException e) {
            throw new IllegalStateException("Update cache by doc id failed", e);
        }
    }

    public static class OwnerIdManager {
        ArrayList<String> idToOwner = new ArrayList();
        HashMap<String, Integer> ownerIds = new HashMap();

        OwnerIdManager() {
            this.idToOwner.add(null);
        }

        public String get(int owner) {
            if (owner < this.idToOwner.size()) {
                return this.idToOwner.get(owner);
            }
            return null;
        }

        public void addAll(OwnerIdManager oldOwnerIdManager) {
            for (int i = 1; i < oldOwnerIdManager.idToOwner.size(); ++i) {
                Integer ownerId = i;
                String owner = oldOwnerIdManager.idToOwner.get(i);
                this.ownerIds.put(owner, ownerId);
                this.idToOwner.add(owner);
            }
        }

        private Integer getOwnerId(String owner) {
            if (owner == null) {
                return 0;
            }
            Integer ownerId = this.ownerIds.get(owner);
            if (ownerId == null) {
                ownerId = this.ownerIds.size() + 1;
                this.ownerIds.put(owner, ownerId);
                this.idToOwner.add(owner);
            }
            return ownerId;
        }

        public String toString() {
            return this.idToOwner.toString() + "\n" + this.ownerIds;
        }
    }

    private static class CacheUpdateTracker {
        int earlyDeletes;
        int inOld;
        int inNew;

        CacheUpdateTracker(int inOld, int inNew, int earlyDeletes) {
            this.inOld = inOld;
            this.inNew = inNew;
            this.earlyDeletes = earlyDeletes;
        }
    }

    public static class SolrIndexReaderCacheSection
    implements CacheSection {
        SolrIndexReader solrIndexReader;
        int newDeletions = 0;

        SolrIndexReaderCacheSection(SolrIndexReader solrIndexReader) {
            this.solrIndexReader = solrIndexReader;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.solrIndexReader == null ? 0 : this.solrIndexReader.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SolrIndexReaderCacheSection other = (SolrIndexReaderCacheSection)obj;
            return !(this.solrIndexReader == null ? other.solrIndexReader != null : !this.solrIndexReader.equals((Object)other.solrIndexReader));
        }

        public static CacheSection[] getCacheSections(SolrIndexReader[] readers) {
            CacheSection[] sections = new SolrIndexReaderCacheSection[readers.length];
            for (int i = 0; i < readers.length; ++i) {
                sections[i] = new SolrIndexReaderCacheSection(readers[i]);
            }
            return sections;
        }

        @Override
        public int getDocCount() {
            return this.solrIndexReader.numDocs();
        }

        @Override
        public int getDeletionsCount() {
            return this.solrIndexReader.maxDoc() - this.solrIndexReader.numDocs();
        }

        @Override
        public int getLength() {
            return this.solrIndexReader.maxDoc();
        }

        @Override
        public int getNewDeletionsCount() {
            return this.newDeletions;
        }

        @Override
        public int getStart() {
            return this.solrIndexReader.getBase();
        }

        @Override
        public void addDeletion(int doc) {
            ++this.newDeletions;
        }
    }

    public static interface CacheSection {
        public int getStart();

        public int getLength();

        public int getDocCount();

        public int getDeletionsCount();

        public int getNewDeletionsCount();

        public void addDeletion(int var1);
    }

    public class New
    extends RebuildCacheMatch {
        public New(int finalCacheSize, int finalDocCount) {
            this(finalCacheSize, finalDocCount, null);
        }

        public New(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        public String toString() {
            return "New";
        }
    }

    public class MergeAndNew
    extends AbstractCacheMatch {
        public MergeAndNew(int finalCacheSize, int finalDocCount) {
            this(finalCacheSize, finalDocCount, null);
        }

        public MergeAndNew(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        public MergeAndNew(CacheMatch cacheMatch) {
            super(cacheMatch.getFinalCacheSize(), cacheMatch.getFinalDocCount(), cacheMatch.getFinalIndexReader());
            this.oldCacheSize = cacheMatch.getOldCacheSize();
            this.numberOfOldCaches = cacheMatch.getNumberOfOldCaches();
        }

        public String toString() {
            return "MergeAndNew";
        }

        @Override
        public void updateCache(CacheUpdateTracker tracker, ResizeableArrayList<CacheEntry> oldIndexedByDocId, long[] oldAclIdByDocId, long[] oldTxByDocId, long[] oldAclTxByDocId, ResizeableArrayList<CacheEntry> indexedByDocId, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, HashMap<Long, CacheEntry> unmatchedByDBID, OpenBitSet deleted, SolrIndexReader reader, OwnerIdManager ownerIdManager) {
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
            boolean targetHasDeletions = this.finalIndexReader.hasDeletions();
            int startNew = tracker.inNew;
            int startOld = tracker.inOld;
            int lastNew = tracker.inNew + this.getFinalCacheSize();
            int lastOld = tracker.inOld + this.getOldCacheSize();
            while (tracker.inNew < lastNew && tracker.inOld < lastOld) {
                if (deleted.get(tracker.inOld)) {
                    if (tracker.earlyDeletes > 0) {
                        --tracker.earlyDeletes;
                    } else if (targetHasDeletions && this.finalIndexReader.isDeleted(tracker.inNew - startNew)) {
                        indexedByDocId.set(tracker.inNew, null);
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                        ++tracker.inNew;
                    }
                    ++tracker.inOld;
                    continue;
                }
                if (tracker.earlyDeletes > 0) {
                    throw new IllegalStateException("Early deletes should have been cleared");
                }
                CacheEntry old = oldIndexedByDocId.get(tracker.inOld);
                if (old != null) {
                    CacheEntry newCacheEntry;
                    if (old.leaf == tracker.inOld) {
                        newCacheEntry = unmatchedByDBID.remove(old.dbid);
                        if (newCacheEntry != null && newCacheEntry.getLeaf() == 0) {
                            newCacheEntry.setLeaf(tracker.inNew);
                        } else {
                            newCacheEntry = new CacheEntry(old.getDbid());
                            newCacheEntry.setLeaf(tracker.inNew);
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(0);
                            unmatchedByDBID.put(newCacheEntry.dbid, newCacheEntry);
                        }
                        indexedByDocId.set(tracker.inNew, newCacheEntry);
                        allLeafDocs.set((long)tracker.inNew);
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                    } else {
                        newCacheEntry = unmatchedByDBID.remove(old.dbid);
                        if (newCacheEntry != null && newCacheEntry.getPath() == 0) {
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(tracker.inNew);
                        } else {
                            newCacheEntry = new CacheEntry(old.getDbid());
                            newCacheEntry.setLeaf(0);
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(tracker.inNew);
                            unmatchedByDBID.put(newCacheEntry.dbid, newCacheEntry);
                        }
                        indexedByDocId.set(tracker.inNew, newCacheEntry);
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                    }
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldAclIdByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclIdByDocId[tracker.inNew] = oldAclIdByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    txIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldTxByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    txIdByDocId[tracker.inNew] = oldTxByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    aclIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldAclTxByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclTxIdByDocId[tracker.inNew] = oldAclTxByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    aclIdByDocId[tracker.inNew] = -1L;
                    txIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                indexedByDocId.set(tracker.inNew, null);
                if (allLeafDocs.get(tracker.inNew)) {
                    allLeafDocs.flip((long)tracker.inNew);
                }
                aclIdByDocId[tracker.inNew] = -1L;
                txIdByDocId[tracker.inNew] = -1L;
                aclTxIdByDocId[tracker.inNew] = -1L;
                if (targetHasDeletions && this.finalIndexReader.isDeleted(tracker.inNew - startNew)) {
                    ++tracker.inNew;
                }
                ++tracker.inOld;
            }
            if ((lastNew - tracker.inNew) * 100 / this.finalCacheSize > 50) {
                AlfrescoSolrEventListener.this.buildCacheForReader(indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, this.getFinalIndexReader(), startNew, this.getFinalCacheSize(), unmatchedByDBID, ownerIdManager);
                tracker.inNew = lastNew;
                tracker.inOld = lastOld;
            } else {
                while (tracker.inNew < lastNew) {
                    AlfrescoSolrEventListener.this.updateCacheByDocId(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, unmatchedByDBID, deleted, reader, ownerIdManager);
                }
            }
            if (tracker.inNew != lastNew || tracker.inOld != lastOld) {
                throw new IllegalStateException("MergeAndNew cache update failed");
            }
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
        }
    }

    public abstract class RebuildCacheMatch
    extends AbstractCacheMatch {
        public RebuildCacheMatch(int finalCacheSize, int finalDocCount) {
            this(finalCacheSize, finalDocCount, null);
        }

        RebuildCacheMatch(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        @Override
        public void updateCache(CacheUpdateTracker tracker, ResizeableArrayList<CacheEntry> oldIndexedByDocId, long[] oldAclIdByDocIdx, long[] oldTxByDocId, long[] oldAclTxByDocId, ResizeableArrayList<CacheEntry> indexedByDocId, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, HashMap<Long, CacheEntry> unmatchedByDBID, OpenBitSet deleted, SolrIndexReader reader, OwnerIdManager ownerIdManager) {
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
            if (tracker.earlyDeletes > 0) {
                throw new IllegalStateException("Early deletes should have been cleared");
            }
            AlfrescoSolrEventListener.this.buildCacheForReader(indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, this.getFinalIndexReader(), tracker.inNew, this.getFinalCacheSize(), unmatchedByDBID, ownerIdManager);
            tracker.inNew += this.getFinalCacheSize();
            tracker.inOld += this.getOldCacheSize();
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
        }
    }

    public static class Merge
    extends RemoveNullEntriesCacheMatch {
        public Merge(int finalCacheSize, int finalDocCount) {
            this(finalCacheSize, finalDocCount, null);
        }

        public Merge(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        public String toString() {
            return "Merge";
        }
    }

    public static class Match
    extends AbstractCacheMatch {
        public Match(int finalCacheSize, int finalDocCount) {
            this(finalCacheSize, finalDocCount, null);
        }

        public Match(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        public String toString() {
            return "Match";
        }

        @Override
        public void updateCache(CacheUpdateTracker tracker, ResizeableArrayList<CacheEntry> oldIndexedByDocId, long[] oldAclIdByDocId, long[] oldTxByDocId, long[] oldAclTxByDocId, ResizeableArrayList<CacheEntry> indexedByDocId, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, HashMap<Long, CacheEntry> unmatchedByDBID, OpenBitSet deleted, SolrIndexReader reader, OwnerIdManager ownerIdManager) {
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
            if (tracker.earlyDeletes > 0) {
                throw new IllegalStateException("Early deletes should have been cleared");
            }
            int lastNew = tracker.inNew + this.getFinalCacheSize();
            int lastOld = tracker.inOld + this.getOldCacheSize();
            while (tracker.inNew < lastNew && tracker.inOld < lastOld) {
                if (deleted.get(tracker.inOld)) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclIdByDocId[tracker.inNew] = -1L;
                    txIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                CacheEntry old = oldIndexedByDocId.get(tracker.inOld);
                if (old != null) {
                    CacheEntry newCacheEntry;
                    if (old.leaf == tracker.inOld) {
                        newCacheEntry = unmatchedByDBID.remove(old.dbid);
                        if (newCacheEntry != null && newCacheEntry.getLeaf() == 0) {
                            newCacheEntry.setLeaf(tracker.inNew);
                        } else {
                            newCacheEntry = new CacheEntry(old.getDbid());
                            newCacheEntry.setLeaf(tracker.inNew);
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(0);
                            unmatchedByDBID.put(newCacheEntry.dbid, newCacheEntry);
                        }
                        indexedByDocId.set(tracker.inNew, newCacheEntry);
                        allLeafDocs.set((long)tracker.inNew);
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                    } else {
                        newCacheEntry = unmatchedByDBID.remove(old.dbid);
                        if (newCacheEntry != null && newCacheEntry.getPath() == 0) {
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(tracker.inNew);
                        } else {
                            newCacheEntry = new CacheEntry(old.getDbid());
                            newCacheEntry.setLeaf(0);
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(tracker.inNew);
                            unmatchedByDBID.put(newCacheEntry.dbid, newCacheEntry);
                        }
                        indexedByDocId.set(tracker.inNew, newCacheEntry);
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                    }
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldAclIdByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclIdByDocId[tracker.inNew] = oldAclIdByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    txIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldTxByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    txIdByDocId[tracker.inNew] = oldTxByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    aclIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldAclTxByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclTxIdByDocId[tracker.inNew] = oldAclTxByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    aclIdByDocId[tracker.inNew] = -1L;
                    txIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                indexedByDocId.set(tracker.inNew, null);
                aclIdByDocId[tracker.inNew] = -1L;
                txIdByDocId[tracker.inNew] = -1L;
                aclTxIdByDocId[tracker.inNew] = -1L;
                if (allLeafDocs.get(tracker.inNew)) {
                    allLeafDocs.flip((long)tracker.inNew);
                }
                ++tracker.inNew;
                ++tracker.inOld;
            }
            if (tracker.inNew != lastNew || tracker.inOld != lastOld) {
                throw new IllegalStateException("Match cache update failed");
            }
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
        }
    }

    public static class Delete
    extends RemoveNullEntriesCacheMatch {
        public Delete(int finalCacheSize, int finalDocCount) {
            this(finalCacheSize, finalDocCount, null);
        }

        public Delete(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        public String toString() {
            return "Delete";
        }
    }

    public static abstract class RemoveNullEntriesCacheMatch
    extends AbstractCacheMatch {
        RemoveNullEntriesCacheMatch(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            super(finalCacheSize, finalDocCount, finalIndexReader);
        }

        @Override
        public void updateCache(CacheUpdateTracker tracker, ResizeableArrayList<CacheEntry> oldIndexedByDocId, long[] oldAclIdByDocId, long[] oldTxByDocId, long[] oldAclTxByDocId, ResizeableArrayList<CacheEntry> indexedByDocId, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, HashMap<Long, CacheEntry> unmatchedByDBID, OpenBitSet deleted, SolrIndexReader reader, OwnerIdManager ownerIdManager) {
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
            if (this.getNumberOfOldCaches() == 1 && tracker.earlyDeletes > 0) {
                throw new IllegalStateException("Early deletes should have been cleared");
            }
            boolean targetHasDeletions = this.finalIndexReader.hasDeletions();
            int firstNew = tracker.inNew;
            int lastNew = tracker.inNew + this.getFinalCacheSize();
            int lastOld = tracker.inOld + this.getOldCacheSize();
            while (tracker.inNew < lastNew && tracker.inOld < lastOld) {
                if (deleted.get(tracker.inOld)) {
                    if (tracker.earlyDeletes > 0) {
                        --tracker.earlyDeletes;
                    } else if (targetHasDeletions && this.finalIndexReader.isDeleted(tracker.inNew - firstNew)) {
                        indexedByDocId.set(tracker.inNew, null);
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                        ++tracker.inNew;
                    }
                    ++tracker.inOld;
                    continue;
                }
                if (tracker.earlyDeletes > 0) {
                    throw new IllegalStateException("Early deletes should have been cleared");
                }
                CacheEntry old = oldIndexedByDocId.get(tracker.inOld);
                if (old != null) {
                    CacheEntry newCacheEntry;
                    if (old.leaf == tracker.inOld) {
                        newCacheEntry = unmatchedByDBID.remove(old.dbid);
                        if (newCacheEntry != null && newCacheEntry.getLeaf() == 0) {
                            newCacheEntry.setLeaf(tracker.inNew);
                        } else {
                            newCacheEntry = new CacheEntry(old.getDbid());
                            newCacheEntry.setLeaf(tracker.inNew);
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(0);
                            unmatchedByDBID.put(newCacheEntry.dbid, newCacheEntry);
                        }
                        indexedByDocId.set(tracker.inNew, newCacheEntry);
                        allLeafDocs.set((long)tracker.inNew);
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                    } else {
                        newCacheEntry = unmatchedByDBID.remove(old.dbid);
                        if (newCacheEntry != null && newCacheEntry.getPath() == 0) {
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(tracker.inNew);
                        } else {
                            newCacheEntry = new CacheEntry(old.getDbid());
                            newCacheEntry.setLeaf(0);
                            newCacheEntry.setAclid(old.getAclid());
                            newCacheEntry.setOwner(old.getOwner());
                            newCacheEntry.setPath(tracker.inNew);
                            unmatchedByDBID.put(newCacheEntry.dbid, newCacheEntry);
                        }
                        indexedByDocId.set(tracker.inNew, newCacheEntry);
                        if (allLeafDocs.get(tracker.inNew)) {
                            allLeafDocs.flip((long)tracker.inNew);
                        }
                        aclIdByDocId[tracker.inNew] = -1L;
                        txIdByDocId[tracker.inNew] = -1L;
                        aclTxIdByDocId[tracker.inNew] = -1L;
                    }
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldAclIdByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclIdByDocId[tracker.inNew] = oldAclIdByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    txIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldTxByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    txIdByDocId[tracker.inNew] = oldTxByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    aclIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                if (oldAclTxByDocId[tracker.inOld] >= 0L) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclTxIdByDocId[tracker.inNew] = oldAclTxByDocId[tracker.inOld];
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    aclIdByDocId[tracker.inNew] = -1L;
                    txIdByDocId[tracker.inNew] = -1L;
                    ++tracker.inNew;
                    ++tracker.inOld;
                    continue;
                }
                indexedByDocId.set(tracker.inNew, null);
                aclIdByDocId[tracker.inNew] = -1L;
                txIdByDocId[tracker.inNew] = -1L;
                aclTxIdByDocId[tracker.inNew] = -1L;
                if (allLeafDocs.get(tracker.inNew)) {
                    allLeafDocs.flip((long)tracker.inNew);
                }
                if (targetHasDeletions && this.finalIndexReader.isDeleted(tracker.inNew - firstNew)) {
                    ++tracker.inNew;
                }
                ++tracker.inOld;
            }
            if (targetHasDeletions) {
                while (tracker.inNew < lastNew && this.finalIndexReader.isDeleted(tracker.inNew - firstNew)) {
                    indexedByDocId.set(tracker.inNew, null);
                    aclIdByDocId[tracker.inNew] = -1L;
                    txIdByDocId[tracker.inNew] = -1L;
                    aclTxIdByDocId[tracker.inNew] = -1L;
                    if (allLeafDocs.get(tracker.inNew)) {
                        allLeafDocs.flip((long)tracker.inNew);
                    }
                    ++tracker.inNew;
                    ++tracker.earlyDeletes;
                }
            }
            while (tracker.inOld < lastOld) {
                if (deleted.get(tracker.inOld)) {
                    if (tracker.earlyDeletes > 0) {
                        --tracker.earlyDeletes;
                    }
                    ++tracker.inOld;
                    continue;
                }
                if (tracker.earlyDeletes > 0) {
                    throw new IllegalStateException("Early deletes should have been cleared");
                }
                ++tracker.inOld;
            }
            if (tracker.inNew != lastNew || tracker.inOld != lastOld) {
                throw new IllegalStateException("RemoveNullEntriesCacheMatch cache update failed");
            }
            this.checkCachePosition(tracker, indexedByDocId, allLeafDocs, aclIdByDocId, txIdByDocId, aclTxIdByDocId, reader, ownerIdManager);
        }
    }

    public static abstract class AbstractCacheMatch
    implements CacheMatch {
        protected int finalCacheSize;
        protected int finalDocCount;
        protected int oldCacheSize = 0;
        protected int numberOfOldCaches = 0;
        protected IndexReader finalIndexReader;

        AbstractCacheMatch(int finalCacheSize, int finalDocCount, IndexReader finalIndexReader) {
            this.finalCacheSize = finalCacheSize;
            this.finalDocCount = finalDocCount;
            this.finalIndexReader = finalIndexReader;
        }

        @Override
        public int getFinalCacheSize() {
            return this.finalCacheSize;
        }

        @Override
        public int getOldCacheSize() {
            return this.oldCacheSize;
        }

        @Override
        public int getFinalDocCount() {
            return this.finalDocCount;
        }

        @Override
        public IndexReader getFinalIndexReader() {
            return this.finalIndexReader;
        }

        @Override
        public void addToOldCacheSize(int increment) {
            this.oldCacheSize += increment;
            ++this.numberOfOldCaches;
        }

        @Override
        public int getNumberOfOldCaches() {
            return this.numberOfOldCaches;
        }

        public void checkCachePosition(CacheUpdateTracker tracker, List<CacheEntry> indexedByDocId, OpenBitSet allLeafDocs, long[] aclIdByDocId, long[] txIdByDocId, long[] aclTxIdByDocId, SolrIndexReader reader, OwnerIdManager ownerIdManager) {
            if (tracker.inNew == 0) {
                return;
            }
            if (tracker.inNew > indexedByDocId.size()) {
                return;
            }
            try {
                if (reader.isDeleted(tracker.inNew - 1)) {
                    boolean failed = false;
                    if (indexedByDocId.get(tracker.inNew - 1) != null) {
                        log.error("Entry found for deleted doc at " + (tracker.inNew - 1) + " " + indexedByDocId.get(tracker.inNew - 1));
                        failed = true;
                    }
                    if (aclIdByDocId[tracker.inNew - 1] != -1L) {
                        log.error("Acl found for deleted doc at " + (tracker.inNew - 1) + " " + aclIdByDocId[tracker.inNew - 1]);
                        failed = true;
                    }
                    if (txIdByDocId[tracker.inNew - 1] != -1L) {
                        log.error("Tx found for deleted doc at " + (tracker.inNew - 1) + " " + txIdByDocId[tracker.inNew - 1]);
                        failed = true;
                    }
                    if (aclTxIdByDocId[tracker.inNew - 1] != -1L) {
                        log.error("Acl Tx found for deleted doc at " + (tracker.inNew - 1) + " " + aclTxIdByDocId[tracker.inNew - 1]);
                        failed = true;
                    }
                    if (allLeafDocs.get(tracker.inNew - 1)) {
                        log.error("Leaf set for deleted doc at " + (tracker.inNew - 1));
                        failed = true;
                    }
                    if (failed) {
                        throw new IllegalStateException("Cache position check failed");
                    }
                } else {
                    Document document = reader.document(tracker.inNew - 1);
                    Field field = document.getField("DBID");
                    if (field != null) {
                        boolean isLeaf;
                        String string = field.stringValue();
                        long dbid = Long.parseLong(string);
                        field = document.getField("ISNODE");
                        if (field == null) {
                            isLeaf = false;
                        } else {
                            string = field.stringValue();
                            isLeaf = string.equals("T");
                        }
                        long aclId = -1L;
                        field = document.getField("ACLID");
                        if (field != null) {
                            string = field.stringValue();
                            aclId = Long.parseLong(string);
                        }
                        String owner = null;
                        field = document.getField("OWNER");
                        if (field != null) {
                            owner = field.stringValue();
                        }
                        boolean failed = false;
                        CacheEntry entry = indexedByDocId.get(tracker.inNew - 1);
                        if (entry == null) {
                            log.error("Entry was incorrectly deleted at " + (tracker.inNew - 1));
                            throw new IllegalStateException("Cache position check failed");
                        }
                        if (entry.getDbid() != dbid) {
                            log.error("Incorrect DBID " + (tracker.inNew - 1) + " " + entry);
                            failed = true;
                        }
                        if (isLeaf) {
                            if (entry.getLeaf() != tracker.inNew - 1) {
                                log.error("Leaf position not set" + (tracker.inNew - 1) + " " + entry);
                                failed = true;
                            }
                            if (!allLeafDocs.get(tracker.inNew - 1)) {
                                log.error("Leaf not set" + (tracker.inNew - 1));
                                failed = true;
                            }
                        } else {
                            if (entry.getPath() != tracker.inNew - 1) {
                                log.error("Path position not set" + (tracker.inNew - 1) + " " + entry);
                                failed = true;
                            }
                            if (entry.getAclid() != aclId) {
                                log.error("Incorrect ACL set" + (tracker.inNew - 1) + " " + entry);
                                failed = true;
                            }
                            if (entry.getOwner() != ownerIdManager.getOwnerId(owner).intValue()) {
                                log.error("Incorrect Owner set" + (tracker.inNew - 1) + " " + entry);
                                failed = true;
                            }
                            if (allLeafDocs.get(tracker.inNew - 1)) {
                                log.error("Leaf set" + (tracker.inNew - 1));
                                failed = true;
                            }
                        }
                        if (aclIdByDocId[tracker.inNew - 1] != -1L) {
                            log.error("Acl found for deleted doc at " + (tracker.inNew - 1) + " " + aclIdByDocId[tracker.inNew - 1]);
                            failed = true;
                        }
                        if (txIdByDocId[tracker.inNew - 1] != -1L) {
                            log.error("Tx found for deleted doc at " + (tracker.inNew - 1) + " " + txIdByDocId[tracker.inNew - 1]);
                            failed = true;
                        }
                        if (aclTxIdByDocId[tracker.inNew - 1] != -1L) {
                            log.error("Acl Tx found for deleted doc at " + (tracker.inNew - 1) + " " + aclTxIdByDocId[tracker.inNew - 1]);
                            failed = true;
                        }
                        if (failed) {
                            throw new IllegalStateException("Cache position check failed");
                        }
                    } else {
                        boolean failed = false;
                        field = document.getField("ACLID");
                        if (field != null) {
                            String string = field.stringValue();
                            long aclId = Long.parseLong(string);
                            if (indexedByDocId.get(tracker.inNew - 1) != null) {
                                log.error("Entry found for ACL  " + (tracker.inNew - 1) + " " + indexedByDocId.get(tracker.inNew - 1));
                                failed = true;
                            }
                            if (aclIdByDocId[tracker.inNew - 1] != aclId) {
                                log.error("Incorrect acl id for ACL  " + (tracker.inNew - 1) + " " + aclIdByDocId[tracker.inNew - 1]);
                                failed = true;
                            }
                            if (txIdByDocId[tracker.inNew - 1] != -1L) {
                                log.error("Tx found for ACL at " + (tracker.inNew - 1) + " " + txIdByDocId[tracker.inNew - 1]);
                                failed = true;
                            }
                            if (aclTxIdByDocId[tracker.inNew - 1] != -1L) {
                                log.error("Acl Tx found for ACL at " + (tracker.inNew - 1) + " " + aclTxIdByDocId[tracker.inNew - 1]);
                                failed = true;
                            }
                            if (allLeafDocs.get(tracker.inNew - 1)) {
                                log.error("Leaf set for ACL at " + (tracker.inNew - 1));
                                failed = true;
                            }
                        } else {
                            field = document.getField("TXID");
                            if (field != null) {
                                String string = field.stringValue();
                                long txId = Long.parseLong(string);
                                if (indexedByDocId.get(tracker.inNew - 1) != null) {
                                    log.error("Entry found for TX  " + (tracker.inNew - 1) + " " + indexedByDocId.get(tracker.inNew - 1));
                                    failed = true;
                                }
                                if (aclIdByDocId[tracker.inNew - 1] != -1L) {
                                    log.error("ACL found for TX  " + (tracker.inNew - 1) + " " + aclIdByDocId[tracker.inNew - 1]);
                                    failed = true;
                                }
                                if (txIdByDocId[tracker.inNew - 1] != txId) {
                                    log.error("Incorrect tx id for TX  " + (tracker.inNew - 1) + " " + txIdByDocId[tracker.inNew - 1]);
                                    failed = true;
                                }
                                if (aclTxIdByDocId[tracker.inNew - 1] != -1L) {
                                    log.error("Acl Tx found for TX at " + (tracker.inNew - 1) + " " + aclTxIdByDocId[tracker.inNew - 1]);
                                    failed = true;
                                }
                                if (allLeafDocs.get(tracker.inNew - 1)) {
                                    log.error("Leaf set for TX at " + (tracker.inNew - 1));
                                    failed = true;
                                }
                            } else {
                                field = document.getField("ACLTXID");
                                if (field != null) {
                                    String string = field.stringValue();
                                    long aclTxId = Long.parseLong(string);
                                    if (indexedByDocId.get(tracker.inNew - 1) != null) {
                                        log.error("Entry found for ACL TX  " + (tracker.inNew - 1) + " " + indexedByDocId.get(tracker.inNew - 1));
                                        failed = true;
                                    }
                                    if (aclIdByDocId[tracker.inNew - 1] != -1L) {
                                        log.error("ACL found for ACL TX  " + (tracker.inNew - 1) + " " + aclIdByDocId[tracker.inNew - 1]);
                                        failed = true;
                                    }
                                    if (txIdByDocId[tracker.inNew - 1] != -1L) {
                                        log.error("TX found for ACL TX  " + (tracker.inNew - 1) + " " + txIdByDocId[tracker.inNew - 1]);
                                        failed = true;
                                    }
                                    if (aclTxIdByDocId[tracker.inNew - 1] != aclTxId) {
                                        log.error("Incorrect acl tx id for ACL TX at " + (tracker.inNew - 1) + " " + aclTxIdByDocId[tracker.inNew - 1]);
                                        failed = true;
                                    }
                                    if (allLeafDocs.get(tracker.inNew - 1)) {
                                        log.error("Leaf set for ACL TX at " + (tracker.inNew - 1));
                                        failed = true;
                                    }
                                } else {
                                    if (indexedByDocId.get(tracker.inNew - 1) != null) {
                                        log.error("Entry found for Unkown  " + (tracker.inNew - 1) + " " + indexedByDocId.get(tracker.inNew - 1));
                                        failed = true;
                                    }
                                    if (aclIdByDocId[tracker.inNew - 1] != -1L) {
                                        log.error("ACL found for Unknown  " + (tracker.inNew - 1) + " " + aclIdByDocId[tracker.inNew - 1]);
                                        failed = true;
                                    }
                                    if (txIdByDocId[tracker.inNew - 1] != -1L) {
                                        log.error("TX found for Unkown " + (tracker.inNew - 1) + " " + txIdByDocId[tracker.inNew - 1]);
                                        failed = true;
                                    }
                                    if (aclTxIdByDocId[tracker.inNew - 1] != -1L) {
                                        log.error("ACL TX found for unknown " + (tracker.inNew - 1) + " " + aclTxIdByDocId[tracker.inNew - 1]);
                                        failed = true;
                                    }
                                    if (allLeafDocs.get(tracker.inNew - 1)) {
                                        log.error("Leaf set for ACL TX at " + (tracker.inNew - 1));
                                        failed = true;
                                    }
                                }
                            }
                        }
                        if (failed) {
                            throw new IllegalStateException("Cache position check failed");
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cache position check failed", e);
            }
        }
    }

    public static interface CacheMatch {
        public int getFinalCacheSize();

        public int getOldCacheSize();

        public int getNumberOfOldCaches();

        public void addToOldCacheSize(int var1);

        public void updateCache(CacheUpdateTracker var1, ResizeableArrayList<CacheEntry> var2, long[] var3, long[] var4, long[] var5, ResizeableArrayList<CacheEntry> var6, OpenBitSet var7, long[] var8, long[] var9, long[] var10, HashMap<Long, CacheEntry> var11, OpenBitSet var12, SolrIndexReader var13, OwnerIdManager var14);

        public int getFinalDocCount();

        public IndexReader getFinalIndexReader();
    }

    public static class OwnerLookUp {
        int owner;
        int start;
        int end;

        public OwnerLookUp(int owner) {
            this.owner = owner;
        }

        public OwnerLookUp(int owner, int start) {
            this.owner = owner;
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getOwner() {
            return this.owner;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    public static class AclLookUp {
        long aclid;
        int start;
        int end;

        public AclLookUp(long aclid) {
            this.aclid = aclid;
        }

        public AclLookUp(long aclid, int start) {
            this.aclid = aclid;
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public long getAclid() {
            return this.aclid;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int hashCode() {
            return (int)(this.aclid ^ this.aclid >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AclLookUp)) {
                return false;
            }
            AclLookUp other = (AclLookUp)obj;
            return this.aclid == other.aclid;
        }

        public void setAclid(long aclid) {
            this.aclid = aclid;
        }
    }

    public static class CacheEntry
    implements Comparator<CacheEntry> {
        int leaf;
        int path;
        long dbid;
        long aclid;
        int owner;

        public CacheEntry(long dbid) {
            this.dbid = dbid;
        }

        public int getLeaf() {
            return this.leaf;
        }

        public void setLeaf(int leaf) {
            this.leaf = leaf;
        }

        public int getPath() {
            return this.path;
        }

        public void setPath(int path) {
            this.path = path;
        }

        public long getDbid() {
            return this.dbid;
        }

        public long getAclid() {
            return this.aclid;
        }

        public void setAclid(long aclid) {
            this.aclid = aclid;
        }

        public int getOwner() {
            return this.owner;
        }

        public void setOwner(int owner) {
            this.owner = owner;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.aclid ^ this.aclid >>> 32);
            result = 31 * result + (int)(this.dbid ^ this.dbid >>> 32);
            result = 31 * result + this.leaf;
            result = 31 * result + this.owner;
            result = 31 * result + this.path;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            if (this.aclid != other.aclid) {
                return false;
            }
            if (this.dbid != other.dbid) {
                return false;
            }
            if (this.leaf != other.leaf) {
                return false;
            }
            if (this.owner != other.owner) {
                return false;
            }
            return this.path == other.path;
        }

        public String toString() {
            return "CacheEntry [dbid=" + this.dbid + ", leaf=" + this.leaf + ", path=" + this.path + ", aclid=" + this.aclid + ", owner=" + this.owner + "]";
        }

        @Override
        public int compare(CacheEntry o1, CacheEntry o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDbid() < o2.getDbid() ? -1 : (o1.getDbid() == o2.getDbid() ? 0 : 1);
        }
    }
}

